/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.Vector;
import net.minecraft.client.Minecraft;
import org.lwjgl.input.Keyboard;

public class PC_PropertyManager {
    private String filename;
    private PC_SortedProperties pr = new PC_SortedProperties();
    private TreeMap entries;
    private TreeMap setValues;
    private TreeMap keyRename;
    private String comment = "";
    private boolean cfgSeparateSections = true;
    private boolean cfgNoValidate = true;
    private boolean cfgNewlineBeforeComments = true;
    private boolean cfgSilent = false;

    public PC_PropertyManager(String filename, String comment) {
        this.filename = filename;
        this.entries = new TreeMap();
        this.setValues = new TreeMap();
        this.keyRename = new TreeMap();
        this.comment = comment;
    }

    public void setValue(String key, String value) {
        this.setValues.put(key, value);
    }

    public void renameKey(String oldKey, String newKey) {
        this.keyRename.put(oldKey, newKey);
    }

    public void cfgSeparateSections(boolean separateSections) {
        this.cfgSeparateSections = separateSections;
    }

    public void enableValidation(boolean validate) {
        this.cfgNoValidate = !validate;
    }

    public void cfgNewlineBeforeComments(boolean newlineBeforeComments) {
        this.cfgNewlineBeforeComments = newlineBeforeComments;
    }

    public void cfgSilent(boolean silent) {
        this.cfgSilent = silent;
    }

    public void putInteger(String n2, int d2, String comment) {
        this.entries.put(n2, new Property(n2, d2, PropertyType.INT, comment));
    }

    public void putInteger(String n2, int d2) {
        this.entries.put(n2, new Property(n2, d2, PropertyType.INT, null));
    }

    public void putKey(String n2, int d2, String comment) {
        this.entries.put(n2, new Property(n2, d2, PropertyType.KEY, comment));
    }

    public void putKey(String n2, int d2) {
        this.entries.put(n2, new Property(n2, d2, PropertyType.KEY, null));
    }

    public void putItem(String n2, int d2, String comment) {
        this.entries.put(n2, new Property(n2, d2, PropertyType.ITEM, comment));
    }

    public void putItem(String n2, int d2) {
        this.entries.put(n2, new Property(n2, d2, PropertyType.ITEM, null));
    }

    public void putBlock(String n2, int d2, String comment) {
        this.entries.put(n2, new Property(n2, d2, PropertyType.BLOCK, comment));
    }

    public void putBlock(String n2, int d2) {
        this.entries.put(n2, new Property(n2, d2, PropertyType.BLOCK, null));
    }

    public void putString(String n2, String d2, String comment) {
        this.entries.put(n2, new Property(n2, d2, PropertyType.STRING, comment));
    }

    public void putString(String n2, String d2) {
        this.entries.put(n2, new Property(n2, d2, PropertyType.STRING, null));
    }

    public void putBoolean(String n2, boolean d2, String comment) {
        this.entries.put(n2, new Property(n2, d2, PropertyType.BOOLEAN, comment));
    }

    public void putBoolean(String n2, boolean d2) {
        this.entries.put(n2, new Property(n2, d2, PropertyType.BOOLEAN, null));
    }

    private Property get(String n2) {
        try {
            return (Property)this.entries.get(n2);
        }
        catch (Throwable t2) {
            return null;
        }
    }

    public String getString(String n2) {
        try {
            return this.get(n2).getString();
        }
        catch (Throwable t2) {
            return null;
        }
    }

    public String string(String n2) {
        try {
            return this.get(n2).getString();
        }
        catch (Throwable t2) {
            return null;
        }
    }

    public String str(String n2) {
        try {
            return this.get(n2).getString();
        }
        catch (Throwable t2) {
            return null;
        }
    }

    public Integer getInteger(String n2) {
        try {
            return this.get(n2).getInteger();
        }
        catch (Throwable t2) {
            return -1;
        }
    }

    public Integer getNum(String n2) {
        return this.getInteger(n2);
    }

    public Integer getInt(String n2) {
        return this.getInteger(n2);
    }

    public Integer num(String n2) {
        return this.getInteger(n2);
    }

    public Integer integer(String n2) {
        try {
            return this.get(n2).getInteger();
        }
        catch (Throwable t2) {
            return -1;
        }
    }

    public Boolean getBoolean(String n2) {
        try {
            return ((Property)this.entries.get(n2)).getBoolean();
        }
        catch (Throwable t2) {
            return false;
        }
    }

    public Boolean flag(String n2) {
        return this.getBoolean(n2);
    }

    public Boolean bool(String n2) {
        return this.getBoolean(n2);
    }

    public Boolean isKeyDown(String n2) {
        try {
            return ((Property)this.entries.get(n2)).isKeyDown();
        }
        catch (Throwable t2) {
            return false;
        }
    }

    public void apply() {
        if (!this.cfgSilent) {
            PC_Logger.finest("Loading configuration from file \"" + this.filename + "\"");
        }
        boolean needsSave = false;
        try {
            new File(new File(Minecraft.b(), this.filename).getParent()).mkdirs();
            this.pr = PropertiesLoader.loadProperties(this.pr, new FileInputStream(Minecraft.b() + this.filename));
        }
        catch (IOException e2) {
            needsSave = true;
            this.pr = new PC_SortedProperties();
        }
        this.pr.cfgSeparateSectionsByEmptyLine = this.cfgSeparateSections;
        this.pr.cfgEmptyLineBeforeComment = this.cfgNewlineBeforeComments;
        ArrayList<String> keyList = new ArrayList<String>();
        for (Map.Entry entry : this.keyRename.entrySet()) {
            this.pr.setProperty((String)entry.getValue(), this.pr.getProperty((String)entry.getKey()));
            this.pr.remove(entry.getKey());
            needsSave = true;
        }
        for (Map.Entry entry : this.setValues.entrySet()) {
            this.pr.setProperty((String)entry.getKey(), (String)entry.getValue());
            needsSave = true;
        }
        for (Property property : this.entries.values()) {
            keyList.add(property.name);
            String propOrig = this.pr.getProperty(property.name);
            property.parse(propOrig);
            if (!this.cfgNoValidate) {
                property.validate();
            }
            if (property.comment != null) {
                this.pr.setKeyComment(property.name, property.comment);
            }
            if (propOrig != null && property.toString().equals(propOrig)) continue;
            this.pr.setProperty(property.name, property.toString());
            needsSave = true;
        }
        for (String propname : this.pr.keySet().toArray(new String[this.pr.size()])) {
            if (keyList.contains(propname)) continue;
            this.pr.remove(propname);
            PC_Logger.finest("* Removing unused property \"" + propname + "\" from config file " + this.filename);
            needsSave = true;
        }
        if (needsSave) {
            try {
                PC_Logger.finest("* Saving modified property file " + this.filename);
                this.pr.store(new FileOutputStream(Minecraft.b() + this.filename), this.comment);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        if (!this.cfgSilent) {
            PC_Logger.finest("Configuration loaded.");
        }
        this.setValues.clear();
        this.keyRename.clear();
    }

    private static enum PropertyType {
        BLOCK,
        ITEM,
        KEY,
        STRING,
        BOOLEAN,
        INT;

    }

    private static class PropertiesLoader {
        private PropertiesLoader() {
        }

        public static PC_SortedProperties loadProperties(PC_SortedProperties props, InputStream is2) throws IOException {
            return PropertiesLoader.loadProperties(props, is2, "utf-8");
        }

        public static PC_SortedProperties loadProperties(PC_SortedProperties props, InputStream is2, String encoding) throws IOException {
            int temp;
            StringBuilder sb2 = new StringBuilder();
            InputStreamReader isr = new InputStreamReader(is2, encoding);
            while ((temp = isr.read()) >= 0) {
                char c2 = (char)temp;
                sb2.append(c2);
            }
            String read = sb2.toString();
            String inputString = PropertiesLoader.escapifyStr(read);
            byte[] bs2 = inputString.getBytes("ISO-8859-1");
            ByteArrayInputStream bais = new ByteArrayInputStream(bs2);
            PC_SortedProperties ps2 = props;
            ps2.load(bais);
            return ps2;
        }

        private static char hexDigit(char ch2, int offset) {
            int val = ch2 >> offset & 0xF;
            if (val <= 9) {
                return (char)(48 + val);
            }
            return (char)(65 + val - 10);
        }

        private static String escapifyStr(String str) {
            StringBuilder result2 = new StringBuilder();
            int len = str.length();
            for (int x2 = 0; x2 < len; ++x2) {
                char ch2 = str.charAt(x2);
                if (ch2 <= '~') {
                    result2.append(ch2);
                    continue;
                }
                result2.append('\\');
                result2.append('u');
                result2.append(PropertiesLoader.hexDigit(ch2, 12));
                result2.append(PropertiesLoader.hexDigit(ch2, 8));
                result2.append(PropertiesLoader.hexDigit(ch2, 4));
                result2.append(PropertiesLoader.hexDigit(ch2, 0));
            }
            return result2.toString();
        }
    }

    private static class PC_SortedProperties
    extends Properties {
        private Hashtable keyComments = new Hashtable();
        public boolean cfgSeparateSectionsByEmptyLine = true;
        public boolean cfgEmptyLineBeforeComment = true;
        private String lastSectionBeginning = "";
        private boolean firstEntry = true;
        private static final char[] hexDigit_custom = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

        private PC_SortedProperties() {
        }

        public void setKeyComment(String key, String comment) {
            this.keyComments.put(key, comment);
        }

        @Override
        public synchronized Enumeration keys() {
            Enumeration<Object> keysEnum = super.keys();
            Vector<Object> keyList = new Vector<Object>();
            while (keysEnum.hasMoreElements()) {
                keyList.add(keysEnum.nextElement());
            }
            Collections.sort(keyList);
            return keyList.elements();
        }

        @Override
        public void store(OutputStream out, String comments) throws IOException {
            this.store_custom(new BufferedWriter(new OutputStreamWriter(out, "UTF-8")), comments, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void store_custom(BufferedWriter bw2, String comments, boolean escUnicode) throws IOException {
            if (comments != null) {
                PC_SortedProperties.writeComments_custom(bw2, comments);
            }
            PC_SortedProperties pC_SortedProperties = this;
            synchronized (pC_SortedProperties) {
                Enumeration e2 = this.keys();
                while (e2.hasMoreElements()) {
                    boolean wasNewLine = false;
                    String key = (String)e2.nextElement();
                    String val = (String)this.get(key);
                    key = this.saveConvert_custom(key, true, escUnicode);
                    val = this.saveConvert_custom(val, false, escUnicode);
                    if (this.cfgSeparateSectionsByEmptyLine && !this.lastSectionBeginning.equals(key.split("[.]")[0])) {
                        if (!this.firstEntry) {
                            bw2.newLine();
                            bw2.newLine();
                        }
                        wasNewLine = true;
                        this.lastSectionBeginning = key.split("[.]")[0];
                    }
                    if (this.keyComments.containsKey(key)) {
                        String cm2 = (String)this.keyComments.get(key);
                        cm2 = cm2.replace("\r", "\n");
                        cm2 = cm2.replace("\r\n", "\n");
                        cm2 = cm2.replace("\n\n", "\n \n");
                        String[] cmlines = cm2.split("\n");
                        if (!wasNewLine && !this.firstEntry && this.cfgEmptyLineBeforeComment) {
                            bw2.newLine();
                        }
                        for (String cmline : cmlines) {
                            bw2.write("# " + cmline);
                            bw2.newLine();
                        }
                    }
                    bw2.write(key + " = " + val);
                    bw2.newLine();
                    this.firstEntry = false;
                }
            }
            bw2.flush();
        }

        private static void writeComments_custom(BufferedWriter bw2, String comm) throws IOException {
            int current;
            String comments = comm.replace("\n\n", "\n \n");
            int len = comments.length();
            int last = 0;
            char[] uu2 = new char[6];
            uu2[0] = 92;
            uu2[1] = 117;
            for (current = 0; current < len; ++current) {
                char c2 = comments.charAt(current);
                if (c2 <= '\u00ff' && c2 != '\n' && c2 != '\r') continue;
                if (last != current) {
                    bw2.write("# " + comments.substring(last, current));
                }
                if (c2 > '\u00ff') {
                    uu2[2] = PC_SortedProperties.toHex_custom(c2 >> 12 & 0xF);
                    uu2[3] = PC_SortedProperties.toHex_custom(c2 >> 8 & 0xF);
                    uu2[4] = PC_SortedProperties.toHex_custom(c2 >> 4 & 0xF);
                    uu2[5] = PC_SortedProperties.toHex_custom(c2 & 0xF);
                    bw2.write(new String(uu2));
                } else {
                    bw2.newLine();
                    if (c2 == '\r' && current != len - 1 && comments.charAt(current + 1) == '\n') {
                        ++current;
                    }
                }
                last = current + 1;
            }
            if (last != current) {
                bw2.write("# " + comments.substring(last, current));
            }
            bw2.newLine();
            bw2.newLine();
            bw2.newLine();
        }

        private String saveConvert_custom(String theString, boolean escapeSpace, boolean escapeUnicode) {
            int len = theString.length();
            int bufLen = len * 2;
            if (bufLen < 0) {
                bufLen = Integer.MAX_VALUE;
            }
            StringBuffer outBuffer = new StringBuffer(bufLen);
            block8: for (int x2 = 0; x2 < len; ++x2) {
                char aChar = theString.charAt(x2);
                if (aChar > '=' && aChar < '\u007f') {
                    if (aChar == '\\') {
                        outBuffer.append('\\');
                        outBuffer.append('\\');
                        continue;
                    }
                    outBuffer.append(aChar);
                    continue;
                }
                switch (aChar) {
                    case ' ': {
                        if (x2 == 0 || escapeSpace) {
                            outBuffer.append('\\');
                        }
                        outBuffer.append(' ');
                        continue block8;
                    }
                    case '\t': {
                        outBuffer.append('\\');
                        outBuffer.append('t');
                        continue block8;
                    }
                    case '\n': {
                        outBuffer.append('\\');
                        outBuffer.append('n');
                        continue block8;
                    }
                    case '\r': {
                        outBuffer.append('\\');
                        outBuffer.append('r');
                        continue block8;
                    }
                    case '\f': {
                        outBuffer.append('\\');
                        outBuffer.append('f');
                        continue block8;
                    }
                    case '!': 
                    case '#': 
                    case ':': 
                    case '=': {
                        outBuffer.append('\\');
                        outBuffer.append(aChar);
                        continue block8;
                    }
                    default: {
                        if ((aChar < ' ' || aChar > '~') & escapeUnicode) {
                            outBuffer.append('\\');
                            outBuffer.append('u');
                            outBuffer.append(PC_SortedProperties.toHex_custom(aChar >> 12 & 0xF));
                            outBuffer.append(PC_SortedProperties.toHex_custom(aChar >> 8 & 0xF));
                            outBuffer.append(PC_SortedProperties.toHex_custom(aChar >> 4 & 0xF));
                            outBuffer.append(PC_SortedProperties.toHex_custom(aChar & 0xF));
                            continue block8;
                        }
                        outBuffer.append(aChar);
                    }
                }
            }
            return outBuffer.toString();
        }

        private static char toHex_custom(int nibble) {
            return hexDigit_custom[nibble & 0xF];
        }
    }

    private class Property {
        public String name;
        public int defnum = -1;
        public String defstr = "";
        public boolean defbool = false;
        public PropertyType type;
        public int num = -1;
        public String str = "";
        public boolean bool = false;
        public String comment;

        public Property(String key, int default_value, PropertyType entry_type, String entry_comment) {
            this.name = key;
            this.defnum = default_value;
            this.type = entry_type;
            this.comment = entry_comment;
        }

        public Property(String key, String default_value, PropertyType entry_type, String entry_comment) {
            this.name = key;
            this.defstr = default_value;
            this.type = entry_type;
            this.comment = entry_comment;
        }

        public Property(String key, boolean default_value, PropertyType entry_type, String entry_comment) {
            this.name = key;
            this.defbool = default_value;
            this.type = entry_type;
            this.comment = entry_comment;
        }

        public String toString() {
            if (!(this.isValid() || this.type != PropertyType.INT && this.type != PropertyType.ITEM && this.type != PropertyType.BLOCK)) {
                this.num = this.defnum;
            }
            if (this.type == PropertyType.BLOCK || this.type == PropertyType.ITEM || this.type == PropertyType.INT) {
                return Integer.toString(this.num);
            }
            if (this.type == PropertyType.STRING) {
                return this.str;
            }
            if (this.type == PropertyType.KEY) {
                return Keyboard.getKeyName((int)this.num) == null ? "none" : Keyboard.getKeyName((int)this.num);
            }
            if (this.type == PropertyType.BOOLEAN) {
                return this.bool ? "True" : "False";
            }
            return null;
        }

        public Property parse(String string) {
            if (this.type == PropertyType.BLOCK || this.type == PropertyType.ITEM || this.type == PropertyType.INT) {
                if (string == null) {
                    PC_Logger.finest("* Numeric property \"" + this.name + "\" not set, setting to default \"" + this.defnum + "\"");
                    this.num = this.defnum;
                    return this;
                }
                try {
                    this.num = Integer.parseInt(string);
                }
                catch (NumberFormatException e2) {
                    PC_Logger.warning("Numeric property \"" + this.name + "\" has invalid value \"" + this.num + "\". Falling back to default \"" + this.defnum + "\"");
                    this.num = this.defnum;
                }
            }
            if (this.type == PropertyType.KEY) {
                if (string == null) {
                    PC_Logger.finest("* Key property \"" + this.name + "\" not set, setting to default \"" + Keyboard.getKeyName((int)this.defnum) + "\"");
                    this.num = this.defnum;
                    return this;
                }
                this.num = Keyboard.getKeyIndex((String)string);
                if (this.num == 0) {
                    PC_Logger.warning("Key property \"" + this.name + "\" has invalid value \"" + string + "\". Falling back to default \"" + Keyboard.getKeyName((int)this.defnum) + "\"");
                    this.num = this.defnum;
                }
            }
            if (this.type == PropertyType.STRING) {
                if (string == null) {
                    PC_Logger.finest("* String property \"" + this.name + "\" not set, setting to default \"" + this.defstr + "\"");
                    this.str = this.defstr;
                    return this;
                }
                this.str = string;
            }
            if (this.type == PropertyType.BOOLEAN) {
                if (string == null) {
                    PC_Logger.finest("* Boolean property \"" + this.name + "\" not set, setting to default \"" + this.defbool + "\"");
                    this.bool = this.defbool;
                    return this;
                }
                String string2 = string.toLowerCase();
                this.bool = string2.equals("yes") || string2.equals("true") || string2.equals("on") || string2.equals("enabled") || string2.equals("enable");
            }
            return this;
        }

        public boolean isKeyDown() {
            return this.type == PropertyType.KEY && Keyboard.isKeyDown((int)this.num);
        }

        public int getInteger() {
            return this.num;
        }

        public String getString() {
            return this.str;
        }

        public boolean getBoolean() {
            return this.bool;
        }

        public boolean isValid() {
            if (this.type == PropertyType.BLOCK) {
                return this.num > 0 && this.num <= pb.m.length && pb.m[this.num] == null;
            }
            if (this.type == PropertyType.ITEM) {
                return this.num > 200 && this.num <= 31744 && yr.e[this.num + 256] == null;
            }
            if (this.type == PropertyType.KEY) {
                return Keyboard.getKeyName((int)this.num) != null;
            }
            if (this.type == PropertyType.STRING) {
                return this.str != null;
            }
            return this.type == PropertyType.BOOLEAN || this.type == PropertyType.INT;
        }

        public void validate() {
            if (!this.isValid()) {
                if (this.type == PropertyType.BLOCK) {
                    PC_Logger.severe("Block ID property \"" + this.name + "\" has invalid value (ID out of range, or already used). YOUR MINECRAFT WILL CRASH!");
                } else if (this.type == PropertyType.ITEM) {
                    PC_Logger.severe("Item ID property \"" + this.name + "\" has invalid value (ID out of range, or already used). THIS MAY CAUSE CRASH!");
                }
                if (this.type == PropertyType.KEY) {
                    PC_Logger.warning("Key property \"" + this.name + "\" has invalid value (unknown key name). Falling back to default value  \"" + Keyboard.getKeyName((int)this.defnum) + "\"");
                    this.num = this.defnum;
                }
                if (this.type == PropertyType.STRING) {
                    PC_Logger.warning("String property \"" + this.name + "\" has invalid value (NULL). Falling back to default value  \"" + this.defstr + "\"");
                    this.str = this.defstr;
                }
            }
        }
    }
}

