/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FilenameFilter;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;

public class PC_Lang {
    private HashMap defaults;
    private String module;
    private static final String deflang = "en_US";

    public static String tr(String identifier) {
        return adn.a().b(identifier).trim();
    }

    public static String tr(String identifier, String[] replacements) {
        return adn.a().a(identifier, replacements);
    }

    public PC_Lang(String moduleName, HashMap en_US) {
        this.defaults = en_US;
        this.module = moduleName;
        this.addLocalizations(deflang, this.defaults);
    }

    private void addLocalizations(String lang, HashMap locs) {
        for (Map.Entry a2 : locs.entrySet()) {
            ModLoader.addLocalization((String)a2.getKey(), lang, (String)a2.getValue());
        }
    }

    public void loadTranstalions() {
        File folder = new File(Minecraft.b(), "/PowerCraft/lang/");
        String[] files = folder.list(new FilenameFilter(){

            @Override
            public boolean accept(File arg0, String arg1) {
                return arg1.matches("[a-z]{2,3}_[A-Z]{2,3}-" + PC_Lang.this.module + "[.]lang");
            }
        });
        if (files == null) {
            PC_Logger.severe("Received NULL instead of list of translations.");
            return;
        }
        for (String filename : files) {
            PC_Logger.finest("* loading names from file " + filename + "...");
            String language = filename.substring(0, filename.indexOf(45));
            PC_PropertyManager p2 = new PC_PropertyManager("/PowerCraft/lang/" + filename, language + " translation of " + this.module + " module.");
            p2.cfgSilent(true);
            for (Map.Entry a2 : this.defaults.entrySet()) {
                p2.putString((String)a2.getKey(), (String)a2.getValue());
            }
            p2.apply();
            for (String key : this.defaults.keySet()) {
                ModLoader.addLocalization(key, language, p2.getString(key).trim());
            }
        }
        PC_Logger.finer("Translations loaded.");
    }

    public void generateDefaultTranslationFile() {
        PC_PropertyManager p2 = new PC_PropertyManager("/PowerCraft/lang/en_US-" + this.module + ".lang", "English (default, immutable) translation of " + this.module + " module.\n" + "To add your own translation, copy this file, change language prefix and transtalte the names.");
        p2.cfgSilent(true);
        for (Map.Entry a2 : this.defaults.entrySet()) {
            p2.putString((String)a2.getKey(), (String)a2.getValue());
        }
        p2.apply();
    }
}

