/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.List;
import java.util.Map;
import net.minecraft.src.Block;
import net.minecraft.src.Entity;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.ModLoader;
import net.minecraft.src.PC_CraftingToolGroup;
import net.minecraft.src.PC_InveditManager;
import net.minecraft.src.PC_Module;
import net.minecraft.src.PC_PropertyManager;
import net.minecraft.src.PC_Struct3;
import net.minecraft.src.PClo_BlockGate;
import net.minecraft.src.PClo_BlockLight;
import net.minecraft.src.PClo_BlockPulsar;
import net.minecraft.src.PClo_BlockRadio;
import net.minecraft.src.PClo_BlockSensor;
import net.minecraft.src.PClo_ItemBlockGate;
import net.minecraft.src.PClo_ItemBlockLight;
import net.minecraft.src.PClo_ItemBlockRadio;
import net.minecraft.src.PClo_ItemBlockSensor;
import net.minecraft.src.PClo_ItemRadioRemote;
import net.minecraft.src.PClo_Renderer;
import net.minecraft.src.PClo_TileEntityGate;
import net.minecraft.src.PClo_TileEntityLight;
import net.minecraft.src.PClo_TileEntityPulsar;
import net.minecraft.src.PClo_TileEntityRadio;
import net.minecraft.src.PClo_TileEntityRadioRenderer;
import net.minecraft.src.PClo_TileEntitySensor;
import net.minecraft.src.PClo_TileEntitySensorRenderer;
import net.minecraft.src.RenderBlocks;
import net.minecraft.src.TileEntity;
import net.minecraft.src.TileEntitySpecialRenderer;

public class mod_PClogic
extends PC_Module {
    public static String default_radio_channel = "default";
    public static int default_sensor_range = 3;
    private static final String pk_idGateOff = "id.block.gate_off";
    private static final String pk_idGateOn = "id.block.gate_on";
    private static final String pk_idPulsar = "id.block.pulsar";
    private static final String pk_idLightOff = "id.block.light_off";
    private static final String pk_idLightOn = "id.block.light_on";
    private static final String pk_brightLight = "brightness.light_on";
    private static final String pk_brightGate = "brightness.gate_on";
    private static final String pk_idRadio = "id.block.radio";
    private static final String pk_idSensor = "id.block.motion_sensor";
    private static final String pk_idRemote = "id.item.radio_remote";
    private static final String pk_optRadioDefChannel = "default.radio.channel";
    private static final String pk_optSensorDefRange = "default.sensor.range";
    public static Block radio;
    public static PClo_BlockSensor sensor;
    public static Item portableTx;
    public static Block gateOff;
    public static Block gateOn;
    public static Block pulsar;
    public static Block lightOff;
    public static Block lightOn;

    @Override
    public String getVersion() {
        return "3.4p4";
    }

    public static String getImgDir() {
        return "/PowerCraft/logic/";
    }

    public static String getTerrainFile() {
        return mod_PClogic.getImgDir() + "tiles.png";
    }

    @Override
    public String getModuleName() {
        return "LOGIC";
    }

    @Override
    public void preInit() {
    }

    @Override
    public void initProperties(PC_PropertyManager conf) {
        conf.putBlock(pk_idGateOff, 223);
        conf.putBlock(pk_idGateOn, 224);
        conf.putBlock(pk_idPulsar, 225);
        conf.putBlock(pk_idLightOff, 226);
        conf.putBlock(pk_idLightOn, 227);
        conf.putInteger(pk_brightLight, 12, "Light block brightness, scale 0-15.");
        conf.putInteger(pk_brightGate, 8, "Active gate block brightness, scale 0-15.");
        conf.putBlock(pk_idRadio, 236);
        conf.putBlock(pk_idSensor, 229);
        conf.putItem(pk_idRemote, 19000);
        conf.putString(pk_optRadioDefChannel, "default", "the default channel for radios");
        conf.putInteger(pk_optSensorDefRange, 3, "the range of newly placed sensor");
        conf.apply();
        default_radio_channel = conf.getString(pk_optRadioDefChannel);
        default_sensor_range = conf.getInteger(pk_optSensorDefRange);
    }

    @Override
    public void registerEntities(List<PC_Struct3<Class<? extends Entity>, String, Integer>> list) {
    }

    @Override
    public void registerTileEntities(List<PC_Struct3<Class<? extends TileEntity>, String, TileEntitySpecialRenderer>> list) {
        list.add(new PC_Struct3<Class<PClo_TileEntityGate>, String, Object>(PClo_TileEntityGate.class, "FCLogicGate", null));
        list.add(new PC_Struct3<Class<PClo_TileEntityPulsar>, String, Object>(PClo_TileEntityPulsar.class, "FCRedstonePulsar", null));
        list.add(new PC_Struct3<Class<PClo_TileEntityLight>, String, Object>(PClo_TileEntityLight.class, "FCRedstoneIndicator", null));
        list.add(new PC_Struct3<Class<PClo_TileEntitySensor>, String, PClo_TileEntitySensorRenderer>(PClo_TileEntitySensor.class, "FCSensorRanged", new PClo_TileEntitySensorRenderer()));
        list.add(new PC_Struct3<Class<PClo_TileEntityRadio>, String, PClo_TileEntityRadioRenderer>(PClo_TileEntityRadio.class, "PCRadioDevice", new PClo_TileEntityRadioRenderer()));
    }

    @Override
    public void registerBlockRenderers() {
        PClo_Renderer.radioRenderer = ModLoader.getUniqueBlockModelID(this, true);
        PClo_Renderer.sensorRenderer = ModLoader.getUniqueBlockModelID(this, true);
    }

    @Override
    public void registerBlocks(List<Block> list) {
        radio = new PClo_BlockRadio(this.cfg().getInteger(pk_idRadio)).setBlockName("PCloRadio").setHardness(0.2f);
        sensor = (PClo_BlockSensor)new PClo_BlockSensor(this.cfg().getInteger(pk_idSensor)).setBlockName("PCloSensorRanged").setHardness(0.2f);
        gateOff = new PClo_BlockGate((int)this.cfg().getInteger(pk_idGateOff), false).setBlockName("PCloLogicGate").setHardness(0.0f).setLightValue(0.0f).setStepSound(Block.soundWoodFootstep).disableStats().setRequiresSelfNotify();
        gateOn = new PClo_BlockGate((int)this.cfg().getInteger(pk_idGateOn), true).setBlockName("PCloLogicGate").setHardness(0.0f).setLightValue((float)this.cfg().getInteger(pk_brightGate).intValue() * 0.0625f).setStepSound(Block.soundWoodFootstep).disableStats().setRequiresSelfNotify();
        pulsar = new PClo_BlockPulsar(this.cfg().getInteger(pk_idPulsar)).setHardness(0.8f).setBlockName("PCloRedstonePulsar").setRequiresSelfNotify().setStepSound(Block.soundWoodFootstep);
        lightOff = new PClo_BlockLight((int)this.cfg().getInteger(pk_idLightOff), false).setHardness(0.0f).setBlockName("PCloLight").setStepSound(Block.soundStoneFootstep).setRequiresSelfNotify();
        lightOn = new PClo_BlockLight((int)this.cfg().getInteger(pk_idLightOn), true).setHardness(0.0f).setLightValue((float)this.cfg().getInteger(pk_brightLight).intValue() * 0.0625f).setBlockName("PCloLight").setStepSound(Block.soundStoneFootstep).setRequiresSelfNotify();
        list.add(radio);
        list.add(sensor);
        list.add(gateOff);
        list.add(gateOn);
        list.add(pulsar);
        list.add(lightOff);
        list.add(lightOn);
    }

    @Override
    public void registerItems() {
        portableTx = new PClo_ItemRadioRemote(this.cfg().getInteger(pk_idRemote)).setMaxStackSize(1).setItemName("PCloRadioPortableTx");
        mod_PClogic.removeBlockItem(mod_PClogic.gateOn.blockID);
        mod_PClogic.setBlockItem(mod_PClogic.gateOn.blockID, new PClo_ItemBlockGate(mod_PClogic.gateOn.blockID - 256));
        mod_PClogic.removeBlockItem(mod_PClogic.lightOn.blockID);
        mod_PClogic.setBlockItem(mod_PClogic.lightOn.blockID, new PClo_ItemBlockLight(mod_PClogic.lightOn.blockID - 256));
        mod_PClogic.removeBlockItem(mod_PClogic.sensor.blockID);
        mod_PClogic.setBlockItem(mod_PClogic.sensor.blockID, new PClo_ItemBlockSensor(mod_PClogic.sensor.blockID - 256, sensor));
        mod_PClogic.removeBlockItem(mod_PClogic.radio.blockID);
        mod_PClogic.setBlockItem(mod_PClogic.radio.blockID, new PClo_ItemBlockRadio(mod_PClogic.radio.blockID - 256));
    }

    @Override
    public void preloadTextures(List<String> list) {
        list.add(mod_PClogic.getTerrainFile());
    }

    @Override
    public void setTextures() {
        portableTx.setIconIndex(ModLoader.addOverride("/gui/items.png", mod_PClogic.getImgDir() + "portable.png"));
    }

    @Override
    public void setNames(Map<Object, String> map) {
        map.put(pulsar, "Redstone Pulsar");
        map.put(portableTx, "Radio Remote");
        map.put("tile.PCloRadio.tx.name", "Redstone Radio Transmitter");
        map.put("tile.PCloRadio.rx.name", "Redstone Radio Receiver");
        map.put("tile.PCloSensorRanged.item.name", "Item Proximity Detector");
        map.put("tile.PCloSensorRanged.living.name", "Mob Proximity Detector");
        map.put("tile.PCloSensorRanged.player.name", "Player Proximity Detector");
        map.put("tile.PCloLight.0.name", "Black Indicator");
        map.put("tile.PCloLight.1.name", "Red Indicator");
        map.put("tile.PCloLight.2.name", "Green Indicator");
        map.put("tile.PCloLight.3.name", "Brown Indicator");
        map.put("tile.PCloLight.4.name", "Blue Indicator");
        map.put("tile.PCloLight.5.name", "Purple Indicator");
        map.put("tile.PCloLight.6.name", "Cyan Indicator");
        map.put("tile.PCloLight.7.name", "Light-gray Indicator");
        map.put("tile.PCloLight.8.name", "Gray Indicator");
        map.put("tile.PCloLight.9.name", "Pink Indicator");
        map.put("tile.PCloLight.10.name", "Lime Indicator");
        map.put("tile.PCloLight.11.name", "Yellow Indicator");
        map.put("tile.PCloLight.12.name", "Light-blue Indicator");
        map.put("tile.PCloLight.13.name", "Magenta Indicator");
        map.put("tile.PCloLight.14.name", "Orange Indicator");
        map.put("tile.PCloLight.15.name", "White Indicator");
        map.put("tile.PCloLogicGate.not.name", "Redstone Inverter");
        map.put("tile.PCloLogicGate.and.name", "Redstone AND gate");
        map.put("tile.PCloLogicGate.nand.name", "Redstone NAND gate");
        map.put("tile.PCloLogicGate.or.name", "Redstone OR gate");
        map.put("tile.PCloLogicGate.nor.name", "Redstone NOR gate");
        map.put("tile.PCloLogicGate.xor.name", "Redstone XOR gate");
        map.put("tile.PCloLogicGate.xnor.name", "Redstone XNOR gate");
        map.put("tile.PCloLogicGate.xnor3.name", "Redstone 3-input XNOR gate");
        map.put("tile.PCloLogicGate.and3.name", "Redstone 3-input AND gate");
        map.put("tile.PCloLogicGate.nand3.name", "Redstone 3-input NAND gate");
        map.put("tile.PCloLogicGate.or3.name", "Redstone 3-input OR gate");
        map.put("tile.PCloLogicGate.nor3.name", "Redstone 3-input NOR gate");
        map.put("tile.PCloLogicGate.xor3.name", "Redstone 3-input XOR gate");
        map.put("tile.PCloLogicGate.d.name", "Redstone D flip-flop");
        map.put("tile.PCloLogicGate.rs.name", "Redstone RS flip-flop");
        map.put("tile.PCloLogicGate.t.name", "Redstone T flip-flop");
        map.put("tile.PCloLogicGate.day.name", "Daytime Sensor");
        map.put("tile.PCloLogicGate.rain.name", "Rain Sensor");
        map.put("tile.PCloLogicGate.chestEmpty.name", "Empty Chest Detector");
        map.put("tile.PCloLogicGate.chestFull.name", "Full Chest Detector");
        map.put("tile.PCloLogicGate.special.name", "Redstone Special Controller");
        map.put("tile.PCloLogicGate.buffer.name", "Buffered Delayer");
        map.put("tile.PCloLogicGate.slowRepeater.name", "Slow Repeater");
        map.put("tile.PCloLogicGate.crossing.name", "Redstone Crossing");
        map.put("tile.PCloLogicGate.random.name", "Redstone Random Gate");
        map.put("tile.PCloLogicGate.programmable.name", "Programmable Logic Gate");
        map.put("pc.gate.not.desc", "negates input");
        map.put("pc.gate.and.desc", "both inputs on");
        map.put("pc.gate.nand.desc", "some inputs off");
        map.put("pc.gate.or.desc", "at least one input on");
        map.put("pc.gate.nor.desc", "all inputs off");
        map.put("pc.gate.xor.desc", "inputs different");
        map.put("pc.gate.xnor.desc", "inputs equal");
        map.put("pc.gate.xnor3.desc", "all inputs equal");
        map.put("pc.gate.and3.desc", "all inputs on");
        map.put("pc.gate.nand3.desc", "some inputs off");
        map.put("pc.gate.or3.desc", "at least one input on");
        map.put("pc.gate.nor3.desc", "all inputs off");
        map.put("pc.gate.xor3.desc", "inputs different");
        map.put("pc.gate.d.desc", "latch memory");
        map.put("pc.gate.rs.desc", "set/reset memory");
        map.put("pc.gate.t.desc", "divides signal by 2");
        map.put("pc.gate.day.desc", "on during day");
        map.put("pc.gate.rain.desc", "on during rain");
        map.put("pc.gate.chestEmpty.desc", "on if nearby container is empty");
        map.put("pc.gate.chestFull.desc", "on if nearby container is full");
        map.put("pc.gate.special.desc", "spawner & pulsar control");
        map.put("pc.gate.buffer.desc", "slows down signal");
        map.put("pc.gate.slowRepeater.desc", "makes pulses longer");
        map.put("pc.gate.crossing.desc", "lets two wires intersect");
        map.put("pc.gate.random.desc", "changes state randomly on pulse");
        map.put("pc.gate.programmable.desc", "gate with custom function");
        map.put("pc.radioRemote.connected", "Portable device connected to channel \"%s\".");
        map.put("pc.radioRemote.desc", "Channel: %s");
        map.put("pc.gui.gate.delay", "Delay (sec)");
        map.put("pc.gui.gate.delayer.errRange", "Delay time out of range.");
        map.put("pc.gui.gate.delayer.errNumFormat", "Invalid number format.");
        map.put("pc.gui.gate.delayer.ticks", "ticks");
        map.put("pc.gui.pulsar.silent", "Silent");
        map.put("pc.gui.pulsar.delay", "Delay (sec)");
        map.put("pc.gui.pulsar.hold", "Hold time (sec)");
        map.put("pc.gui.pulsar.ticks", "ticks");
        map.put("pc.gui.pulsar.errDelay", "Bad delay time!");
        map.put("pc.gui.pulsar.errHold", "Bad hold time!");
        map.put("pc.gui.radio.channel", "Channel:");
        map.put("pc.gui.radio.errChannel", "Invalid channel name.");
        map.put("pc.pulsar.clickMsg", "Period %s ticks (%s s)");
        map.put("pc.pulsar.clickMsgTime", "Period %s ticks (%s s), remains %s");
        map.put("pc.sensor.rangeChanged.1", "Range changed to %s block.");
        map.put("pc.sensor.rangeChanged.2-4", "Range changed to %s blocks.");
        map.put("pc.sensor.rangeChanged.5+", "Range changed to %s blocks.");
        map.put("pc.sensor.range.1", "Range: %s block");
        map.put("pc.sensor.range.2-4", "Range: %s blocks");
        map.put("pc.sensor.range.5+", "Range: %s blocks");
        map.put("pc.gui.customGate.errProgEq0", "Program need to be longer than 0");
        map.put("pc.gui.customGate.errUnkChar", "unknown char '%s'");
        map.put("pc.gui.customGate.errUnclosed", "Unclosed bracket");
        map.put("pc.gui.customGate.errNoTextBefore", "You need a text before '%s'");
        map.put("pc.gui.customGate.errNoTextBehind", "You need a text behind '%s'");
        map.put("pc.gui.customGate.errUnkString", "unknown string '%s'");
    }

    @Override
    public void addRecipes() {
        ModLoader.addRecipe(new ItemStack(pulsar, 1, 0), new Object[]{" r ", "ror", " r ", Character.valueOf('r'), Item.redstone, Character.valueOf('o'), Block.obsidian});
        ModLoader.addRecipe(new ItemStack(gateOn, 1, 0), new Object[]{"RST", Character.valueOf('R'), Item.redstone, Character.valueOf('S'), Block.stone, Character.valueOf('T'), Block.torchRedstoneActive});
        ModLoader.addRecipe(new ItemStack(gateOn, 1, 1), new Object[]{" R ", "SSS", "R R", Character.valueOf('R'), Item.redstone, Character.valueOf('S'), Block.stone});
        ModLoader.addRecipe(new ItemStack(gateOn, 1, 3), new Object[]{" R ", "RSR", Character.valueOf('R'), Item.redstone, Character.valueOf('S'), Block.stone});
        ModLoader.addRecipe(new ItemStack(gateOn, 1, 5), new Object[]{"R", "X", Character.valueOf('X'), new ItemStack(gateOn, 1, 3), Character.valueOf('R'), Item.redstone});
        ModLoader.addRecipe(new ItemStack(gateOn, 1, 2), new Object[]{"I", "G", Character.valueOf('I'), new ItemStack(gateOn, 1, 0), Character.valueOf('G'), new ItemStack(gateOn, 1, 1)});
        ModLoader.addRecipe(new ItemStack(gateOn, 1, 4), new Object[]{"I", "G", Character.valueOf('I'), new ItemStack(gateOn, 1, 0), Character.valueOf('G'), new ItemStack(gateOn, 1, 3)});
        ModLoader.addRecipe(new ItemStack(gateOn, 1, 6), new Object[]{"I", "G", Character.valueOf('I'), new ItemStack(gateOn, 1, 0), Character.valueOf('G'), new ItemStack(gateOn, 1, 5)});
        ModLoader.addRecipe(new ItemStack(gateOn, 1, 10), new Object[]{"I", "G", Character.valueOf('I'), new ItemStack(gateOn, 1, 0), Character.valueOf('G'), new ItemStack(gateOn, 1, 9)});
        ModLoader.addRecipe(new ItemStack(gateOn, 1, 8), new Object[]{"I", "G", Character.valueOf('I'), new ItemStack(gateOn, 1, 0), Character.valueOf('G'), new ItemStack(gateOn, 1, 7)});
        ModLoader.addRecipe(new ItemStack(gateOn, 1, 12), new Object[]{"I", "G", Character.valueOf('I'), new ItemStack(gateOn, 1, 0), Character.valueOf('G'), new ItemStack(gateOn, 1, 11)});
        ModLoader.addRecipe(new ItemStack(gateOn, 1, 7), new Object[]{" R ", "SSS", "RRR", Character.valueOf('R'), Item.redstone, Character.valueOf('S'), Block.stone});
        ModLoader.addRecipe(new ItemStack(gateOn, 1, 9), new Object[]{" R ", "RSR", " R ", Character.valueOf('R'), Item.redstone, Character.valueOf('S'), Block.stone});
        ModLoader.addRecipe(new ItemStack(gateOn, 1, 11), new Object[]{"R", "X", Character.valueOf('X'), new ItemStack(gateOn, 1, 9), Character.valueOf('R'), Item.redstone});
        ModLoader.addRecipe(new ItemStack(gateOn, 1, 13), new Object[]{" S ", "RSR", " S ", Character.valueOf('S'), Block.stone, Character.valueOf('R'), Item.redstone});
        ModLoader.addRecipe(new ItemStack(gateOn, 1, 14), new Object[]{" R ", "SLS", "R R", Character.valueOf('R'), Item.redstone, Character.valueOf('S'), Block.stone, Character.valueOf('L'), Block.lever});
        ModLoader.addRecipe(new ItemStack(gateOn, 1, 15), new Object[]{"RSR", Character.valueOf('R'), Item.redstone, Character.valueOf('S'), Block.stone});
        ModLoader.addRecipe(new ItemStack(gateOn, 1, 15), new Object[]{"R", "T", Character.valueOf('R'), Item.redstone, Character.valueOf('T'), new ItemStack(gateOn, 1, 15)});
        ModLoader.addRecipe(new ItemStack(gateOn, 1, 16), new Object[]{"G", "P", Character.valueOf('G'), Item.lightStoneDust, Character.valueOf('P'), Block.pressurePlatePlanks});
        ModLoader.addRecipe(new ItemStack(gateOn, 1, 16), new Object[]{"G", "P", Character.valueOf('G'), Item.lightStoneDust, Character.valueOf('P'), Block.pressurePlateStone});
        ModLoader.addRecipe(new ItemStack(gateOn, 1, 17), new Object[]{"L", "P", Character.valueOf('L'), new ItemStack(Item.dyePowder, 1, 4), Character.valueOf('P'), Block.pressurePlatePlanks});
        ModLoader.addRecipe(new ItemStack(gateOn, 1, 17), new Object[]{"L", "P", Character.valueOf('L'), new ItemStack(Item.dyePowder, 1, 4), Character.valueOf('P'), Block.pressurePlateStone});
        ModLoader.addRecipe(new ItemStack(gateOn, 1, 18), new Object[]{"C", "P", Character.valueOf('C'), Block.chest, Character.valueOf('P'), Block.pressurePlatePlanks});
        ModLoader.addRecipe(new ItemStack(gateOn, 1, 18), new Object[]{"C", "P", Character.valueOf('C'), Block.chest, Character.valueOf('P'), Block.pressurePlateStone});
        ModLoader.addRecipe(new ItemStack(gateOn, 1, 19), new Object[]{"I", "G", Character.valueOf('I'), new ItemStack(gateOn, 1, 0), Character.valueOf('G'), new ItemStack(gateOn, 1, 18)});
        ModLoader.addRecipe(new ItemStack(gateOn, 1, 20), new Object[]{" I", "RS", Character.valueOf('R'), Item.redstone, Character.valueOf('S'), Block.stone, Character.valueOf('I'), Item.ingotIron});
        ModLoader.addRecipe(new ItemStack(gateOn, 1, 21), new Object[]{"DDD", "SSS", Character.valueOf('D'), Item.redstoneRepeater, Character.valueOf('S'), Block.stone});
        ModLoader.addRecipe(new ItemStack(gateOn, 1, 22), new Object[]{"DD", "SS", Character.valueOf('D'), Item.redstoneRepeater, Character.valueOf('S'), Block.stone});
        ModLoader.addRecipe(new ItemStack(gateOn, 1, 23), new Object[]{" + ", "+++", " + ", Character.valueOf('+'), Item.redstone});
        ModLoader.addRecipe(new ItemStack(gateOn, 2, 25), new Object[]{"+++", "+S+", "+++", Character.valueOf('+'), Item.redstone, Character.valueOf('S'), Block.stone});
        ModLoader.addShapelessRecipe(new ItemStack(lightOn, 1, 1), new Object[]{Item.redstone, Item.lightStoneDust});
        ModLoader.addShapelessRecipe(new ItemStack(lightOn, 1, 0), new Object[]{new ItemStack(lightOn, 1, 1), new ItemStack(Item.dyePowder, 1, 0)});
        ModLoader.addShapelessRecipe(new ItemStack(lightOn, 1, 2), new Object[]{new ItemStack(lightOn, 1, 1), new ItemStack(Item.dyePowder, 1, 2)});
        ModLoader.addShapelessRecipe(new ItemStack(lightOn, 1, 3), new Object[]{new ItemStack(lightOn, 1, 1), new ItemStack(Item.dyePowder, 1, 3)});
        ModLoader.addShapelessRecipe(new ItemStack(lightOn, 1, 4), new Object[]{new ItemStack(lightOn, 1, 1), new ItemStack(Item.dyePowder, 1, 4)});
        ModLoader.addShapelessRecipe(new ItemStack(lightOn, 1, 5), new Object[]{new ItemStack(lightOn, 1, 1), new ItemStack(Item.dyePowder, 1, 5)});
        ModLoader.addShapelessRecipe(new ItemStack(lightOn, 1, 6), new Object[]{new ItemStack(lightOn, 1, 1), new ItemStack(Item.dyePowder, 1, 6)});
        ModLoader.addShapelessRecipe(new ItemStack(lightOn, 1, 7), new Object[]{new ItemStack(lightOn, 1, 1), new ItemStack(Item.dyePowder, 1, 7)});
        ModLoader.addShapelessRecipe(new ItemStack(lightOn, 1, 8), new Object[]{new ItemStack(lightOn, 1, 1), new ItemStack(Item.dyePowder, 1, 8)});
        ModLoader.addShapelessRecipe(new ItemStack(lightOn, 1, 9), new Object[]{new ItemStack(lightOn, 1, 1), new ItemStack(Item.dyePowder, 1, 9)});
        ModLoader.addShapelessRecipe(new ItemStack(lightOn, 1, 10), new Object[]{new ItemStack(lightOn, 1, 1), new ItemStack(Item.dyePowder, 1, 10)});
        ModLoader.addShapelessRecipe(new ItemStack(lightOn, 1, 11), new Object[]{new ItemStack(lightOn, 1, 1), new ItemStack(Item.dyePowder, 1, 11)});
        ModLoader.addShapelessRecipe(new ItemStack(lightOn, 1, 12), new Object[]{new ItemStack(lightOn, 1, 1), new ItemStack(Item.dyePowder, 1, 12)});
        ModLoader.addShapelessRecipe(new ItemStack(lightOn, 1, 13), new Object[]{new ItemStack(lightOn, 1, 1), new ItemStack(Item.dyePowder, 1, 13)});
        ModLoader.addShapelessRecipe(new ItemStack(lightOn, 1, 14), new Object[]{new ItemStack(lightOn, 1, 1), new ItemStack(Item.dyePowder, 1, 14)});
        ModLoader.addShapelessRecipe(new ItemStack(lightOn, 1, 15), new Object[]{new ItemStack(lightOn, 1, 1), new ItemStack(Item.dyePowder, 1, 15)});
        ModLoader.addRecipe(new ItemStack(radio, 1, 0), new Object[]{" I ", "RIR", "SSS", Character.valueOf('I'), Item.ingotGold, Character.valueOf('R'), Item.redstone, Character.valueOf('S'), Block.stone});
        ModLoader.addRecipe(new ItemStack(radio, 1, 1), new Object[]{" I ", "RIR", "SSS", Character.valueOf('I'), Item.ingotIron, Character.valueOf('R'), Item.redstone, Character.valueOf('S'), Block.stone});
        ModLoader.addRecipe(new ItemStack(portableTx), new Object[]{"T", "B", Character.valueOf('B'), Block.button, Character.valueOf('T'), radio});
        ModLoader.addRecipe(new ItemStack(sensor, 1, 1), new Object[]{"R", "I", "S", Character.valueOf('I'), Item.ingotIron, Character.valueOf('R'), Item.redstone, Character.valueOf('S'), Block.stone});
        ModLoader.addRecipe(new ItemStack(sensor, 1, 0), new Object[]{"R", "I", "W", Character.valueOf('I'), Item.ingotIron, Character.valueOf('R'), Item.redstone, Character.valueOf('W'), Block.planks});
        ModLoader.addRecipe(new ItemStack(sensor, 1, 2), new Object[]{"R", "I", "O", Character.valueOf('I'), Item.ingotIron, Character.valueOf('R'), Item.redstone, Character.valueOf('O'), Block.obsidian});
    }

    @Override
    public void postInit() {
        PC_InveditManager.setDamageRange(mod_PClogic.gateOn.blockID, 0, 25);
        PC_InveditManager.setDamageRange(mod_PClogic.sensor.blockID, 0, 2);
        PC_InveditManager.hideItem(mod_PClogic.gateOff.blockID);
        PC_InveditManager.hideItem(mod_PClogic.lightOff.blockID);
        PC_InveditManager.setItemCategory(mod_PClogic.lightOn.blockID, "Control lights");
        PC_InveditManager.setItemCategory(mod_PClogic.pulsar.blockID, "Logic gates");
        PC_InveditManager.setItemCategory(mod_PClogic.gateOn.blockID, "Logic gates");
        PC_InveditManager.setItemCategory(mod_PClogic.sensor.blockID, "Wireless");
        PC_InveditManager.setItemCategory(mod_PClogic.radio.blockID, "Wireless");
        PC_InveditManager.setItemCategory(mod_PClogic.portableTx.shiftedIndex, "Wireless");
        mod_PClogic.addStackRangeToCraftingTool(PC_CraftingToolGroup.LOGIC, mod_PClogic.gateOn.blockID, 0, 25, 1);
        mod_PClogic.addStacksToCraftingTool(PC_CraftingToolGroup.LOGIC, new ItemStack(pulsar));
        mod_PClogic.addStackRangeToCraftingTool(PC_CraftingToolGroup.LOGIC, mod_PClogic.lightOn.blockID, 0, 15, 1);
        mod_PClogic.addStacksToCraftingTool(PC_CraftingToolGroup.WIRELESS, new ItemStack(radio, 1, 0), new ItemStack(radio, 1, 1), new ItemStack(sensor, 1, 0), new ItemStack(sensor, 1, 1), new ItemStack(sensor, 1, 2));
        mod_PClogic.addStacksToCraftingTool(PC_CraftingToolGroup.HANDHELD, new ItemStack(portableTx));
    }

    @Override
    public boolean renderWorldBlock(RenderBlocks renderblocks, IBlockAccess iblockaccess, int i, int j, int k, Block block, int renderType) {
        return false;
    }

    @Override
    public void renderInvBlock(RenderBlocks renderblocks, Block block, int i, int rtype) {
        PClo_Renderer.renderInvBlockByType(renderblocks, block, i, rtype);
    }
}

