/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.io.ByteArrayInputStream;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import net.minecraft.client.Minecraft;
import net.minecraft.src.Block;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.MathHelper;
import net.minecraft.src.ModLoader;
import net.minecraft.src.PC_Color;
import net.minecraft.src.PC_CoordI;
import net.minecraft.src.PC_CraftingToolGroup;
import net.minecraft.src.PC_CropHarvestingManager;
import net.minecraft.src.PC_IActivatorListener;
import net.minecraft.src.PC_InveditManager;
import net.minecraft.src.PC_Logger;
import net.minecraft.src.PC_Module;
import net.minecraft.src.PC_PropertyManager;
import net.minecraft.src.PC_Renderer;
import net.minecraft.src.PC_Struct3;
import net.minecraft.src.PC_TreeHarvestingManager;
import net.minecraft.src.PC_Utils;
import net.minecraft.src.PC_WorldGenMinableMetadata;
import net.minecraft.src.PCco_BlockPowerCrystal;
import net.minecraft.src.PCco_GuiSpawnerEditor;
import net.minecraft.src.PCco_GuiUpdateNotification;
import net.minecraft.src.PCco_ItemActivator;
import net.minecraft.src.PCco_ItemBlockPowerCrystal;
import net.minecraft.src.PCco_ItemCraftingTool;
import net.minecraft.src.PCco_ItemOreSniffer;
import net.minecraft.src.PCco_ItemPowerDust;
import net.minecraft.src.PCco_Renderer;
import net.minecraft.src.PCco_SlotDirectCrafting;
import net.minecraft.src.PCco_ThreadCheckUpdates;
import net.minecraft.src.PCco_ThreadDownloadTranslations;
import net.minecraft.src.RenderBlocks;
import net.minecraft.src.TileEntity;
import net.minecraft.src.TileEntityMobSpawner;
import net.minecraft.src.TileEntitySign;
import net.minecraft.src.TileEntitySpecialRenderer;
import net.minecraft.src.UnexpectedThrowable;
import net.minecraft.src.World;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class mod_PCcore
extends PC_Module
implements PC_IActivatorListener {
    public static mod_PCcore instance;
    public static final String VERSION = "3.4p4";
    public static final String updateInfoPath = "http://dl.dropbox.com/u/64454818/POWERCRAFT_DATA/info.xml";
    public static final String updateLangPath = "http://dl.dropbox.com/u/64454818/POWERCRAFT_DATA/lang.zip";
    public static final String cfgdir = "/PowerCraft";
    public static Item craftingTool;
    public static Item activator;
    public static Item powerDust;
    public static PCco_ItemOreSniffer oreSniffer;
    public static Block powerCrystal;
    private boolean optUpdateNotify;
    public static boolean soundsEnabled;
    public static String update_last_ignored_version;
    public static String current_lang_version;
    public static final String pk_keyReverse = "global.key.reverse_placing";
    private static final String pk_optRecRecyclation = "opt.new_recipes.recyclation";
    private static final String pk_optRecSpawner = "opt.new_recipes.spawner";
    private static final String pk_optRecEasyCrystals = "opt.cheat.easy_crystals";
    private static final String pk_idCraftingTool = "id.item.crafting_tool";
    private static final String pk_idActivator = "id.item.activation_crystal";
    private static final String pk_idPowerDust = "id.item.power_dust";
    private static final String pk_idCrystal = "id.block.power_crystal";
    private static final String pk_idSniffer = "id.item.ore_sniffer";
    private static final String pk_brightCrystal = "brightness.power_crystal";
    private static final String pk_optCraftCheating = "opt.crafting_tool.cheat_in_survival";
    private static final String pk_genCrystalsInChunk = "opt.worldgen.crystals.in_chunk";
    private static final String pk_genCrystalsDepositMaxCount = "opt.worldgen.crystals.deposit_max_size";
    private static final String pk_genCrystalsMinY = "opt.worldgen.crystals.min_y";
    private static final String pk_genCrystalsMaxY = "opt.worldgen.crystals.max_y";
    private static final String pk_genCrystal_gen = "opt.worldgen.crystals.enabled";
    private static final String pk_optUpdates = "global.checkUpdates";
    private static final String pk_optMuteSound = "global.disableSounds";
    private static final String pk_optSoundCrystal = "opt.power_crystal.soundEnabled";
    public static final String pk_cfgUpdateIgnored = "cfg.updateVersionMarkedAsIgnored";
    public static final String pk_cfgCurrentLangVersion = "cfg.currentLangVersion";
    public static boolean updateAvailable;
    public static String updateModVersion;
    public static String updateMcVersion;
    public static String updateLangVersion;
    public static String updateText;
    private static boolean updateAlreadyShown;
    private int inGameTickCounter = 0;

    @Override
    public String getVersion() {
        return VERSION;
    }

    public static String getImgDir() {
        return "/PowerCraft/core/";
    }

    public static String getTerrainFile() {
        return mod_PCcore.getImgDir() + "tiles.png";
    }

    @Override
    public String getPriorities() {
        return "before:*";
    }

    @Override
    public String getModuleName() {
        return "CORE";
    }

    @Override
    public int addFuel(int i, int j) {
        return i == mod_PCcore.powerDust.shiftedIndex ? 2200 : 0;
    }

    @Override
    public void preInit() {
        Thread.setDefaultUncaughtExceptionHandler(new PC_ErrorHandler());
        instance = this;
        new PCco_ThreadCheckUpdates().start();
    }

    @Override
    public void initProperties(PC_PropertyManager conf) {
        conf.putKey(pk_keyReverse, 29, "Keyboard key used to place blocks in reversed orientation");
        conf.putBoolean(pk_optRecRecyclation, true, "Add new recypes allowing easy material recyclation");
        conf.putBoolean(pk_optRecSpawner, true, "Make spawners craftable of iron and mossy cobble");
        conf.putItem(pk_idCraftingTool, 19003);
        conf.putItem(pk_idActivator, 19001);
        conf.putItem(pk_idPowerDust, 19002);
        conf.putItem(pk_idSniffer, 19004);
        conf.putBlock(pk_idCrystal, 232);
        conf.putBoolean(pk_genCrystal_gen, true, "Generate Power Crystals in the world?");
        conf.putInteger(pk_brightCrystal, 15, "Power Crystal block brightness, scale 0-15.");
        conf.putBoolean(pk_optRecEasyCrystals, false, "Get power crystals by smelting diamonds,\nchange crystals color by crafting.");
        conf.putInteger(pk_genCrystalsInChunk, 3, "Number of deposits in each 16x16 chunk.");
        conf.putInteger(pk_genCrystalsDepositMaxCount, 4, "Highest crystal count in one deposit");
        conf.putInteger(pk_genCrystalsMinY, 5, "Min Y coordinate of crystal deposits.");
        conf.putInteger(pk_genCrystalsMaxY, 15, "Max Y coordinate of crystal deposits.");
        conf.putBoolean(pk_optUpdates, true, "Checks updates each time the game starts, and informs\nyou via a dialog when a world is loaded.");
        conf.putBoolean(pk_optMuteSound, false, "Disable all sounds and breaking animations with sounds.");
        conf.putBoolean(pk_optSoundCrystal, true, "Enable \"jingle\" sounds made by PowerCrystals.");
        conf.putBoolean(pk_optCraftCheating, false, "Makes the Crafting Tool work like TMI in Survival,\ngiving you everything with no resources consumed.");
        conf.putString(pk_cfgUpdateIgnored, this.getVersion());
        conf.putString(pk_cfgCurrentLangVersion, "0");
        conf.apply();
        PCco_SlotDirectCrafting.survivalCheating = conf.flag(pk_optCraftCheating);
        this.optUpdateNotify = conf.flag(pk_optUpdates);
        System.out.println("updnotify " + this.optUpdateNotify);
        soundsEnabled = conf.flag(pk_optMuteSound) == false;
        PCco_BlockPowerCrystal.makeSound = conf.flag(pk_optSoundCrystal) == false;
        update_last_ignored_version = conf.string(pk_cfgUpdateIgnored);
        current_lang_version = conf.string(pk_cfgCurrentLangVersion);
    }

    @Override
    public void registerEntities(List<PC_Struct3<Class<? extends Entity>, String, Integer>> list) {
    }

    @Override
    public void registerTileEntities(List<PC_Struct3<Class<? extends TileEntity>, String, TileEntitySpecialRenderer>> list) {
    }

    @Override
    public void registerBlockRenderers() {
        PC_Renderer.swapTerrainRenderer = ModLoader.getUniqueBlockModelID(this, true);
        PC_Renderer.rotatedBoxRenderer = ModLoader.getUniqueBlockModelID(this, true);
        PCco_Renderer.crystalRenderer = ModLoader.getUniqueBlockModelID(this, true);
    }

    @Override
    public void registerBlocks(List<Block> list) {
        powerCrystal = new PCco_BlockPowerCrystal((int)this.cfg().num(pk_idCrystal), 49).setHardness(0.5f).setResistance(0.5f).setBlockName("PCcoPowerCrystal").setStepSound(Block.soundGlassFootstep).setLightValue((float)this.cfg().num(pk_brightCrystal).intValue() * 0.0625f);
        list.add(powerCrystal);
    }

    @Override
    public void registerItems() {
        craftingTool = new PCco_ItemCraftingTool(this.cfg().num(pk_idCraftingTool)).setItemName("PCcoGateCrafter");
        activator = new PCco_ItemActivator(this.cfg().num(pk_idActivator)).setIconIndex(37).setItemName("PCcoActivatorItem");
        powerDust = new PCco_ItemPowerDust(this.cfg().num(pk_idPowerDust)).setIconCoord(13, 9).setItemName("PCcoPowerDust");
        oreSniffer = (PCco_ItemOreSniffer)new PCco_ItemOreSniffer(this.cfg().num(pk_idSniffer)).setIconIndex(37).setItemName("PCcoOreSnifferItem");
        mod_PCcore.removeBlockItem(mod_PCcore.powerCrystal.blockID);
        mod_PCcore.setBlockItem(mod_PCcore.powerCrystal.blockID, new PCco_ItemBlockPowerCrystal(mod_PCcore.powerCrystal.blockID - 256));
    }

    @Override
    public void preloadTextures(List<String> list) {
        list.add(mod_PCcore.getTerrainFile());
        list.add(mod_PCcore.getImgDir() + "gres/dialog.png");
        list.add(mod_PCcore.getImgDir() + "gres/widgets.png");
        list.add(mod_PCcore.getImgDir() + "gres/frame.png");
        list.add(mod_PCcore.getImgDir() + "gres/button.png");
        list.add(mod_PCcore.getImgDir() + "graphics.png");
    }

    @Override
    public void setTextures() {
        craftingTool.setIconIndex(ModLoader.addOverride("/gui/items.png", mod_PCcore.getImgDir() + "item_craftingtool.png"));
        activator.setIconIndex(ModLoader.addOverride("/gui/items.png", mod_PCcore.getImgDir() + "item_activator.png"));
        oreSniffer.setIconIndex(ModLoader.addOverride("/gui/items.png", mod_PCcore.getImgDir() + "item_sniffer.png"));
    }

    @Override
    public void setNames(Map<Object, String> map) {
        map.put(craftingTool, "PowerCraft's Crafting Tool");
        map.put(activator, "Activation Crystal");
        map.put(powerCrystal, "Power Crystal");
        map.put(powerDust, "Power Dust");
        map.put(oreSniffer, "Ore Sniffer");
        map.put("tile.PCcoPowerCrystal.color0.name", "\u03b1 Power Crystal");
        map.put("tile.PCcoPowerCrystal.color1.name", "\u03b2 Power Crystal");
        map.put("tile.PCcoPowerCrystal.color2.name", "\u03b3 Power Crystal");
        map.put("tile.PCcoPowerCrystal.color3.name", "\u03b4 Power Crystal");
        map.put("tile.PCcoPowerCrystal.color4.name", "\u03d1 Power Crystal");
        map.put("tile.PCcoPowerCrystal.color5.name", "\u03b6 Power Crystal");
        map.put("tile.PCcoPowerCrystal.color6.name", "\u03be Power Crystal");
        map.put("tile.PCcoPowerCrystal.color7.name", "\u03d7 Power Crystal");
        map.put("pc.gui.craftingTool.title", "PowerCraft's Crafting Tool");
        map.put("pc.gui.spawnerEditor.enableDangerous", "Enable dangerous");
        map.put("pc.gui.ok", "OK");
        map.put("pc.gui.cancel", "Cancel");
        map.put("pc.sniffer.sniffing", "Sniffing ores...");
        map.put("pc.sniffer.away", "(far away)");
        map.put("pc.sniffer.desc", "Portable radar device");
        map.put("pc.gui.update.title", "Mod Update Notification");
        map.put("pc.gui.update.newVersionAvailable", "Update available!");
        map.put("pc.gui.update.readMore", "Read more...");
        map.put("pc.gui.update.version", "Using %1$s (%2$s), Available %3$s (%4$s)");
        map.put("pc.gui.update.doNotShowAgain", "Don't show again");
    }

    @Override
    public void addRecipes() {
        ModLoader.addRecipe(new ItemStack(craftingTool), new Object[]{" r ", "rIr", " r ", Character.valueOf('r'), Item.redstone, Character.valueOf('I'), Block.blockSteel});
        ModLoader.addShapelessRecipe(new ItemStack(craftingTool), new Object[]{Block.dirt});
        ModLoader.addShapelessRecipe(new ItemStack(Block.wood, 32), new Object[]{Block.dirt, Block.dirt});
        if (this.cfg().getBoolean(pk_optRecRecyclation).booleanValue()) {
            ModLoader.addShapelessRecipe(new ItemStack(Block.sand, 4), new Object[]{new ItemStack(Block.sandStone, 1, -1)});
            ModLoader.addShapelessRecipe(new ItemStack(Block.planks, 6), new Object[]{Item.doorWood});
            ModLoader.addShapelessRecipe(new ItemStack(Block.planks, 8), new Object[]{Block.chest});
            ModLoader.addShapelessRecipe(new ItemStack(Block.planks, 4), new Object[]{Block.workbench});
            ModLoader.addShapelessRecipe(new ItemStack(Block.planks, 2), new Object[]{Block.pressurePlatePlanks});
            ModLoader.addShapelessRecipe(new ItemStack(Block.stone, 2), new Object[]{Block.pressurePlateStone});
            ModLoader.addShapelessRecipe(new ItemStack(Block.stone, 2), new Object[]{Block.button});
            ModLoader.addShapelessRecipe(new ItemStack(Item.stick, 3), new Object[]{Block.fence});
            ModLoader.addShapelessRecipe(new ItemStack(Item.stick, 2), new Object[]{Block.ladder});
            ModLoader.addShapelessRecipe(new ItemStack(Block.planks, 6), new Object[]{Item.sign});
            ModLoader.addShapelessRecipe(new ItemStack(Item.ingotIron, 6), new Object[]{Item.doorSteel});
            ModLoader.addShapelessRecipe(new ItemStack(Block.cobblestone, 8), new Object[]{Block.stoneOvenIdle});
            ModLoader.addShapelessRecipe(new ItemStack(Item.ingotIron, 5), new Object[]{Item.minecartEmpty});
            ModLoader.addShapelessRecipe(new ItemStack(Item.ingotIron, 3), new Object[]{Item.bucketEmpty});
            ModLoader.addShapelessRecipe(new ItemStack(Block.planks, 5), new Object[]{Item.boat});
            ModLoader.addShapelessRecipe(new ItemStack(Item.stick, 3), new Object[]{Block.fence});
            ModLoader.addShapelessRecipe(new ItemStack(Item.stick, 8), new Object[]{Block.fenceGate});
            ModLoader.addShapelessRecipe(new ItemStack(Item.stick, 7), new Object[]{Block.ladder, Block.ladder});
            ModLoader.addShapelessRecipe(new ItemStack(Block.stone), new Object[]{new ItemStack(Block.stoneBrick, 1, -1)});
            ModLoader.addShapelessRecipe(new ItemStack(Item.ingotIron, 7), new Object[]{new ItemStack(Item.cauldron, 1, -1)});
            ModLoader.addShapelessRecipe(new ItemStack(Block.planks, 3), new Object[]{Block.trapdoor});
            ModLoader.addShapelessRecipe(new ItemStack(Block.planks, 1), new Object[]{Item.stick, Item.stick});
        }
        if (this.cfg().getBoolean(pk_optRecSpawner).booleanValue()) {
            ModLoader.addRecipe(new ItemStack(Block.mobSpawner, 1), new Object[]{"SIS", "I I", "SIS", Character.valueOf('I'), Item.ingotIron, Character.valueOf('S'), Block.cobblestoneMossy});
        }
        if (this.cfg().getBoolean(pk_optRecEasyCrystals).booleanValue()) {
            ModLoader.addSmelting(Item.diamond.shiftedIndex, new ItemStack(powerCrystal, 1));
            ModLoader.addShapelessRecipe(new ItemStack(powerCrystal, 1, 1), new Object[]{new ItemStack(powerCrystal, 1, 0)});
            ModLoader.addShapelessRecipe(new ItemStack(powerCrystal, 1, 2), new Object[]{new ItemStack(powerCrystal, 1, 1)});
            ModLoader.addShapelessRecipe(new ItemStack(powerCrystal, 1, 3), new Object[]{new ItemStack(powerCrystal, 1, 2)});
            ModLoader.addShapelessRecipe(new ItemStack(powerCrystal, 1, 4), new Object[]{new ItemStack(powerCrystal, 1, 3)});
            ModLoader.addShapelessRecipe(new ItemStack(powerCrystal, 1, 5), new Object[]{new ItemStack(powerCrystal, 1, 4)});
            ModLoader.addShapelessRecipe(new ItemStack(powerCrystal, 1, 6), new Object[]{new ItemStack(powerCrystal, 1, 5)});
            ModLoader.addShapelessRecipe(new ItemStack(powerCrystal, 1, 7), new Object[]{new ItemStack(powerCrystal, 1, 6)});
            ModLoader.addShapelessRecipe(new ItemStack(powerCrystal), new Object[]{new ItemStack(powerCrystal, 1, 7)});
            ModLoader.addShapelessRecipe(new ItemStack(powerDust, 25, 0), new Object[]{new ItemStack(powerCrystal, 1, -1), new ItemStack(Item.coal, 1, -1)});
        } else {
            ModLoader.addShapelessRecipe(new ItemStack(powerDust, 24, 0), new Object[]{new ItemStack(powerCrystal, 1, -1)});
        }
        ModLoader.addRecipe(new ItemStack(oreSniffer), new Object[]{" G ", "GCG", " G ", Character.valueOf('C'), new ItemStack(powerCrystal, 1, -1), Character.valueOf('G'), Item.ingotGold});
        ModLoader.addRecipe(new ItemStack(activator, 1), new Object[]{"C", "I", Character.valueOf('C'), new ItemStack(powerCrystal, 1, -1), Character.valueOf('I'), Item.ingotIron});
    }

    @Override
    public void postInit() {
        PC_CropHarvestingManager.loadCrops();
        PC_TreeHarvestingManager.loadTrees();
        PC_Module.registerActivatorListener(this);
        oreSniffer.initNames();
        PC_InveditManager.setDamageRange(mod_PCcore.powerCrystal.blockID, 0, 7);
        PC_InveditManager.setItemCategory(mod_PCcore.powerCrystal.blockID, "Power crystals");
        PC_InveditManager.setItemCategory(mod_PCcore.powerDust.shiftedIndex, "Power crystals");
        PC_InveditManager.setItemCategory(mod_PCcore.craftingTool.shiftedIndex, "Handheld devices");
        PC_InveditManager.setItemCategory(mod_PCcore.activator.shiftedIndex, "Handheld devices");
        PC_InveditManager.setItemCategory(mod_PCcore.oreSniffer.shiftedIndex, "Handheld devices");
        ItemStack[] crystals = new ItemStack[9];
        for (int i = 0; i < 8; ++i) {
            crystals[i] = new ItemStack(powerCrystal, 1, i);
        }
        crystals[8] = new ItemStack(powerDust);
        mod_PCcore.addStacksToCraftingTool(PC_CraftingToolGroup.DECORATIVE, crystals);
        mod_PCcore.addStacksToCraftingTool(PC_CraftingToolGroup.HANDHELD, new ItemStack(activator), new ItemStack(oreSniffer), new ItemStack(craftingTool));
        mod_PCcore.addStacksToCraftingTool(PC_CraftingToolGroup.VANILLA_RELATED, new ItemStack(Item.redstone), new ItemStack(Item.redstoneRepeater), new ItemStack(Block.torchRedstoneActive), new ItemStack(Block.lever), new ItemStack(Block.button), new ItemStack(Block.pressurePlateStone), new ItemStack(Block.pressurePlatePlanks), new ItemStack(Block.redstoneLampIdle), new ItemStack(Block.pistonBase), new ItemStack(Block.pistonStickyBase), new ItemStack(Block.mobSpawner), new ItemStack(Block.music), new ItemStack(Block.jukebox), new ItemStack(Block.dispenser), new ItemStack(Block.stoneOvenIdle), new ItemStack(Block.chest), new ItemStack(Block.workbench), new ItemStack(Block.glowStone), new ItemStack(Item.lightStoneDust), new ItemStack(Block.tnt), new ItemStack(Item.fireballCharge), new ItemStack(Block.rail), new ItemStack(Block.railDetector), new ItemStack(Block.railPowered), new ItemStack(Item.minecartEmpty), new ItemStack(Item.minecartCrate), new ItemStack(Item.minecartPowered), new ItemStack(Block.ladder), new ItemStack(Block.trapdoor), new ItemStack(Item.doorSteel), new ItemStack(Item.doorWood), new ItemStack(Item.cauldron), new ItemStack(Item.brewingStand), new ItemStack(Item.bucketEmpty), new ItemStack(Block.enchantmentTable), new ItemStack(Item.glassBottle), new ItemStack(Item.blazePowder), new ItemStack(Item.magmaCream), new ItemStack(Item.netherStalkSeeds), new ItemStack(Item.sugar), new ItemStack(Item.gunpowder), new ItemStack(Item.spiderEye), new ItemStack(Item.fermentedSpiderEye), new ItemStack(Item.eyeOfEnder), new ItemStack(Item.ghastTear), new ItemStack(Item.speckledMelon), new ItemStack(Item.goldNugget), new ItemStack(Item.dyePowder, 1, 15), new ItemStack(Block.mushroomBrown), new ItemStack(Block.mushroomRed), new ItemStack(Block.sapling, 1, 0), new ItemStack(Block.sapling, 1, 1), new ItemStack(Block.sapling, 1, 2), new ItemStack(Block.sapling, 1, 3), new ItemStack(Item.compass), new ItemStack(Item.pocketSundial), new ItemStack(Item.fishingRod), new ItemStack(Item.shears), new ItemStack(Block.torchWood), new ItemStack(Item.sign), new ItemStack(Block.fence), new ItemStack(Block.fenceGate), new ItemStack(Item.stick), new ItemStack(Block.blockDiamond), new ItemStack(Block.blockGold), new ItemStack(Block.blockSteel), new ItemStack(Block.blockLapis), new ItemStack(Item.diamond), new ItemStack(Item.ingotGold), new ItemStack(Item.ingotIron), new ItemStack(Item.dyePowder, PC_Color.dye.BLUE.meta), new ItemStack(Block.planks), new ItemStack(Block.obsidian), new ItemStack(Block.stone, 1, 0), new ItemStack(Block.cobblestone), new ItemStack(Block.cobblestoneMossy), new ItemStack(Block.stoneBrick), new ItemStack(Block.blockClay), new ItemStack(Block.brick), new ItemStack(Block.sand), new ItemStack(Block.sandStone));
        if (this.optUpdateNotify) {
            ModLoader.setInGameHook(this, true, false);
        }
    }

    @Override
    public boolean renderWorldBlock(RenderBlocks renderblocks, IBlockAccess blockAccess, int i, int j, int k, Block block, int rtype) {
        boolean flag = false;
        flag |= PC_Renderer.renderBlockByType(renderblocks, blockAccess, i, j, k, block, rtype);
        return flag |= PCco_Renderer.renderBlockByType(renderblocks, blockAccess, i, j, k, block, rtype);
    }

    @Override
    public void renderInvBlock(RenderBlocks renderblocks, Block block, int i, int rtype) {
        PC_Renderer.renderInvBlockByType(renderblocks, block, i, rtype);
        PCco_Renderer.renderInvBlockByType(renderblocks, block, i, rtype);
    }

    @Override
    public void generateSurface(World world, Random random, int chunkX, int chunkZ) {
        if (!this.cfg().flag(pk_genCrystal_gen).booleanValue()) {
            return;
        }
        for (int q = 0; q < this.cfg().num(pk_genCrystalsInChunk); ++q) {
            int maxBlocks = random.nextInt(MathHelper.clamp_int(this.cfg().num(pk_genCrystalsDepositMaxCount) - 1, 1, 10)) + 2;
            int posX = chunkX + random.nextInt(16);
            int posY = MathHelper.clamp_int(random.nextInt(MathHelper.clamp_int(this.cfg().num(pk_genCrystalsMaxY) - this.cfg().num(pk_genCrystalsMinY), 1, 255)) + this.cfg().num(pk_genCrystalsMinY), 1, 255);
            int posZ = chunkZ + random.nextInt(16);
            PC_Logger.finest("Generating PowerCrystals deposit of size " + maxBlocks + " at coords " + new PC_CoordI(posX, posY, posZ));
            new PC_WorldGenMinableMetadata(mod_PCcore.powerCrystal.blockID, random.nextInt(8), maxBlocks).generate(world, random, posX, posY, posZ);
        }
    }

    @Override
    public boolean onActivatorUsedOnBlock(ItemStack stack, EntityPlayer player, World world, PC_CoordI pos) {
        if (pos.getId(world) == Block.mobSpawner.blockID) {
            PC_Utils.openGres(player, new PCco_GuiSpawnerEditor((TileEntityMobSpawner)pos.getTileEntity(world)));
            stack.damageItem(1, player);
            return true;
        }
        if (pos.getId(world) == Block.signPost.blockID || pos.getId(world) == Block.signWall.blockID) {
            TileEntitySign tileentitysign = (TileEntitySign)world.getBlockTileEntity(pos.x, pos.y, pos.z);
            if (tileentitysign != null) {
                player.displayGUIEditSign(tileentitysign);
                stack.damageItem(1, player);
            }
            return true;
        }
        return false;
    }

    public static void updateCheckingThreadResult(String file_contents) {
        PC_Logger.fine("\n\nUpdate information received from server.");
        try {
            Element latest;
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(new ByteArrayInputStream(file_contents.getBytes("UTF-8")));
            doc.getDocumentElement().normalize();
            NodeList latest_l = doc.getElementsByTagName("update");
            if (latest_l.getLength() == 1 && (updateModVersion = (latest = (Element)latest_l.item(0)).getAttribute("modVersion")) != null && !updateModVersion.equals("") && (updateMcVersion = latest.getAttribute("mcVersion")) != null && !updateMcVersion.equals("")) {
                updateLangVersion = latest.getAttribute("langVersion");
                String updateLangModVersion = latest.getAttribute("langModVersion");
                if (updateLangVersion != null && !updateLangVersion.equals("") && !updateLangVersion.equals(current_lang_version) && updateLangModVersion.equals(instance.getVersion())) {
                    new PCco_ThreadDownloadTranslations().start();
                }
                if ((updateText = latest.getTextContent()) != null && !updateText.equals("")) {
                    updateText = updateText.trim();
                    updateAvailable = !updateModVersion.equals(instance.getVersion()) && !updateModVersion.equals(update_last_ignored_version);
                    PC_Logger.finer("* Update mod version = " + updateModVersion);
                    PC_Logger.finer("* Update MC version = " + updateMcVersion);
                    PC_Logger.finer("* Latest language pack version = " + updateLangVersion);
                    PC_Logger.finer("* Update info = " + updateText);
                }
            }
        }
        catch (SAXParseException err) {
            PC_Logger.severe("** Parsing error, line " + err.getLineNumber() + ", uri " + err.getSystemId());
            PC_Logger.severe(" " + err.getMessage());
        }
        catch (SAXException e) {
            Exception x = e.getException();
            (x == null ? e : x).printStackTrace();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    @Override
    public boolean onTickInGame(float f, Minecraft minecraft) {
        System.out.println("already shown=" + updateAlreadyShown);
        System.out.println("available=" + updateAvailable);
        System.out.println("optUpdateNotify=" + this.optUpdateNotify);
        System.out.println("counter=" + this.inGameTickCounter);
        if (!updateAlreadyShown && updateAvailable && this.optUpdateNotify) {
            if (++this.inGameTickCounter > 20) {
                updateAlreadyShown = true;
                PC_Utils.openGres(mod_PCcore.mc.thePlayer, new PCco_GuiUpdateNotification());
                PC_Logger.fine("Openning UPDATE NOTIFICATION screen.");
                return false;
            }
            return true;
        }
        return false;
    }

    static {
        updateAvailable = false;
        updateModVersion = "";
        updateMcVersion = "";
        updateLangVersion = "";
        updateText = "";
        updateAlreadyShown = false;
    }

    private static class PC_ErrorHandler
    implements Thread.UncaughtExceptionHandler {
        private PC_ErrorHandler() {
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            PC_Logger.throwing(e.getClass().getName(), "Uncaught Exception", e);
            PC_Utils.mc().onMinecraftCrash(new UnexpectedThrowable("Uncaught Exception\n" + e.getMessage(), e));
        }
    }
}

