/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.Block;
import net.minecraft.src.Chunk;
import net.minecraft.src.ChunkCache;
import net.minecraft.src.Entity;
import net.minecraft.src.ICamera;
import net.minecraft.src.RenderBlocks;
import net.minecraft.src.RenderItem;
import net.minecraft.src.Tessellator;
import net.minecraft.src.TileEntity;
import net.minecraft.src.TileEntityRenderer;
import net.minecraft.src.World;
import org.lwjgl.opengl.GL11;

public class WorldRenderer {
    public World worldObj;
    private int glRenderList = -1;
    private static Tessellator tessellator;
    public static int chunksUpdated;
    public int posX;
    public int posY;
    public int posZ;
    public int posXMinus;
    public int posYMinus;
    public int posZMinus;
    public int posXClip;
    public int posYClip;
    public int posZClip;
    public boolean isInFrustum = false;
    public boolean[] skipRenderPass = new boolean[2];
    public int posXPlus;
    public int posYPlus;
    public int posZPlus;
    public boolean needsUpdate;
    public AxisAlignedBB rendererBoundingBox;
    public int chunkIndex;
    public boolean isVisible = true;
    public boolean isWaitingOnOcclusionQuery;
    public int glOcclusionQuery;
    public boolean isChunkLit;
    private boolean isInitialized = false;
    public List tileEntityRenderers = new ArrayList();
    private List tileEntities;
    private int bytesDrawn;

    public WorldRenderer(World par1World, List par2List, int par3, int par4, int par5, int par6) {
        this.worldObj = par1World;
        this.tileEntities = par2List;
        this.glRenderList = par6;
        this.posX = -999;
        this.setPosition(par3, par4, par5);
        this.needsUpdate = false;
    }

    public void setPosition(int par1, int par2, int par3) {
        if (par1 == this.posX && par2 == this.posY && par3 == this.posZ) {
            return;
        }
        this.setDontDraw();
        this.posX = par1;
        this.posY = par2;
        this.posZ = par3;
        this.posXPlus = par1 + 8;
        this.posYPlus = par2 + 8;
        this.posZPlus = par3 + 8;
        this.posXClip = par1 & 0x3FF;
        this.posYClip = par2;
        this.posZClip = par3 & 0x3FF;
        this.posXMinus = par1 - this.posXClip;
        this.posYMinus = par2 - this.posYClip;
        this.posZMinus = par3 - this.posZClip;
        float f = 6.0f;
        this.rendererBoundingBox = AxisAlignedBB.getBoundingBox((float)par1 - f, (float)par2 - f, (float)par3 - f, (float)(par1 + 16) + f, (float)(par2 + 16) + f, (float)(par3 + 16) + f);
        GL11.glNewList((int)(this.glRenderList + 2), (int)4864);
        RenderItem.renderAABB(AxisAlignedBB.getBoundingBoxFromPool((float)this.posXClip - f, (float)this.posYClip - f, (float)this.posZClip - f, (float)(this.posXClip + 16) + f, (float)(this.posYClip + 16) + f, (float)(this.posZClip + 16) + f));
        GL11.glEndList();
        this.markDirty();
    }

    private void setupGLTranslation() {
        GL11.glTranslatef((float)this.posXClip, (float)this.posYClip, (float)this.posZClip);
    }

    public void updateRenderer() {
        if (!this.needsUpdate) {
            return;
        }
        this.needsUpdate = false;
        int i = this.posX;
        int j = this.posY;
        int k = this.posZ;
        int l = this.posX + 16;
        int i1 = this.posY + 16;
        int j1 = this.posZ + 16;
        for (int k1 = 0; k1 < 2; ++k1) {
            this.skipRenderPass[k1] = true;
        }
        Chunk.isLit = false;
        HashSet hashset = new HashSet();
        hashset.addAll(this.tileEntityRenderers);
        this.tileEntityRenderers.clear();
        int l1 = 1;
        ChunkCache chunkcache = new ChunkCache(this.worldObj, i - l1, j - l1, k - l1, l + l1, i1 + l1, j1 + l1);
        if (!chunkcache.func_48452_a()) {
            ++chunksUpdated;
            RenderBlocks renderblocks = new RenderBlocks(chunkcache);
            this.bytesDrawn = 0;
            for (int i2 = 0; i2 < 2; ++i2) {
                boolean flag = false;
                boolean flag1 = false;
                boolean flag2 = false;
                for (int j2 = j; j2 < i1; ++j2) {
                    for (int k2 = k; k2 < j1; ++k2) {
                        for (int l2 = i; l2 < l; ++l2) {
                            Block block;
                            int j3;
                            TileEntity tileentity;
                            int i3 = chunkcache.getBlockId(l2, j2, k2);
                            if (i3 <= 0) continue;
                            if (!flag2) {
                                flag2 = true;
                                GL11.glNewList((int)(this.glRenderList + i2), (int)4864);
                                GL11.glPushMatrix();
                                this.setupGLTranslation();
                                float f = 1.000001f;
                                GL11.glTranslatef((float)-8.0f, (float)-8.0f, (float)-8.0f);
                                GL11.glScalef((float)f, (float)f, (float)f);
                                GL11.glTranslatef((float)8.0f, (float)8.0f, (float)8.0f);
                                tessellator.startDrawingQuads();
                                tessellator.setTranslation(-this.posX, -this.posY, -this.posZ);
                            }
                            if (i2 == 0 && Block.blocksList[i3].hasTileEntity() && TileEntityRenderer.instance.hasSpecialRenderer(tileentity = chunkcache.getBlockTileEntity(l2, j2, k2))) {
                                this.tileEntityRenderers.add(tileentity);
                            }
                            if ((j3 = (block = Block.blocksList[i3]).getRenderBlockPass()) != i2) {
                                flag = true;
                                continue;
                            }
                            if (j3 != i2) continue;
                            flag1 |= renderblocks.renderBlockByRenderType(block, l2, j2, k2);
                        }
                    }
                }
                if (flag2) {
                    this.bytesDrawn += tessellator.draw();
                    GL11.glPopMatrix();
                    GL11.glEndList();
                    tessellator.setTranslation(0.0, 0.0, 0.0);
                } else {
                    flag1 = false;
                }
                if (flag1) {
                    this.skipRenderPass[i2] = false;
                }
                if (!flag) break;
            }
        }
        HashSet hashset1 = new HashSet();
        hashset1.addAll(this.tileEntityRenderers);
        hashset1.removeAll(hashset);
        this.tileEntities.addAll(hashset1);
        hashset.removeAll(this.tileEntityRenderers);
        this.tileEntities.removeAll(hashset);
        this.isChunkLit = Chunk.isLit;
        this.isInitialized = true;
    }

    public float distanceToEntitySquared(Entity par1Entity) {
        float f = (float)(par1Entity.posX - (double)this.posXPlus);
        float f1 = (float)(par1Entity.posY - (double)this.posYPlus);
        float f2 = (float)(par1Entity.posZ - (double)this.posZPlus);
        return f * f + f1 * f1 + f2 * f2;
    }

    public void setDontDraw() {
        for (int i = 0; i < 2; ++i) {
            this.skipRenderPass[i] = true;
        }
        this.isInFrustum = false;
        this.isInitialized = false;
    }

    public void stopRendering() {
        this.setDontDraw();
        this.worldObj = null;
    }

    public int getGLCallListForPass(int par1) {
        if (!this.isInFrustum) {
            return -1;
        }
        if (!this.skipRenderPass[par1]) {
            return this.glRenderList + par1;
        }
        return -1;
    }

    public void updateInFrustum(ICamera par1ICamera) {
        this.isInFrustum = par1ICamera.isBoundingBoxInFrustum(this.rendererBoundingBox);
    }

    public void callOcclusionQueryList() {
        GL11.glCallList((int)(this.glRenderList + 2));
    }

    public boolean skipAllRenderPasses() {
        if (!this.isInitialized) {
            return false;
        }
        return this.skipRenderPass[0] && this.skipRenderPass[1];
    }

    public void markDirty() {
        this.needsUpdate = true;
    }

    static {
        chunksUpdated = 0;
        tessellator = Tessellator.instance;
    }
}

