/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.BiomeGenBase;
import net.minecraft.src.Block;
import net.minecraft.src.ChunkCoordinates;
import net.minecraft.src.ChunkProviderEnd;
import net.minecraft.src.IChunkProvider;
import net.minecraft.src.MathHelper;
import net.minecraft.src.Vec3D;
import net.minecraft.src.WorldChunkManagerHell;
import net.minecraft.src.WorldProvider;

public class WorldProviderEnd
extends WorldProvider {
    @Override
    public void registerWorldChunkManager() {
        this.worldChunkMgr = new WorldChunkManagerHell(BiomeGenBase.sky, 0.5f, 0.0f);
        this.worldType = 1;
        this.hasNoSky = true;
    }

    @Override
    public IChunkProvider getChunkProvider() {
        return new ChunkProviderEnd(this.worldObj, this.worldObj.getSeed());
    }

    @Override
    public float calculateCelestialAngle(long par1, float par3) {
        return 0.0f;
    }

    @Override
    public float[] calcSunriseSunsetColors(float par1, float par2) {
        return null;
    }

    @Override
    public Vec3D getFogColor(float par1, float par2) {
        int i = 0x8080A0;
        float f = MathHelper.cos(par1 * (float)Math.PI * 2.0f) * 2.0f + 0.5f;
        if (f < 0.0f) {
            f = 0.0f;
        }
        if (f > 1.0f) {
            f = 1.0f;
        }
        float f1 = (float)(i >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(i >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(i & 0xFF) / 255.0f;
        return Vec3D.createVector(f1 *= f * 0.0f + 0.15f, f2 *= f * 0.0f + 0.15f, f3 *= f * 0.0f + 0.15f);
    }

    @Override
    public boolean isSkyColored() {
        return false;
    }

    @Override
    public boolean canRespawnHere() {
        return false;
    }

    @Override
    public boolean func_48217_e() {
        return false;
    }

    @Override
    public float getCloudHeight() {
        return 8.0f;
    }

    @Override
    public boolean canCoordinateBeSpawn(int par1, int par2) {
        int i = this.worldObj.getFirstUncoveredBlock(par1, par2);
        if (i == 0) {
            return false;
        }
        return Block.blocksList[i].blockMaterial.blocksMovement();
    }

    @Override
    public ChunkCoordinates getEntrancePortalLocation() {
        return new ChunkCoordinates(100, 50, 0);
    }

    @Override
    public int getAverageGroundLevel() {
        return 50;
    }

    @Override
    public boolean func_48218_b(int par1, int par2) {
        return true;
    }
}

