/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.Block;
import net.minecraft.src.ChunkCoordinates;
import net.minecraft.src.IChunkProvider;
import net.minecraft.src.MathHelper;
import net.minecraft.src.Vec3D;
import net.minecraft.src.World;
import net.minecraft.src.WorldChunkManager;
import net.minecraft.src.WorldProviderEnd;
import net.minecraft.src.WorldProviderHell;
import net.minecraft.src.WorldProviderSurface;
import net.minecraft.src.WorldType;

public abstract class WorldProvider {
    public World worldObj;
    public WorldType terrainType;
    public WorldChunkManager worldChunkMgr;
    public boolean isHellWorld = false;
    public boolean hasNoSky = false;
    public float[] lightBrightnessTable = new float[16];
    public int worldType = 0;
    private float[] colorsSunriseSunset = new float[4];

    public final void registerWorld(World par1World) {
        this.worldObj = par1World;
        this.terrainType = par1World.getWorldInfo().getTerrainType();
        this.registerWorldChunkManager();
        this.generateLightBrightnessTable();
    }

    protected void generateLightBrightnessTable() {
        float f = 0.0f;
        for (int i = 0; i <= 15; ++i) {
            float f1 = 1.0f - (float)i / 15.0f;
            this.lightBrightnessTable[i] = (1.0f - f1) / (f1 * 3.0f + 1.0f) * (1.0f - f) + f;
        }
    }

    protected void registerWorldChunkManager() {
        this.worldChunkMgr = this.terrainType.getChunkManager(this.worldObj);
    }

    public IChunkProvider getChunkProvider() {
        return this.terrainType.getChunkGenerator(this.worldObj);
    }

    public boolean canCoordinateBeSpawn(int par1, int par2) {
        int i = this.worldObj.getFirstUncoveredBlock(par1, par2);
        return i == Block.grass.blockID;
    }

    public float calculateCelestialAngle(long par1, float par3) {
        int i = (int)(par1 % 24000L);
        float f = ((float)i + par3) / 24000.0f - 0.25f;
        if (f < 0.0f) {
            f += 1.0f;
        }
        if (f > 1.0f) {
            f -= 1.0f;
        }
        float f1 = f;
        f = 1.0f - (float)((Math.cos((double)f * Math.PI) + 1.0) / 2.0);
        f = f1 + (f - f1) / 3.0f;
        return f;
    }

    public int getMoonPhase(long par1, float par3) {
        return (int)(par1 / 24000L) % 8;
    }

    public boolean func_48217_e() {
        return true;
    }

    public float[] calcSunriseSunsetColors(float par1, float par2) {
        float f2;
        float f = 0.4f;
        float f1 = MathHelper.cos(par1 * (float)Math.PI * 2.0f) - 0.0f;
        if (f1 >= (f2 = -0.0f) - f && f1 <= f2 + f) {
            float f3 = (f1 - f2) / f * 0.5f + 0.5f;
            float f4 = 1.0f - (1.0f - MathHelper.sin(f3 * (float)Math.PI)) * 0.99f;
            f4 *= f4;
            this.colorsSunriseSunset[0] = f3 * 0.3f + 0.7f;
            this.colorsSunriseSunset[1] = f3 * f3 * 0.7f + 0.2f;
            this.colorsSunriseSunset[2] = f3 * f3 * 0.0f + 0.2f;
            this.colorsSunriseSunset[3] = f4;
            return this.colorsSunriseSunset;
        }
        return null;
    }

    public Vec3D getFogColor(float par1, float par2) {
        float f = MathHelper.cos(par1 * (float)Math.PI * 2.0f) * 2.0f + 0.5f;
        if (f < 0.0f) {
            f = 0.0f;
        }
        if (f > 1.0f) {
            f = 1.0f;
        }
        float f1 = 0.7529412f;
        float f2 = 0.8470588f;
        float f3 = 1.0f;
        return Vec3D.createVector(f1 *= f * 0.94f + 0.06f, f2 *= f * 0.94f + 0.06f, f3 *= f * 0.91f + 0.09f);
    }

    public boolean canRespawnHere() {
        return true;
    }

    public static WorldProvider getProviderForDimension(int par0) {
        return par0 != -1 ? (par0 != 0 ? (par0 != 1 ? null : new WorldProviderEnd()) : new WorldProviderSurface()) : new WorldProviderHell();
    }

    public float getCloudHeight() {
        return 128.0f;
    }

    public boolean isSkyColored() {
        return true;
    }

    public ChunkCoordinates getEntrancePortalLocation() {
        return null;
    }

    public int getAverageGroundLevel() {
        return this.terrainType.getSeaLevel(this.worldObj);
    }

    public boolean getWorldHasNoSky() {
        return this.terrainType.hasVoidParticles(this.hasNoSky);
    }

    public double getVoidFogYFactor() {
        return this.terrainType.voidFadeMagnitude();
    }

    public boolean func_48218_b(int par1, int par2) {
        return false;
    }
}

