/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

public class VillageDoorInfo {
    public final int posX;
    public final int posY;
    public final int posZ;
    public final int insideDirectionX;
    public final int insideDirectionZ;
    public int lastActivityTimestamp;
    public boolean isDetachedFromVillageFlag = false;
    private int doorOpeningRestrictionCounter = 0;

    public VillageDoorInfo(int par1, int par2, int par3, int par4, int par5, int par6) {
        this.posX = par1;
        this.posY = par2;
        this.posZ = par3;
        this.insideDirectionX = par4;
        this.insideDirectionZ = par5;
        this.lastActivityTimestamp = par6;
    }

    public int getDistanceSquared(int par1, int par2, int par3) {
        int i = par1 - this.posX;
        int j = par2 - this.posY;
        int k = par3 - this.posZ;
        return i * i + j * j + k * k;
    }

    public int getInsideDistanceSquare(int par1, int par2, int par3) {
        int i = par1 - this.posX - this.insideDirectionX;
        int j = par2 - this.posY;
        int k = par3 - this.posZ - this.insideDirectionZ;
        return i * i + j * j + k * k;
    }

    public int getInsidePosX() {
        return this.posX + this.insideDirectionX;
    }

    public int getInsidePosY() {
        return this.posY;
    }

    public int getInsidePosZ() {
        return this.posZ + this.insideDirectionZ;
    }

    public boolean isInside(int par1, int par2) {
        int i = par1 - this.posX;
        int j = par2 - this.posZ;
        return i * this.insideDirectionX + j * this.insideDirectionZ >= 0;
    }

    public void resetDoorOpeningRestrictionCounter() {
        this.doorOpeningRestrictionCounter = 0;
    }

    public void incrementDoorOpeningRestrictionCounter() {
        ++this.doorOpeningRestrictionCounter;
    }

    public int getDoorOpeningRestrictionCounter() {
        return this.doorOpeningRestrictionCounter;
    }
}

