/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.src.Block;
import net.minecraft.src.BlockDoor;
import net.minecraft.src.ChunkCoordinates;
import net.minecraft.src.Village;
import net.minecraft.src.VillageDoorInfo;
import net.minecraft.src.World;

public class VillageCollection {
    private World worldObj;
    private final List villagerPositionsList = new ArrayList();
    private final List newDoors = new ArrayList();
    private final List villageList = new ArrayList();
    private int tickCounter = 0;

    public VillageCollection(World par1World) {
        this.worldObj = par1World;
    }

    public void addVillagerPosition(int par1, int par2, int par3) {
        if (this.villagerPositionsList.size() > 64) {
            return;
        }
        if (!this.isVillagerPositionPresent(par1, par2, par3)) {
            this.villagerPositionsList.add(new ChunkCoordinates(par1, par2, par3));
        }
    }

    public void tick() {
        ++this.tickCounter;
        for (Village village : this.villageList) {
            village.tick(this.tickCounter);
        }
        this.removeAnnihilatedVillages();
        this.dropOldestVillagerPosition();
        this.addNewDoorsToVillageOrCreateVillage();
    }

    private void removeAnnihilatedVillages() {
        Iterator iterator = this.villageList.iterator();
        while (iterator.hasNext()) {
            Village village = (Village)iterator.next();
            if (!village.isAnnihilated()) continue;
            iterator.remove();
        }
    }

    public List func_48554_b() {
        return this.villageList;
    }

    public Village findNearestVillage(int par1, int par2, int par3, int par4) {
        Village village = null;
        float f = 3.402823E38f;
        for (Village village1 : this.villageList) {
            int i;
            float f1 = village1.getCenter().getDistanceSquared(par1, par2, par3);
            if (!(f1 < f) || !(f1 <= (float)((i = par4 + village1.getVillageRadius()) * i))) continue;
            village = village1;
            f = f1;
        }
        return village;
    }

    private void dropOldestVillagerPosition() {
        if (this.villagerPositionsList.isEmpty()) {
            return;
        }
        this.addUnassignedWoodenDoorsAroundToNewDoorsList((ChunkCoordinates)this.villagerPositionsList.remove(0));
    }

    private void addNewDoorsToVillageOrCreateVillage() {
        for (int i = 0; i < this.newDoors.size(); ++i) {
            VillageDoorInfo villagedoorinfo = (VillageDoorInfo)this.newDoors.get(i);
            boolean flag = false;
            for (Village village1 : this.villageList) {
                int j = (int)village1.getCenter().getEuclideanDistanceTo(villagedoorinfo.posX, villagedoorinfo.posY, villagedoorinfo.posZ);
                if (j > 32 + village1.getVillageRadius()) continue;
                village1.addVillageDoorInfo(villagedoorinfo);
                flag = true;
                break;
            }
            if (flag) continue;
            Village village = new Village(this.worldObj);
            village.addVillageDoorInfo(villagedoorinfo);
            this.villageList.add(village);
        }
        this.newDoors.clear();
    }

    private void addUnassignedWoodenDoorsAroundToNewDoorsList(ChunkCoordinates par1ChunkCoordinates) {
        int byte0 = 16;
        int byte1 = 4;
        int byte2 = 16;
        for (int i = par1ChunkCoordinates.posX - byte0; i < par1ChunkCoordinates.posX + byte0; ++i) {
            for (int j = par1ChunkCoordinates.posY - byte1; j < par1ChunkCoordinates.posY + byte1; ++j) {
                for (int k = par1ChunkCoordinates.posZ - byte2; k < par1ChunkCoordinates.posZ + byte2; ++k) {
                    if (!this.isWoodenDoorAt(i, j, k)) continue;
                    VillageDoorInfo villagedoorinfo = this.getVillageDoorAt(i, j, k);
                    if (villagedoorinfo == null) {
                        this.addDoorToNewListIfAppropriate(i, j, k);
                        continue;
                    }
                    villagedoorinfo.lastActivityTimestamp = this.tickCounter;
                }
            }
        }
    }

    private VillageDoorInfo getVillageDoorAt(int par1, int par2, int par3) {
        for (VillageDoorInfo villagedoorinfo : this.newDoors) {
            if (villagedoorinfo.posX != par1 || villagedoorinfo.posZ != par3 || Math.abs(villagedoorinfo.posY - par2) > 1) continue;
            return villagedoorinfo;
        }
        for (Village village : this.villageList) {
            VillageDoorInfo villagedoorinfo1 = village.getVillageDoorAt(par1, par2, par3);
            if (villagedoorinfo1 == null) continue;
            return villagedoorinfo1;
        }
        return null;
    }

    private void addDoorToNewListIfAppropriate(int par1, int par2, int par3) {
        int i = ((BlockDoor)Block.doorWood).getDoorOrientation(this.worldObj, par1, par2, par3);
        if (i == 0 || i == 2) {
            int j = 0;
            for (int l = -5; l < 0; ++l) {
                if (!this.worldObj.canBlockSeeTheSky(par1 + l, par2, par3)) continue;
                --j;
            }
            for (int i1 = 1; i1 <= 5; ++i1) {
                if (!this.worldObj.canBlockSeeTheSky(par1 + i1, par2, par3)) continue;
                ++j;
            }
            if (j != 0) {
                this.newDoors.add(new VillageDoorInfo(par1, par2, par3, j <= 0 ? 2 : -2, 0, this.tickCounter));
            }
        } else {
            int k = 0;
            for (int j1 = -5; j1 < 0; ++j1) {
                if (!this.worldObj.canBlockSeeTheSky(par1, par2, par3 + j1)) continue;
                --k;
            }
            for (int k1 = 1; k1 <= 5; ++k1) {
                if (!this.worldObj.canBlockSeeTheSky(par1, par2, par3 + k1)) continue;
                ++k;
            }
            if (k != 0) {
                this.newDoors.add(new VillageDoorInfo(par1, par2, par3, 0, k <= 0 ? 2 : -2, this.tickCounter));
            }
        }
    }

    private boolean isVillagerPositionPresent(int par1, int par2, int par3) {
        for (ChunkCoordinates chunkcoordinates : this.villagerPositionsList) {
            if (chunkcoordinates.posX != par1 || chunkcoordinates.posY != par2 || chunkcoordinates.posZ != par3) continue;
            return true;
        }
        return false;
    }

    private boolean isWoodenDoorAt(int par1, int par2, int par3) {
        int i = this.worldObj.getBlockId(par1, par2, par3);
        return i == Block.doorWood.blockID;
    }
}

