/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.List;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.IInventory;
import net.minecraft.src.Item;
import net.minecraft.src.ItemPotion;
import net.minecraft.src.ItemStack;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.NBTTagList;
import net.minecraft.src.PotionHelper;
import net.minecraft.src.TileEntity;

public class TileEntityBrewingStand
extends TileEntity
implements IInventory {
    private ItemStack[] brewingItemStacks = new ItemStack[4];
    private int brewTime;
    private int filledSlots;
    private int ingredientID;

    @Override
    public String getInvName() {
        return "container.brewing";
    }

    @Override
    public int getSizeInventory() {
        return this.brewingItemStacks.length;
    }

    @Override
    public void updateEntity() {
        if (this.brewTime > 0) {
            --this.brewTime;
            if (this.brewTime == 0) {
                this.brewPotions();
                this.onInventoryChanged();
            } else if (!this.canBrew()) {
                this.brewTime = 0;
                this.onInventoryChanged();
            } else if (this.ingredientID != this.brewingItemStacks[3].itemID) {
                this.brewTime = 0;
                this.onInventoryChanged();
            }
        } else if (this.canBrew()) {
            this.brewTime = 400;
            this.ingredientID = this.brewingItemStacks[3].itemID;
        }
        int i = this.getFilledSlots();
        if (i != this.filledSlots) {
            this.filledSlots = i;
            this.worldObj.setBlockMetadataWithNotify(this.xCoord, this.yCoord, this.zCoord, i);
        }
        super.updateEntity();
    }

    public int getBrewTime() {
        return this.brewTime;
    }

    private boolean canBrew() {
        if (this.brewingItemStacks[3] == null || this.brewingItemStacks[3].stackSize <= 0) {
            return false;
        }
        ItemStack itemstack = this.brewingItemStacks[3];
        if (!Item.itemsList[itemstack.itemID].isPotionIngredient()) {
            return false;
        }
        boolean flag = false;
        for (int i = 0; i < 3; ++i) {
            if (this.brewingItemStacks[i] == null || this.brewingItemStacks[i].itemID != Item.potion.shiftedIndex) continue;
            int j = this.brewingItemStacks[i].getItemDamage();
            int k = this.getPotionResult(j, itemstack);
            if (!ItemPotion.isSplash(j) && ItemPotion.isSplash(k)) {
                flag = true;
                break;
            }
            List list = Item.potion.getEffects(j);
            List list1 = Item.potion.getEffects(k);
            if (j > 0 && list == list1 || list != null && (((Object)list).equals(list1) || list1 == null) || j == k) continue;
            flag = true;
            break;
        }
        return flag;
    }

    private void brewPotions() {
        if (!this.canBrew()) {
            return;
        }
        ItemStack itemstack = this.brewingItemStacks[3];
        for (int i = 0; i < 3; ++i) {
            if (this.brewingItemStacks[i] == null || this.brewingItemStacks[i].itemID != Item.potion.shiftedIndex) continue;
            int j = this.brewingItemStacks[i].getItemDamage();
            int k = this.getPotionResult(j, itemstack);
            List list = Item.potion.getEffects(j);
            List list1 = Item.potion.getEffects(k);
            if (j > 0 && list == list1 || list != null && (((Object)list).equals(list1) || list1 == null)) {
                if (ItemPotion.isSplash(j) || !ItemPotion.isSplash(k)) continue;
                this.brewingItemStacks[i].setItemDamage(k);
                continue;
            }
            if (j == k) continue;
            this.brewingItemStacks[i].setItemDamage(k);
        }
        if (Item.itemsList[itemstack.itemID].hasContainerItem()) {
            this.brewingItemStacks[3] = new ItemStack(Item.itemsList[itemstack.itemID].getContainerItem());
        } else {
            --this.brewingItemStacks[3].stackSize;
            if (this.brewingItemStacks[3].stackSize <= 0) {
                this.brewingItemStacks[3] = null;
            }
        }
    }

    private int getPotionResult(int par1, ItemStack par2ItemStack) {
        if (par2ItemStack == null) {
            return par1;
        }
        if (Item.itemsList[par2ItemStack.itemID].isPotionIngredient()) {
            return PotionHelper.applyIngredient(par1, Item.itemsList[par2ItemStack.itemID].getPotionEffect());
        }
        return par1;
    }

    @Override
    public void readFromNBT(NBTTagCompound par1NBTTagCompound) {
        super.readFromNBT(par1NBTTagCompound);
        NBTTagList nbttaglist = par1NBTTagCompound.getTagList("Items");
        this.brewingItemStacks = new ItemStack[this.getSizeInventory()];
        for (int i = 0; i < nbttaglist.tagCount(); ++i) {
            NBTTagCompound nbttagcompound = (NBTTagCompound)nbttaglist.tagAt(i);
            byte byte0 = nbttagcompound.getByte("Slot");
            if (byte0 < 0 || byte0 >= this.brewingItemStacks.length) continue;
            this.brewingItemStacks[byte0] = ItemStack.loadItemStackFromNBT(nbttagcompound);
        }
        this.brewTime = par1NBTTagCompound.getShort("BrewTime");
    }

    @Override
    public void writeToNBT(NBTTagCompound par1NBTTagCompound) {
        super.writeToNBT(par1NBTTagCompound);
        par1NBTTagCompound.setShort("BrewTime", (short)this.brewTime);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.brewingItemStacks.length; ++i) {
            if (this.brewingItemStacks[i] == null) continue;
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.setByte("Slot", (byte)i);
            this.brewingItemStacks[i].writeToNBT(nbttagcompound);
            nbttaglist.appendTag(nbttagcompound);
        }
        par1NBTTagCompound.setTag("Items", nbttaglist);
    }

    @Override
    public ItemStack getStackInSlot(int par1) {
        if (par1 >= 0 && par1 < this.brewingItemStacks.length) {
            return this.brewingItemStacks[par1];
        }
        return null;
    }

    @Override
    public ItemStack decrStackSize(int par1, int par2) {
        if (par1 >= 0 && par1 < this.brewingItemStacks.length) {
            ItemStack itemstack = this.brewingItemStacks[par1];
            this.brewingItemStacks[par1] = null;
            return itemstack;
        }
        return null;
    }

    @Override
    public ItemStack getStackInSlotOnClosing(int par1) {
        if (par1 >= 0 && par1 < this.brewingItemStacks.length) {
            ItemStack itemstack = this.brewingItemStacks[par1];
            this.brewingItemStacks[par1] = null;
            return itemstack;
        }
        return null;
    }

    @Override
    public void setInventorySlotContents(int par1, ItemStack par2ItemStack) {
        if (par1 >= 0 && par1 < this.brewingItemStacks.length) {
            this.brewingItemStacks[par1] = par2ItemStack;
        }
    }

    @Override
    public int getInventoryStackLimit() {
        return 1;
    }

    @Override
    public boolean isUseableByPlayer(EntityPlayer par1EntityPlayer) {
        if (this.worldObj.getBlockTileEntity(this.xCoord, this.yCoord, this.zCoord) != this) {
            return false;
        }
        return par1EntityPlayer.getDistanceSq((double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5) <= 64.0;
    }

    @Override
    public void openChest() {
    }

    @Override
    public void closeChest() {
    }

    public void setBrewTime(int par1) {
        this.brewTime = par1;
    }

    public int getFilledSlots() {
        int i = 0;
        for (int j = 0; j < 3; ++j) {
            if (this.brewingItemStacks[j] == null) continue;
            i |= 1 << j;
        }
        return i;
    }
}

