/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.src.Block;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.TileEntityBrewingStand;
import net.minecraft.src.TileEntityChest;
import net.minecraft.src.TileEntityDispenser;
import net.minecraft.src.TileEntityEnchantmentTable;
import net.minecraft.src.TileEntityEndPortal;
import net.minecraft.src.TileEntityFurnace;
import net.minecraft.src.TileEntityMobSpawner;
import net.minecraft.src.TileEntityNote;
import net.minecraft.src.TileEntityPiston;
import net.minecraft.src.TileEntityRecordPlayer;
import net.minecraft.src.TileEntitySign;
import net.minecraft.src.World;

public class TileEntity {
    private static Map nameToClassMap = new HashMap();
    private static Map classToNameMap = new HashMap();
    public World worldObj;
    public int xCoord;
    public int yCoord;
    public int zCoord;
    protected boolean tileEntityInvalid;
    public int blockMetadata = -1;
    public Block blockType;

    private static void addMapping(Class par0Class, String par1Str) {
        if (classToNameMap.containsKey(par1Str)) {
            throw new IllegalArgumentException("Duplicate id: " + par1Str);
        }
        nameToClassMap.put(par1Str, par0Class);
        classToNameMap.put(par0Class, par1Str);
    }

    public void readFromNBT(NBTTagCompound par1NBTTagCompound) {
        this.xCoord = par1NBTTagCompound.getInteger("x");
        this.yCoord = par1NBTTagCompound.getInteger("y");
        this.zCoord = par1NBTTagCompound.getInteger("z");
    }

    public void writeToNBT(NBTTagCompound par1NBTTagCompound) {
        String s = (String)classToNameMap.get(this.getClass());
        if (s == null) {
            throw new RuntimeException(this.getClass() + " is missing a mapping! This is a bug!");
        }
        par1NBTTagCompound.setString("id", s);
        par1NBTTagCompound.setInteger("x", this.xCoord);
        par1NBTTagCompound.setInteger("y", this.yCoord);
        par1NBTTagCompound.setInteger("z", this.zCoord);
    }

    public void updateEntity() {
    }

    public static TileEntity createAndLoadEntity(NBTTagCompound par0NBTTagCompound) {
        TileEntity tileentity = null;
        try {
            Class class1 = (Class)nameToClassMap.get(par0NBTTagCompound.getString("id"));
            if (class1 != null) {
                tileentity = (TileEntity)class1.newInstance();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (tileentity != null) {
            tileentity.readFromNBT(par0NBTTagCompound);
        } else {
            System.out.println("Skipping TileEntity with id " + par0NBTTagCompound.getString("id"));
        }
        return tileentity;
    }

    public int getBlockMetadata() {
        if (this.blockMetadata == -1) {
            this.blockMetadata = this.worldObj.getBlockMetadata(this.xCoord, this.yCoord, this.zCoord);
        }
        return this.blockMetadata;
    }

    public void onInventoryChanged() {
        if (this.worldObj != null) {
            this.blockMetadata = this.worldObj.getBlockMetadata(this.xCoord, this.yCoord, this.zCoord);
            this.worldObj.updateTileEntityChunkAndDoNothing(this.xCoord, this.yCoord, this.zCoord, this);
        }
    }

    public double getDistanceFrom(double par1, double par3, double par5) {
        double d = (double)this.xCoord + 0.5 - par1;
        double d1 = (double)this.yCoord + 0.5 - par3;
        double d2 = (double)this.zCoord + 0.5 - par5;
        return d * d + d1 * d1 + d2 * d2;
    }

    public Block getBlockType() {
        if (this.blockType == null) {
            this.blockType = Block.blocksList[this.worldObj.getBlockId(this.xCoord, this.yCoord, this.zCoord)];
        }
        return this.blockType;
    }

    public boolean isInvalid() {
        return this.tileEntityInvalid;
    }

    public void invalidate() {
        this.tileEntityInvalid = true;
    }

    public void validate() {
        this.tileEntityInvalid = false;
    }

    public void onTileEntityPowered(int i, int j) {
    }

    public void updateContainingBlockInfo() {
        this.blockType = null;
        this.blockMetadata = -1;
    }

    static {
        TileEntity.addMapping(TileEntityFurnace.class, "Furnace");
        TileEntity.addMapping(TileEntityChest.class, "Chest");
        TileEntity.addMapping(TileEntityRecordPlayer.class, "RecordPlayer");
        TileEntity.addMapping(TileEntityDispenser.class, "Trap");
        TileEntity.addMapping(TileEntitySign.class, "Sign");
        TileEntity.addMapping(TileEntityMobSpawner.class, "MobSpawner");
        TileEntity.addMapping(TileEntityNote.class, "Music");
        TileEntity.addMapping(TileEntityPiston.class, "Piston");
        TileEntity.addMapping(TileEntityBrewingStand.class, "Cauldron");
        TileEntity.addMapping(TileEntityEnchantmentTable.class, "EnchantTable");
        TileEntity.addMapping(TileEntityEndPortal.class, "Airportal");
    }
}

