/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.net.ConnectException;
import java.net.UnknownHostException;
import net.minecraft.client.Minecraft;
import net.minecraft.src.GuiConnecting;
import net.minecraft.src.GuiDisconnected;
import net.minecraft.src.NetClientHandler;
import net.minecraft.src.Packet2Handshake;

class ThreadConnectToServer
extends Thread {
    final Minecraft mc;
    final String ip;
    final int port;
    final GuiConnecting connectingGui;

    ThreadConnectToServer(GuiConnecting par1GuiConnecting, Minecraft par2Minecraft, String par3Str, int par4) {
        this.connectingGui = par1GuiConnecting;
        this.mc = par2Minecraft;
        this.ip = par3Str;
        this.port = par4;
    }

    @Override
    public void run() {
        try {
            GuiConnecting.setNetClientHandler(this.connectingGui, new NetClientHandler(this.mc, this.ip, this.port));
            if (GuiConnecting.isCancelled(this.connectingGui)) {
                return;
            }
            GuiConnecting.getNetClientHandler(this.connectingGui).addToSendQueue(new Packet2Handshake(this.mc.session.username, this.ip, this.port));
        }
        catch (UnknownHostException unknownhostexception) {
            if (GuiConnecting.isCancelled(this.connectingGui)) {
                return;
            }
            this.mc.displayGuiScreen(new GuiDisconnected("connect.failed", "disconnect.genericReason", new Object[]{"Unknown host '" + this.ip + "'"}));
        }
        catch (ConnectException connectexception) {
            if (GuiConnecting.isCancelled(this.connectingGui)) {
                return;
            }
            this.mc.displayGuiScreen(new GuiDisconnected("connect.failed", "disconnect.genericReason", new Object[]{connectexception.getMessage()}));
        }
        catch (Exception exception) {
            if (GuiConnecting.isCancelled(this.connectingGui)) {
                return;
            }
            exception.printStackTrace();
            this.mc.displayGuiScreen(new GuiDisconnected("connect.failed", "disconnect.genericReason", new Object[]{exception.toString()}));
        }
    }
}

