/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.Block;
import net.minecraft.src.TextureFX;

public class TextureWaterFX
extends TextureFX {
    protected float[] red = new float[256];
    protected float[] green = new float[256];
    protected float[] blue = new float[256];
    protected float[] alpha = new float[256];
    private int tickCounter = 0;

    public TextureWaterFX() {
        super(Block.waterMoving.blockIndexInTexture);
    }

    @Override
    public void onTick() {
        ++this.tickCounter;
        for (int i = 0; i < 16; ++i) {
            for (int k = 0; k < 16; ++k) {
                float f = 0.0f;
                for (int j1 = i - 1; j1 <= i + 1; ++j1) {
                    int k1 = j1 & 0xF;
                    int i2 = k & 0xF;
                    f += this.red[k1 + i2 * 16];
                }
                this.green[i + k * 16] = f / 3.3f + this.blue[i + k * 16] * 0.8f;
            }
        }
        for (int j = 0; j < 16; ++j) {
            for (int l = 0; l < 16; ++l) {
                int n = j + l * 16;
                this.blue[n] = this.blue[n] + this.alpha[j + l * 16] * 0.05f;
                if (this.blue[j + l * 16] < 0.0f) {
                    this.blue[j + l * 16] = 0.0f;
                }
                int n2 = j + l * 16;
                this.alpha[n2] = this.alpha[n2] - 0.1f;
                if (!(Math.random() < 0.05)) continue;
                this.alpha[j + l * 16] = 0.5f;
            }
        }
        float[] af = this.green;
        this.green = this.red;
        this.red = af;
        for (int i1 = 0; i1 < 256; ++i1) {
            float f1 = this.red[i1];
            if (f1 > 1.0f) {
                f1 = 1.0f;
            }
            if (f1 < 0.0f) {
                f1 = 0.0f;
            }
            float f2 = f1 * f1;
            int l1 = (int)(32.0f + f2 * 32.0f);
            int j2 = (int)(50.0f + f2 * 64.0f);
            int k2 = 255;
            int l2 = (int)(146.0f + f2 * 50.0f);
            if (this.anaglyphEnabled) {
                int i3 = (l1 * 30 + j2 * 59 + k2 * 11) / 100;
                int j3 = (l1 * 30 + j2 * 70) / 100;
                int k3 = (l1 * 30 + k2 * 70) / 100;
                l1 = i3;
                j2 = j3;
                k2 = k3;
            }
            this.imageData[i1 * 4 + 0] = (byte)l1;
            this.imageData[i1 * 4 + 1] = (byte)j2;
            this.imageData[i1 * 4 + 2] = (byte)k2;
            this.imageData[i1 * 4 + 3] = (byte)l2;
        }
    }
}

