/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.Block;
import net.minecraft.src.MathHelper;
import net.minecraft.src.TextureFX;

public class TexturePortalFX
extends TextureFX {
    private int portalTickCounter = 0;
    private byte[][] portalTextureData = new byte[32][1024];

    public TexturePortalFX() {
        super(Block.portal.blockIndexInTexture);
        Random random = new Random(100L);
        for (int i = 0; i < 32; ++i) {
            for (int j = 0; j < 16; ++j) {
                for (int k = 0; k < 16; ++k) {
                    float f = 0.0f;
                    for (int l = 0; l < 2; ++l) {
                        float f1 = (float)(l * 16) * 0.5f;
                        float f2 = (float)(l * 16) * 0.5f;
                        float f3 = ((float)j - f1) / 16.0f * 2.0f;
                        float f4 = ((float)k - f2) / 16.0f * 2.0f;
                        if (f3 < -1.0f) {
                            f3 += 2.0f;
                        }
                        if (f3 >= 1.0f) {
                            f3 -= 2.0f;
                        }
                        if (f4 < -1.0f) {
                            f4 += 2.0f;
                        }
                        if (f4 >= 1.0f) {
                            f4 -= 2.0f;
                        }
                        float f5 = f3 * f3 + f4 * f4;
                        float f6 = (float)Math.atan2(f4, f3) + ((float)i / 32.0f * (float)Math.PI * 2.0f - f5 * 10.0f + (float)(l * 2)) * (float)(l * 2 - 1);
                        f6 = (MathHelper.sin(f6) + 1.0f) / 2.0f;
                        f += (f6 /= f5 + 1.0f) * 0.5f;
                    }
                    int i1 = (int)((f += random.nextFloat() * 0.1f) * 100.0f + 155.0f);
                    int j1 = (int)(f * f * 200.0f + 55.0f);
                    int k1 = (int)(f * f * f * f * 255.0f);
                    int l1 = (int)(f * 100.0f + 155.0f);
                    int i2 = k * 16 + j;
                    this.portalTextureData[i][i2 * 4 + 0] = (byte)j1;
                    this.portalTextureData[i][i2 * 4 + 1] = (byte)k1;
                    this.portalTextureData[i][i2 * 4 + 2] = (byte)i1;
                    this.portalTextureData[i][i2 * 4 + 3] = (byte)l1;
                }
            }
        }
    }

    @Override
    public void onTick() {
        ++this.portalTickCounter;
        byte[] abyte0 = this.portalTextureData[this.portalTickCounter & 0x1F];
        for (int i = 0; i < 256; ++i) {
            int j = abyte0[i * 4 + 0] & 0xFF;
            int k = abyte0[i * 4 + 1] & 0xFF;
            int l = abyte0[i * 4 + 2] & 0xFF;
            int i1 = abyte0[i * 4 + 3] & 0xFF;
            if (this.anaglyphEnabled) {
                int j1 = (j * 30 + k * 59 + l * 11) / 100;
                int k1 = (j * 30 + k * 70) / 100;
                int l1 = (j * 30 + l * 70) / 100;
                j = j1;
                k = k1;
                l = l1;
            }
            this.imageData[i * 4 + 0] = (byte)j;
            this.imageData[i * 4 + 1] = (byte)k;
            this.imageData[i * 4 + 2] = (byte)l;
            this.imageData[i * 4 + 3] = (byte)i1;
        }
    }
}

