/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.src.TexturePackBase;
import net.minecraft.src.TexturePackCustom;
import net.minecraft.src.TexturePackDefault;
import net.minecraft.src.TexturePackFolder;

public class TexturePackList {
    private List availableTexturePacks = new ArrayList();
    private TexturePackBase defaultTexturePack = new TexturePackDefault();
    public TexturePackBase selectedTexturePack;
    private Map field_6538_d = new HashMap();
    private Minecraft mc;
    private File texturePackDir;
    private String currentTexturePack;

    public TexturePackList(Minecraft par1Minecraft, File par2File) {
        this.mc = par1Minecraft;
        this.texturePackDir = new File(par2File, "texturepacks");
        if (this.texturePackDir.exists()) {
            if (!this.texturePackDir.isDirectory()) {
                this.texturePackDir.delete();
                this.texturePackDir.mkdirs();
            }
        } else {
            this.texturePackDir.mkdirs();
        }
        this.currentTexturePack = par1Minecraft.gameSettings.skin;
        this.updateAvaliableTexturePacks();
        this.selectedTexturePack.func_6482_a();
    }

    public boolean setTexturePack(TexturePackBase par1TexturePackBase) {
        if (par1TexturePackBase == this.selectedTexturePack) {
            return false;
        }
        this.selectedTexturePack.closeTexturePackFile();
        this.currentTexturePack = par1TexturePackBase.texturePackFileName;
        this.selectedTexturePack = par1TexturePackBase;
        this.mc.gameSettings.skin = this.currentTexturePack;
        this.mc.gameSettings.saveOptions();
        this.selectedTexturePack.func_6482_a();
        return true;
    }

    public void updateAvaliableTexturePacks() {
        ArrayList<TexturePackBase> arraylist = new ArrayList<TexturePackBase>();
        this.selectedTexturePack = null;
        arraylist.add(this.defaultTexturePack);
        if (this.texturePackDir.exists() && this.texturePackDir.isDirectory()) {
            File[] afile;
            for (File file : afile = this.texturePackDir.listFiles()) {
                if (file.isFile() && file.getName().toLowerCase().endsWith(".zip")) {
                    String s = file.getName() + ":" + file.length() + ":" + file.lastModified();
                    try {
                        if (!this.field_6538_d.containsKey(s)) {
                            TexturePackCustom texturepackcustom = new TexturePackCustom(file);
                            texturepackcustom.texturePackID = s;
                            this.field_6538_d.put(s, texturepackcustom);
                            texturepackcustom.func_6485_a(this.mc);
                        }
                        TexturePackBase texturepackbase1 = (TexturePackBase)this.field_6538_d.get(s);
                        if (texturepackbase1.texturePackFileName.equals(this.currentTexturePack)) {
                            this.selectedTexturePack = texturepackbase1;
                        }
                        arraylist.add(texturepackbase1);
                    }
                    catch (IOException ioexception) {
                        ioexception.printStackTrace();
                    }
                    continue;
                }
                if (!file.isDirectory() || !new File(file, "pack.txt").exists()) continue;
                String s1 = file.getName() + ":folder:" + file.lastModified();
                try {
                    if (!this.field_6538_d.containsKey(s1)) {
                        TexturePackFolder texturepackfolder = new TexturePackFolder(file);
                        texturepackfolder.texturePackID = s1;
                        this.field_6538_d.put(s1, texturepackfolder);
                        texturepackfolder.func_6485_a(this.mc);
                    }
                    TexturePackBase texturepackbase2 = (TexturePackBase)this.field_6538_d.get(s1);
                    if (texturepackbase2.texturePackFileName.equals(this.currentTexturePack)) {
                        this.selectedTexturePack = texturepackbase2;
                    }
                    arraylist.add(texturepackbase2);
                }
                catch (IOException ioexception1) {
                    ioexception1.printStackTrace();
                }
            }
        }
        if (this.selectedTexturePack == null) {
            this.selectedTexturePack = this.defaultTexturePack;
        }
        this.availableTexturePacks.removeAll(arraylist);
        for (TexturePackBase texturepackbase : this.availableTexturePacks) {
            texturepackbase.unbindThumbnailTexture(this.mc);
            this.field_6538_d.remove(texturepackbase.texturePackID);
        }
        this.availableTexturePacks = arraylist;
    }

    public List availableTexturePacks() {
        return new ArrayList(this.availableTexturePacks);
    }
}

