/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.src.ComponentStronghold;
import net.minecraft.src.ComponentStrongholdChestCorridor;
import net.minecraft.src.ComponentStrongholdCorridor;
import net.minecraft.src.ComponentStrongholdCrossing;
import net.minecraft.src.ComponentStrongholdLeftTurn;
import net.minecraft.src.ComponentStrongholdLibrary;
import net.minecraft.src.ComponentStrongholdPortalRoom;
import net.minecraft.src.ComponentStrongholdPrison;
import net.minecraft.src.ComponentStrongholdRightTurn;
import net.minecraft.src.ComponentStrongholdRoomCrossing;
import net.minecraft.src.ComponentStrongholdStairs;
import net.minecraft.src.ComponentStrongholdStairs2;
import net.minecraft.src.ComponentStrongholdStairsStraight;
import net.minecraft.src.ComponentStrongholdStraight;
import net.minecraft.src.StructureBoundingBox;
import net.minecraft.src.StructureComponent;
import net.minecraft.src.StructureStrongholdPieceWeight;
import net.minecraft.src.StructureStrongholdPieceWeight2;
import net.minecraft.src.StructureStrongholdPieceWeight3;
import net.minecraft.src.StructureStrongholdStones;

public class StructureStrongholdPieces {
    private static final StructureStrongholdPieceWeight[] pieceWeightArray;
    private static List structurePieceList;
    private static Class strongComponentType;
    static int totalWeight;
    private static final StructureStrongholdStones strongholdStones;

    public static void prepareStructurePieces() {
        structurePieceList = new ArrayList();
        for (StructureStrongholdPieceWeight structurestrongholdpieceweight : pieceWeightArray) {
            structurestrongholdpieceweight.instancesSpawned = 0;
            structurePieceList.add(structurestrongholdpieceweight);
        }
        strongComponentType = null;
    }

    private static boolean canAddStructurePieces() {
        boolean flag = false;
        totalWeight = 0;
        for (StructureStrongholdPieceWeight structurestrongholdpieceweight : structurePieceList) {
            if (structurestrongholdpieceweight.instancesLimit > 0 && structurestrongholdpieceweight.instancesSpawned < structurestrongholdpieceweight.instancesLimit) {
                flag = true;
            }
            totalWeight += structurestrongholdpieceweight.pieceWeight;
        }
        return flag;
    }

    private static ComponentStronghold getStrongholdComponentFromWeightedPiece(Class par0Class, List par1List, Random par2Random, int par3, int par4, int par5, int par6, int par7) {
        ComponentStronghold obj = null;
        if (par0Class == ComponentStrongholdStraight.class) {
            obj = ComponentStrongholdStraight.findValidPlacement(par1List, par2Random, par3, par4, par5, par6, par7);
        } else if (par0Class == ComponentStrongholdPrison.class) {
            obj = ComponentStrongholdPrison.findValidPlacement(par1List, par2Random, par3, par4, par5, par6, par7);
        } else if (par0Class == ComponentStrongholdLeftTurn.class) {
            obj = ComponentStrongholdLeftTurn.findValidPlacement(par1List, par2Random, par3, par4, par5, par6, par7);
        } else if (par0Class == ComponentStrongholdRightTurn.class) {
            obj = ComponentStrongholdRightTurn.findValidPlacement(par1List, par2Random, par3, par4, par5, par6, par7);
        } else if (par0Class == ComponentStrongholdRoomCrossing.class) {
            obj = ComponentStrongholdRoomCrossing.findValidPlacement(par1List, par2Random, par3, par4, par5, par6, par7);
        } else if (par0Class == ComponentStrongholdStairsStraight.class) {
            obj = ComponentStrongholdStairsStraight.findValidPlacement(par1List, par2Random, par3, par4, par5, par6, par7);
        } else if (par0Class == ComponentStrongholdStairs.class) {
            obj = ComponentStrongholdStairs.getStrongholdStairsComponent(par1List, par2Random, par3, par4, par5, par6, par7);
        } else if (par0Class == ComponentStrongholdCrossing.class) {
            obj = ComponentStrongholdCrossing.findValidPlacement(par1List, par2Random, par3, par4, par5, par6, par7);
        } else if (par0Class == ComponentStrongholdChestCorridor.class) {
            obj = ComponentStrongholdChestCorridor.findValidPlacement(par1List, par2Random, par3, par4, par5, par6, par7);
        } else if (par0Class == ComponentStrongholdLibrary.class) {
            obj = ComponentStrongholdLibrary.findValidPlacement(par1List, par2Random, par3, par4, par5, par6, par7);
        } else if (par0Class == ComponentStrongholdPortalRoom.class) {
            obj = ComponentStrongholdPortalRoom.findValidPlacement(par1List, par2Random, par3, par4, par5, par6, par7);
        }
        return obj;
    }

    private static ComponentStronghold getNextComponent(ComponentStrongholdStairs2 par0ComponentStrongholdStairs2, List par1List, Random par2Random, int par3, int par4, int par5, int par6, int par7) {
        if (!StructureStrongholdPieces.canAddStructurePieces()) {
            return null;
        }
        if (strongComponentType != null) {
            ComponentStronghold var8 = StructureStrongholdPieces.getStrongholdComponentFromWeightedPiece(strongComponentType, par1List, par2Random, par3, par4, par5, par6, par7);
            strongComponentType = null;
            if (var8 != null) {
                return var8;
            }
        }
        int var13 = 0;
        block0: while (var13 < 5) {
            ++var13;
            int var9 = par2Random.nextInt(totalWeight);
            for (StructureStrongholdPieceWeight var11 : structurePieceList) {
                if ((var9 -= var11.pieceWeight) >= 0) continue;
                if (!var11.canSpawnMoreStructuresOfType(par7) || var11 == par0ComponentStrongholdStairs2.field_35038_a) continue block0;
                ComponentStronghold var12 = StructureStrongholdPieces.getStrongholdComponentFromWeightedPiece(var11.pieceClass, par1List, par2Random, par3, par4, par5, par6, par7);
                if (var12 == null) continue;
                ++var11.instancesSpawned;
                par0ComponentStrongholdStairs2.field_35038_a = var11;
                if (!var11.canSpawnMoreStructures()) {
                    structurePieceList.remove(var11);
                }
                return var12;
            }
        }
        StructureBoundingBox var14 = ComponentStrongholdCorridor.func_35051_a(par1List, par2Random, par3, par4, par5, par6);
        if (var14 != null && var14.minY > 1) {
            return new ComponentStrongholdCorridor(par7, par2Random, var14, par6);
        }
        return null;
    }

    private static StructureComponent getNextValidComponent(ComponentStrongholdStairs2 par0ComponentStrongholdStairs2, List par1List, Random par2Random, int par3, int par4, int par5, int par6, int par7) {
        if (par7 > 50) {
            return null;
        }
        if (Math.abs(par3 - par0ComponentStrongholdStairs2.getBoundingBox().minX) > 112 || Math.abs(par5 - par0ComponentStrongholdStairs2.getBoundingBox().minZ) > 112) {
            return null;
        }
        ComponentStronghold componentstronghold = StructureStrongholdPieces.getNextComponent(par0ComponentStrongholdStairs2, par1List, par2Random, par3, par4, par5, par6, par7 + 1);
        if (componentstronghold != null) {
            par1List.add(componentstronghold);
            par0ComponentStrongholdStairs2.field_35037_b.add(componentstronghold);
        }
        return componentstronghold;
    }

    static StructureComponent getNextValidComponentAccess(ComponentStrongholdStairs2 par0ComponentStrongholdStairs2, List par1List, Random par2Random, int par3, int par4, int par5, int par6, int par7) {
        return StructureStrongholdPieces.getNextValidComponent(par0ComponentStrongholdStairs2, par1List, par2Random, par3, par4, par5, par6, par7);
    }

    static Class setComponentType(Class par0Class) {
        strongComponentType = par0Class;
        return strongComponentType;
    }

    static StructureStrongholdStones getStrongholdStones() {
        return strongholdStones;
    }

    static {
        totalWeight = 0;
        strongholdStones = new StructureStrongholdStones(null);
        pieceWeightArray = new StructureStrongholdPieceWeight[]{new StructureStrongholdPieceWeight(ComponentStrongholdStraight.class, 40, 0), new StructureStrongholdPieceWeight(ComponentStrongholdPrison.class, 5, 5), new StructureStrongholdPieceWeight(ComponentStrongholdLeftTurn.class, 20, 0), new StructureStrongholdPieceWeight(ComponentStrongholdRightTurn.class, 20, 0), new StructureStrongholdPieceWeight(ComponentStrongholdRoomCrossing.class, 10, 6), new StructureStrongholdPieceWeight(ComponentStrongholdStairsStraight.class, 5, 5), new StructureStrongholdPieceWeight(ComponentStrongholdStairs.class, 5, 5), new StructureStrongholdPieceWeight(ComponentStrongholdCrossing.class, 5, 4), new StructureStrongholdPieceWeight(ComponentStrongholdChestCorridor.class, 5, 4), new StructureStrongholdPieceWeight2(ComponentStrongholdLibrary.class, 10, 2), new StructureStrongholdPieceWeight3(ComponentStrongholdPortalRoom.class, 20, 1)};
    }
}

