/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Properties;
import java.util.TreeMap;

public class StringTranslate {
    private static StringTranslate instance = new StringTranslate();
    private Properties translateTable = new Properties();
    private TreeMap languageList;
    private String currentLanguage;
    private boolean isUnicode;

    private StringTranslate() {
        this.loadLanguageList();
        this.setLanguage("en_US");
    }

    public static StringTranslate getInstance() {
        return instance;
    }

    private void loadLanguageList() {
        TreeMap<String, String> treemap = new TreeMap<String, String>();
        try {
            BufferedReader bufferedreader = new BufferedReader(new InputStreamReader(StringTranslate.class.getResourceAsStream("/lang/languages.txt"), "UTF-8"));
            String s = bufferedreader.readLine();
            while (s != null) {
                String[] as = s.split("=");
                if (as != null && as.length == 2) {
                    treemap.put(as[0], as[1]);
                }
                s = bufferedreader.readLine();
            }
        }
        catch (IOException ioexception) {
            ioexception.printStackTrace();
            return;
        }
        this.languageList = treemap;
    }

    public TreeMap getLanguageList() {
        return this.languageList;
    }

    private void loadLanguage(Properties par1Properties, String par2Str) throws IOException {
        BufferedReader bufferedreader = new BufferedReader(new InputStreamReader(StringTranslate.class.getResourceAsStream("/lang/" + par2Str + ".lang"), "UTF-8"));
        String s = bufferedreader.readLine();
        while (s != null) {
            String[] as;
            if (!(s = s.trim()).startsWith("#") && (as = s.split("=")) != null && as.length == 2) {
                par1Properties.setProperty(as[0], as[1]);
            }
            s = bufferedreader.readLine();
        }
    }

    public void setLanguage(String par1Str) {
        if (!par1Str.equals(this.currentLanguage)) {
            Properties var2 = new Properties();
            try {
                this.loadLanguage(var2, "en_US");
            }
            catch (IOException var8) {
                // empty catch block
            }
            this.isUnicode = false;
            if (!"en_US".equals(par1Str)) {
                try {
                    this.loadLanguage(var2, par1Str);
                    Enumeration<?> var3 = var2.propertyNames();
                    block4: while (var3.hasMoreElements() && !this.isUnicode) {
                        Object var4 = var3.nextElement();
                        Object var5 = var2.get(var4);
                        if (var5 == null) continue;
                        String var6 = var5.toString();
                        for (int var7 = 0; var7 < var6.length(); ++var7) {
                            if (var6.charAt(var7) < '\u0100') continue;
                            this.isUnicode = true;
                            continue block4;
                        }
                    }
                }
                catch (IOException var9) {
                    var9.printStackTrace();
                    return;
                }
            }
            this.currentLanguage = par1Str;
            this.translateTable = var2;
        }
    }

    public String getCurrentLanguage() {
        return this.currentLanguage;
    }

    public boolean isUnicode() {
        return this.isUnicode;
    }

    public String translateKey(String par1Str) {
        return this.translateTable.getProperty(par1Str, par1Str);
    }

    public String translateKeyFormat(String par1Str, Object[] par2ArrayOfObj) {
        String s = this.translateTable.getProperty(par1Str, par1Str);
        return String.format(s, par2ArrayOfObj);
    }

    public String translateNamedKey(String par1Str) {
        return this.translateTable.getProperty(par1Str + ".name", "");
    }

    public static boolean isBidrectional(String par0Str) {
        return "ar_SA".equals(par0Str) || "he_IL".equals(par0Str);
    }
}

