/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import argo.jdom.JdomParser;
import argo.jdom.JsonNode;
import argo.jdom.JsonRootNode;
import argo.jdom.JsonStringNode;
import argo.saj.InvalidSyntaxException;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.src.Achievement;
import net.minecraft.src.MD5String;
import net.minecraft.src.Session;
import net.minecraft.src.StatBase;
import net.minecraft.src.StatList;
import net.minecraft.src.StatsSyncher;

public class StatFileWriter {
    private Map field_25102_a = new HashMap();
    private Map field_25101_b = new HashMap();
    private boolean field_27189_c = false;
    private StatsSyncher statsSyncher;

    public StatFileWriter(Session par1Session, File par2File) {
        File file = new File(par2File, "stats");
        if (!file.exists()) {
            file.mkdir();
        }
        for (File file1 : par2File.listFiles()) {
            File file2;
            if (!file1.getName().startsWith("stats_") || !file1.getName().endsWith(".dat") || (file2 = new File(file, file1.getName())).exists()) continue;
            System.out.println("Relocating " + file1.getName());
            file1.renameTo(file2);
        }
        this.statsSyncher = new StatsSyncher(par1Session, this, file);
    }

    public void readStat(StatBase par1StatBase, int par2) {
        this.writeStatToMap(this.field_25101_b, par1StatBase, par2);
        this.writeStatToMap(this.field_25102_a, par1StatBase, par2);
        this.field_27189_c = true;
    }

    private void writeStatToMap(Map par1Map, StatBase par2StatBase, int par3) {
        Integer integer = (Integer)par1Map.get(par2StatBase);
        int i = integer != null ? integer : 0;
        par1Map.put(par2StatBase, i + par3);
    }

    public Map func_27176_a() {
        return new HashMap(this.field_25101_b);
    }

    public void func_27179_a(Map par1Map) {
        if (par1Map == null) {
            return;
        }
        this.field_27189_c = true;
        for (StatBase statbase : par1Map.keySet()) {
            this.writeStatToMap(this.field_25101_b, statbase, (Integer)par1Map.get(statbase));
            this.writeStatToMap(this.field_25102_a, statbase, (Integer)par1Map.get(statbase));
        }
    }

    public void func_27180_b(Map par1Map) {
        if (par1Map == null) {
            return;
        }
        for (StatBase statbase : par1Map.keySet()) {
            Integer integer = (Integer)this.field_25101_b.get(statbase);
            int i = integer != null ? integer : 0;
            this.field_25102_a.put(statbase, (Integer)par1Map.get(statbase) + i);
        }
    }

    public void func_27187_c(Map par1Map) {
        if (par1Map == null) {
            return;
        }
        this.field_27189_c = true;
        for (StatBase statbase : par1Map.keySet()) {
            this.writeStatToMap(this.field_25101_b, statbase, (Integer)par1Map.get(statbase));
        }
    }

    public static Map func_27177_a(String par0Str) {
        HashMap<StatBase, Integer> hashmap = new HashMap<StatBase, Integer>();
        try {
            String s = "local";
            StringBuilder stringbuilder = new StringBuilder();
            JsonRootNode jsonrootnode = new JdomParser().parse(par0Str);
            List list = jsonrootnode.getArrayNode(new Object[]{"stats-change"});
            for (JsonNode jsonnode : list) {
                Map map = jsonnode.getFields();
                Map.Entry entry = map.entrySet().iterator().next();
                int i = Integer.parseInt(((JsonStringNode)entry.getKey()).getText());
                int j = Integer.parseInt(((JsonNode)entry.getValue()).getText());
                StatBase statbase = StatList.getOneShotStat(i);
                if (statbase == null) {
                    System.out.println(i + " is not a valid stat");
                    continue;
                }
                stringbuilder.append(StatList.getOneShotStat((int)i).statGuid).append(",");
                stringbuilder.append(j).append(",");
                hashmap.put(statbase, j);
            }
            MD5String md5string = new MD5String(s);
            String s1 = md5string.getMD5String(stringbuilder.toString());
            if (!s1.equals(jsonrootnode.getStringValue(new Object[]{"checksum"}))) {
                System.out.println("CHECKSUM MISMATCH");
                return null;
            }
        }
        catch (InvalidSyntaxException invalidsyntaxexception) {
            invalidsyntaxexception.printStackTrace();
        }
        return hashmap;
    }

    public static String func_27185_a(String par0Str, String par1Str, Map par2Map) {
        StringBuilder stringbuilder = new StringBuilder();
        StringBuilder stringbuilder1 = new StringBuilder();
        boolean flag = true;
        stringbuilder.append("{\r\n");
        if (par0Str != null && par1Str != null) {
            stringbuilder.append("  \"user\":{\r\n");
            stringbuilder.append("    \"name\":\"").append(par0Str).append("\",\r\n");
            stringbuilder.append("    \"sessionid\":\"").append(par1Str).append("\"\r\n");
            stringbuilder.append("  },\r\n");
        }
        stringbuilder.append("  \"stats-change\":[");
        for (StatBase statbase : par2Map.keySet()) {
            if (!flag) {
                stringbuilder.append("},");
            } else {
                flag = false;
            }
            stringbuilder.append("\r\n    {\"").append(statbase.statId).append("\":").append(par2Map.get(statbase));
            stringbuilder1.append(statbase.statGuid).append(",");
            stringbuilder1.append(par2Map.get(statbase)).append(",");
        }
        if (!flag) {
            stringbuilder.append("}");
        }
        MD5String md5string = new MD5String(par1Str);
        stringbuilder.append("\r\n  ],\r\n");
        stringbuilder.append("  \"checksum\":\"").append(md5string.getMD5String(stringbuilder1.toString())).append("\"\r\n");
        stringbuilder.append("}");
        return stringbuilder.toString();
    }

    public boolean hasAchievementUnlocked(Achievement par1Achievement) {
        return this.field_25102_a.containsKey(par1Achievement);
    }

    public boolean canUnlockAchievement(Achievement par1Achievement) {
        return par1Achievement.parentAchievement == null || this.hasAchievementUnlocked(par1Achievement.parentAchievement);
    }

    public int writeStat(StatBase par1StatBase) {
        Integer integer = (Integer)this.field_25102_a.get(par1StatBase);
        return integer != null ? integer : 0;
    }

    public void func_27175_b() {
    }

    public void syncStats() {
        this.statsSyncher.syncStatsFileWithMap(this.func_27176_a());
    }

    public void func_27178_d() {
        if (this.field_27189_c && this.statsSyncher.func_27420_b()) {
            this.statsSyncher.beginSendStats(this.func_27176_a());
        }
        this.statsSyncher.func_27425_c();
    }
}

