/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.client.Minecraft;
import net.minecraft.src.Block;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.EntityPlayerSP;
import net.minecraft.src.EnumAction;
import net.minecraft.src.FontRenderer;
import net.minecraft.src.Item;
import net.minecraft.src.ItemArmor;
import net.minecraft.src.ItemStack;
import net.minecraft.src.MathHelper;
import net.minecraft.src.ModelBiped;
import net.minecraft.src.RenderBlocks;
import net.minecraft.src.RenderLiving;
import net.minecraft.src.Tessellator;
import org.lwjgl.opengl.GL11;

public class RenderPlayer
extends RenderLiving {
    private ModelBiped modelBipedMain;
    private ModelBiped modelArmorChestplate;
    private ModelBiped modelArmor;
    private static final String[] armorFilenamePrefix = new String[]{"cloth", "chain", "iron", "diamond", "gold"};

    public RenderPlayer() {
        super(new ModelBiped(0.0f), 0.5f);
        this.modelBipedMain = (ModelBiped)this.mainModel;
        this.modelArmorChestplate = new ModelBiped(1.0f);
        this.modelArmor = new ModelBiped(0.5f);
    }

    protected int setArmorModel(EntityPlayer par1EntityPlayer, int par2, float par3) {
        Item item;
        ItemStack itemstack = par1EntityPlayer.inventory.armorItemInSlot(3 - par2);
        if (itemstack != null && (item = itemstack.getItem()) instanceof ItemArmor) {
            ItemArmor itemarmor = (ItemArmor)item;
            this.loadTexture("/armor/" + armorFilenamePrefix[itemarmor.renderIndex] + "_" + (par2 != 2 ? 1 : 2) + ".png");
            ModelBiped modelbiped = par2 != 2 ? this.modelArmorChestplate : this.modelArmor;
            modelbiped.bipedHead.showModel = par2 == 0;
            modelbiped.bipedHeadwear.showModel = par2 == 0;
            modelbiped.bipedBody.showModel = par2 == 1 || par2 == 2;
            modelbiped.bipedRightArm.showModel = par2 == 1;
            modelbiped.bipedLeftArm.showModel = par2 == 1;
            modelbiped.bipedRightLeg.showModel = par2 == 2 || par2 == 3;
            modelbiped.bipedLeftLeg.showModel = par2 == 2 || par2 == 3;
            this.setRenderPassModel(modelbiped);
            return !itemstack.isItemEnchanted() ? 1 : 15;
        }
        return -1;
    }

    public void renderPlayer(EntityPlayer par1EntityPlayer, double par2, double par4, double par6, float par8, float par9) {
        ItemStack itemstack = par1EntityPlayer.inventory.getCurrentItem();
        this.modelBipedMain.heldItemRight = itemstack == null ? 0 : 1;
        this.modelArmor.heldItemRight = this.modelBipedMain.heldItemRight;
        this.modelArmorChestplate.heldItemRight = this.modelBipedMain.heldItemRight;
        if (itemstack != null && par1EntityPlayer.getItemInUseCount() > 0) {
            EnumAction enumaction = itemstack.getItemUseAction();
            if (enumaction == EnumAction.block) {
                this.modelBipedMain.heldItemRight = 3;
                this.modelArmor.heldItemRight = 3;
                this.modelArmorChestplate.heldItemRight = 3;
            } else if (enumaction == EnumAction.bow) {
                this.modelBipedMain.aimedBow = true;
                this.modelArmor.aimedBow = true;
                this.modelArmorChestplate.aimedBow = true;
            }
        }
        this.modelArmor.isSneak = this.modelBipedMain.isSneak = par1EntityPlayer.isSneaking();
        this.modelArmorChestplate.isSneak = this.modelBipedMain.isSneak;
        double d = par4 - (double)par1EntityPlayer.yOffset;
        if (par1EntityPlayer.isSneaking() && !(par1EntityPlayer instanceof EntityPlayerSP)) {
            d -= 0.125;
        }
        super.doRenderLiving(par1EntityPlayer, par2, d, par6, par8, par9);
        this.modelBipedMain.aimedBow = false;
        this.modelArmor.aimedBow = false;
        this.modelArmorChestplate.aimedBow = false;
        this.modelBipedMain.isSneak = false;
        this.modelArmor.isSneak = false;
        this.modelArmorChestplate.isSneak = false;
        this.modelBipedMain.heldItemRight = 0;
        this.modelArmor.heldItemRight = 0;
        this.modelArmorChestplate.heldItemRight = 0;
    }

    protected void renderName(EntityPlayer par1EntityPlayer, double par2, double par4, double par6) {
        if (Minecraft.isGuiEnabled() && par1EntityPlayer != this.renderManager.livingPlayer) {
            float f3;
            float f = 1.6f;
            float f1 = 0.01666667f * f;
            float f2 = par1EntityPlayer.getDistanceToEntity(this.renderManager.livingPlayer);
            float f4 = f3 = par1EntityPlayer.isSneaking() ? 32.0f : 64.0f;
            if (f2 < f3) {
                String s = par1EntityPlayer.username;
                if (!par1EntityPlayer.isSneaking()) {
                    if (par1EntityPlayer.isPlayerSleeping()) {
                        this.renderLivingLabel(par1EntityPlayer, s, par2, par4 - 1.5, par6, 64);
                    } else {
                        this.renderLivingLabel(par1EntityPlayer, s, par2, par4, par6, 64);
                    }
                } else {
                    FontRenderer fontrenderer = this.getFontRendererFromRenderManager();
                    GL11.glPushMatrix();
                    GL11.glTranslatef((float)((float)par2 + 0.0f), (float)((float)par4 + 2.3f), (float)((float)par6));
                    GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glRotatef((float)(-this.renderManager.playerViewY), (float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glRotatef((float)this.renderManager.playerViewX, (float)1.0f, (float)0.0f, (float)0.0f);
                    GL11.glScalef((float)(-f1), (float)(-f1), (float)f1);
                    GL11.glDisable((int)2896);
                    GL11.glTranslatef((float)0.0f, (float)(0.25f / f1), (float)0.0f);
                    GL11.glDepthMask((boolean)false);
                    GL11.glEnable((int)3042);
                    GL11.glBlendFunc((int)770, (int)771);
                    Tessellator tessellator = Tessellator.instance;
                    GL11.glDisable((int)3553);
                    tessellator.startDrawingQuads();
                    int i = fontrenderer.getStringWidth(s) / 2;
                    tessellator.setColorRGBA_F(0.0f, 0.0f, 0.0f, 0.25f);
                    tessellator.addVertex(-i - 1, -1.0, 0.0);
                    tessellator.addVertex(-i - 1, 8.0, 0.0);
                    tessellator.addVertex(i + 1, 8.0, 0.0);
                    tessellator.addVertex(i + 1, -1.0, 0.0);
                    tessellator.draw();
                    GL11.glEnable((int)3553);
                    GL11.glDepthMask((boolean)true);
                    fontrenderer.drawString(s, -fontrenderer.getStringWidth(s) / 2, 0, 0x20FFFFFF);
                    GL11.glEnable((int)2896);
                    GL11.glDisable((int)3042);
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    GL11.glPopMatrix();
                }
            }
        }
    }

    protected void renderSpecials(EntityPlayer par1EntityPlayer, float par2) {
        ItemStack itemstack1;
        super.renderEquippedItems(par1EntityPlayer, par2);
        ItemStack itemstack = par1EntityPlayer.inventory.armorItemInSlot(3);
        if (itemstack != null && itemstack.getItem().shiftedIndex < 256) {
            GL11.glPushMatrix();
            this.modelBipedMain.bipedHead.postRender(0.0625f);
            if (RenderBlocks.renderItemIn3d(Block.blocksList[itemstack.itemID].getRenderType())) {
                float f = 0.625f;
                GL11.glTranslatef((float)0.0f, (float)-0.25f, (float)0.0f);
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glScalef((float)f, (float)(-f), (float)f);
            }
            this.renderManager.itemRenderer.renderItem(par1EntityPlayer, itemstack, 0);
            GL11.glPopMatrix();
        }
        if (par1EntityPlayer.username.equals("deadmau5") && this.loadDownloadableImageTexture(par1EntityPlayer.skinUrl, null)) {
            for (int i = 0; i < 2; ++i) {
                float f1 = par1EntityPlayer.prevRotationYaw + (par1EntityPlayer.rotationYaw - par1EntityPlayer.prevRotationYaw) * par2 - (par1EntityPlayer.prevRenderYawOffset + (par1EntityPlayer.renderYawOffset - par1EntityPlayer.prevRenderYawOffset) * par2);
                float f2 = par1EntityPlayer.prevRotationPitch + (par1EntityPlayer.rotationPitch - par1EntityPlayer.prevRotationPitch) * par2;
                GL11.glPushMatrix();
                GL11.glRotatef((float)f1, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)f2, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glTranslatef((float)(0.375f * (float)(i * 2 - 1)), (float)0.0f, (float)0.0f);
                GL11.glTranslatef((float)0.0f, (float)-0.375f, (float)0.0f);
                GL11.glRotatef((float)(-f2), (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)(-f1), (float)0.0f, (float)1.0f, (float)0.0f);
                float f7 = 1.333333f;
                GL11.glScalef((float)f7, (float)f7, (float)f7);
                this.modelBipedMain.renderEars(0.0625f);
                GL11.glPopMatrix();
            }
        }
        if (this.loadDownloadableImageTexture(par1EntityPlayer.playerCloakUrl, null)) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)0.125f);
            double d = par1EntityPlayer.field_20066_r + (par1EntityPlayer.field_20063_u - par1EntityPlayer.field_20066_r) * (double)par2 - (par1EntityPlayer.prevPosX + (par1EntityPlayer.posX - par1EntityPlayer.prevPosX) * (double)par2);
            double d1 = par1EntityPlayer.field_20065_s + (par1EntityPlayer.field_20062_v - par1EntityPlayer.field_20065_s) * (double)par2 - (par1EntityPlayer.prevPosY + (par1EntityPlayer.posY - par1EntityPlayer.prevPosY) * (double)par2);
            double d2 = par1EntityPlayer.field_20064_t + (par1EntityPlayer.field_20061_w - par1EntityPlayer.field_20064_t) * (double)par2 - (par1EntityPlayer.prevPosZ + (par1EntityPlayer.posZ - par1EntityPlayer.prevPosZ) * (double)par2);
            float f10 = par1EntityPlayer.prevRenderYawOffset + (par1EntityPlayer.renderYawOffset - par1EntityPlayer.prevRenderYawOffset) * par2;
            double d3 = MathHelper.sin(f10 * (float)Math.PI / 180.0f);
            double d4 = -MathHelper.cos(f10 * (float)Math.PI / 180.0f);
            float f12 = (float)d1 * 10.0f;
            if (f12 < -6.0f) {
                f12 = -6.0f;
            }
            if (f12 > 32.0f) {
                f12 = 32.0f;
            }
            float f13 = (float)(d * d3 + d2 * d4) * 100.0f;
            float f14 = (float)(d * d4 - d2 * d3) * 100.0f;
            if (f13 < 0.0f) {
                f13 = 0.0f;
            }
            float f15 = par1EntityPlayer.prevCameraYaw + (par1EntityPlayer.cameraYaw - par1EntityPlayer.prevCameraYaw) * par2;
            f12 += MathHelper.sin((par1EntityPlayer.prevDistanceWalkedModified + (par1EntityPlayer.distanceWalkedModified - par1EntityPlayer.prevDistanceWalkedModified) * par2) * 6.0f) * 32.0f * f15;
            if (par1EntityPlayer.isSneaking()) {
                f12 += 25.0f;
            }
            GL11.glRotatef((float)(6.0f + f13 / 2.0f + f12), (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)(f14 / 2.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)(-f14 / 2.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            this.modelBipedMain.renderCloak(0.0625f);
            GL11.glPopMatrix();
        }
        if ((itemstack1 = par1EntityPlayer.inventory.getCurrentItem()) != null) {
            GL11.glPushMatrix();
            this.modelBipedMain.bipedRightArm.postRender(0.0625f);
            GL11.glTranslatef((float)-0.0625f, (float)0.4375f, (float)0.0625f);
            if (par1EntityPlayer.fishEntity != null) {
                itemstack1 = new ItemStack(Item.stick);
            }
            EnumAction enumaction = null;
            if (par1EntityPlayer.getItemInUseCount() > 0) {
                enumaction = itemstack1.getItemUseAction();
            }
            if (itemstack1.itemID < 256 && RenderBlocks.renderItemIn3d(Block.blocksList[itemstack1.itemID].getRenderType())) {
                float f3 = 0.5f;
                GL11.glTranslatef((float)0.0f, (float)0.1875f, (float)-0.3125f);
                GL11.glRotatef((float)20.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glScalef((float)(f3 *= 0.75f), (float)(-f3), (float)f3);
            } else if (itemstack1.itemID == Item.bow.shiftedIndex) {
                float f4 = 0.625f;
                GL11.glTranslatef((float)0.0f, (float)0.125f, (float)0.3125f);
                GL11.glRotatef((float)-20.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glScalef((float)f4, (float)(-f4), (float)f4);
                GL11.glRotatef((float)-100.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            } else if (Item.itemsList[itemstack1.itemID].isFull3D()) {
                float f5 = 0.625f;
                if (Item.itemsList[itemstack1.itemID].shouldRotateAroundWhenRendering()) {
                    GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    GL11.glTranslatef((float)0.0f, (float)-0.125f, (float)0.0f);
                }
                if (par1EntityPlayer.getItemInUseCount() > 0 && enumaction == EnumAction.block) {
                    GL11.glTranslatef((float)0.05f, (float)0.0f, (float)-0.1f);
                    GL11.glRotatef((float)-50.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glRotatef((float)-10.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    GL11.glRotatef((float)-60.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                }
                GL11.glTranslatef((float)0.0f, (float)0.1875f, (float)0.0f);
                GL11.glScalef((float)f5, (float)(-f5), (float)f5);
                GL11.glRotatef((float)-100.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            } else {
                float f6 = 0.375f;
                GL11.glTranslatef((float)0.25f, (float)0.1875f, (float)-0.1875f);
                GL11.glScalef((float)f6, (float)f6, (float)f6);
                GL11.glRotatef((float)60.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)20.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            }
            if (itemstack1.getItem().func_46058_c()) {
                for (int j = 0; j <= 1; ++j) {
                    int k = itemstack1.getItem().getColorFromDamage(itemstack1.getItemDamage(), j);
                    float f8 = (float)(k >> 16 & 0xFF) / 255.0f;
                    float f9 = (float)(k >> 8 & 0xFF) / 255.0f;
                    float f11 = (float)(k & 0xFF) / 255.0f;
                    GL11.glColor4f((float)f8, (float)f9, (float)f11, (float)1.0f);
                    this.renderManager.itemRenderer.renderItem(par1EntityPlayer, itemstack1, j);
                }
            } else {
                this.renderManager.itemRenderer.renderItem(par1EntityPlayer, itemstack1, 0);
            }
            GL11.glPopMatrix();
        }
    }

    protected void renderPlayerScale(EntityPlayer par1EntityPlayer, float par2) {
        float f = 0.9375f;
        GL11.glScalef((float)f, (float)f, (float)f);
    }

    public void drawFirstPersonHand() {
        this.modelBipedMain.onGround = 0.0f;
        this.modelBipedMain.setRotationAngles(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
        this.modelBipedMain.bipedRightArm.render(0.0625f);
    }

    protected void renderPlayerSleep(EntityPlayer par1EntityPlayer, double par2, double par4, double par6) {
        if (par1EntityPlayer.isEntityAlive() && par1EntityPlayer.isPlayerSleeping()) {
            super.renderLivingAt(par1EntityPlayer, par2 + (double)par1EntityPlayer.field_22063_x, par4 + (double)par1EntityPlayer.field_22062_y, par6 + (double)par1EntityPlayer.field_22061_z);
        } else {
            super.renderLivingAt(par1EntityPlayer, par2, par4, par6);
        }
    }

    protected void rotatePlayer(EntityPlayer par1EntityPlayer, float par2, float par3, float par4) {
        if (par1EntityPlayer.isEntityAlive() && par1EntityPlayer.isPlayerSleeping()) {
            GL11.glRotatef((float)par1EntityPlayer.getBedOrientationInDegrees(), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)this.getDeathMaxRotation(par1EntityPlayer), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        } else {
            super.rotateCorpse(par1EntityPlayer, par2, par3, par4);
        }
    }

    @Override
    protected void passSpecialRender(EntityLiving par1EntityLiving, double par2, double par4, double par6) {
        this.renderName((EntityPlayer)par1EntityLiving, par2, par4, par6);
    }

    @Override
    protected void preRenderCallback(EntityLiving par1EntityLiving, float par2) {
        this.renderPlayerScale((EntityPlayer)par1EntityLiving, par2);
    }

    @Override
    protected int shouldRenderPass(EntityLiving par1EntityLiving, int par2, float par3) {
        return this.setArmorModel((EntityPlayer)par1EntityLiving, par2, par3);
    }

    @Override
    protected void renderEquippedItems(EntityLiving par1EntityLiving, float par2) {
        this.renderSpecials((EntityPlayer)par1EntityLiving, par2);
    }

    @Override
    protected void rotateCorpse(EntityLiving par1EntityLiving, float par2, float par3, float par4) {
        this.rotatePlayer((EntityPlayer)par1EntityLiving, par2, par3, par4);
    }

    @Override
    protected void renderLivingAt(EntityLiving par1EntityLiving, double par2, double par4, double par6) {
        this.renderPlayerSleep((EntityPlayer)par1EntityLiving, par2, par4, par6);
    }

    @Override
    public void doRenderLiving(EntityLiving par1EntityLiving, double par2, double par4, double par6, float par8, float par9) {
        this.renderPlayer((EntityPlayer)par1EntityLiving, par2, par4, par6, par8, par9);
    }

    @Override
    public void doRender(Entity par1Entity, double par2, double par4, double par6, float par8, float par9) {
        this.renderPlayer((EntityPlayer)par1Entity, par2, par4, par6, par8, par9);
    }
}

