/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.Block;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityAuraFX;
import net.minecraft.src.EntityBreakingFX;
import net.minecraft.src.EntityBubbleFX;
import net.minecraft.src.EntityCloudFX;
import net.minecraft.src.EntityCritFX;
import net.minecraft.src.EntityDiggingFX;
import net.minecraft.src.EntityDropParticleFX;
import net.minecraft.src.EntityEnchantmentTableParticleFX;
import net.minecraft.src.EntityExplodeFX;
import net.minecraft.src.EntityFX;
import net.minecraft.src.EntityFlameFX;
import net.minecraft.src.EntityFootStepFX;
import net.minecraft.src.EntityHeartFX;
import net.minecraft.src.EntityHugeExplodeFX;
import net.minecraft.src.EntityLargeExplodeFX;
import net.minecraft.src.EntityLavaFX;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.EntityNoteFX;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.EntityPortalFX;
import net.minecraft.src.EntityReddustFX;
import net.minecraft.src.EntityRenderer;
import net.minecraft.src.EntitySmokeFX;
import net.minecraft.src.EntitySnowShovelFX;
import net.minecraft.src.EntitySorter;
import net.minecraft.src.EntitySpellParticleFX;
import net.minecraft.src.EntitySplashFX;
import net.minecraft.src.EntitySuspendFX;
import net.minecraft.src.EnumMovingObjectType;
import net.minecraft.src.GLAllocation;
import net.minecraft.src.ICamera;
import net.minecraft.src.IWorldAccess;
import net.minecraft.src.ImageBufferDownload;
import net.minecraft.src.Item;
import net.minecraft.src.ItemRecord;
import net.minecraft.src.ItemStack;
import net.minecraft.src.Material;
import net.minecraft.src.MathHelper;
import net.minecraft.src.MovingObjectPosition;
import net.minecraft.src.OpenGlCapsChecker;
import net.minecraft.src.Profiler;
import net.minecraft.src.RenderBlocks;
import net.minecraft.src.RenderEngine;
import net.minecraft.src.RenderHelper;
import net.minecraft.src.RenderList;
import net.minecraft.src.RenderManager;
import net.minecraft.src.RenderSorter;
import net.minecraft.src.Tessellator;
import net.minecraft.src.TileEntity;
import net.minecraft.src.TileEntityRenderer;
import net.minecraft.src.Vec3D;
import net.minecraft.src.World;
import net.minecraft.src.WorldRenderer;
import org.lwjgl.opengl.ARBOcclusionQuery;
import org.lwjgl.opengl.GL11;

public class RenderGlobal
implements IWorldAccess {
    public List tileEntities;
    private World worldObj;
    private RenderEngine renderEngine;
    private List worldRenderersToUpdate;
    private WorldRenderer[] sortedWorldRenderers;
    private WorldRenderer[] worldRenderers;
    private int renderChunksWide;
    private int renderChunksTall;
    private int renderChunksDeep;
    private int glRenderListBase;
    private Minecraft mc;
    private RenderBlocks globalRenderBlocks;
    private IntBuffer glOcclusionQueryBase;
    private boolean occlusionEnabled = false;
    private int cloudOffsetX = 0;
    private int starGLCallList;
    private int glSkyList;
    private int glSkyList2;
    private int minBlockX;
    private int minBlockY;
    private int minBlockZ;
    private int maxBlockX;
    private int maxBlockY;
    private int maxBlockZ;
    private int renderDistance = -1;
    private int renderEntitiesStartupCounter = 2;
    private int countEntitiesTotal;
    private int countEntitiesRendered;
    private int countEntitiesHidden;
    int[] dummyBuf50k;
    IntBuffer occlusionResult;
    private int renderersLoaded;
    private int renderersBeingClipped;
    private int renderersBeingOccluded;
    private int renderersBeingRendered;
    private int renderersSkippingRenderPass;
    private int dummyRenderInt;
    private int worldRenderersCheckIndex;
    private List glRenderLists;
    private RenderList[] allRenderLists = new RenderList[]{new RenderList(), new RenderList(), new RenderList(), new RenderList()};
    double prevSortX = -9999.0;
    double prevSortY = -9999.0;
    double prevSortZ = -9999.0;
    public float damagePartialTime;
    int frustumCheckOffset = 0;

    public RenderGlobal(Minecraft par1Minecraft, RenderEngine par2RenderEngine) {
        this.tileEntities = new ArrayList();
        this.worldRenderersToUpdate = new ArrayList();
        this.dummyBuf50k = new int[50000];
        this.occlusionResult = GLAllocation.createDirectIntBuffer(64);
        this.glRenderLists = new ArrayList();
        this.mc = par1Minecraft;
        this.renderEngine = par2RenderEngine;
        int byte0 = 34;
        int byte1 = 32;
        this.glRenderListBase = GLAllocation.generateDisplayLists(byte0 * byte0 * byte1 * 3);
        this.occlusionEnabled = OpenGlCapsChecker.checkARBOcclusion();
        if (this.occlusionEnabled) {
            this.occlusionResult.clear();
            this.glOcclusionQueryBase = GLAllocation.createDirectIntBuffer(byte0 * byte0 * byte1);
            this.glOcclusionQueryBase.clear();
            this.glOcclusionQueryBase.position(0);
            this.glOcclusionQueryBase.limit(byte0 * byte0 * byte1);
            ARBOcclusionQuery.glGenQueriesARB((IntBuffer)this.glOcclusionQueryBase);
        }
        this.starGLCallList = GLAllocation.generateDisplayLists(3);
        GL11.glPushMatrix();
        GL11.glNewList((int)this.starGLCallList, (int)4864);
        this.renderStars();
        GL11.glEndList();
        GL11.glPopMatrix();
        Tessellator tessellator = Tessellator.instance;
        this.glSkyList = this.starGLCallList + 1;
        GL11.glNewList((int)this.glSkyList, (int)4864);
        int byte2 = 64;
        int i = 256 / byte2 + 2;
        float f = 16.0f;
        for (int j = -byte2 * i; j <= byte2 * i; j += byte2) {
            for (int l = -byte2 * i; l <= byte2 * i; l += byte2) {
                tessellator.startDrawingQuads();
                tessellator.addVertex(j + 0, f, l + 0);
                tessellator.addVertex(j + byte2, f, l + 0);
                tessellator.addVertex(j + byte2, f, l + byte2);
                tessellator.addVertex(j + 0, f, l + byte2);
                tessellator.draw();
            }
        }
        GL11.glEndList();
        this.glSkyList2 = this.starGLCallList + 2;
        GL11.glNewList((int)this.glSkyList2, (int)4864);
        f = -16.0f;
        tessellator.startDrawingQuads();
        for (int k = -byte2 * i; k <= byte2 * i; k += byte2) {
            for (int i1 = -byte2 * i; i1 <= byte2 * i; i1 += byte2) {
                tessellator.addVertex(k + byte2, f, i1 + 0);
                tessellator.addVertex(k + 0, f, i1 + 0);
                tessellator.addVertex(k + 0, f, i1 + byte2);
                tessellator.addVertex(k + byte2, f, i1 + byte2);
            }
        }
        tessellator.draw();
        GL11.glEndList();
    }

    private void renderStars() {
        Random random = new Random(10842L);
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawingQuads();
        for (int i = 0; i < 1500; ++i) {
            double d = random.nextFloat() * 2.0f - 1.0f;
            double d1 = random.nextFloat() * 2.0f - 1.0f;
            double d2 = random.nextFloat() * 2.0f - 1.0f;
            double d3 = 0.25f + random.nextFloat() * 0.25f;
            double d4 = d * d + d1 * d1 + d2 * d2;
            if (d4 >= 1.0 || d4 <= 0.01) continue;
            d4 = 1.0 / Math.sqrt(d4);
            double d5 = (d *= d4) * 100.0;
            double d6 = (d1 *= d4) * 100.0;
            double d7 = (d2 *= d4) * 100.0;
            double d8 = Math.atan2(d, d2);
            double d9 = Math.sin(d8);
            double d10 = Math.cos(d8);
            double d11 = Math.atan2(Math.sqrt(d * d + d2 * d2), d1);
            double d12 = Math.sin(d11);
            double d13 = Math.cos(d11);
            double d14 = random.nextDouble() * Math.PI * 2.0;
            double d15 = Math.sin(d14);
            double d16 = Math.cos(d14);
            for (int j = 0; j < 4; ++j) {
                double d22;
                double d17 = 0.0;
                double d18 = (double)((j & 2) - 1) * d3;
                double d19 = (double)((j + 1 & 2) - 1) * d3;
                double d20 = d17;
                double d21 = d18 * d16 - d19 * d15;
                double d23 = d22 = d19 * d16 + d18 * d15;
                double d24 = d21 * d12 + d20 * d13;
                double d25 = d20 * d12 - d21 * d13;
                double d26 = d25 * d9 - d23 * d10;
                double d27 = d24;
                double d28 = d23 * d9 + d25 * d10;
                tessellator.addVertex(d5 + d26, d6 + d27, d7 + d28);
            }
        }
        tessellator.draw();
    }

    public void changeWorld(World par1World) {
        if (this.worldObj != null) {
            this.worldObj.removeWorldAccess(this);
        }
        this.prevSortX = -9999.0;
        this.prevSortY = -9999.0;
        this.prevSortZ = -9999.0;
        RenderManager.instance.set(par1World);
        this.worldObj = par1World;
        this.globalRenderBlocks = new RenderBlocks(par1World);
        if (par1World != null) {
            par1World.addWorldAccess(this);
            this.loadRenderers();
        }
    }

    public void loadRenderers() {
        EntityLiving entityliving;
        int j;
        if (this.worldObj == null) {
            return;
        }
        Block.leaves.setGraphicsLevel(this.mc.gameSettings.fancyGraphics);
        this.renderDistance = this.mc.gameSettings.renderDistance;
        if (this.worldRenderers != null) {
            for (int i = 0; i < this.worldRenderers.length; ++i) {
                this.worldRenderers[i].stopRendering();
            }
        }
        if ((j = 64 << 3 - this.renderDistance) > 400) {
            j = 400;
        }
        this.renderChunksWide = j / 16 + 1;
        this.renderChunksTall = 16;
        this.renderChunksDeep = j / 16 + 1;
        this.worldRenderers = new WorldRenderer[this.renderChunksWide * this.renderChunksTall * this.renderChunksDeep];
        this.sortedWorldRenderers = new WorldRenderer[this.renderChunksWide * this.renderChunksTall * this.renderChunksDeep];
        int k = 0;
        int l = 0;
        this.minBlockX = 0;
        this.minBlockY = 0;
        this.minBlockZ = 0;
        this.maxBlockX = this.renderChunksWide;
        this.maxBlockY = this.renderChunksTall;
        this.maxBlockZ = this.renderChunksDeep;
        for (int i1 = 0; i1 < this.worldRenderersToUpdate.size(); ++i1) {
            ((WorldRenderer)this.worldRenderersToUpdate.get((int)i1)).needsUpdate = false;
        }
        this.worldRenderersToUpdate.clear();
        this.tileEntities.clear();
        for (int j1 = 0; j1 < this.renderChunksWide; ++j1) {
            for (int k1 = 0; k1 < this.renderChunksTall; ++k1) {
                for (int l1 = 0; l1 < this.renderChunksDeep; ++l1) {
                    this.worldRenderers[(l1 * this.renderChunksTall + k1) * this.renderChunksWide + j1] = new WorldRenderer(this.worldObj, this.tileEntities, j1 * 16, k1 * 16, l1 * 16, this.glRenderListBase + k);
                    if (this.occlusionEnabled) {
                        this.worldRenderers[(l1 * this.renderChunksTall + k1) * this.renderChunksWide + j1].glOcclusionQuery = this.glOcclusionQueryBase.get(l);
                    }
                    this.worldRenderers[(l1 * this.renderChunksTall + k1) * this.renderChunksWide + j1].isWaitingOnOcclusionQuery = false;
                    this.worldRenderers[(l1 * this.renderChunksTall + k1) * this.renderChunksWide + j1].isVisible = true;
                    this.worldRenderers[(l1 * this.renderChunksTall + k1) * this.renderChunksWide + j1].isInFrustum = true;
                    this.worldRenderers[(l1 * this.renderChunksTall + k1) * this.renderChunksWide + j1].chunkIndex = l++;
                    this.worldRenderers[(l1 * this.renderChunksTall + k1) * this.renderChunksWide + j1].markDirty();
                    this.sortedWorldRenderers[(l1 * this.renderChunksTall + k1) * this.renderChunksWide + j1] = this.worldRenderers[(l1 * this.renderChunksTall + k1) * this.renderChunksWide + j1];
                    this.worldRenderersToUpdate.add(this.worldRenderers[(l1 * this.renderChunksTall + k1) * this.renderChunksWide + j1]);
                    k += 3;
                }
            }
        }
        if (this.worldObj != null && (entityliving = this.mc.renderViewEntity) != null) {
            this.markRenderersForNewPosition(MathHelper.floor_double(entityliving.posX), MathHelper.floor_double(entityliving.posY), MathHelper.floor_double(entityliving.posZ));
            Arrays.sort(this.sortedWorldRenderers, new EntitySorter(entityliving));
        }
        this.renderEntitiesStartupCounter = 2;
    }

    public void renderEntities(Vec3D par1Vec3D, ICamera par2ICamera, float par3) {
        if (this.renderEntitiesStartupCounter > 0) {
            --this.renderEntitiesStartupCounter;
            return;
        }
        Profiler.startSection("prepare");
        TileEntityRenderer.instance.cacheActiveRenderInfo(this.worldObj, this.renderEngine, this.mc.fontRenderer, this.mc.renderViewEntity, par3);
        RenderManager.instance.cacheActiveRenderInfo(this.worldObj, this.renderEngine, this.mc.fontRenderer, this.mc.renderViewEntity, this.mc.gameSettings, par3);
        TileEntityRenderer.instance.func_40742_a();
        this.countEntitiesTotal = 0;
        this.countEntitiesRendered = 0;
        this.countEntitiesHidden = 0;
        EntityLiving entityliving = this.mc.renderViewEntity;
        RenderManager.renderPosX = entityliving.lastTickPosX + (entityliving.posX - entityliving.lastTickPosX) * (double)par3;
        RenderManager.renderPosY = entityliving.lastTickPosY + (entityliving.posY - entityliving.lastTickPosY) * (double)par3;
        RenderManager.renderPosZ = entityliving.lastTickPosZ + (entityliving.posZ - entityliving.lastTickPosZ) * (double)par3;
        TileEntityRenderer.staticPlayerX = entityliving.lastTickPosX + (entityliving.posX - entityliving.lastTickPosX) * (double)par3;
        TileEntityRenderer.staticPlayerY = entityliving.lastTickPosY + (entityliving.posY - entityliving.lastTickPosY) * (double)par3;
        TileEntityRenderer.staticPlayerZ = entityliving.lastTickPosZ + (entityliving.posZ - entityliving.lastTickPosZ) * (double)par3;
        this.mc.entityRenderer.enableLightmap(par3);
        Profiler.endStartSection("global");
        List list = this.worldObj.getLoadedEntityList();
        this.countEntitiesTotal = list.size();
        for (int i = 0; i < this.worldObj.weatherEffects.size(); ++i) {
            Entity entity = (Entity)this.worldObj.weatherEffects.get(i);
            ++this.countEntitiesRendered;
            if (!entity.isInRangeToRenderVec3D(par1Vec3D)) continue;
            RenderManager.instance.renderEntity(entity, par3);
        }
        Profiler.endStartSection("entities");
        for (int j = 0; j < list.size(); ++j) {
            Entity entity1 = (Entity)list.get(j);
            if (!entity1.isInRangeToRenderVec3D(par1Vec3D) || !entity1.ignoreFrustumCheck && !par2ICamera.isBoundingBoxInFrustum(entity1.boundingBox) || entity1 == this.mc.renderViewEntity && this.mc.gameSettings.thirdPersonView == 0 && !this.mc.renderViewEntity.isPlayerSleeping() || !this.worldObj.blockExists(MathHelper.floor_double(entity1.posX), 0, MathHelper.floor_double(entity1.posZ))) continue;
            ++this.countEntitiesRendered;
            RenderManager.instance.renderEntity(entity1, par3);
        }
        Profiler.endStartSection("tileentities");
        RenderHelper.enableStandardItemLighting();
        for (int k = 0; k < this.tileEntities.size(); ++k) {
            TileEntityRenderer.instance.renderTileEntity((TileEntity)this.tileEntities.get(k), par3);
        }
        this.mc.entityRenderer.disableLightmap(par3);
        Profiler.endSection();
    }

    public String getDebugInfoRenders() {
        return "C: " + this.renderersBeingRendered + "/" + this.renderersLoaded + ". F: " + this.renderersBeingClipped + ", O: " + this.renderersBeingOccluded + ", E: " + this.renderersSkippingRenderPass;
    }

    public String getDebugInfoEntities() {
        return "E: " + this.countEntitiesRendered + "/" + this.countEntitiesTotal + ". B: " + this.countEntitiesHidden + ", I: " + (this.countEntitiesTotal - this.countEntitiesHidden - this.countEntitiesRendered);
    }

    private void markRenderersForNewPosition(int par1, int par2, int par3) {
        par1 -= 8;
        par2 -= 8;
        par3 -= 8;
        this.minBlockX = Integer.MAX_VALUE;
        this.minBlockY = Integer.MAX_VALUE;
        this.minBlockZ = Integer.MAX_VALUE;
        this.maxBlockX = Integer.MIN_VALUE;
        this.maxBlockY = Integer.MIN_VALUE;
        this.maxBlockZ = Integer.MIN_VALUE;
        int i = this.renderChunksWide * 16;
        int j = i / 2;
        for (int k = 0; k < this.renderChunksWide; ++k) {
            int l = k * 16;
            int i1 = l + j - par1;
            if (i1 < 0) {
                i1 -= i - 1;
            }
            if ((l -= (i1 /= i) * i) < this.minBlockX) {
                this.minBlockX = l;
            }
            if (l > this.maxBlockX) {
                this.maxBlockX = l;
            }
            for (int j1 = 0; j1 < this.renderChunksDeep; ++j1) {
                int k1 = j1 * 16;
                int l1 = k1 + j - par3;
                if (l1 < 0) {
                    l1 -= i - 1;
                }
                if ((k1 -= (l1 /= i) * i) < this.minBlockZ) {
                    this.minBlockZ = k1;
                }
                if (k1 > this.maxBlockZ) {
                    this.maxBlockZ = k1;
                }
                for (int i2 = 0; i2 < this.renderChunksTall; ++i2) {
                    int j2 = i2 * 16;
                    if (j2 < this.minBlockY) {
                        this.minBlockY = j2;
                    }
                    if (j2 > this.maxBlockY) {
                        this.maxBlockY = j2;
                    }
                    WorldRenderer worldrenderer = this.worldRenderers[(j1 * this.renderChunksTall + i2) * this.renderChunksWide + k];
                    boolean flag = worldrenderer.needsUpdate;
                    worldrenderer.setPosition(l, j2, k1);
                    if (flag || !worldrenderer.needsUpdate) continue;
                    this.worldRenderersToUpdate.add(worldrenderer);
                }
            }
        }
    }

    public int sortAndRender(EntityLiving par1EntityLiving, int par2, double par3) {
        Profiler.startSection("sortchunks");
        for (int i = 0; i < 10; ++i) {
            this.worldRenderersCheckIndex = (this.worldRenderersCheckIndex + 1) % this.worldRenderers.length;
            WorldRenderer worldrenderer = this.worldRenderers[this.worldRenderersCheckIndex];
            if (!worldrenderer.needsUpdate || this.worldRenderersToUpdate.contains(worldrenderer)) continue;
            this.worldRenderersToUpdate.add(worldrenderer);
        }
        if (this.mc.gameSettings.renderDistance != this.renderDistance) {
            this.loadRenderers();
        }
        if (par2 == 0) {
            this.renderersLoaded = 0;
            this.dummyRenderInt = 0;
            this.renderersBeingClipped = 0;
            this.renderersBeingOccluded = 0;
            this.renderersBeingRendered = 0;
            this.renderersSkippingRenderPass = 0;
        }
        double d = par1EntityLiving.lastTickPosX + (par1EntityLiving.posX - par1EntityLiving.lastTickPosX) * par3;
        double d1 = par1EntityLiving.lastTickPosY + (par1EntityLiving.posY - par1EntityLiving.lastTickPosY) * par3;
        double d2 = par1EntityLiving.lastTickPosZ + (par1EntityLiving.posZ - par1EntityLiving.lastTickPosZ) * par3;
        double d3 = par1EntityLiving.posX - this.prevSortX;
        double d4 = par1EntityLiving.posY - this.prevSortY;
        double d5 = par1EntityLiving.posZ - this.prevSortZ;
        if (d3 * d3 + d4 * d4 + d5 * d5 > 16.0) {
            this.prevSortX = par1EntityLiving.posX;
            this.prevSortY = par1EntityLiving.posY;
            this.prevSortZ = par1EntityLiving.posZ;
            this.markRenderersForNewPosition(MathHelper.floor_double(par1EntityLiving.posX), MathHelper.floor_double(par1EntityLiving.posY), MathHelper.floor_double(par1EntityLiving.posZ));
            Arrays.sort(this.sortedWorldRenderers, new EntitySorter(par1EntityLiving));
        }
        RenderHelper.disableStandardItemLighting();
        int j = 0;
        if (this.occlusionEnabled && this.mc.gameSettings.advancedOpengl && !this.mc.gameSettings.anaglyph && par2 == 0) {
            int k = 0;
            int l = 16;
            this.checkOcclusionQueryResult(k, l);
            for (int i1 = k; i1 < l; ++i1) {
                this.sortedWorldRenderers[i1].isVisible = true;
            }
            Profiler.endStartSection("render");
            j += this.renderSortedRenderers(k, l, par2, par3);
            do {
                Profiler.endStartSection("occ");
                int byte0 = l;
                if ((l *= 2) > this.sortedWorldRenderers.length) {
                    l = this.sortedWorldRenderers.length;
                }
                GL11.glDisable((int)3553);
                GL11.glDisable((int)2896);
                GL11.glDisable((int)3008);
                GL11.glDisable((int)2912);
                GL11.glColorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
                GL11.glDepthMask((boolean)false);
                Profiler.startSection("check");
                this.checkOcclusionQueryResult(byte0, l);
                Profiler.endSection();
                GL11.glPushMatrix();
                float f = 0.0f;
                float f1 = 0.0f;
                float f2 = 0.0f;
                for (int j1 = byte0; j1 < l; ++j1) {
                    float f3;
                    int k1;
                    if (this.sortedWorldRenderers[j1].skipAllRenderPasses()) {
                        this.sortedWorldRenderers[j1].isInFrustum = false;
                        continue;
                    }
                    if (!this.sortedWorldRenderers[j1].isInFrustum) {
                        this.sortedWorldRenderers[j1].isVisible = true;
                    }
                    if (!this.sortedWorldRenderers[j1].isInFrustum || this.sortedWorldRenderers[j1].isWaitingOnOcclusionQuery || this.cloudOffsetX % (k1 = (int)(1.0f + (f3 = MathHelper.sqrt_float(this.sortedWorldRenderers[j1].distanceToEntitySquared(par1EntityLiving))) / 128.0f)) != j1 % k1) continue;
                    WorldRenderer worldrenderer1 = this.sortedWorldRenderers[j1];
                    float f4 = (float)((double)worldrenderer1.posXMinus - d);
                    float f5 = (float)((double)worldrenderer1.posYMinus - d1);
                    float f6 = (float)((double)worldrenderer1.posZMinus - d2);
                    float f7 = f4 - f;
                    float f8 = f5 - f1;
                    float f9 = f6 - f2;
                    if (f7 != 0.0f || f8 != 0.0f || f9 != 0.0f) {
                        GL11.glTranslatef((float)f7, (float)f8, (float)f9);
                        f += f7;
                        f1 += f8;
                        f2 += f9;
                    }
                    Profiler.startSection("bb");
                    ARBOcclusionQuery.glBeginQueryARB((int)35092, (int)this.sortedWorldRenderers[j1].glOcclusionQuery);
                    this.sortedWorldRenderers[j1].callOcclusionQueryList();
                    ARBOcclusionQuery.glEndQueryARB((int)35092);
                    Profiler.endSection();
                    this.sortedWorldRenderers[j1].isWaitingOnOcclusionQuery = true;
                }
                GL11.glPopMatrix();
                if (this.mc.gameSettings.anaglyph) {
                    if (EntityRenderer.anaglyphField == 0) {
                        GL11.glColorMask((boolean)false, (boolean)true, (boolean)true, (boolean)true);
                    } else {
                        GL11.glColorMask((boolean)true, (boolean)false, (boolean)false, (boolean)true);
                    }
                } else {
                    GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                }
                GL11.glDepthMask((boolean)true);
                GL11.glEnable((int)3553);
                GL11.glEnable((int)3008);
                GL11.glEnable((int)2912);
                Profiler.endStartSection("render");
                j += this.renderSortedRenderers(byte0, l, par2, par3);
            } while (l < this.sortedWorldRenderers.length);
        } else {
            Profiler.endStartSection("render");
            j += this.renderSortedRenderers(0, this.sortedWorldRenderers.length, par2, par3);
        }
        Profiler.endSection();
        return j;
    }

    private void checkOcclusionQueryResult(int par1, int par2) {
        for (int i = par1; i < par2; ++i) {
            if (!this.sortedWorldRenderers[i].isWaitingOnOcclusionQuery) continue;
            this.occlusionResult.clear();
            ARBOcclusionQuery.glGetQueryObjectuARB((int)this.sortedWorldRenderers[i].glOcclusionQuery, (int)34919, (IntBuffer)this.occlusionResult);
            if (this.occlusionResult.get(0) == 0) continue;
            this.sortedWorldRenderers[i].isWaitingOnOcclusionQuery = false;
            this.occlusionResult.clear();
            ARBOcclusionQuery.glGetQueryObjectuARB((int)this.sortedWorldRenderers[i].glOcclusionQuery, (int)34918, (IntBuffer)this.occlusionResult);
            this.sortedWorldRenderers[i].isVisible = this.occlusionResult.get(0) != 0;
        }
    }

    private int renderSortedRenderers(int par1, int par2, int par3, double par4) {
        this.glRenderLists.clear();
        int i = 0;
        for (int j = par1; j < par2; ++j) {
            int k;
            if (par3 == 0) {
                ++this.renderersLoaded;
                if (this.sortedWorldRenderers[j].skipRenderPass[par3]) {
                    ++this.renderersSkippingRenderPass;
                } else if (!this.sortedWorldRenderers[j].isInFrustum) {
                    ++this.renderersBeingClipped;
                } else if (this.occlusionEnabled && !this.sortedWorldRenderers[j].isVisible) {
                    ++this.renderersBeingOccluded;
                } else {
                    ++this.renderersBeingRendered;
                }
            }
            if (this.sortedWorldRenderers[j].skipRenderPass[par3] || !this.sortedWorldRenderers[j].isInFrustum || this.occlusionEnabled && !this.sortedWorldRenderers[j].isVisible || (k = this.sortedWorldRenderers[j].getGLCallListForPass(par3)) < 0) continue;
            this.glRenderLists.add(this.sortedWorldRenderers[j]);
            ++i;
        }
        EntityLiving entityliving = this.mc.renderViewEntity;
        double d = entityliving.lastTickPosX + (entityliving.posX - entityliving.lastTickPosX) * par4;
        double d1 = entityliving.lastTickPosY + (entityliving.posY - entityliving.lastTickPosY) * par4;
        double d2 = entityliving.lastTickPosZ + (entityliving.posZ - entityliving.lastTickPosZ) * par4;
        int l = 0;
        for (int i1 = 0; i1 < this.allRenderLists.length; ++i1) {
            this.allRenderLists[i1].func_859_b();
        }
        for (int j1 = 0; j1 < this.glRenderLists.size(); ++j1) {
            WorldRenderer worldrenderer = (WorldRenderer)this.glRenderLists.get(j1);
            int k1 = -1;
            for (int l1 = 0; l1 < l; ++l1) {
                if (!this.allRenderLists[l1].func_862_a(worldrenderer.posXMinus, worldrenderer.posYMinus, worldrenderer.posZMinus)) continue;
                k1 = l1;
            }
            if (k1 < 0) {
                k1 = l++;
                this.allRenderLists[k1].func_861_a(worldrenderer.posXMinus, worldrenderer.posYMinus, worldrenderer.posZMinus, d, d1, d2);
            }
            this.allRenderLists[k1].func_858_a(worldrenderer.getGLCallListForPass(par3));
        }
        this.renderAllRenderLists(par3, par4);
        return i;
    }

    public void renderAllRenderLists(int par1, double par2) {
        this.mc.entityRenderer.enableLightmap(par2);
        for (int i = 0; i < this.allRenderLists.length; ++i) {
            this.allRenderLists[i].func_860_a();
        }
        this.mc.entityRenderer.disableLightmap(par2);
    }

    public void updateClouds() {
        ++this.cloudOffsetX;
    }

    public void renderSky(float par1) {
        if (this.mc.theWorld.worldProvider.worldType == 1) {
            GL11.glDisable((int)2912);
            GL11.glDisable((int)3008);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            RenderHelper.disableStandardItemLighting();
            GL11.glDepthMask((boolean)false);
            this.renderEngine.bindTexture(this.renderEngine.getTexture("/misc/tunnel.png"));
            Tessellator tessellator = Tessellator.instance;
            for (int i = 0; i < 6; ++i) {
                GL11.glPushMatrix();
                if (i == 1) {
                    GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                }
                if (i == 2) {
                    GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                }
                if (i == 3) {
                    GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                }
                if (i == 4) {
                    GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                }
                if (i == 5) {
                    GL11.glRotatef((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                }
                tessellator.startDrawingQuads();
                tessellator.setColorOpaque_I(0x181818);
                tessellator.addVertexWithUV(-100.0, -100.0, -100.0, 0.0, 0.0);
                tessellator.addVertexWithUV(-100.0, -100.0, 100.0, 0.0, 16.0);
                tessellator.addVertexWithUV(100.0, -100.0, 100.0, 16.0, 16.0);
                tessellator.addVertexWithUV(100.0, -100.0, -100.0, 16.0, 0.0);
                tessellator.draw();
                GL11.glPopMatrix();
            }
            GL11.glDepthMask((boolean)true);
            GL11.glEnable((int)3553);
            GL11.glEnable((int)3008);
            return;
        }
        if (!this.mc.theWorld.worldProvider.func_48217_e()) {
            return;
        }
        GL11.glDisable((int)3553);
        Vec3D vec3d = this.worldObj.getSkyColor(this.mc.renderViewEntity, par1);
        float f = (float)vec3d.xCoord;
        float f1 = (float)vec3d.yCoord;
        float f2 = (float)vec3d.zCoord;
        if (this.mc.gameSettings.anaglyph) {
            float f3 = (f * 30.0f + f1 * 59.0f + f2 * 11.0f) / 100.0f;
            float f4 = (f * 30.0f + f1 * 70.0f) / 100.0f;
            float f5 = (f * 30.0f + f2 * 70.0f) / 100.0f;
            f = f3;
            f1 = f4;
            f2 = f5;
        }
        GL11.glColor3f((float)f, (float)f1, (float)f2);
        Tessellator tessellator1 = Tessellator.instance;
        GL11.glDepthMask((boolean)false);
        GL11.glEnable((int)2912);
        GL11.glColor3f((float)f, (float)f1, (float)f2);
        GL11.glCallList((int)this.glSkyList);
        GL11.glDisable((int)2912);
        GL11.glDisable((int)3008);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        RenderHelper.disableStandardItemLighting();
        float[] af = this.worldObj.worldProvider.calcSunriseSunsetColors(this.worldObj.getCelestialAngle(par1), par1);
        if (af != null) {
            GL11.glDisable((int)3553);
            GL11.glShadeModel((int)7425);
            GL11.glPushMatrix();
            GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)(MathHelper.sin(this.worldObj.getCelestialAngleRadians(par1)) >= 0.0f ? 0.0f : 180.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            float f6 = af[0];
            float f8 = af[1];
            float f11 = af[2];
            if (this.mc.gameSettings.anaglyph) {
                float f14 = (f6 * 30.0f + f8 * 59.0f + f11 * 11.0f) / 100.0f;
                float f17 = (f6 * 30.0f + f8 * 70.0f) / 100.0f;
                float f20 = (f6 * 30.0f + f11 * 70.0f) / 100.0f;
                f6 = f14;
                f8 = f17;
                f11 = f20;
            }
            tessellator1.startDrawing(6);
            tessellator1.setColorRGBA_F(f6, f8, f11, af[3]);
            tessellator1.addVertex(0.0, 100.0, 0.0);
            int j = 16;
            tessellator1.setColorRGBA_F(af[0], af[1], af[2], 0.0f);
            for (int k = 0; k <= j; ++k) {
                float f21 = (float)k * (float)Math.PI * 2.0f / (float)j;
                float f22 = MathHelper.sin(f21);
                float f23 = MathHelper.cos(f21);
                tessellator1.addVertex(f22 * 120.0f, f23 * 120.0f, -f23 * 40.0f * af[3]);
            }
            tessellator1.draw();
            GL11.glPopMatrix();
            GL11.glShadeModel((int)7424);
        }
        GL11.glEnable((int)3553);
        GL11.glBlendFunc((int)770, (int)1);
        GL11.glPushMatrix();
        double d = 1.0f - this.worldObj.getRainStrength(par1);
        float f7 = 0.0f;
        float f9 = 0.0f;
        float f12 = 0.0f;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)((float)d));
        GL11.glTranslatef((float)f7, (float)f9, (float)f12);
        GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(this.worldObj.getCelestialAngle(par1) * 360.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        float f15 = 30.0f;
        GL11.glBindTexture((int)3553, (int)this.renderEngine.getTexture("/terrain/sun.png"));
        tessellator1.startDrawingQuads();
        tessellator1.addVertexWithUV(-f15, 100.0, -f15, 0.0, 0.0);
        tessellator1.addVertexWithUV(f15, 100.0, -f15, 1.0, 0.0);
        tessellator1.addVertexWithUV(f15, 100.0, f15, 1.0, 1.0);
        tessellator1.addVertexWithUV(-f15, 100.0, f15, 0.0, 1.0);
        tessellator1.draw();
        f15 = 20.0f;
        GL11.glBindTexture((int)3553, (int)this.renderEngine.getTexture("/terrain/moon_phases.png"));
        int i18 = this.worldObj.getMoonPhase(par1);
        int l = i18 % 4;
        int i1 = i18 / 4 % 2;
        float f24 = (float)(l + 0) / 4.0f;
        float f25 = (float)(i1 + 0) / 2.0f;
        float f26 = (float)(l + 1) / 4.0f;
        float f27 = (float)(i1 + 1) / 2.0f;
        tessellator1.startDrawingQuads();
        tessellator1.addVertexWithUV(-f15, -100.0, f15, f26, f27);
        tessellator1.addVertexWithUV(f15, -100.0, f15, f24, f27);
        tessellator1.addVertexWithUV(f15, -100.0, -f15, f24, f25);
        tessellator1.addVertexWithUV(-f15, -100.0, -f15, f26, f25);
        tessellator1.draw();
        GL11.glDisable((int)3553);
        float f18 = (float)((double)this.worldObj.getStarBrightness(par1) * d);
        if (f18 > 0.0f) {
            GL11.glColor4f((float)f18, (float)f18, (float)f18, (float)f18);
            GL11.glCallList((int)this.starGLCallList);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)2912);
        GL11.glPopMatrix();
        GL11.glDisable((int)3553);
        GL11.glColor3f((float)0.0f, (float)0.0f, (float)0.0f);
        d = this.mc.thePlayer.getPosition((float)par1).yCoord - this.worldObj.getSeaLevel();
        if (d < 0.0) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)0.0f, (float)12.0f, (float)0.0f);
            GL11.glCallList((int)this.glSkyList2);
            GL11.glPopMatrix();
            float f10 = 1.0f;
            float f13 = -((float)(d + 65.0));
            float f16 = -f10;
            float f19 = f13;
            tessellator1.startDrawingQuads();
            tessellator1.setColorRGBA_I(0, 255);
            tessellator1.addVertex(-f10, f19, f10);
            tessellator1.addVertex(f10, f19, f10);
            tessellator1.addVertex(f10, f16, f10);
            tessellator1.addVertex(-f10, f16, f10);
            tessellator1.addVertex(-f10, f16, -f10);
            tessellator1.addVertex(f10, f16, -f10);
            tessellator1.addVertex(f10, f19, -f10);
            tessellator1.addVertex(-f10, f19, -f10);
            tessellator1.addVertex(f10, f16, -f10);
            tessellator1.addVertex(f10, f16, f10);
            tessellator1.addVertex(f10, f19, f10);
            tessellator1.addVertex(f10, f19, -f10);
            tessellator1.addVertex(-f10, f19, -f10);
            tessellator1.addVertex(-f10, f19, f10);
            tessellator1.addVertex(-f10, f16, f10);
            tessellator1.addVertex(-f10, f16, -f10);
            tessellator1.addVertex(-f10, f16, -f10);
            tessellator1.addVertex(-f10, f16, f10);
            tessellator1.addVertex(f10, f16, f10);
            tessellator1.addVertex(f10, f16, -f10);
            tessellator1.draw();
        }
        if (this.worldObj.worldProvider.isSkyColored()) {
            GL11.glColor3f((float)(f * 0.2f + 0.04f), (float)(f1 * 0.2f + 0.04f), (float)(f2 * 0.6f + 0.1f));
        } else {
            GL11.glColor3f((float)f, (float)f1, (float)f2);
        }
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)(-((float)(d - 16.0))), (float)0.0f);
        GL11.glCallList((int)this.glSkyList2);
        GL11.glPopMatrix();
        GL11.glEnable((int)3553);
        GL11.glDepthMask((boolean)true);
    }

    public void renderClouds(float par1) {
        if (!this.mc.theWorld.worldProvider.func_48217_e()) {
            return;
        }
        if (this.mc.gameSettings.fancyGraphics) {
            this.renderCloudsFancy(par1);
            return;
        }
        GL11.glDisable((int)2884);
        float f = (float)(this.mc.renderViewEntity.lastTickPosY + (this.mc.renderViewEntity.posY - this.mc.renderViewEntity.lastTickPosY) * (double)par1);
        int byte0 = 32;
        int i = 256 / byte0;
        Tessellator tessellator = Tessellator.instance;
        GL11.glBindTexture((int)3553, (int)this.renderEngine.getTexture("/environment/clouds.png"));
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        Vec3D vec3d = this.worldObj.drawClouds(par1);
        float f1 = (float)vec3d.xCoord;
        float f2 = (float)vec3d.yCoord;
        float f3 = (float)vec3d.zCoord;
        if (this.mc.gameSettings.anaglyph) {
            float f4 = (f1 * 30.0f + f2 * 59.0f + f3 * 11.0f) / 100.0f;
            float f6 = (f1 * 30.0f + f2 * 70.0f) / 100.0f;
            float f7 = (f1 * 30.0f + f3 * 70.0f) / 100.0f;
            f1 = f4;
            f2 = f6;
            f3 = f7;
        }
        float f5 = 4.882813E-4f;
        double d = (float)this.cloudOffsetX + par1;
        double d1 = this.mc.renderViewEntity.prevPosX + (this.mc.renderViewEntity.posX - this.mc.renderViewEntity.prevPosX) * (double)par1 + d * (double)0.03f;
        double d2 = this.mc.renderViewEntity.prevPosZ + (this.mc.renderViewEntity.posZ - this.mc.renderViewEntity.prevPosZ) * (double)par1;
        int j = MathHelper.floor_double(d1 / 2048.0);
        int k = MathHelper.floor_double(d2 / 2048.0);
        float f8 = this.worldObj.worldProvider.getCloudHeight() - f + 0.33f;
        float f9 = (float)((d1 -= (double)(j * 2048)) * (double)f5);
        float f10 = (float)((d2 -= (double)(k * 2048)) * (double)f5);
        tessellator.startDrawingQuads();
        tessellator.setColorRGBA_F(f1, f2, f3, 0.8f);
        for (int l = -byte0 * i; l < byte0 * i; l += byte0) {
            for (int i1 = -byte0 * i; i1 < byte0 * i; i1 += byte0) {
                tessellator.addVertexWithUV(l + 0, f8, i1 + byte0, (float)(l + 0) * f5 + f9, (float)(i1 + byte0) * f5 + f10);
                tessellator.addVertexWithUV(l + byte0, f8, i1 + byte0, (float)(l + byte0) * f5 + f9, (float)(i1 + byte0) * f5 + f10);
                tessellator.addVertexWithUV(l + byte0, f8, i1 + 0, (float)(l + byte0) * f5 + f9, (float)(i1 + 0) * f5 + f10);
                tessellator.addVertexWithUV(l + 0, f8, i1 + 0, (float)(l + 0) * f5 + f9, (float)(i1 + 0) * f5 + f10);
            }
        }
        tessellator.draw();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)2884);
    }

    public boolean func_27307_a(double par1, double par3, double d, float f) {
        return false;
    }

    public void renderCloudsFancy(float par1) {
        GL11.glDisable((int)2884);
        float f = (float)(this.mc.renderViewEntity.lastTickPosY + (this.mc.renderViewEntity.posY - this.mc.renderViewEntity.lastTickPosY) * (double)par1);
        Tessellator tessellator = Tessellator.instance;
        float f1 = 12.0f;
        float f2 = 4.0f;
        double d = (float)this.cloudOffsetX + par1;
        double d1 = (this.mc.renderViewEntity.prevPosX + (this.mc.renderViewEntity.posX - this.mc.renderViewEntity.prevPosX) * (double)par1 + d * (double)0.03f) / (double)f1;
        double d2 = (this.mc.renderViewEntity.prevPosZ + (this.mc.renderViewEntity.posZ - this.mc.renderViewEntity.prevPosZ) * (double)par1) / (double)f1 + (double)0.33f;
        float f3 = this.worldObj.worldProvider.getCloudHeight() - f + 0.33f;
        int i = MathHelper.floor_double(d1 / 2048.0);
        int j = MathHelper.floor_double(d2 / 2048.0);
        d1 -= (double)(i * 2048);
        d2 -= (double)(j * 2048);
        GL11.glBindTexture((int)3553, (int)this.renderEngine.getTexture("/environment/clouds.png"));
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        Vec3D vec3d = this.worldObj.drawClouds(par1);
        float f4 = (float)vec3d.xCoord;
        float f5 = (float)vec3d.yCoord;
        float f6 = (float)vec3d.zCoord;
        if (this.mc.gameSettings.anaglyph) {
            float f7 = (f4 * 30.0f + f5 * 59.0f + f6 * 11.0f) / 100.0f;
            float f9 = (f4 * 30.0f + f5 * 70.0f) / 100.0f;
            float f11 = (f4 * 30.0f + f6 * 70.0f) / 100.0f;
            f4 = f7;
            f5 = f9;
            f6 = f11;
        }
        float f8 = (float)(d1 * 0.0);
        float f10 = (float)(d2 * 0.0);
        float f12 = 0.00390625f;
        f8 = (float)MathHelper.floor_double(d1) * f12;
        f10 = (float)MathHelper.floor_double(d2) * f12;
        float f13 = (float)(d1 - (double)MathHelper.floor_double(d1));
        float f14 = (float)(d2 - (double)MathHelper.floor_double(d2));
        int k = 8;
        int byte0 = 4;
        float f15 = 9.765625E-4f;
        GL11.glScalef((float)f1, (float)1.0f, (float)f1);
        for (int l = 0; l < 2; ++l) {
            if (l == 0) {
                GL11.glColorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
            } else if (this.mc.gameSettings.anaglyph) {
                if (EntityRenderer.anaglyphField == 0) {
                    GL11.glColorMask((boolean)false, (boolean)true, (boolean)true, (boolean)true);
                } else {
                    GL11.glColorMask((boolean)true, (boolean)false, (boolean)false, (boolean)true);
                }
            } else {
                GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            }
            for (int i1 = -byte0 + 1; i1 <= byte0; ++i1) {
                for (int j1 = -byte0 + 1; j1 <= byte0; ++j1) {
                    tessellator.startDrawingQuads();
                    float f16 = i1 * k;
                    float f17 = j1 * k;
                    float f18 = f16 - f13;
                    float f19 = f17 - f14;
                    if (f3 > -f2 - 1.0f) {
                        tessellator.setColorRGBA_F(f4 * 0.7f, f5 * 0.7f, f6 * 0.7f, 0.8f);
                        tessellator.setNormal(0.0f, -1.0f, 0.0f);
                        tessellator.addVertexWithUV(f18 + 0.0f, f3 + 0.0f, f19 + (float)k, (f16 + 0.0f) * f12 + f8, (f17 + (float)k) * f12 + f10);
                        tessellator.addVertexWithUV(f18 + (float)k, f3 + 0.0f, f19 + (float)k, (f16 + (float)k) * f12 + f8, (f17 + (float)k) * f12 + f10);
                        tessellator.addVertexWithUV(f18 + (float)k, f3 + 0.0f, f19 + 0.0f, (f16 + (float)k) * f12 + f8, (f17 + 0.0f) * f12 + f10);
                        tessellator.addVertexWithUV(f18 + 0.0f, f3 + 0.0f, f19 + 0.0f, (f16 + 0.0f) * f12 + f8, (f17 + 0.0f) * f12 + f10);
                    }
                    if (f3 <= f2 + 1.0f) {
                        tessellator.setColorRGBA_F(f4, f5, f6, 0.8f);
                        tessellator.setNormal(0.0f, 1.0f, 0.0f);
                        tessellator.addVertexWithUV(f18 + 0.0f, f3 + f2 - f15, f19 + (float)k, (f16 + 0.0f) * f12 + f8, (f17 + (float)k) * f12 + f10);
                        tessellator.addVertexWithUV(f18 + (float)k, f3 + f2 - f15, f19 + (float)k, (f16 + (float)k) * f12 + f8, (f17 + (float)k) * f12 + f10);
                        tessellator.addVertexWithUV(f18 + (float)k, f3 + f2 - f15, f19 + 0.0f, (f16 + (float)k) * f12 + f8, (f17 + 0.0f) * f12 + f10);
                        tessellator.addVertexWithUV(f18 + 0.0f, f3 + f2 - f15, f19 + 0.0f, (f16 + 0.0f) * f12 + f8, (f17 + 0.0f) * f12 + f10);
                    }
                    tessellator.setColorRGBA_F(f4 * 0.9f, f5 * 0.9f, f6 * 0.9f, 0.8f);
                    if (i1 > -1) {
                        tessellator.setNormal(-1.0f, 0.0f, 0.0f);
                        for (int k1 = 0; k1 < k; ++k1) {
                            tessellator.addVertexWithUV(f18 + (float)k1 + 0.0f, f3 + 0.0f, f19 + (float)k, (f16 + (float)k1 + 0.5f) * f12 + f8, (f17 + (float)k) * f12 + f10);
                            tessellator.addVertexWithUV(f18 + (float)k1 + 0.0f, f3 + f2, f19 + (float)k, (f16 + (float)k1 + 0.5f) * f12 + f8, (f17 + (float)k) * f12 + f10);
                            tessellator.addVertexWithUV(f18 + (float)k1 + 0.0f, f3 + f2, f19 + 0.0f, (f16 + (float)k1 + 0.5f) * f12 + f8, (f17 + 0.0f) * f12 + f10);
                            tessellator.addVertexWithUV(f18 + (float)k1 + 0.0f, f3 + 0.0f, f19 + 0.0f, (f16 + (float)k1 + 0.5f) * f12 + f8, (f17 + 0.0f) * f12 + f10);
                        }
                    }
                    if (i1 <= 1) {
                        tessellator.setNormal(1.0f, 0.0f, 0.0f);
                        for (int l1 = 0; l1 < k; ++l1) {
                            tessellator.addVertexWithUV(f18 + (float)l1 + 1.0f - f15, f3 + 0.0f, f19 + (float)k, (f16 + (float)l1 + 0.5f) * f12 + f8, (f17 + (float)k) * f12 + f10);
                            tessellator.addVertexWithUV(f18 + (float)l1 + 1.0f - f15, f3 + f2, f19 + (float)k, (f16 + (float)l1 + 0.5f) * f12 + f8, (f17 + (float)k) * f12 + f10);
                            tessellator.addVertexWithUV(f18 + (float)l1 + 1.0f - f15, f3 + f2, f19 + 0.0f, (f16 + (float)l1 + 0.5f) * f12 + f8, (f17 + 0.0f) * f12 + f10);
                            tessellator.addVertexWithUV(f18 + (float)l1 + 1.0f - f15, f3 + 0.0f, f19 + 0.0f, (f16 + (float)l1 + 0.5f) * f12 + f8, (f17 + 0.0f) * f12 + f10);
                        }
                    }
                    tessellator.setColorRGBA_F(f4 * 0.8f, f5 * 0.8f, f6 * 0.8f, 0.8f);
                    if (j1 > -1) {
                        tessellator.setNormal(0.0f, 0.0f, -1.0f);
                        for (int i2 = 0; i2 < k; ++i2) {
                            tessellator.addVertexWithUV(f18 + 0.0f, f3 + f2, f19 + (float)i2 + 0.0f, (f16 + 0.0f) * f12 + f8, (f17 + (float)i2 + 0.5f) * f12 + f10);
                            tessellator.addVertexWithUV(f18 + (float)k, f3 + f2, f19 + (float)i2 + 0.0f, (f16 + (float)k) * f12 + f8, (f17 + (float)i2 + 0.5f) * f12 + f10);
                            tessellator.addVertexWithUV(f18 + (float)k, f3 + 0.0f, f19 + (float)i2 + 0.0f, (f16 + (float)k) * f12 + f8, (f17 + (float)i2 + 0.5f) * f12 + f10);
                            tessellator.addVertexWithUV(f18 + 0.0f, f3 + 0.0f, f19 + (float)i2 + 0.0f, (f16 + 0.0f) * f12 + f8, (f17 + (float)i2 + 0.5f) * f12 + f10);
                        }
                    }
                    if (j1 <= 1) {
                        tessellator.setNormal(0.0f, 0.0f, 1.0f);
                        for (int j2 = 0; j2 < k; ++j2) {
                            tessellator.addVertexWithUV(f18 + 0.0f, f3 + f2, f19 + (float)j2 + 1.0f - f15, (f16 + 0.0f) * f12 + f8, (f17 + (float)j2 + 0.5f) * f12 + f10);
                            tessellator.addVertexWithUV(f18 + (float)k, f3 + f2, f19 + (float)j2 + 1.0f - f15, (f16 + (float)k) * f12 + f8, (f17 + (float)j2 + 0.5f) * f12 + f10);
                            tessellator.addVertexWithUV(f18 + (float)k, f3 + 0.0f, f19 + (float)j2 + 1.0f - f15, (f16 + (float)k) * f12 + f8, (f17 + (float)j2 + 0.5f) * f12 + f10);
                            tessellator.addVertexWithUV(f18 + 0.0f, f3 + 0.0f, f19 + (float)j2 + 1.0f - f15, (f16 + 0.0f) * f12 + f8, (f17 + (float)j2 + 0.5f) * f12 + f10);
                        }
                    }
                    tessellator.draw();
                }
            }
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)2884);
    }

    public boolean updateRenderers(EntityLiving par1EntityLiving, boolean par2) {
        int j2;
        boolean flag = false;
        if (flag) {
            Collections.sort(this.worldRenderersToUpdate, new RenderSorter(par1EntityLiving));
            int i = this.worldRenderersToUpdate.size() - 1;
            int j = this.worldRenderersToUpdate.size();
            for (int k = 0; k < j; ++k) {
                WorldRenderer worldrenderer = (WorldRenderer)this.worldRenderersToUpdate.get(i - k);
                if (!par2) {
                    if (worldrenderer.distanceToEntitySquared(par1EntityLiving) > 256.0f && (worldrenderer.isInFrustum ? k >= 30 : k >= 1)) {
                        return false;
                    }
                } else if (!worldrenderer.isInFrustum) continue;
                worldrenderer.updateRenderer();
                this.worldRenderersToUpdate.remove(worldrenderer);
                worldrenderer.needsUpdate = false;
            }
            return this.worldRenderersToUpdate.size() == 0;
        }
        int byte0 = 2;
        RenderSorter rendersorter = new RenderSorter(par1EntityLiving);
        WorldRenderer[] aworldrenderer = new WorldRenderer[byte0];
        ArrayList<WorldRenderer> arraylist = null;
        int l = this.worldRenderersToUpdate.size();
        int i1 = 0;
        for (int j1 = 0; j1 < l; ++j1) {
            WorldRenderer worldrenderer1 = (WorldRenderer)this.worldRenderersToUpdate.get(j1);
            if (!par2) {
                if (worldrenderer1.distanceToEntitySquared(par1EntityLiving) > 256.0f) {
                    int k2;
                    for (k2 = 0; k2 < byte0 && (aworldrenderer[k2] == null || rendersorter.doCompare(aworldrenderer[k2], worldrenderer1) <= 0); ++k2) {
                    }
                    if (--k2 <= 0) continue;
                    int i3 = k2;
                    while (--i3 != 0) {
                        aworldrenderer[i3 - 1] = aworldrenderer[i3];
                    }
                    aworldrenderer[k2] = worldrenderer1;
                    continue;
                }
            } else if (!worldrenderer1.isInFrustum) continue;
            if (arraylist == null) {
                arraylist = new ArrayList<WorldRenderer>();
            }
            ++i1;
            arraylist.add(worldrenderer1);
            this.worldRenderersToUpdate.set(j1, null);
        }
        if (arraylist != null) {
            if (arraylist.size() > 1) {
                Collections.sort(arraylist, rendersorter);
            }
            for (int k1 = arraylist.size() - 1; k1 >= 0; --k1) {
                WorldRenderer worldrenderer2 = (WorldRenderer)arraylist.get(k1);
                worldrenderer2.updateRenderer();
                worldrenderer2.needsUpdate = false;
            }
        }
        int l1 = 0;
        for (int i2 = byte0 - 1; i2 >= 0; --i2) {
            WorldRenderer worldrenderer3 = aworldrenderer[i2];
            if (worldrenderer3 == null) continue;
            if (!worldrenderer3.isInFrustum && i2 != byte0 - 1) {
                aworldrenderer[i2] = null;
                aworldrenderer[0] = null;
                break;
            }
            aworldrenderer[i2].updateRenderer();
            aworldrenderer[i2].needsUpdate = false;
            ++l1;
        }
        int l2 = 0;
        int j3 = this.worldRenderersToUpdate.size();
        for (j2 = 0; j2 != j3; ++j2) {
            WorldRenderer worldrenderer4 = (WorldRenderer)this.worldRenderersToUpdate.get(j2);
            if (worldrenderer4 == null) continue;
            boolean flag1 = false;
            for (int k3 = 0; k3 < byte0 && !flag1; ++k3) {
                if (worldrenderer4 != aworldrenderer[k3]) continue;
                flag1 = true;
            }
            if (flag1) continue;
            if (l2 != j2) {
                this.worldRenderersToUpdate.set(l2, worldrenderer4);
            }
            ++l2;
        }
        while (--j2 >= l2) {
            this.worldRenderersToUpdate.remove(j2);
        }
        return l == i1 + l1;
    }

    public void drawBlockBreaking(EntityPlayer par1EntityPlayer, MovingObjectPosition par2MovingObjectPosition, int par3, ItemStack par4ItemStack, float par5) {
        Tessellator tessellator = Tessellator.instance;
        GL11.glEnable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glBlendFunc((int)770, (int)1);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)((MathHelper.sin((float)System.currentTimeMillis() / 100.0f) * 0.2f + 0.4f) * 0.5f));
        if (par3 == 0) {
            if (this.damagePartialTime > 0.0f) {
                GL11.glBlendFunc((int)774, (int)768);
                int i = this.renderEngine.getTexture("/terrain.png");
                GL11.glBindTexture((int)3553, (int)i);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
                GL11.glPushMatrix();
                int j = this.worldObj.getBlockId(par2MovingObjectPosition.blockX, par2MovingObjectPosition.blockY, par2MovingObjectPosition.blockZ);
                Block block = j <= 0 ? null : Block.blocksList[j];
                GL11.glDisable((int)3008);
                GL11.glPolygonOffset((float)-3.0f, (float)-3.0f);
                GL11.glEnable((int)32823);
                double d = par1EntityPlayer.lastTickPosX + (par1EntityPlayer.posX - par1EntityPlayer.lastTickPosX) * (double)par5;
                double d1 = par1EntityPlayer.lastTickPosY + (par1EntityPlayer.posY - par1EntityPlayer.lastTickPosY) * (double)par5;
                double d2 = par1EntityPlayer.lastTickPosZ + (par1EntityPlayer.posZ - par1EntityPlayer.lastTickPosZ) * (double)par5;
                if (block == null) {
                    block = Block.stone;
                }
                GL11.glEnable((int)3008);
                tessellator.startDrawingQuads();
                tessellator.setTranslation(-d, -d1, -d2);
                tessellator.disableColor();
                this.globalRenderBlocks.renderBlockUsingTexture(block, par2MovingObjectPosition.blockX, par2MovingObjectPosition.blockY, par2MovingObjectPosition.blockZ, 240 + (int)(this.damagePartialTime * 10.0f));
                tessellator.draw();
                tessellator.setTranslation(0.0, 0.0, 0.0);
                GL11.glDisable((int)3008);
                GL11.glPolygonOffset((float)0.0f, (float)0.0f);
                GL11.glDisable((int)32823);
                GL11.glEnable((int)3008);
                GL11.glDepthMask((boolean)true);
                GL11.glPopMatrix();
            }
        } else if (par4ItemStack != null) {
            GL11.glBlendFunc((int)770, (int)771);
            float f = MathHelper.sin((float)System.currentTimeMillis() / 100.0f) * 0.2f + 0.8f;
            GL11.glColor4f((float)f, (float)f, (float)f, (float)(MathHelper.sin((float)System.currentTimeMillis() / 200.0f) * 0.2f + 0.5f));
            int k = this.renderEngine.getTexture("/terrain.png");
            GL11.glBindTexture((int)3553, (int)k);
            int l = par2MovingObjectPosition.blockX;
            int i1 = par2MovingObjectPosition.blockY;
            int j1 = par2MovingObjectPosition.blockZ;
            if (par2MovingObjectPosition.sideHit == 0) {
                --i1;
            }
            if (par2MovingObjectPosition.sideHit == 1) {
                ++i1;
            }
            if (par2MovingObjectPosition.sideHit == 2) {
                --j1;
            }
            if (par2MovingObjectPosition.sideHit == 3) {
                ++j1;
            }
            if (par2MovingObjectPosition.sideHit == 4) {
                --l;
            }
            if (par2MovingObjectPosition.sideHit == 5) {
                ++l;
            }
        }
        GL11.glDisable((int)3042);
        GL11.glDisable((int)3008);
    }

    public void drawSelectionBox(EntityPlayer par1EntityPlayer, MovingObjectPosition par2MovingObjectPosition, int par3, ItemStack par4ItemStack, float par5) {
        if (par3 == 0 && par2MovingObjectPosition.typeOfHit == EnumMovingObjectType.TILE) {
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
            GL11.glLineWidth((float)2.0f);
            GL11.glDisable((int)3553);
            GL11.glDepthMask((boolean)false);
            float f = 0.002f;
            int i = this.worldObj.getBlockId(par2MovingObjectPosition.blockX, par2MovingObjectPosition.blockY, par2MovingObjectPosition.blockZ);
            if (i > 0) {
                Block.blocksList[i].setBlockBoundsBasedOnState(this.worldObj, par2MovingObjectPosition.blockX, par2MovingObjectPosition.blockY, par2MovingObjectPosition.blockZ);
                double d = par1EntityPlayer.lastTickPosX + (par1EntityPlayer.posX - par1EntityPlayer.lastTickPosX) * (double)par5;
                double d1 = par1EntityPlayer.lastTickPosY + (par1EntityPlayer.posY - par1EntityPlayer.lastTickPosY) * (double)par5;
                double d2 = par1EntityPlayer.lastTickPosZ + (par1EntityPlayer.posZ - par1EntityPlayer.lastTickPosZ) * (double)par5;
                this.drawOutlinedBoundingBox(Block.blocksList[i].getSelectedBoundingBoxFromPool(this.worldObj, par2MovingObjectPosition.blockX, par2MovingObjectPosition.blockY, par2MovingObjectPosition.blockZ).expand(f, f, f).getOffsetBoundingBox(-d, -d1, -d2));
            }
            GL11.glDepthMask((boolean)true);
            GL11.glEnable((int)3553);
            GL11.glDisable((int)3042);
        }
    }

    private void drawOutlinedBoundingBox(AxisAlignedBB par1AxisAlignedBB) {
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawing(3);
        tessellator.addVertex(par1AxisAlignedBB.minX, par1AxisAlignedBB.minY, par1AxisAlignedBB.minZ);
        tessellator.addVertex(par1AxisAlignedBB.maxX, par1AxisAlignedBB.minY, par1AxisAlignedBB.minZ);
        tessellator.addVertex(par1AxisAlignedBB.maxX, par1AxisAlignedBB.minY, par1AxisAlignedBB.maxZ);
        tessellator.addVertex(par1AxisAlignedBB.minX, par1AxisAlignedBB.minY, par1AxisAlignedBB.maxZ);
        tessellator.addVertex(par1AxisAlignedBB.minX, par1AxisAlignedBB.minY, par1AxisAlignedBB.minZ);
        tessellator.draw();
        tessellator.startDrawing(3);
        tessellator.addVertex(par1AxisAlignedBB.minX, par1AxisAlignedBB.maxY, par1AxisAlignedBB.minZ);
        tessellator.addVertex(par1AxisAlignedBB.maxX, par1AxisAlignedBB.maxY, par1AxisAlignedBB.minZ);
        tessellator.addVertex(par1AxisAlignedBB.maxX, par1AxisAlignedBB.maxY, par1AxisAlignedBB.maxZ);
        tessellator.addVertex(par1AxisAlignedBB.minX, par1AxisAlignedBB.maxY, par1AxisAlignedBB.maxZ);
        tessellator.addVertex(par1AxisAlignedBB.minX, par1AxisAlignedBB.maxY, par1AxisAlignedBB.minZ);
        tessellator.draw();
        tessellator.startDrawing(1);
        tessellator.addVertex(par1AxisAlignedBB.minX, par1AxisAlignedBB.minY, par1AxisAlignedBB.minZ);
        tessellator.addVertex(par1AxisAlignedBB.minX, par1AxisAlignedBB.maxY, par1AxisAlignedBB.minZ);
        tessellator.addVertex(par1AxisAlignedBB.maxX, par1AxisAlignedBB.minY, par1AxisAlignedBB.minZ);
        tessellator.addVertex(par1AxisAlignedBB.maxX, par1AxisAlignedBB.maxY, par1AxisAlignedBB.minZ);
        tessellator.addVertex(par1AxisAlignedBB.maxX, par1AxisAlignedBB.minY, par1AxisAlignedBB.maxZ);
        tessellator.addVertex(par1AxisAlignedBB.maxX, par1AxisAlignedBB.maxY, par1AxisAlignedBB.maxZ);
        tessellator.addVertex(par1AxisAlignedBB.minX, par1AxisAlignedBB.minY, par1AxisAlignedBB.maxZ);
        tessellator.addVertex(par1AxisAlignedBB.minX, par1AxisAlignedBB.maxY, par1AxisAlignedBB.maxZ);
        tessellator.draw();
    }

    public void markBlocksForUpdate(int par1, int par2, int par3, int par4, int par5, int par6) {
        int i = MathHelper.bucketInt(par1, 16);
        int j = MathHelper.bucketInt(par2, 16);
        int k = MathHelper.bucketInt(par3, 16);
        int l = MathHelper.bucketInt(par4, 16);
        int i1 = MathHelper.bucketInt(par5, 16);
        int j1 = MathHelper.bucketInt(par6, 16);
        for (int k1 = i; k1 <= l; ++k1) {
            int l1 = k1 % this.renderChunksWide;
            if (l1 < 0) {
                l1 += this.renderChunksWide;
            }
            for (int i2 = j; i2 <= i1; ++i2) {
                int j2 = i2 % this.renderChunksTall;
                if (j2 < 0) {
                    j2 += this.renderChunksTall;
                }
                for (int k2 = k; k2 <= j1; ++k2) {
                    int l2 = k2 % this.renderChunksDeep;
                    if (l2 < 0) {
                        l2 += this.renderChunksDeep;
                    }
                    int i3 = (l2 * this.renderChunksTall + j2) * this.renderChunksWide + l1;
                    WorldRenderer worldrenderer = this.worldRenderers[i3];
                    if (worldrenderer.needsUpdate) continue;
                    this.worldRenderersToUpdate.add(worldrenderer);
                    worldrenderer.markDirty();
                }
            }
        }
    }

    @Override
    public void markBlockNeedsUpdate(int par1, int par2, int par3) {
        this.markBlocksForUpdate(par1 - 1, par2 - 1, par3 - 1, par1 + 1, par2 + 1, par3 + 1);
    }

    @Override
    public void markBlockNeedsUpdate2(int par1, int par2, int par3) {
        this.markBlocksForUpdate(par1 - 1, par2 - 1, par3 - 1, par1 + 1, par2 + 1, par3 + 1);
    }

    @Override
    public void markBlockRangeNeedsUpdate(int par1, int par2, int par3, int par4, int par5, int par6) {
        this.markBlocksForUpdate(par1 - 1, par2 - 1, par3 - 1, par4 + 1, par5 + 1, par6 + 1);
    }

    public void clipRenderersByFrustum(ICamera par1ICamera, float par2) {
        for (int i = 0; i < this.worldRenderers.length; ++i) {
            if (this.worldRenderers[i].skipAllRenderPasses() || this.worldRenderers[i].isInFrustum && (i + this.frustumCheckOffset & 0xF) != 0) continue;
            this.worldRenderers[i].updateInFrustum(par1ICamera);
        }
        ++this.frustumCheckOffset;
    }

    @Override
    public void playRecord(String par1Str, int par2, int par3, int par4) {
        if (par1Str != null) {
            this.mc.ingameGUI.setRecordPlayingMessage("C418 - " + par1Str);
        }
        this.mc.sndManager.playStreaming(par1Str, par2, par3, par4, 1.0f, 1.0f);
    }

    @Override
    public void playSound(String par1Str, double par2, double par4, double par6, float par8, float par9) {
        float f = 16.0f;
        if (par8 > 1.0f) {
            f *= par8;
        }
        if (this.mc.renderViewEntity.getDistanceSq(par2, par4, par6) < (double)(f * f)) {
            this.mc.sndManager.playSound(par1Str, (float)par2, (float)par4, (float)par6, par8, par9);
        }
    }

    @Override
    public void spawnParticle(String par1Str, double par2, double par4, double par6, double par8, double par10, double par12) {
        this.func_40193_b(par1Str, par2, par4, par6, par8, par10, par12);
    }

    public EntityFX func_40193_b(String par1Str, double par2, double par4, double par6, double par8, double par10, double par12) {
        if (this.mc == null || this.mc.renderViewEntity == null || this.mc.effectRenderer == null) {
            return null;
        }
        int i = this.mc.gameSettings.particleSetting;
        if (i == 1 && this.worldObj.rand.nextInt(3) == 0) {
            i = 2;
        }
        double d = this.mc.renderViewEntity.posX - par2;
        double d1 = this.mc.renderViewEntity.posY - par4;
        double d2 = this.mc.renderViewEntity.posZ - par6;
        EntityFX obj = null;
        if (par1Str.equals("hugeexplosion")) {
            obj = new EntityHugeExplodeFX(this.worldObj, par2, par4, par6, par8, par10, par12);
            this.mc.effectRenderer.addEffect(obj);
        } else if (par1Str.equals("largeexplode")) {
            obj = new EntityLargeExplodeFX(this.renderEngine, this.worldObj, par2, par4, par6, par8, par10, par12);
            this.mc.effectRenderer.addEffect(obj);
        }
        if (obj != null) {
            return obj;
        }
        double d3 = 16.0;
        if (d * d + d1 * d1 + d2 * d2 > d3 * d3) {
            return null;
        }
        if (i > 1) {
            return null;
        }
        if (par1Str.equals("bubble")) {
            obj = new EntityBubbleFX(this.worldObj, par2, par4, par6, par8, par10, par12);
        } else if (par1Str.equals("suspended")) {
            obj = new EntitySuspendFX(this.worldObj, par2, par4, par6, par8, par10, par12);
        } else if (par1Str.equals("depthsuspend")) {
            obj = new EntityAuraFX(this.worldObj, par2, par4, par6, par8, par10, par12);
        } else if (par1Str.equals("townaura")) {
            obj = new EntityAuraFX(this.worldObj, par2, par4, par6, par8, par10, par12);
        } else if (par1Str.equals("crit")) {
            obj = new EntityCritFX(this.worldObj, par2, par4, par6, par8, par10, par12);
        } else if (par1Str.equals("magicCrit")) {
            obj = new EntityCritFX(this.worldObj, par2, par4, par6, par8, par10, par12);
            ((EntityFX)obj).func_40097_b(((EntityFX)obj).func_40098_n() * 0.3f, ((EntityFX)obj).func_40101_o() * 0.8f, ((EntityFX)obj).func_40102_p());
            ((EntityFX)obj).setParticleTextureIndex(((EntityFX)obj).getParticleTextureIndex() + 1);
        } else if (par1Str.equals("smoke")) {
            obj = new EntitySmokeFX(this.worldObj, par2, par4, par6, par8, par10, par12);
        } else if (par1Str.equals("mobSpell")) {
            obj = new EntitySpellParticleFX(this.worldObj, par2, par4, par6, 0.0, 0.0, 0.0);
            ((EntityFX)obj).func_40097_b((float)par8, (float)par10, (float)par12);
        } else if (par1Str.equals("spell")) {
            obj = new EntitySpellParticleFX(this.worldObj, par2, par4, par6, par8, par10, par12);
        } else if (par1Str.equals("instantSpell")) {
            obj = new EntitySpellParticleFX(this.worldObj, par2, par4, par6, par8, par10, par12);
            ((EntitySpellParticleFX)obj).func_40110_b(144);
        } else if (par1Str.equals("note")) {
            obj = new EntityNoteFX(this.worldObj, par2, par4, par6, par8, par10, par12);
        } else if (par1Str.equals("portal")) {
            obj = new EntityPortalFX(this.worldObj, par2, par4, par6, par8, par10, par12);
        } else if (par1Str.equals("enchantmenttable")) {
            obj = new EntityEnchantmentTableParticleFX(this.worldObj, par2, par4, par6, par8, par10, par12);
        } else if (par1Str.equals("explode")) {
            obj = new EntityExplodeFX(this.worldObj, par2, par4, par6, par8, par10, par12);
        } else if (par1Str.equals("flame")) {
            obj = new EntityFlameFX(this.worldObj, par2, par4, par6, par8, par10, par12);
        } else if (par1Str.equals("lava")) {
            obj = new EntityLavaFX(this.worldObj, par2, par4, par6);
        } else if (par1Str.equals("footstep")) {
            obj = new EntityFootStepFX(this.renderEngine, this.worldObj, par2, par4, par6);
        } else if (par1Str.equals("splash")) {
            obj = new EntitySplashFX(this.worldObj, par2, par4, par6, par8, par10, par12);
        } else if (par1Str.equals("largesmoke")) {
            obj = new EntitySmokeFX(this.worldObj, par2, par4, par6, par8, par10, par12, 2.5f);
        } else if (par1Str.equals("cloud")) {
            obj = new EntityCloudFX(this.worldObj, par2, par4, par6, par8, par10, par12);
        } else if (par1Str.equals("reddust")) {
            obj = new EntityReddustFX(this.worldObj, par2, par4, par6, (float)par8, (float)par10, (float)par12);
        } else if (par1Str.equals("snowballpoof")) {
            obj = new EntityBreakingFX(this.worldObj, par2, par4, par6, Item.snowball);
        } else if (par1Str.equals("dripWater")) {
            obj = new EntityDropParticleFX(this.worldObj, par2, par4, par6, Material.water);
        } else if (par1Str.equals("dripLava")) {
            obj = new EntityDropParticleFX(this.worldObj, par2, par4, par6, Material.lava);
        } else if (par1Str.equals("snowshovel")) {
            obj = new EntitySnowShovelFX(this.worldObj, par2, par4, par6, par8, par10, par12);
        } else if (par1Str.equals("slime")) {
            obj = new EntityBreakingFX(this.worldObj, par2, par4, par6, Item.slimeBall);
        } else if (par1Str.equals("heart")) {
            obj = new EntityHeartFX(this.worldObj, par2, par4, par6, par8, par10, par12);
        } else if (par1Str.startsWith("iconcrack_")) {
            int j = Integer.parseInt(par1Str.substring(par1Str.indexOf("_") + 1));
            obj = new EntityBreakingFX(this.worldObj, par2, par4, par6, par8, par10, par12, Item.itemsList[j]);
        } else if (par1Str.startsWith("tilecrack_")) {
            int k = Integer.parseInt(par1Str.substring(par1Str.indexOf("_") + 1));
            obj = new EntityDiggingFX(this.worldObj, par2, par4, par6, par8, par10, par12, Block.blocksList[k], 0, 0);
        }
        if (obj != null) {
            this.mc.effectRenderer.addEffect(obj);
        }
        return obj;
    }

    @Override
    public void obtainEntitySkin(Entity par1Entity) {
        par1Entity.updateCloak();
        if (par1Entity.skinUrl != null) {
            this.renderEngine.obtainImageData(par1Entity.skinUrl, new ImageBufferDownload());
        }
        if (par1Entity.cloakUrl != null) {
            this.renderEngine.obtainImageData(par1Entity.cloakUrl, new ImageBufferDownload());
        }
    }

    @Override
    public void releaseEntitySkin(Entity par1Entity) {
        if (par1Entity.skinUrl != null) {
            this.renderEngine.releaseImageData(par1Entity.skinUrl);
        }
        if (par1Entity.cloakUrl != null) {
            this.renderEngine.releaseImageData(par1Entity.cloakUrl);
        }
    }

    @Override
    public void doNothingWithTileEntity(int i, int j, int k, TileEntity tileentity) {
    }

    public void func_28137_f() {
        GLAllocation.deleteDisplayLists(this.glRenderListBase);
    }

    @Override
    public void playAuxSFX(EntityPlayer par1EntityPlayer, int par2, int par3, int par4, int par5, int par6) {
        Random random = this.worldObj.rand;
        switch (par2) {
            default: {
                break;
            }
            case 1001: {
                this.worldObj.playSoundEffect(par3, par4, par5, "random.click", 1.0f, 1.2f);
                break;
            }
            case 1000: {
                this.worldObj.playSoundEffect(par3, par4, par5, "random.click", 1.0f, 1.0f);
                break;
            }
            case 1002: {
                this.worldObj.playSoundEffect(par3, par4, par5, "random.bow", 1.0f, 1.2f);
                break;
            }
            case 2000: {
                int i = par6 % 3 - 1;
                int l = par6 / 3 % 3 - 1;
                double d3 = (double)par3 + (double)i * 0.6 + 0.5;
                double d7 = (double)par4 + 0.5;
                double d11 = (double)par5 + (double)l * 0.6 + 0.5;
                for (int l1 = 0; l1 < 10; ++l1) {
                    double d13 = random.nextDouble() * 0.2 + 0.01;
                    double d14 = d3 + (double)i * 0.01 + (random.nextDouble() - 0.5) * (double)l * 0.5;
                    double d15 = d7 + (random.nextDouble() - 0.5) * 0.5;
                    double d17 = d11 + (double)l * 0.01 + (random.nextDouble() - 0.5) * (double)i * 0.5;
                    double d19 = (double)i * d13 + random.nextGaussian() * 0.01;
                    double d21 = -0.03 + random.nextGaussian() * 0.01;
                    double d23 = (double)l * d13 + random.nextGaussian() * 0.01;
                    this.spawnParticle("smoke", d14, d15, d17, d19, d21, d23);
                }
                break;
            }
            case 2003: {
                double d = (double)par3 + 0.5;
                double d4 = par4;
                double d8 = (double)par5 + 0.5;
                String s = "iconcrack_" + Item.eyeOfEnder.shiftedIndex;
                for (int i1 = 0; i1 < 8; ++i1) {
                    this.spawnParticle(s, d, d4, d8, random.nextGaussian() * 0.15, random.nextDouble() * 0.2, random.nextGaussian() * 0.15);
                }
                for (double d12 = 0.0; d12 < Math.PI * 2; d12 += 0.15707963267948966) {
                    this.spawnParticle("portal", d + Math.cos(d12) * 5.0, d4 - 0.4, d8 + Math.sin(d12) * 5.0, Math.cos(d12) * -5.0, 0.0, Math.sin(d12) * -5.0);
                    this.spawnParticle("portal", d + Math.cos(d12) * 5.0, d4 - 0.4, d8 + Math.sin(d12) * 5.0, Math.cos(d12) * -7.0, 0.0, Math.sin(d12) * -7.0);
                }
                break;
            }
            case 2002: {
                double d1 = par3;
                double d5 = par4;
                double d9 = par5;
                String s1 = "iconcrack_" + Item.potion.shiftedIndex;
                for (int j1 = 0; j1 < 8; ++j1) {
                    this.spawnParticle(s1, d1, d5, d9, random.nextGaussian() * 0.15, random.nextDouble() * 0.2, random.nextGaussian() * 0.15);
                }
                int k1 = Item.potion.getColorFromDamage(par6, 0);
                float f = (float)(k1 >> 16 & 0xFF) / 255.0f;
                float f1 = (float)(k1 >> 8 & 0xFF) / 255.0f;
                float f2 = (float)(k1 >> 0 & 0xFF) / 255.0f;
                String s2 = "spell";
                if (Item.potion.isEffectInstant(par6)) {
                    s2 = "instantSpell";
                }
                for (int i2 = 0; i2 < 100; ++i2) {
                    double d16 = random.nextDouble() * 4.0;
                    double d18 = random.nextDouble() * Math.PI * 2.0;
                    double d20 = Math.cos(d18) * d16;
                    double d22 = 0.01 + random.nextDouble() * 0.5;
                    double d24 = Math.sin(d18) * d16;
                    EntityFX entityfx = this.func_40193_b(s2, d1 + d20 * 0.1, d5 + 0.3, d9 + d24 * 0.1, d20, d22, d24);
                    if (entityfx == null) continue;
                    float f3 = 0.75f + random.nextFloat() * 0.25f;
                    entityfx.func_40097_b(f * f3, f1 * f3, f2 * f3);
                    entityfx.multiplyVelocity((float)d16);
                }
                this.worldObj.playSoundEffect((double)par3 + 0.5, (double)par4 + 0.5, (double)par5 + 0.5, "random.glass", 1.0f, this.worldObj.rand.nextFloat() * 0.1f + 0.9f);
                break;
            }
            case 2001: {
                int j = par6 & 0xFFF;
                if (j > 0) {
                    Block block = Block.blocksList[j];
                    this.mc.sndManager.playSound(block.stepSound.getBreakSound(), (float)par3 + 0.5f, (float)par4 + 0.5f, (float)par5 + 0.5f, (block.stepSound.getVolume() + 1.0f) / 2.0f, block.stepSound.getPitch() * 0.8f);
                }
                this.mc.effectRenderer.addBlockDestroyEffects(par3, par4, par5, par6 & 0xFFF, par6 >> 12 & 0xFF);
                break;
            }
            case 2004: {
                for (int k = 0; k < 20; ++k) {
                    double d2 = (double)par3 + 0.5 + ((double)this.worldObj.rand.nextFloat() - 0.5) * 2.0;
                    double d6 = (double)par4 + 0.5 + ((double)this.worldObj.rand.nextFloat() - 0.5) * 2.0;
                    double d10 = (double)par5 + 0.5 + ((double)this.worldObj.rand.nextFloat() - 0.5) * 2.0;
                    this.worldObj.spawnParticle("smoke", d2, d6, d10, 0.0, 0.0, 0.0);
                    this.worldObj.spawnParticle("flame", d2, d6, d10, 0.0, 0.0, 0.0);
                }
                break;
            }
            case 1003: {
                if (Math.random() < 0.5) {
                    this.worldObj.playSoundEffect((double)par3 + 0.5, (double)par4 + 0.5, (double)par5 + 0.5, "random.door_open", 1.0f, this.worldObj.rand.nextFloat() * 0.1f + 0.9f);
                    break;
                }
                this.worldObj.playSoundEffect((double)par3 + 0.5, (double)par4 + 0.5, (double)par5 + 0.5, "random.door_close", 1.0f, this.worldObj.rand.nextFloat() * 0.1f + 0.9f);
                break;
            }
            case 1004: {
                this.worldObj.playSoundEffect((float)par3 + 0.5f, (float)par4 + 0.5f, (float)par5 + 0.5f, "random.fizz", 0.5f, 2.6f + (random.nextFloat() - random.nextFloat()) * 0.8f);
                break;
            }
            case 1005: {
                if (Item.itemsList[par6] instanceof ItemRecord) {
                    this.worldObj.playRecord(((ItemRecord)Item.itemsList[par6]).recordName, par3, par4, par5);
                    break;
                }
                this.worldObj.playRecord(null, par3, par4, par5);
                break;
            }
            case 1007: {
                this.worldObj.playSoundEffect((double)par3 + 0.5, (double)par4 + 0.5, (double)par5 + 0.5, "mob.ghast.charge", 10.0f, (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f);
                break;
            }
            case 1008: {
                this.worldObj.playSoundEffect((double)par3 + 0.5, (double)par4 + 0.5, (double)par5 + 0.5, "mob.ghast.fireball", 10.0f, (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f);
                break;
            }
            case 1010: {
                this.worldObj.playSoundEffect((double)par3 + 0.5, (double)par4 + 0.5, (double)par5 + 0.5, "mob.zombie.wood", 2.0f, (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f);
                break;
            }
            case 1012: {
                this.worldObj.playSoundEffect((double)par3 + 0.5, (double)par4 + 0.5, (double)par5 + 0.5, "mob.zombie.woodbreak", 2.0f, (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f);
                break;
            }
            case 1011: {
                this.worldObj.playSoundEffect((double)par3 + 0.5, (double)par4 + 0.5, (double)par5 + 0.5, "mob.zombie.metal", 2.0f, (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f);
            }
        }
    }
}

