/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import net.minecraft.src.GLAllocation;
import net.minecraft.src.GameSettings;
import net.minecraft.src.ImageBuffer;
import net.minecraft.src.IntHashMap;
import net.minecraft.src.TextureFX;
import net.minecraft.src.TexturePackBase;
import net.minecraft.src.TexturePackList;
import net.minecraft.src.ThreadDownloadImageData;
import org.lwjgl.opengl.GL11;

public class RenderEngine {
    public static boolean useMipmaps = false;
    private HashMap textureMap = new HashMap();
    private HashMap textureContentsMap = new HashMap();
    private IntHashMap textureNameToImageMap = new IntHashMap();
    private IntBuffer singleIntBuffer = GLAllocation.createDirectIntBuffer(1);
    private ByteBuffer imageData = GLAllocation.createDirectByteBuffer(0x1000000);
    private List textureList = new ArrayList();
    private Map urlToImageDataMap = new HashMap();
    private GameSettings options;
    public boolean clampTexture = false;
    public boolean blurTexture = false;
    private TexturePackList texturePack;
    private BufferedImage missingTextureImage = new BufferedImage(64, 64, 2);
    private int field_48512_n = 16;

    public RenderEngine(TexturePackList par1TexturePackList, GameSettings par2GameSettings) {
        this.texturePack = par1TexturePackList;
        this.options = par2GameSettings;
        Graphics g = this.missingTextureImage.getGraphics();
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, 64, 64);
        g.setColor(Color.BLACK);
        g.drawString("missingtex", 1, 10);
        g.dispose();
    }

    public int[] getTextureContents(String par1Str) {
        TexturePackBase texturepackbase = this.texturePack.selectedTexturePack;
        int[] ai = (int[])this.textureContentsMap.get(par1Str);
        if (ai != null) {
            return ai;
        }
        try {
            int[] ai1 = null;
            if (par1Str.startsWith("##")) {
                ai1 = this.getImageContentsAndAllocate(this.unwrapImageByColumns(this.readTextureImage(texturepackbase.getResourceAsStream(par1Str.substring(2)))));
            } else if (par1Str.startsWith("%clamp%")) {
                this.clampTexture = true;
                ai1 = this.getImageContentsAndAllocate(this.readTextureImage(texturepackbase.getResourceAsStream(par1Str.substring(7))));
                this.clampTexture = false;
            } else if (par1Str.startsWith("%blur%")) {
                this.blurTexture = true;
                this.clampTexture = true;
                ai1 = this.getImageContentsAndAllocate(this.readTextureImage(texturepackbase.getResourceAsStream(par1Str.substring(6))));
                this.clampTexture = false;
                this.blurTexture = false;
            } else {
                InputStream inputstream = texturepackbase.getResourceAsStream(par1Str);
                ai1 = inputstream == null ? this.getImageContentsAndAllocate(this.missingTextureImage) : this.getImageContentsAndAllocate(this.readTextureImage(inputstream));
            }
            this.textureContentsMap.put(par1Str, ai1);
            return ai1;
        }
        catch (IOException ioexception) {
            ioexception.printStackTrace();
            int[] ai2 = this.getImageContentsAndAllocate(this.missingTextureImage);
            this.textureContentsMap.put(par1Str, ai2);
            return ai2;
        }
    }

    private int[] getImageContentsAndAllocate(BufferedImage par1BufferedImage) {
        int i = par1BufferedImage.getWidth();
        int j = par1BufferedImage.getHeight();
        int[] ai = new int[i * j];
        par1BufferedImage.getRGB(0, 0, i, j, ai, 0, i);
        return ai;
    }

    private int[] getImageContents(BufferedImage par1BufferedImage, int[] par2ArrayOfInteger) {
        int i = par1BufferedImage.getWidth();
        int j = par1BufferedImage.getHeight();
        par1BufferedImage.getRGB(0, 0, i, j, par2ArrayOfInteger, 0, i);
        return par2ArrayOfInteger;
    }

    public int getTexture(String par1Str) {
        TexturePackBase texturepackbase = this.texturePack.selectedTexturePack;
        Integer integer = (Integer)this.textureMap.get(par1Str);
        if (integer != null) {
            return integer;
        }
        try {
            this.singleIntBuffer.clear();
            GLAllocation.generateTextureNames(this.singleIntBuffer);
            int i = this.singleIntBuffer.get(0);
            if (par1Str.startsWith("##")) {
                this.setupTexture(this.unwrapImageByColumns(this.readTextureImage(texturepackbase.getResourceAsStream(par1Str.substring(2)))), i);
            } else if (par1Str.startsWith("%clamp%")) {
                this.clampTexture = true;
                this.setupTexture(this.readTextureImage(texturepackbase.getResourceAsStream(par1Str.substring(7))), i);
                this.clampTexture = false;
            } else if (par1Str.startsWith("%blur%")) {
                this.blurTexture = true;
                this.setupTexture(this.readTextureImage(texturepackbase.getResourceAsStream(par1Str.substring(6))), i);
                this.blurTexture = false;
            } else if (par1Str.startsWith("%blurclamp%")) {
                this.blurTexture = true;
                this.clampTexture = true;
                this.setupTexture(this.readTextureImage(texturepackbase.getResourceAsStream(par1Str.substring(11))), i);
                this.blurTexture = false;
                this.clampTexture = false;
            } else {
                InputStream inputstream = texturepackbase.getResourceAsStream(par1Str);
                if (inputstream == null) {
                    this.setupTexture(this.missingTextureImage, i);
                } else {
                    this.setupTexture(this.readTextureImage(inputstream), i);
                }
            }
            this.textureMap.put(par1Str, i);
            return i;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            GLAllocation.generateTextureNames(this.singleIntBuffer);
            int j = this.singleIntBuffer.get(0);
            this.setupTexture(this.missingTextureImage, j);
            this.textureMap.put(par1Str, j);
            return j;
        }
    }

    private BufferedImage unwrapImageByColumns(BufferedImage par1BufferedImage) {
        int i = par1BufferedImage.getWidth() / 16;
        BufferedImage bufferedimage = new BufferedImage(16, par1BufferedImage.getHeight() * i, 2);
        Graphics g = bufferedimage.getGraphics();
        for (int j = 0; j < i; ++j) {
            g.drawImage(par1BufferedImage, -j * 16, j * par1BufferedImage.getHeight(), null);
        }
        g.dispose();
        return bufferedimage;
    }

    public int allocateAndSetupTexture(BufferedImage par1BufferedImage) {
        this.singleIntBuffer.clear();
        GLAllocation.generateTextureNames(this.singleIntBuffer);
        int i = this.singleIntBuffer.get(0);
        this.setupTexture(par1BufferedImage, i);
        this.textureNameToImageMap.addKey(i, par1BufferedImage);
        return i;
    }

    public void setupTexture(BufferedImage par1BufferedImage, int par2) {
        GL11.glBindTexture((int)3553, (int)par2);
        if (useMipmaps) {
            GL11.glTexParameteri((int)3553, (int)10241, (int)9986);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        } else {
            GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        }
        if (this.blurTexture) {
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        }
        if (this.clampTexture) {
            GL11.glTexParameteri((int)3553, (int)10242, (int)10496);
            GL11.glTexParameteri((int)3553, (int)10243, (int)10496);
        } else {
            GL11.glTexParameteri((int)3553, (int)10242, (int)10497);
            GL11.glTexParameteri((int)3553, (int)10243, (int)10497);
        }
        int i = par1BufferedImage.getWidth();
        int j = par1BufferedImage.getHeight();
        int[] ai = new int[i * j];
        byte[] abyte0 = new byte[i * j * 4];
        par1BufferedImage.getRGB(0, 0, i, j, ai, 0, i);
        for (int k = 0; k < ai.length; ++k) {
            int i1 = ai[k] >> 24 & 0xFF;
            int k1 = ai[k] >> 16 & 0xFF;
            int i2 = ai[k] >> 8 & 0xFF;
            int k2 = ai[k] & 0xFF;
            if (this.options != null && this.options.anaglyph) {
                int i3 = (k1 * 30 + i2 * 59 + k2 * 11) / 100;
                int k3 = (k1 * 30 + i2 * 70) / 100;
                int i4 = (k1 * 30 + k2 * 70) / 100;
                k1 = i3;
                i2 = k3;
                k2 = i4;
            }
            abyte0[k * 4 + 0] = (byte)k1;
            abyte0[k * 4 + 1] = (byte)i2;
            abyte0[k * 4 + 2] = (byte)k2;
            abyte0[k * 4 + 3] = (byte)i1;
        }
        this.imageData.clear();
        this.imageData.put(abyte0);
        this.imageData.position(0).limit(abyte0.length);
        GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)i, (int)j, (int)0, (int)6408, (int)5121, (ByteBuffer)this.imageData);
        if (useMipmaps) {
            for (int l = 1; l <= 4; ++l) {
                int j1 = i >> l - 1;
                int l1 = i >> l;
                int j2 = j >> l;
                for (int l2 = 0; l2 < l1; ++l2) {
                    for (int j3 = 0; j3 < j2; ++j3) {
                        int l3 = this.imageData.getInt((l2 * 2 + 0 + (j3 * 2 + 0) * j1) * 4);
                        int j4 = this.imageData.getInt((l2 * 2 + 1 + (j3 * 2 + 0) * j1) * 4);
                        int k4 = this.imageData.getInt((l2 * 2 + 1 + (j3 * 2 + 1) * j1) * 4);
                        int l4 = this.imageData.getInt((l2 * 2 + 0 + (j3 * 2 + 1) * j1) * 4);
                        int i5 = this.alphaBlend(this.alphaBlend(l3, j4), this.alphaBlend(k4, l4));
                        this.imageData.putInt((l2 + j3 * l1) * 4, i5);
                    }
                }
                GL11.glTexImage2D((int)3553, (int)l, (int)6408, (int)l1, (int)j2, (int)0, (int)6408, (int)5121, (ByteBuffer)this.imageData);
            }
        }
    }

    public void createTextureFromBytes(int[] par1ArrayOfInteger, int par2, int par3, int par4) {
        GL11.glBindTexture((int)3553, (int)par4);
        if (useMipmaps) {
            GL11.glTexParameteri((int)3553, (int)10241, (int)9986);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        } else {
            GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        }
        if (this.blurTexture) {
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        }
        if (this.clampTexture) {
            GL11.glTexParameteri((int)3553, (int)10242, (int)10496);
            GL11.glTexParameteri((int)3553, (int)10243, (int)10496);
        } else {
            GL11.glTexParameteri((int)3553, (int)10242, (int)10497);
            GL11.glTexParameteri((int)3553, (int)10243, (int)10497);
        }
        byte[] abyte0 = new byte[par2 * par3 * 4];
        for (int i = 0; i < par1ArrayOfInteger.length; ++i) {
            int j = par1ArrayOfInteger[i] >> 24 & 0xFF;
            int k = par1ArrayOfInteger[i] >> 16 & 0xFF;
            int l = par1ArrayOfInteger[i] >> 8 & 0xFF;
            int i1 = par1ArrayOfInteger[i] & 0xFF;
            if (this.options != null && this.options.anaglyph) {
                int j1 = (k * 30 + l * 59 + i1 * 11) / 100;
                int k1 = (k * 30 + l * 70) / 100;
                int l1 = (k * 30 + i1 * 70) / 100;
                k = j1;
                l = k1;
                i1 = l1;
            }
            abyte0[i * 4 + 0] = (byte)k;
            abyte0[i * 4 + 1] = (byte)l;
            abyte0[i * 4 + 2] = (byte)i1;
            abyte0[i * 4 + 3] = (byte)j;
        }
        this.imageData.clear();
        this.imageData.put(abyte0);
        this.imageData.position(0).limit(abyte0.length);
        GL11.glTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)par2, (int)par3, (int)6408, (int)5121, (ByteBuffer)this.imageData);
    }

    public void deleteTexture(int par1) {
        this.textureNameToImageMap.removeObject(par1);
        this.singleIntBuffer.clear();
        this.singleIntBuffer.put(par1);
        this.singleIntBuffer.flip();
        GL11.glDeleteTextures((IntBuffer)this.singleIntBuffer);
    }

    public int getTextureForDownloadableImage(String par1Str, String par2Str) {
        ThreadDownloadImageData threaddownloadimagedata = (ThreadDownloadImageData)this.urlToImageDataMap.get(par1Str);
        if (threaddownloadimagedata != null && threaddownloadimagedata.image != null && !threaddownloadimagedata.textureSetupComplete) {
            if (threaddownloadimagedata.textureName < 0) {
                threaddownloadimagedata.textureName = this.allocateAndSetupTexture(threaddownloadimagedata.image);
            } else {
                this.setupTexture(threaddownloadimagedata.image, threaddownloadimagedata.textureName);
            }
            threaddownloadimagedata.textureSetupComplete = true;
        }
        if (threaddownloadimagedata == null || threaddownloadimagedata.textureName < 0) {
            if (par2Str == null) {
                return -1;
            }
            return this.getTexture(par2Str);
        }
        return threaddownloadimagedata.textureName;
    }

    public ThreadDownloadImageData obtainImageData(String par1Str, ImageBuffer par2ImageBuffer) {
        ThreadDownloadImageData threaddownloadimagedata = (ThreadDownloadImageData)this.urlToImageDataMap.get(par1Str);
        if (threaddownloadimagedata == null) {
            this.urlToImageDataMap.put(par1Str, new ThreadDownloadImageData(par1Str, par2ImageBuffer));
        } else {
            ++threaddownloadimagedata.referenceCount;
        }
        return threaddownloadimagedata;
    }

    public void releaseImageData(String par1Str) {
        ThreadDownloadImageData threaddownloadimagedata = (ThreadDownloadImageData)this.urlToImageDataMap.get(par1Str);
        if (threaddownloadimagedata != null) {
            --threaddownloadimagedata.referenceCount;
            if (threaddownloadimagedata.referenceCount == 0) {
                if (threaddownloadimagedata.textureName >= 0) {
                    this.deleteTexture(threaddownloadimagedata.textureName);
                }
                this.urlToImageDataMap.remove(par1Str);
            }
        }
    }

    public void registerTextureFX(TextureFX par1TextureFX) {
        this.textureList.add(par1TextureFX);
        par1TextureFX.onTick();
    }

    public void updateDynamicTextures() {
        int i = -1;
        for (int j = 0; j < this.textureList.size(); ++j) {
            TextureFX texturefx = (TextureFX)this.textureList.get(j);
            texturefx.anaglyphEnabled = this.options.anaglyph;
            texturefx.onTick();
            this.imageData.clear();
            this.imageData.put(texturefx.imageData);
            this.imageData.position(0).limit(texturefx.imageData.length);
            if (texturefx.iconIndex != i) {
                texturefx.bindImage(this);
                i = texturefx.iconIndex;
            }
            for (int k = 0; k < texturefx.tileSize; ++k) {
                for (int l = 0; l < texturefx.tileSize; ++l) {
                    GL11.glTexSubImage2D((int)3553, (int)0, (int)(texturefx.iconIndex % 16 * 16 + k * 16), (int)(texturefx.iconIndex / 16 * 16 + l * 16), (int)16, (int)16, (int)6408, (int)5121, (ByteBuffer)this.imageData);
                }
            }
        }
    }

    private int alphaBlend(int par1, int par2) {
        int i = (par1 & 0xFF000000) >> 24 & 0xFF;
        int j = (par2 & 0xFF000000) >> 24 & 0xFF;
        int c = 255;
        if (i + j < 255) {
            c = 0;
            i = 1;
            j = 1;
        } else if (i > j) {
            i = 255;
            j = 1;
        } else {
            i = 1;
            j = 255;
        }
        int k = (par1 >> 16 & 0xFF) * i;
        int l = (par1 >> 8 & 0xFF) * i;
        int i1 = (par1 & 0xFF) * i;
        int j1 = (par2 >> 16 & 0xFF) * j;
        int k1 = (par2 >> 8 & 0xFF) * j;
        int l1 = (par2 & 0xFF) * j;
        int i2 = (k + j1) / (i + j);
        int j2 = (l + k1) / (i + j);
        int k2 = (i1 + l1) / (i + j);
        return c << 24 | i2 << 16 | j2 << 8 | k2;
    }

    public void refreshTextures() {
        TexturePackBase texturepackbase = this.texturePack.selectedTexturePack;
        Iterator iterator = this.textureNameToImageMap.getKeySet().iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            BufferedImage bufferedimage = (BufferedImage)this.textureNameToImageMap.lookup(i);
            this.setupTexture(bufferedimage, i);
        }
        for (ThreadDownloadImageData threaddownloadimagedata : this.urlToImageDataMap.values()) {
            threaddownloadimagedata.textureSetupComplete = false;
        }
        for (String s : this.textureMap.keySet()) {
            try {
                BufferedImage bufferedimage1;
                if (s.startsWith("##")) {
                    bufferedimage1 = this.unwrapImageByColumns(this.readTextureImage(texturepackbase.getResourceAsStream(s.substring(2))));
                } else if (s.startsWith("%clamp%")) {
                    this.clampTexture = true;
                    bufferedimage1 = this.readTextureImage(texturepackbase.getResourceAsStream(s.substring(7)));
                } else if (s.startsWith("%blur%")) {
                    this.blurTexture = true;
                    bufferedimage1 = this.readTextureImage(texturepackbase.getResourceAsStream(s.substring(6)));
                } else if (s.startsWith("%blurclamp%")) {
                    this.blurTexture = true;
                    this.clampTexture = true;
                    bufferedimage1 = this.readTextureImage(texturepackbase.getResourceAsStream(s.substring(11)));
                } else {
                    bufferedimage1 = this.readTextureImage(texturepackbase.getResourceAsStream(s));
                }
                int j = (Integer)this.textureMap.get(s);
                this.setupTexture(bufferedimage1, j);
                this.blurTexture = false;
                this.clampTexture = false;
            }
            catch (IOException ioexception) {
                ioexception.printStackTrace();
            }
        }
        for (String s1 : this.textureContentsMap.keySet()) {
            try {
                BufferedImage bufferedimage2;
                if (s1.startsWith("##")) {
                    bufferedimage2 = this.unwrapImageByColumns(this.readTextureImage(texturepackbase.getResourceAsStream(s1.substring(2))));
                } else if (s1.startsWith("%clamp%")) {
                    this.clampTexture = true;
                    bufferedimage2 = this.readTextureImage(texturepackbase.getResourceAsStream(s1.substring(7)));
                } else if (s1.startsWith("%blur%")) {
                    this.blurTexture = true;
                    bufferedimage2 = this.readTextureImage(texturepackbase.getResourceAsStream(s1.substring(6)));
                } else {
                    bufferedimage2 = this.readTextureImage(texturepackbase.getResourceAsStream(s1));
                }
                this.getImageContents(bufferedimage2, (int[])this.textureContentsMap.get(s1));
                this.blurTexture = false;
                this.clampTexture = false;
            }
            catch (IOException ioexception1) {
                ioexception1.printStackTrace();
            }
        }
    }

    private BufferedImage readTextureImage(InputStream par1InputStream) throws IOException {
        BufferedImage bufferedimage = ImageIO.read(par1InputStream);
        par1InputStream.close();
        return bufferedimage;
    }

    public void bindTexture(int par1) {
        if (par1 < 0) {
            return;
        }
        GL11.glBindTexture((int)3553, (int)par1);
    }
}

