/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.Block;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityEnderman;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.ModelEnderman;
import net.minecraft.src.OpenGlHelper;
import net.minecraft.src.RenderLiving;
import org.lwjgl.opengl.GL11;

public class RenderEnderman
extends RenderLiving {
    private ModelEnderman endermanModel;
    private Random rnd = new Random();

    public RenderEnderman() {
        super(new ModelEnderman(), 0.5f);
        this.endermanModel = (ModelEnderman)this.mainModel;
        this.setRenderPassModel(this.endermanModel);
    }

    public void renderEnderman(EntityEnderman par1EntityEnderman, double par2, double par4, double par6, float par8, float par9) {
        this.endermanModel.isCarrying = par1EntityEnderman.getCarried() > 0;
        this.endermanModel.isAttacking = par1EntityEnderman.isAttacking;
        if (par1EntityEnderman.isAttacking) {
            double d = 0.02;
            par2 += this.rnd.nextGaussian() * d;
            par6 += this.rnd.nextGaussian() * d;
        }
        super.doRenderLiving(par1EntityEnderman, par2, par4, par6, par8, par9);
    }

    protected void renderCarrying(EntityEnderman par1EntityEnderman, float par2) {
        super.renderEquippedItems(par1EntityEnderman, par2);
        if (par1EntityEnderman.getCarried() > 0) {
            GL11.glEnable((int)32826);
            GL11.glPushMatrix();
            float f = 0.5f;
            GL11.glTranslatef((float)0.0f, (float)0.6875f, (float)-0.75f);
            GL11.glRotatef((float)20.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glScalef((float)(f *= 1.0f), (float)(-f), (float)f);
            int i = par1EntityEnderman.getBrightnessForRender(par2);
            int j = i % 65536;
            int k = i / 65536;
            OpenGlHelper.setLightmapTextureCoords(OpenGlHelper.lightmapTexUnit, (float)j / 1.0f, (float)k / 1.0f);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.loadTexture("/terrain.png");
            this.renderBlocks.renderBlockAsItem(Block.blocksList[par1EntityEnderman.getCarried()], par1EntityEnderman.getCarryingData(), 1.0f);
            GL11.glPopMatrix();
            GL11.glDisable((int)32826);
        }
    }

    protected int renderEyes(EntityEnderman par1EntityEnderman, int par2, float par3) {
        if (par2 != 0) {
            return -1;
        }
        this.loadTexture("/mob/enderman_eyes.png");
        float f = 1.0f;
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3008);
        GL11.glBlendFunc((int)1, (int)1);
        GL11.glDisable((int)2896);
        int i = 61680;
        int j = i % 65536;
        int k = i / 65536;
        OpenGlHelper.setLightmapTextureCoords(OpenGlHelper.lightmapTexUnit, (float)j / 1.0f, (float)k / 1.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)2896);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)f);
        return 1;
    }

    @Override
    protected int shouldRenderPass(EntityLiving par1EntityLiving, int par2, float par3) {
        return this.renderEyes((EntityEnderman)par1EntityLiving, par2, par3);
    }

    @Override
    protected void renderEquippedItems(EntityLiving par1EntityLiving, float par2) {
        this.renderCarrying((EntityEnderman)par1EntityLiving, par2);
    }

    @Override
    public void doRenderLiving(EntityLiving par1EntityLiving, double par2, double par4, double par6, float par8, float par9) {
        this.renderEnderman((EntityEnderman)par1EntityLiving, par2, par4, par6, par8, par9);
    }

    @Override
    public void doRender(Entity par1Entity, double par2, double par4, double par6, float par8, float par9) {
        this.renderEnderman((EntityEnderman)par1Entity, par2, par4, par6, par8, par9);
    }
}

