/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityDragon;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.MathHelper;
import net.minecraft.src.ModelDragon;
import net.minecraft.src.OpenGlHelper;
import net.minecraft.src.RenderHelper;
import net.minecraft.src.RenderLiving;
import net.minecraft.src.Tessellator;
import org.lwjgl.opengl.GL11;

public class RenderDragon
extends RenderLiving {
    public static EntityDragon entityDragon;
    private static int updateModelState;
    protected ModelDragon modelDragon;

    public RenderDragon() {
        super(new ModelDragon(0.0f), 0.5f);
        this.modelDragon = (ModelDragon)this.mainModel;
        this.setRenderPassModel(this.mainModel);
    }

    protected void rotateDragonBody(EntityDragon par1EntityDragon, float par2, float par3, float par4) {
        float f = (float)par1EntityDragon.getMovementOffsets(7, par4)[0];
        float f1 = (float)(par1EntityDragon.getMovementOffsets(5, par4)[1] - par1EntityDragon.getMovementOffsets(10, par4)[1]);
        GL11.glRotatef((float)(-f), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(f1 * 10.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)1.0f);
        if (par1EntityDragon.deathTime > 0) {
            float f2 = ((float)par1EntityDragon.deathTime + par4 - 1.0f) / 20.0f * 1.6f;
            if ((f2 = MathHelper.sqrt_float(f2)) > 1.0f) {
                f2 = 1.0f;
            }
            GL11.glRotatef((float)(f2 * this.getDeathMaxRotation(par1EntityDragon)), (float)0.0f, (float)0.0f, (float)1.0f);
        }
    }

    protected void renderDragonModel(EntityDragon par1EntityDragon, float par2, float par3, float par4, float par5, float par6, float par7) {
        if (par1EntityDragon.deathTicks > 0) {
            float f = (float)par1EntityDragon.deathTicks / 200.0f;
            GL11.glDepthFunc((int)515);
            GL11.glEnable((int)3008);
            GL11.glAlphaFunc((int)516, (float)f);
            this.loadDownloadableImageTexture(par1EntityDragon.skinUrl, "/mob/enderdragon/shuffle.png");
            this.mainModel.render(par1EntityDragon, par2, par3, par4, par5, par6, par7);
            GL11.glAlphaFunc((int)516, (float)0.1f);
            GL11.glDepthFunc((int)514);
        }
        this.loadDownloadableImageTexture(par1EntityDragon.skinUrl, par1EntityDragon.getTexture());
        this.mainModel.render(par1EntityDragon, par2, par3, par4, par5, par6, par7);
        if (par1EntityDragon.hurtTime > 0) {
            GL11.glDepthFunc((int)514);
            GL11.glDisable((int)3553);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glColor4f((float)1.0f, (float)0.0f, (float)0.0f, (float)0.5f);
            this.mainModel.render(par1EntityDragon, par2, par3, par4, par5, par6, par7);
            GL11.glEnable((int)3553);
            GL11.glDisable((int)3042);
            GL11.glDepthFunc((int)515);
        }
    }

    public void renderDragon(EntityDragon par1EntityDragon, double par2, double par4, double par6, float par8, float par9) {
        entityDragon = par1EntityDragon;
        if (updateModelState != 4) {
            this.mainModel = new ModelDragon(0.0f);
            updateModelState = 4;
        }
        super.doRenderLiving(par1EntityDragon, par2, par4, par6, par8, par9);
        if (par1EntityDragon.healingEnderCrystal != null) {
            float f = (float)par1EntityDragon.healingEnderCrystal.innerRotation + par9;
            float f1 = MathHelper.sin(f * 0.2f) / 2.0f + 0.5f;
            f1 = (f1 * f1 + f1) * 0.2f;
            float f2 = (float)(par1EntityDragon.healingEnderCrystal.posX - par1EntityDragon.posX - (par1EntityDragon.prevPosX - par1EntityDragon.posX) * (double)(1.0f - par9));
            float f3 = (float)((double)f1 + par1EntityDragon.healingEnderCrystal.posY - 1.0 - par1EntityDragon.posY - (par1EntityDragon.prevPosY - par1EntityDragon.posY) * (double)(1.0f - par9));
            float f4 = (float)(par1EntityDragon.healingEnderCrystal.posZ - par1EntityDragon.posZ - (par1EntityDragon.prevPosZ - par1EntityDragon.posZ) * (double)(1.0f - par9));
            float f5 = MathHelper.sqrt_float(f2 * f2 + f4 * f4);
            float f6 = MathHelper.sqrt_float(f2 * f2 + f3 * f3 + f4 * f4);
            GL11.glPushMatrix();
            GL11.glTranslatef((float)((float)par2), (float)((float)par4 + 2.0f), (float)((float)par6));
            GL11.glRotatef((float)((float)(-Math.atan2(f4, f2)) * 180.0f / (float)Math.PI - 90.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)((float)(-Math.atan2(f5, f3)) * 180.0f / (float)Math.PI - 90.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            Tessellator tessellator = Tessellator.instance;
            RenderHelper.disableStandardItemLighting();
            GL11.glDisable((int)2884);
            this.loadTexture("/mob/enderdragon/beam.png");
            GL11.glShadeModel((int)7425);
            float f7 = 0.0f - ((float)par1EntityDragon.ticksExisted + par9) * 0.01f;
            float f8 = MathHelper.sqrt_float(f2 * f2 + f3 * f3 + f4 * f4) / 32.0f - ((float)par1EntityDragon.ticksExisted + par9) * 0.01f;
            tessellator.startDrawing(5);
            int i = 8;
            for (int j = 0; j <= i; ++j) {
                float f9 = MathHelper.sin((float)(j % i) * (float)Math.PI * 2.0f / (float)i) * 0.75f;
                float f10 = MathHelper.cos((float)(j % i) * (float)Math.PI * 2.0f / (float)i) * 0.75f;
                float f11 = (float)(j % i) * 1.0f / (float)i;
                tessellator.setColorOpaque_I(0);
                tessellator.addVertexWithUV(f9 * 0.2f, f10 * 0.2f, 0.0, f11, f8);
                tessellator.setColorOpaque_I(0xFFFFFF);
                tessellator.addVertexWithUV(f9, f10, f6, f11, f7);
            }
            tessellator.draw();
            GL11.glEnable((int)2884);
            GL11.glShadeModel((int)7424);
            RenderHelper.enableStandardItemLighting();
            GL11.glPopMatrix();
        }
    }

    protected void renderDragonDying(EntityDragon par1EntityDragon, float par2) {
        super.renderEquippedItems(par1EntityDragon, par2);
        Tessellator tessellator = Tessellator.instance;
        if (par1EntityDragon.deathTicks > 0) {
            RenderHelper.disableStandardItemLighting();
            float f = ((float)par1EntityDragon.deathTicks + par2) / 200.0f;
            float f1 = 0.0f;
            if (f > 0.8f) {
                f1 = (f - 0.8f) / 0.2f;
            }
            Random random = new Random(432L);
            GL11.glDisable((int)3553);
            GL11.glShadeModel((int)7425);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)1);
            GL11.glDisable((int)3008);
            GL11.glEnable((int)2884);
            GL11.glDepthMask((boolean)false);
            GL11.glPushMatrix();
            GL11.glTranslatef((float)0.0f, (float)-1.0f, (float)-2.0f);
            int i = 0;
            while ((float)i < (f + f * f) / 2.0f * 60.0f) {
                GL11.glRotatef((float)(random.nextFloat() * 360.0f), (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)(random.nextFloat() * 360.0f), (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)(random.nextFloat() * 360.0f), (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glRotatef((float)(random.nextFloat() * 360.0f), (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)(random.nextFloat() * 360.0f), (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)(random.nextFloat() * 360.0f + f * 90.0f), (float)0.0f, (float)0.0f, (float)1.0f);
                tessellator.startDrawing(6);
                float f2 = random.nextFloat() * 20.0f + 5.0f + f1 * 10.0f;
                float f3 = random.nextFloat() * 2.0f + 1.0f + f1 * 2.0f;
                tessellator.setColorRGBA_I(0xFFFFFF, (int)(255.0f * (1.0f - f1)));
                tessellator.addVertex(0.0, 0.0, 0.0);
                tessellator.setColorRGBA_I(0xFF00FF, 0);
                tessellator.addVertex(-0.866 * (double)f3, f2, -0.5f * f3);
                tessellator.addVertex(0.866 * (double)f3, f2, -0.5f * f3);
                tessellator.addVertex(0.0, f2, 1.0f * f3);
                tessellator.addVertex(-0.866 * (double)f3, f2, -0.5f * f3);
                tessellator.draw();
                ++i;
            }
            GL11.glPopMatrix();
            GL11.glDepthMask((boolean)true);
            GL11.glDisable((int)2884);
            GL11.glDisable((int)3042);
            GL11.glShadeModel((int)7424);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glEnable((int)3553);
            GL11.glEnable((int)3008);
            RenderHelper.enableStandardItemLighting();
        }
    }

    protected int renderGlow(EntityDragon par1EntityDragon, int par2, float par3) {
        if (par2 == 1) {
            GL11.glDepthFunc((int)515);
        }
        if (par2 != 0) {
            return -1;
        }
        this.loadTexture("/mob/enderdragon/ender_eyes.png");
        float f = 1.0f;
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3008);
        GL11.glBlendFunc((int)1, (int)1);
        GL11.glDisable((int)2896);
        GL11.glDepthFunc((int)514);
        int i = 61680;
        int j = i % 65536;
        int k = i / 65536;
        OpenGlHelper.setLightmapTextureCoords(OpenGlHelper.lightmapTexUnit, (float)j / 1.0f, (float)k / 1.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)2896);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)f);
        return 1;
    }

    @Override
    protected int shouldRenderPass(EntityLiving par1EntityLiving, int par2, float par3) {
        return this.renderGlow((EntityDragon)par1EntityLiving, par2, par3);
    }

    @Override
    protected void renderEquippedItems(EntityLiving par1EntityLiving, float par2) {
        this.renderDragonDying((EntityDragon)par1EntityLiving, par2);
    }

    @Override
    protected void rotateCorpse(EntityLiving par1EntityLiving, float par2, float par3, float par4) {
        this.rotateDragonBody((EntityDragon)par1EntityLiving, par2, par3, par4);
    }

    @Override
    protected void renderModel(EntityLiving par1EntityLiving, float par2, float par3, float par4, float par5, float par6, float par7) {
        this.renderDragonModel((EntityDragon)par1EntityLiving, par2, par3, par4, par5, par6, par7);
    }

    @Override
    public void doRenderLiving(EntityLiving par1EntityLiving, double par2, double par4, double par6, float par8, float par9) {
        this.renderDragon((EntityDragon)par1EntityLiving, par2, par4, par6, par8, par9);
    }

    @Override
    public void doRender(Entity par1Entity, double par2, double par4, double par6, float par8, float par9) {
        this.renderDragon((EntityDragon)par1Entity, par2, par4, par6, par8, par9);
    }

    static {
        updateModelState = 0;
    }
}

