/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.client.Minecraft;
import net.minecraft.src.Block;
import net.minecraft.src.BlockBed;
import net.minecraft.src.BlockBrewingStand;
import net.minecraft.src.BlockCauldron;
import net.minecraft.src.BlockDirectional;
import net.minecraft.src.BlockDoor;
import net.minecraft.src.BlockDragonEgg;
import net.minecraft.src.BlockEndPortalFrame;
import net.minecraft.src.BlockFence;
import net.minecraft.src.BlockFenceGate;
import net.minecraft.src.BlockFluid;
import net.minecraft.src.BlockPane;
import net.minecraft.src.BlockPistonBase;
import net.minecraft.src.BlockPistonExtension;
import net.minecraft.src.BlockRail;
import net.minecraft.src.BlockRedstoneRepeater;
import net.minecraft.src.BlockRedstoneWire;
import net.minecraft.src.BlockStem;
import net.minecraft.src.ChestItemRenderHelper;
import net.minecraft.src.Direction;
import net.minecraft.src.EntityRenderer;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.Material;
import net.minecraft.src.MathHelper;
import net.minecraft.src.ModLoader;
import net.minecraft.src.Tessellator;
import net.minecraft.src.Vec3D;
import net.minecraft.src.World;
import org.lwjgl.opengl.GL11;

public class RenderBlocks {
    public IBlockAccess blockAccess;
    public int overrideBlockTexture = -1;
    public boolean flipTexture = false;
    public boolean renderAllFaces = false;
    public static boolean fancyGrass = true;
    public static boolean cfgGrassFix = true;
    public boolean useInventoryTint = true;
    public int uvRotateEast = 0;
    public int uvRotateWest = 0;
    public int uvRotateSouth = 0;
    public int uvRotateNorth = 0;
    public int uvRotateTop = 0;
    public int uvRotateBottom = 0;
    public boolean enableAO;
    public float lightValueOwn;
    public float aoLightValueXNeg;
    public float aoLightValueYNeg;
    public float aoLightValueZNeg;
    public float aoLightValueXPos;
    public float aoLightValueYPos;
    public float aoLightValueZPos;
    public float aoLightValueScratchXYZNNN;
    public float aoLightValueScratchXYNN;
    public float aoLightValueScratchXYZNNP;
    public float aoLightValueScratchYZNN;
    public float aoLightValueScratchYZNP;
    public float aoLightValueScratchXYZPNN;
    public float aoLightValueScratchXYPN;
    public float aoLightValueScratchXYZPNP;
    public float aoLightValueScratchXYZNPN;
    public float aoLightValueScratchXYNP;
    public float aoLightValueScratchXYZNPP;
    public float aoLightValueScratchYZPN;
    public float aoLightValueScratchXYZPPN;
    public float aoLightValueScratchXYPP;
    public float aoLightValueScratchYZPP;
    public float aoLightValueScratchXYZPPP;
    public float aoLightValueScratchXZNN;
    public float aoLightValueScratchXZPN;
    public float aoLightValueScratchXZNP;
    public float aoLightValueScratchXZPP;
    public int aoBrightnessXYZNNN;
    public int aoBrightnessXYNN;
    public int aoBrightnessXYZNNP;
    public int aoBrightnessYZNN;
    public int aoBrightnessYZNP;
    public int aoBrightnessXYZPNN;
    public int aoBrightnessXYPN;
    public int aoBrightnessXYZPNP;
    public int aoBrightnessXYZNPN;
    public int aoBrightnessXYNP;
    public int aoBrightnessXYZNPP;
    public int aoBrightnessYZPN;
    public int aoBrightnessXYZPPN;
    public int aoBrightnessXYPP;
    public int aoBrightnessYZPP;
    public int aoBrightnessXYZPPP;
    public int aoBrightnessXZNN;
    public int aoBrightnessXZPN;
    public int aoBrightnessXZNP;
    public int aoBrightnessXZPP;
    public int aoType = 1;
    public int brightnessTopLeft;
    public int brightnessBottomLeft;
    public int brightnessBottomRight;
    public int brightnessTopRight;
    public float colorRedTopLeft;
    public float colorRedBottomLeft;
    public float colorRedBottomRight;
    public float colorRedTopRight;
    public float colorGreenTopLeft;
    public float colorGreenBottomLeft;
    public float colorGreenBottomRight;
    public float colorGreenTopRight;
    public float colorBlueTopLeft;
    public float colorBlueBottomLeft;
    public float colorBlueBottomRight;
    public float colorBlueTopRight;
    public boolean aoGrassXYZCPN;
    public boolean aoGrassXYZPPC;
    public boolean aoGrassXYZNPC;
    public boolean aoGrassXYZCPP;
    public boolean aoGrassXYZNCN;
    public boolean aoGrassXYZPCP;
    public boolean aoGrassXYZNCP;
    public boolean aoGrassXYZPCN;
    public boolean aoGrassXYZCNN;
    public boolean aoGrassXYZPNC;
    public boolean aoGrassXYZNNC;
    public boolean aoGrassXYZCNP;

    public RenderBlocks(IBlockAccess par1IBlockAccess) {
        this.blockAccess = par1IBlockAccess;
    }

    public RenderBlocks() {
    }

    public void clearOverrideBlockTexture() {
        this.overrideBlockTexture = -1;
    }

    public void renderBlockUsingTexture(Block par1Block, int par2, int par3, int par4, int par5) {
        this.overrideBlockTexture = par5;
        this.renderBlockByRenderType(par1Block, par2, par3, par4);
        this.overrideBlockTexture = -1;
    }

    public void renderBlockAllFaces(Block par1Block, int par2, int par3, int par4) {
        this.renderAllFaces = true;
        this.renderBlockByRenderType(par1Block, par2, par3, par4);
        this.renderAllFaces = false;
    }

    public boolean renderBlockByRenderType(Block par1Block, int par2, int par3, int par4) {
        int i = par1Block.getRenderType();
        par1Block.setBlockBoundsBasedOnState(this.blockAccess, par2, par3, par4);
        return i != 0 ? (i != 4 ? (i != 13 ? (i != 1 ? (i != 19 ? (i != 23 ? (i != 6 ? (i != 2 ? (i != 3 ? (i != 5 ? (i != 8 ? (i != 7 ? (i != 9 ? (i != 10 ? (i != 27 ? (i != 11 ? (i != 12 ? (i != 14 ? (i != 15 ? (i != 16 ? (i != 17 ? (i != 18 ? (i != 20 ? (i != 21 ? (i != 24 ? (i != 25 ? (i != 26 ? ModLoader.renderWorldBlock(this, this.blockAccess, par2, par3, par4, par1Block, i) : this.renderBlockEndPortalFrame(par1Block, par2, par3, par4)) : this.renderBlockBrewingStand((BlockBrewingStand)par1Block, par2, par3, par4)) : this.renderBlockCauldron((BlockCauldron)par1Block, par2, par3, par4)) : this.renderBlockFenceGate((BlockFenceGate)par1Block, par2, par3, par4)) : this.renderBlockVine(par1Block, par2, par3, par4)) : this.renderBlockPane((BlockPane)par1Block, par2, par3, par4)) : this.renderPistonExtension(par1Block, par2, par3, par4, true)) : this.renderPistonBase(par1Block, par2, par3, par4, false)) : this.renderBlockRepeater(par1Block, par2, par3, par4)) : this.renderBlockBed(par1Block, par2, par3, par4)) : this.renderBlockLever(par1Block, par2, par3, par4)) : this.renderBlockFence((BlockFence)par1Block, par2, par3, par4)) : this.renderBlockDragonEgg((BlockDragonEgg)par1Block, par2, par3, par4)) : this.renderBlockStairs(par1Block, par2, par3, par4)) : this.renderBlockMinecartTrack((BlockRail)par1Block, par2, par3, par4)) : this.renderBlockDoor(par1Block, par2, par3, par4)) : this.renderBlockLadder(par1Block, par2, par3, par4)) : this.renderBlockRedstoneWire(par1Block, par2, par3, par4)) : this.renderBlockFire(par1Block, par2, par3, par4)) : this.renderBlockTorch(par1Block, par2, par3, par4)) : this.renderBlockCrops(par1Block, par2, par3, par4)) : this.renderBlockLilyPad(par1Block, par2, par3, par4)) : this.renderBlockStem(par1Block, par2, par3, par4)) : this.renderCrossedSquares(par1Block, par2, par3, par4)) : this.renderBlockCactus(par1Block, par2, par3, par4)) : this.renderBlockFluids(par1Block, par2, par3, par4)) : this.renderStandardBlock(par1Block, par2, par3, par4);
    }

    public boolean renderBlockEndPortalFrame(Block par1Block, int par2, int par3, int par4) {
        int i = this.blockAccess.getBlockMetadata(par2, par3, par4);
        int j = i & 3;
        if (j == 0) {
            this.uvRotateTop = 3;
        } else if (j == 3) {
            this.uvRotateTop = 1;
        } else if (j == 1) {
            this.uvRotateTop = 2;
        }
        if (!BlockEndPortalFrame.isEnderEyeInserted(i)) {
            par1Block.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.8125f, 1.0f);
            this.renderStandardBlock(par1Block, par2, par3, par4);
            par1Block.setBlockBoundsForItemRender();
            this.uvRotateTop = 0;
            return true;
        }
        par1Block.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.8125f, 1.0f);
        this.renderStandardBlock(par1Block, par2, par3, par4);
        this.overrideBlockTexture = 174;
        par1Block.setBlockBounds(0.25f, 0.8125f, 0.25f, 0.75f, 1.0f, 0.75f);
        this.renderStandardBlock(par1Block, par2, par3, par4);
        this.clearOverrideBlockTexture();
        par1Block.setBlockBoundsForItemRender();
        this.uvRotateTop = 0;
        return true;
    }

    public boolean renderBlockBed(Block par1Block, int par2, int par3, int par4) {
        Tessellator tessellator = Tessellator.instance;
        int i = this.blockAccess.getBlockMetadata(par2, par3, par4);
        int j = BlockBed.getDirection(i);
        boolean flag = BlockBed.isBlockFootOfBed(i);
        float f = 0.5f;
        float f1 = 1.0f;
        float f2 = 0.8f;
        float f3 = 0.6f;
        int k = par1Block.getMixedBrightnessForBlock(this.blockAccess, par2, par3, par4);
        tessellator.setBrightness(k);
        tessellator.setColorOpaque_F(f, f, f);
        int l = par1Block.getBlockTexture(this.blockAccess, par2, par3, par4, 0);
        int i1 = (l & 0xF) << 4;
        int j1 = l & 0xF0;
        double d = (float)i1 / 256.0f;
        double d1 = ((double)(i1 + 16) - 0.01) / 256.0;
        double d2 = (float)j1 / 256.0f;
        double d3 = ((double)(j1 + 16) - 0.01) / 256.0;
        double d4 = (double)par2 + par1Block.minX;
        double d5 = (double)par2 + par1Block.maxX;
        double d6 = (double)par3 + par1Block.minY + 0.1875;
        double d7 = (double)par4 + par1Block.minZ;
        double d8 = (double)par4 + par1Block.maxZ;
        tessellator.addVertexWithUV(d4, d6, d8, d, d3);
        tessellator.addVertexWithUV(d4, d6, d7, d, d2);
        tessellator.addVertexWithUV(d5, d6, d7, d1, d2);
        tessellator.addVertexWithUV(d5, d6, d8, d1, d3);
        tessellator.setBrightness(par1Block.getMixedBrightnessForBlock(this.blockAccess, par2, par3 + 1, par4));
        tessellator.setColorOpaque_F(f1, f1, f1);
        l = par1Block.getBlockTexture(this.blockAccess, par2, par3, par4, 1);
        i1 = (l & 0xF) << 4;
        j1 = l & 0xF0;
        d = (float)i1 / 256.0f;
        d1 = ((double)(i1 + 16) - 0.01) / 256.0;
        d2 = (float)j1 / 256.0f;
        d3 = ((double)(j1 + 16) - 0.01) / 256.0;
        d4 = d;
        d5 = d1;
        d6 = d2;
        d7 = d2;
        d8 = d;
        double d9 = d1;
        double d10 = d3;
        double d11 = d3;
        if (j == 0) {
            d5 = d;
            d6 = d3;
            d8 = d1;
            d11 = d2;
        } else if (j == 2) {
            d4 = d1;
            d7 = d3;
            d9 = d;
            d10 = d2;
        } else if (j == 3) {
            d4 = d1;
            d7 = d3;
            d9 = d;
            d10 = d2;
            d5 = d;
            d6 = d3;
            d8 = d1;
            d11 = d2;
        }
        double d12 = (double)par2 + par1Block.minX;
        double d13 = (double)par2 + par1Block.maxX;
        double d14 = (double)par3 + par1Block.maxY;
        double d15 = (double)par4 + par1Block.minZ;
        double d16 = (double)par4 + par1Block.maxZ;
        tessellator.addVertexWithUV(d13, d14, d16, d8, d10);
        tessellator.addVertexWithUV(d13, d14, d15, d4, d6);
        tessellator.addVertexWithUV(d12, d14, d15, d5, d7);
        tessellator.addVertexWithUV(d12, d14, d16, d9, d11);
        l = Direction.headInvisibleFace[j];
        if (flag) {
            l = Direction.headInvisibleFace[Direction.footInvisibleFaceRemap[j]];
        }
        int byte0 = 4;
        switch (j) {
            case 0: {
                byte0 = 5;
                break;
            }
            case 1: {
                byte0 = 3;
                break;
            }
            case 3: {
                byte0 = 2;
            }
        }
        if (l != 2 && (this.renderAllFaces || par1Block.shouldSideBeRendered(this.blockAccess, par2, par3, par4 - 1, 2))) {
            tessellator.setBrightness(par1Block.minZ <= 0.0 ? par1Block.getMixedBrightnessForBlock(this.blockAccess, par2, par3, par4 - 1) : k);
            tessellator.setColorOpaque_F(f2, f2, f2);
            this.flipTexture = byte0 == 2;
            this.renderEastFace(par1Block, par2, par3, par4, par1Block.getBlockTexture(this.blockAccess, par2, par3, par4, 2));
        }
        if (l != 3 && (this.renderAllFaces || par1Block.shouldSideBeRendered(this.blockAccess, par2, par3, par4 + 1, 3))) {
            tessellator.setBrightness(par1Block.maxZ >= 1.0 ? par1Block.getMixedBrightnessForBlock(this.blockAccess, par2, par3, par4 + 1) : k);
            tessellator.setColorOpaque_F(f2, f2, f2);
            this.flipTexture = byte0 == 3;
            this.renderWestFace(par1Block, par2, par3, par4, par1Block.getBlockTexture(this.blockAccess, par2, par3, par4, 3));
        }
        if (l != 4 && (this.renderAllFaces || par1Block.shouldSideBeRendered(this.blockAccess, par2 - 1, par3, par4, 4))) {
            tessellator.setBrightness(par1Block.minZ <= 0.0 ? par1Block.getMixedBrightnessForBlock(this.blockAccess, par2 - 1, par3, par4) : k);
            tessellator.setColorOpaque_F(f3, f3, f3);
            this.flipTexture = byte0 == 4;
            this.renderNorthFace(par1Block, par2, par3, par4, par1Block.getBlockTexture(this.blockAccess, par2, par3, par4, 4));
        }
        if (l != 5 && (this.renderAllFaces || par1Block.shouldSideBeRendered(this.blockAccess, par2 + 1, par3, par4, 5))) {
            tessellator.setBrightness(par1Block.maxZ >= 1.0 ? par1Block.getMixedBrightnessForBlock(this.blockAccess, par2 + 1, par3, par4) : k);
            tessellator.setColorOpaque_F(f3, f3, f3);
            this.flipTexture = byte0 == 5;
            this.renderSouthFace(par1Block, par2, par3, par4, par1Block.getBlockTexture(this.blockAccess, par2, par3, par4, 5));
        }
        this.flipTexture = false;
        return true;
    }

    public boolean renderBlockBrewingStand(BlockBrewingStand par1BlockBrewingStand, int par2, int par3, int par4) {
        par1BlockBrewingStand.setBlockBounds(0.4375f, 0.0f, 0.4375f, 0.5625f, 0.875f, 0.5625f);
        this.renderStandardBlock(par1BlockBrewingStand, par2, par3, par4);
        this.overrideBlockTexture = 156;
        par1BlockBrewingStand.setBlockBounds(0.5625f, 0.0f, 0.3125f, 0.9375f, 0.125f, 0.6875f);
        this.renderStandardBlock(par1BlockBrewingStand, par2, par3, par4);
        par1BlockBrewingStand.setBlockBounds(0.125f, 0.0f, 0.0625f, 0.5f, 0.125f, 0.4375f);
        this.renderStandardBlock(par1BlockBrewingStand, par2, par3, par4);
        par1BlockBrewingStand.setBlockBounds(0.125f, 0.0f, 0.5625f, 0.5f, 0.125f, 0.9375f);
        this.renderStandardBlock(par1BlockBrewingStand, par2, par3, par4);
        this.clearOverrideBlockTexture();
        Tessellator tessellator = Tessellator.instance;
        tessellator.setBrightness(par1BlockBrewingStand.getMixedBrightnessForBlock(this.blockAccess, par2, par3, par4));
        float f = 1.0f;
        int i = par1BlockBrewingStand.colorMultiplier(this.blockAccess, par2, par3, par4);
        float f1 = (float)(i >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(i >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(i & 0xFF) / 255.0f;
        if (EntityRenderer.anaglyphEnable) {
            float f4 = (f1 * 30.0f + f2 * 59.0f + f3 * 11.0f) / 100.0f;
            float f5 = (f1 * 30.0f + f2 * 70.0f) / 100.0f;
            float f6 = (f1 * 30.0f + f3 * 70.0f) / 100.0f;
            f1 = f4;
            f2 = f5;
            f3 = f6;
        }
        tessellator.setColorOpaque_F(f * f1, f * f2, f * f3);
        int j = par1BlockBrewingStand.getBlockTextureFromSideAndMetadata(0, 0);
        if (this.overrideBlockTexture >= 0) {
            j = this.overrideBlockTexture;
        }
        int k = (j & 0xF) << 4;
        int l = j & 0xF0;
        double d = (float)l / 256.0f;
        double d1 = ((float)l + 15.99f) / 256.0f;
        int i1 = this.blockAccess.getBlockMetadata(par2, par3, par4);
        for (int j1 = 0; j1 < 3; ++j1) {
            double d2 = (double)j1 * Math.PI * 2.0 / 3.0 + 1.5707963267948966;
            double d3 = ((float)k + 8.0f) / 256.0f;
            double d4 = ((float)k + 15.99f) / 256.0f;
            if ((i1 & 1 << j1) != 0) {
                d3 = ((float)k + 7.99f) / 256.0f;
                d4 = ((float)k + 0.0f) / 256.0f;
            }
            double d5 = (double)par2 + 0.5;
            double d6 = (double)par2 + 0.5 + Math.sin(d2) * 8.0 / 16.0;
            double d7 = (double)par4 + 0.5;
            double d8 = (double)par4 + 0.5 + Math.cos(d2) * 8.0 / 16.0;
            tessellator.addVertexWithUV(d5, par3 + 1, d7, d3, d);
            tessellator.addVertexWithUV(d5, par3 + 0, d7, d3, d1);
            tessellator.addVertexWithUV(d6, par3 + 0, d8, d4, d1);
            tessellator.addVertexWithUV(d6, par3 + 1, d8, d4, d);
            tessellator.addVertexWithUV(d6, par3 + 1, d8, d4, d);
            tessellator.addVertexWithUV(d6, par3 + 0, d8, d4, d1);
            tessellator.addVertexWithUV(d5, par3 + 0, d7, d3, d1);
            tessellator.addVertexWithUV(d5, par3 + 1, d7, d3, d);
        }
        par1BlockBrewingStand.setBlockBoundsForItemRender();
        return true;
    }

    public boolean renderBlockCauldron(BlockCauldron par1BlockCauldron, int par2, int par3, int par4) {
        this.renderStandardBlock(par1BlockCauldron, par2, par3, par4);
        Tessellator tessellator = Tessellator.instance;
        tessellator.setBrightness(par1BlockCauldron.getMixedBrightnessForBlock(this.blockAccess, par2, par3, par4));
        float f = 1.0f;
        int i = par1BlockCauldron.colorMultiplier(this.blockAccess, par2, par3, par4);
        float f1 = (float)(i >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(i >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(i & 0xFF) / 255.0f;
        if (EntityRenderer.anaglyphEnable) {
            float f6 = (f1 * 30.0f + f2 * 59.0f + f3 * 11.0f) / 100.0f;
            float f4 = (f1 * 30.0f + f2 * 70.0f) / 100.0f;
            float f7 = (f1 * 30.0f + f3 * 70.0f) / 100.0f;
            f1 = f6;
            f2 = f4;
            f3 = f7;
        }
        tessellator.setColorOpaque_F(f * f1, f * f2, f * f3);
        int c = 154;
        float f5 = 0.125f;
        this.renderSouthFace(par1BlockCauldron, (float)par2 - 1.0f + f5, par3, par4, c);
        this.renderNorthFace(par1BlockCauldron, (float)par2 + 1.0f - f5, par3, par4, c);
        this.renderWestFace(par1BlockCauldron, par2, par3, (float)par4 - 1.0f + f5, c);
        this.renderEastFace(par1BlockCauldron, par2, par3, (float)par4 + 1.0f - f5, c);
        int c1 = 139;
        this.renderTopFace(par1BlockCauldron, par2, (float)par3 - 1.0f + 0.25f, par4, c1);
        this.renderBottomFace(par1BlockCauldron, par2, (float)par3 + 1.0f - 0.75f, par4, c1);
        int j = this.blockAccess.getBlockMetadata(par2, par3, par4);
        if (j > 0) {
            int c2 = 205;
            if (j > 3) {
                j = 3;
            }
            this.renderTopFace(par1BlockCauldron, par2, (float)par3 - 1.0f + (6.0f + (float)j * 3.0f) / 16.0f, par4, c2);
        }
        return true;
    }

    public boolean renderBlockTorch(Block par1Block, int par2, int par3, int par4) {
        int i = this.blockAccess.getBlockMetadata(par2, par3, par4);
        Tessellator tessellator = Tessellator.instance;
        tessellator.setBrightness(par1Block.getMixedBrightnessForBlock(this.blockAccess, par2, par3, par4));
        tessellator.setColorOpaque_F(1.0f, 1.0f, 1.0f);
        double d = 0.4f;
        double d1 = 0.5 - d;
        double d2 = 0.2f;
        if (i == 1) {
            this.renderTorchAtAngle(par1Block, (double)par2 - d1, (double)par3 + d2, par4, -d, 0.0);
        } else if (i == 2) {
            this.renderTorchAtAngle(par1Block, (double)par2 + d1, (double)par3 + d2, par4, d, 0.0);
        } else if (i == 3) {
            this.renderTorchAtAngle(par1Block, par2, (double)par3 + d2, (double)par4 - d1, 0.0, -d);
        } else if (i == 4) {
            this.renderTorchAtAngle(par1Block, par2, (double)par3 + d2, (double)par4 + d1, 0.0, d);
        } else {
            this.renderTorchAtAngle(par1Block, par2, par3, par4, 0.0, 0.0);
        }
        return true;
    }

    public boolean renderBlockRepeater(Block par1Block, int par2, int par3, int par4) {
        int i = this.blockAccess.getBlockMetadata(par2, par3, par4);
        int j = i & 3;
        int k = (i & 0xC) >> 2;
        this.renderStandardBlock(par1Block, par2, par3, par4);
        Tessellator tessellator = Tessellator.instance;
        tessellator.setBrightness(par1Block.getMixedBrightnessForBlock(this.blockAccess, par2, par3, par4));
        tessellator.setColorOpaque_F(1.0f, 1.0f, 1.0f);
        double d = -0.1875;
        double d1 = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        switch (j) {
            case 0: {
                d4 = -0.3125;
                d2 = BlockRedstoneRepeater.repeaterTorchOffset[k];
                break;
            }
            case 1: {
                d3 = 0.3125;
                d1 = -BlockRedstoneRepeater.repeaterTorchOffset[k];
                break;
            }
            case 2: {
                d4 = 0.3125;
                d2 = -BlockRedstoneRepeater.repeaterTorchOffset[k];
                break;
            }
            case 3: {
                d3 = -0.3125;
                d1 = BlockRedstoneRepeater.repeaterTorchOffset[k];
            }
        }
        this.renderTorchAtAngle(par1Block, (double)par2 + d1, (double)par3 + d, (double)par4 + d2, 0.0, 0.0);
        this.renderTorchAtAngle(par1Block, (double)par2 + d3, (double)par3 + d, (double)par4 + d4, 0.0, 0.0);
        int l = par1Block.getBlockTextureFromSide(1);
        int i1 = (l & 0xF) << 4;
        int j1 = l & 0xF0;
        double d5 = (float)i1 / 256.0f;
        double d6 = ((float)i1 + 15.99f) / 256.0f;
        double d7 = (float)j1 / 256.0f;
        double d8 = ((float)j1 + 15.99f) / 256.0f;
        double d9 = 0.125;
        double d10 = par2 + 1;
        double d11 = par2 + 1;
        double d12 = par2 + 0;
        double d13 = par2 + 0;
        double d14 = par4 + 0;
        double d15 = par4 + 1;
        double d16 = par4 + 1;
        double d17 = par4 + 0;
        double d18 = (double)par3 + d9;
        if (j == 2) {
            d10 = d11 = (double)(par2 + 0);
            d12 = d13 = (double)(par2 + 1);
            d14 = d17 = (double)(par4 + 1);
            d15 = d16 = (double)(par4 + 0);
        } else if (j == 3) {
            d10 = d13 = (double)(par2 + 0);
            d11 = d12 = (double)(par2 + 1);
            d14 = d15 = (double)(par4 + 0);
            d16 = d17 = (double)(par4 + 1);
        } else if (j == 1) {
            d10 = d13 = (double)(par2 + 1);
            d11 = d12 = (double)(par2 + 0);
            d14 = d15 = (double)(par4 + 1);
            d16 = d17 = (double)(par4 + 0);
        }
        tessellator.addVertexWithUV(d13, d18, d17, d5, d7);
        tessellator.addVertexWithUV(d12, d18, d16, d5, d8);
        tessellator.addVertexWithUV(d11, d18, d15, d6, d8);
        tessellator.addVertexWithUV(d10, d18, d14, d6, d7);
        return true;
    }

    public void renderPistonBaseAllFaces(Block par1Block, int par2, int par3, int par4) {
        this.renderAllFaces = true;
        this.renderPistonBase(par1Block, par2, par3, par4, true);
        this.renderAllFaces = false;
    }

    public boolean renderPistonBase(Block par1Block, int par2, int par3, int par4, boolean par5) {
        int i = this.blockAccess.getBlockMetadata(par2, par3, par4);
        boolean flag = par5 || (i & 8) != 0;
        int j = BlockPistonBase.getOrientation(i);
        if (flag) {
            switch (j) {
                case 0: {
                    this.uvRotateEast = 3;
                    this.uvRotateWest = 3;
                    this.uvRotateSouth = 3;
                    this.uvRotateNorth = 3;
                    par1Block.setBlockBounds(0.0f, 0.25f, 0.0f, 1.0f, 1.0f, 1.0f);
                    break;
                }
                case 1: {
                    par1Block.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.75f, 1.0f);
                    break;
                }
                case 2: {
                    this.uvRotateSouth = 1;
                    this.uvRotateNorth = 2;
                    par1Block.setBlockBounds(0.0f, 0.0f, 0.25f, 1.0f, 1.0f, 1.0f);
                    break;
                }
                case 3: {
                    this.uvRotateSouth = 2;
                    this.uvRotateNorth = 1;
                    this.uvRotateTop = 3;
                    this.uvRotateBottom = 3;
                    par1Block.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.75f);
                    break;
                }
                case 4: {
                    this.uvRotateEast = 1;
                    this.uvRotateWest = 2;
                    this.uvRotateTop = 2;
                    this.uvRotateBottom = 1;
                    par1Block.setBlockBounds(0.25f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                    break;
                }
                case 5: {
                    this.uvRotateEast = 2;
                    this.uvRotateWest = 1;
                    this.uvRotateTop = 1;
                    this.uvRotateBottom = 2;
                    par1Block.setBlockBounds(0.0f, 0.0f, 0.0f, 0.75f, 1.0f, 1.0f);
                }
            }
            this.renderStandardBlock(par1Block, par2, par3, par4);
            this.uvRotateEast = 0;
            this.uvRotateWest = 0;
            this.uvRotateSouth = 0;
            this.uvRotateNorth = 0;
            this.uvRotateTop = 0;
            this.uvRotateBottom = 0;
            par1Block.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        } else {
            switch (j) {
                case 0: {
                    this.uvRotateEast = 3;
                    this.uvRotateWest = 3;
                    this.uvRotateSouth = 3;
                    this.uvRotateNorth = 3;
                    break;
                }
                case 2: {
                    this.uvRotateSouth = 1;
                    this.uvRotateNorth = 2;
                    break;
                }
                case 3: {
                    this.uvRotateSouth = 2;
                    this.uvRotateNorth = 1;
                    this.uvRotateTop = 3;
                    this.uvRotateBottom = 3;
                    break;
                }
                case 4: {
                    this.uvRotateEast = 1;
                    this.uvRotateWest = 2;
                    this.uvRotateTop = 2;
                    this.uvRotateBottom = 1;
                    break;
                }
                case 5: {
                    this.uvRotateEast = 2;
                    this.uvRotateWest = 1;
                    this.uvRotateTop = 1;
                    this.uvRotateBottom = 2;
                }
            }
            this.renderStandardBlock(par1Block, par2, par3, par4);
            this.uvRotateEast = 0;
            this.uvRotateWest = 0;
            this.uvRotateSouth = 0;
            this.uvRotateNorth = 0;
            this.uvRotateTop = 0;
            this.uvRotateBottom = 0;
        }
        return true;
    }

    public void renderPistonRodUD(double par1, double par3, double par5, double par7, double par9, double par11, float par13, double par14) {
        int i = 108;
        if (this.overrideBlockTexture >= 0) {
            i = this.overrideBlockTexture;
        }
        int j = (i & 0xF) << 4;
        int k = i & 0xF0;
        Tessellator tessellator = Tessellator.instance;
        double d = (float)(j + 0) / 256.0f;
        double d1 = (float)(k + 0) / 256.0f;
        double d2 = ((double)j + par14 - 0.01) / 256.0;
        double d3 = ((double)((float)k + 4.0f) - 0.01) / 256.0;
        tessellator.setColorOpaque_F(par13, par13, par13);
        tessellator.addVertexWithUV(par1, par7, par9, d2, d1);
        tessellator.addVertexWithUV(par1, par5, par9, d, d1);
        tessellator.addVertexWithUV(par3, par5, par11, d, d3);
        tessellator.addVertexWithUV(par3, par7, par11, d2, d3);
    }

    public void renderPistonRodSN(double par1, double par3, double par5, double par7, double par9, double par11, float par13, double par14) {
        int i = 108;
        if (this.overrideBlockTexture >= 0) {
            i = this.overrideBlockTexture;
        }
        int j = (i & 0xF) << 4;
        int k = i & 0xF0;
        Tessellator tessellator = Tessellator.instance;
        double d = (float)(j + 0) / 256.0f;
        double d1 = (float)(k + 0) / 256.0f;
        double d2 = ((double)j + par14 - 0.01) / 256.0;
        double d3 = ((double)((float)k + 4.0f) - 0.01) / 256.0;
        tessellator.setColorOpaque_F(par13, par13, par13);
        tessellator.addVertexWithUV(par1, par5, par11, d2, d1);
        tessellator.addVertexWithUV(par1, par5, par9, d, d1);
        tessellator.addVertexWithUV(par3, par7, par9, d, d3);
        tessellator.addVertexWithUV(par3, par7, par11, d2, d3);
    }

    public void renderPistonRodEW(double par1, double par3, double par5, double par7, double par9, double par11, float par13, double par14) {
        int i = 108;
        if (this.overrideBlockTexture >= 0) {
            i = this.overrideBlockTexture;
        }
        int j = (i & 0xF) << 4;
        int k = i & 0xF0;
        Tessellator tessellator = Tessellator.instance;
        double d = (float)(j + 0) / 256.0f;
        double d1 = (float)(k + 0) / 256.0f;
        double d2 = ((double)j + par14 - 0.01) / 256.0;
        double d3 = ((double)((float)k + 4.0f) - 0.01) / 256.0;
        tessellator.setColorOpaque_F(par13, par13, par13);
        tessellator.addVertexWithUV(par3, par5, par9, d2, d1);
        tessellator.addVertexWithUV(par1, par5, par9, d, d1);
        tessellator.addVertexWithUV(par1, par7, par11, d, d3);
        tessellator.addVertexWithUV(par3, par7, par11, d2, d3);
    }

    public void renderPistonExtensionAllFaces(Block par1Block, int par2, int par3, int par4, boolean par5) {
        this.renderAllFaces = true;
        this.renderPistonExtension(par1Block, par2, par3, par4, par5);
        this.renderAllFaces = false;
    }

    public boolean renderPistonExtension(Block par1Block, int par2, int par3, int par4, boolean par5) {
        int i = this.blockAccess.getBlockMetadata(par2, par3, par4);
        int j = BlockPistonExtension.getDirectionMeta(i);
        float f = par1Block.getBlockBrightness(this.blockAccess, par2, par3, par4);
        float f1 = par5 ? 1.0f : 0.5f;
        double d = par5 ? 16.0 : 8.0;
        switch (j) {
            case 0: {
                this.uvRotateEast = 3;
                this.uvRotateWest = 3;
                this.uvRotateSouth = 3;
                this.uvRotateNorth = 3;
                par1Block.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.25f, 1.0f);
                this.renderStandardBlock(par1Block, par2, par3, par4);
                this.renderPistonRodUD((float)par2 + 0.375f, (float)par2 + 0.625f, (float)par3 + 0.25f, (float)par3 + 0.25f + f1, (float)par4 + 0.625f, (float)par4 + 0.625f, f * 0.8f, d);
                this.renderPistonRodUD((float)par2 + 0.625f, (float)par2 + 0.375f, (float)par3 + 0.25f, (float)par3 + 0.25f + f1, (float)par4 + 0.375f, (float)par4 + 0.375f, f * 0.8f, d);
                this.renderPistonRodUD((float)par2 + 0.375f, (float)par2 + 0.375f, (float)par3 + 0.25f, (float)par3 + 0.25f + f1, (float)par4 + 0.375f, (float)par4 + 0.625f, f * 0.6f, d);
                this.renderPistonRodUD((float)par2 + 0.625f, (float)par2 + 0.625f, (float)par3 + 0.25f, (float)par3 + 0.25f + f1, (float)par4 + 0.625f, (float)par4 + 0.375f, f * 0.6f, d);
                break;
            }
            case 1: {
                par1Block.setBlockBounds(0.0f, 0.75f, 0.0f, 1.0f, 1.0f, 1.0f);
                this.renderStandardBlock(par1Block, par2, par3, par4);
                this.renderPistonRodUD((float)par2 + 0.375f, (float)par2 + 0.625f, (float)par3 - 0.25f + 1.0f - f1, (float)par3 - 0.25f + 1.0f, (float)par4 + 0.625f, (float)par4 + 0.625f, f * 0.8f, d);
                this.renderPistonRodUD((float)par2 + 0.625f, (float)par2 + 0.375f, (float)par3 - 0.25f + 1.0f - f1, (float)par3 - 0.25f + 1.0f, (float)par4 + 0.375f, (float)par4 + 0.375f, f * 0.8f, d);
                this.renderPistonRodUD((float)par2 + 0.375f, (float)par2 + 0.375f, (float)par3 - 0.25f + 1.0f - f1, (float)par3 - 0.25f + 1.0f, (float)par4 + 0.375f, (float)par4 + 0.625f, f * 0.6f, d);
                this.renderPistonRodUD((float)par2 + 0.625f, (float)par2 + 0.625f, (float)par3 - 0.25f + 1.0f - f1, (float)par3 - 0.25f + 1.0f, (float)par4 + 0.625f, (float)par4 + 0.375f, f * 0.6f, d);
                break;
            }
            case 2: {
                this.uvRotateSouth = 1;
                this.uvRotateNorth = 2;
                par1Block.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.25f);
                this.renderStandardBlock(par1Block, par2, par3, par4);
                this.renderPistonRodSN((float)par2 + 0.375f, (float)par2 + 0.375f, (float)par3 + 0.625f, (float)par3 + 0.375f, (float)par4 + 0.25f, (float)par4 + 0.25f + f1, f * 0.6f, d);
                this.renderPistonRodSN((float)par2 + 0.625f, (float)par2 + 0.625f, (float)par3 + 0.375f, (float)par3 + 0.625f, (float)par4 + 0.25f, (float)par4 + 0.25f + f1, f * 0.6f, d);
                this.renderPistonRodSN((float)par2 + 0.375f, (float)par2 + 0.625f, (float)par3 + 0.375f, (float)par3 + 0.375f, (float)par4 + 0.25f, (float)par4 + 0.25f + f1, f * 0.5f, d);
                this.renderPistonRodSN((float)par2 + 0.625f, (float)par2 + 0.375f, (float)par3 + 0.625f, (float)par3 + 0.625f, (float)par4 + 0.25f, (float)par4 + 0.25f + f1, f, d);
                break;
            }
            case 3: {
                this.uvRotateSouth = 2;
                this.uvRotateNorth = 1;
                this.uvRotateTop = 3;
                this.uvRotateBottom = 3;
                par1Block.setBlockBounds(0.0f, 0.0f, 0.75f, 1.0f, 1.0f, 1.0f);
                this.renderStandardBlock(par1Block, par2, par3, par4);
                this.renderPistonRodSN((float)par2 + 0.375f, (float)par2 + 0.375f, (float)par3 + 0.625f, (float)par3 + 0.375f, (float)par4 - 0.25f + 1.0f - f1, (float)par4 - 0.25f + 1.0f, f * 0.6f, d);
                this.renderPistonRodSN((float)par2 + 0.625f, (float)par2 + 0.625f, (float)par3 + 0.375f, (float)par3 + 0.625f, (float)par4 - 0.25f + 1.0f - f1, (float)par4 - 0.25f + 1.0f, f * 0.6f, d);
                this.renderPistonRodSN((float)par2 + 0.375f, (float)par2 + 0.625f, (float)par3 + 0.375f, (float)par3 + 0.375f, (float)par4 - 0.25f + 1.0f - f1, (float)par4 - 0.25f + 1.0f, f * 0.5f, d);
                this.renderPistonRodSN((float)par2 + 0.625f, (float)par2 + 0.375f, (float)par3 + 0.625f, (float)par3 + 0.625f, (float)par4 - 0.25f + 1.0f - f1, (float)par4 - 0.25f + 1.0f, f, d);
                break;
            }
            case 4: {
                this.uvRotateEast = 1;
                this.uvRotateWest = 2;
                this.uvRotateTop = 2;
                this.uvRotateBottom = 1;
                par1Block.setBlockBounds(0.0f, 0.0f, 0.0f, 0.25f, 1.0f, 1.0f);
                this.renderStandardBlock(par1Block, par2, par3, par4);
                this.renderPistonRodEW((float)par2 + 0.25f, (float)par2 + 0.25f + f1, (float)par3 + 0.375f, (float)par3 + 0.375f, (float)par4 + 0.625f, (float)par4 + 0.375f, f * 0.5f, d);
                this.renderPistonRodEW((float)par2 + 0.25f, (float)par2 + 0.25f + f1, (float)par3 + 0.625f, (float)par3 + 0.625f, (float)par4 + 0.375f, (float)par4 + 0.625f, f, d);
                this.renderPistonRodEW((float)par2 + 0.25f, (float)par2 + 0.25f + f1, (float)par3 + 0.375f, (float)par3 + 0.625f, (float)par4 + 0.375f, (float)par4 + 0.375f, f * 0.6f, d);
                this.renderPistonRodEW((float)par2 + 0.25f, (float)par2 + 0.25f + f1, (float)par3 + 0.625f, (float)par3 + 0.375f, (float)par4 + 0.625f, (float)par4 + 0.625f, f * 0.6f, d);
                break;
            }
            case 5: {
                this.uvRotateEast = 2;
                this.uvRotateWest = 1;
                this.uvRotateTop = 1;
                this.uvRotateBottom = 2;
                par1Block.setBlockBounds(0.75f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                this.renderStandardBlock(par1Block, par2, par3, par4);
                this.renderPistonRodEW((float)par2 - 0.25f + 1.0f - f1, (float)par2 - 0.25f + 1.0f, (float)par3 + 0.375f, (float)par3 + 0.375f, (float)par4 + 0.625f, (float)par4 + 0.375f, f * 0.5f, d);
                this.renderPistonRodEW((float)par2 - 0.25f + 1.0f - f1, (float)par2 - 0.25f + 1.0f, (float)par3 + 0.625f, (float)par3 + 0.625f, (float)par4 + 0.375f, (float)par4 + 0.625f, f, d);
                this.renderPistonRodEW((float)par2 - 0.25f + 1.0f - f1, (float)par2 - 0.25f + 1.0f, (float)par3 + 0.375f, (float)par3 + 0.625f, (float)par4 + 0.375f, (float)par4 + 0.375f, f * 0.6f, d);
                this.renderPistonRodEW((float)par2 - 0.25f + 1.0f - f1, (float)par2 - 0.25f + 1.0f, (float)par3 + 0.625f, (float)par3 + 0.375f, (float)par4 + 0.625f, (float)par4 + 0.625f, f * 0.6f, d);
            }
        }
        this.uvRotateEast = 0;
        this.uvRotateWest = 0;
        this.uvRotateSouth = 0;
        this.uvRotateNorth = 0;
        this.uvRotateTop = 0;
        this.uvRotateBottom = 0;
        par1Block.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        return true;
    }

    public boolean renderBlockLever(Block par1Block, int par2, int par3, int par4) {
        boolean flag1;
        int i = this.blockAccess.getBlockMetadata(par2, par3, par4);
        int j = i & 7;
        boolean flag = (i & 8) > 0;
        Tessellator tessellator = Tessellator.instance;
        boolean bl = flag1 = this.overrideBlockTexture >= 0;
        if (!flag1) {
            this.overrideBlockTexture = Block.cobblestone.blockIndexInTexture;
        }
        float f = 0.25f;
        float f1 = 0.1875f;
        float f2 = 0.1875f;
        if (j == 5) {
            par1Block.setBlockBounds(0.5f - f1, 0.0f, 0.5f - f, 0.5f + f1, f2, 0.5f + f);
        } else if (j == 6) {
            par1Block.setBlockBounds(0.5f - f, 0.0f, 0.5f - f1, 0.5f + f, f2, 0.5f + f1);
        } else if (j == 4) {
            par1Block.setBlockBounds(0.5f - f1, 0.5f - f, 1.0f - f2, 0.5f + f1, 0.5f + f, 1.0f);
        } else if (j == 3) {
            par1Block.setBlockBounds(0.5f - f1, 0.5f - f, 0.0f, 0.5f + f1, 0.5f + f, f2);
        } else if (j == 2) {
            par1Block.setBlockBounds(1.0f - f2, 0.5f - f, 0.5f - f1, 1.0f, 0.5f + f, 0.5f + f1);
        } else if (j == 1) {
            par1Block.setBlockBounds(0.0f, 0.5f - f, 0.5f - f1, f2, 0.5f + f, 0.5f + f1);
        }
        this.renderStandardBlock(par1Block, par2, par3, par4);
        if (!flag1) {
            this.overrideBlockTexture = -1;
        }
        tessellator.setBrightness(par1Block.getMixedBrightnessForBlock(this.blockAccess, par2, par3, par4));
        float f3 = 1.0f;
        if (Block.lightValue[par1Block.blockID] > 0) {
            f3 = 1.0f;
        }
        tessellator.setColorOpaque_F(f3, f3, f3);
        int k = par1Block.getBlockTextureFromSide(0);
        if (this.overrideBlockTexture >= 0) {
            k = this.overrideBlockTexture;
        }
        int l = (k & 0xF) << 4;
        int i1 = k & 0xF0;
        float f4 = (float)l / 256.0f;
        float f5 = ((float)l + 15.99f) / 256.0f;
        float f6 = (float)i1 / 256.0f;
        float f7 = ((float)i1 + 15.99f) / 256.0f;
        Vec3D[] avec3d = new Vec3D[8];
        float f8 = 0.0625f;
        float f9 = 0.0625f;
        float f10 = 0.625f;
        avec3d[0] = Vec3D.createVector(-f8, 0.0, -f9);
        avec3d[1] = Vec3D.createVector(f8, 0.0, -f9);
        avec3d[2] = Vec3D.createVector(f8, 0.0, f9);
        avec3d[3] = Vec3D.createVector(-f8, 0.0, f9);
        avec3d[4] = Vec3D.createVector(-f8, f10, -f9);
        avec3d[5] = Vec3D.createVector(f8, f10, -f9);
        avec3d[6] = Vec3D.createVector(f8, f10, f9);
        avec3d[7] = Vec3D.createVector(-f8, f10, f9);
        for (int j1 = 0; j1 < 8; ++j1) {
            if (flag) {
                avec3d[j1].zCoord -= 0.0625;
                avec3d[j1].rotateAroundX(0.69813174f);
            } else {
                avec3d[j1].zCoord += 0.0625;
                avec3d[j1].rotateAroundX(-0.69813174f);
            }
            if (j == 6) {
                avec3d[j1].rotateAroundY(1.5707964f);
            }
            if (j < 5) {
                avec3d[j1].yCoord -= 0.375;
                avec3d[j1].rotateAroundX(1.5707964f);
                if (j == 4) {
                    avec3d[j1].rotateAroundY(0.0f);
                }
                if (j == 3) {
                    avec3d[j1].rotateAroundY((float)Math.PI);
                }
                if (j == 2) {
                    avec3d[j1].rotateAroundY(1.5707964f);
                }
                if (j == 1) {
                    avec3d[j1].rotateAroundY(-1.5707964f);
                }
                avec3d[j1].xCoord += (double)par2 + 0.5;
                avec3d[j1].yCoord += (double)((float)par3 + 0.5f);
                avec3d[j1].zCoord += (double)par4 + 0.5;
                continue;
            }
            avec3d[j1].xCoord += (double)par2 + 0.5;
            avec3d[j1].yCoord += (double)((float)par3 + 0.125f);
            avec3d[j1].zCoord += (double)par4 + 0.5;
        }
        Vec3D vec3d = null;
        Vec3D vec3d1 = null;
        Vec3D vec3d2 = null;
        Vec3D vec3d3 = null;
        for (int k1 = 0; k1 < 6; ++k1) {
            if (k1 == 0) {
                f4 = (float)(l + 7) / 256.0f;
                f5 = ((float)(l + 9) - 0.01f) / 256.0f;
                f6 = (float)(i1 + 6) / 256.0f;
                f7 = ((float)(i1 + 8) - 0.01f) / 256.0f;
            } else if (k1 == 2) {
                f4 = (float)(l + 7) / 256.0f;
                f5 = ((float)(l + 9) - 0.01f) / 256.0f;
                f6 = (float)(i1 + 6) / 256.0f;
                f7 = ((float)(i1 + 16) - 0.01f) / 256.0f;
            }
            if (k1 == 0) {
                vec3d = avec3d[0];
                vec3d1 = avec3d[1];
                vec3d2 = avec3d[2];
                vec3d3 = avec3d[3];
            } else if (k1 == 1) {
                vec3d = avec3d[7];
                vec3d1 = avec3d[6];
                vec3d2 = avec3d[5];
                vec3d3 = avec3d[4];
            } else if (k1 == 2) {
                vec3d = avec3d[1];
                vec3d1 = avec3d[0];
                vec3d2 = avec3d[4];
                vec3d3 = avec3d[5];
            } else if (k1 == 3) {
                vec3d = avec3d[2];
                vec3d1 = avec3d[1];
                vec3d2 = avec3d[5];
                vec3d3 = avec3d[6];
            } else if (k1 == 4) {
                vec3d = avec3d[3];
                vec3d1 = avec3d[2];
                vec3d2 = avec3d[6];
                vec3d3 = avec3d[7];
            } else if (k1 == 5) {
                vec3d = avec3d[0];
                vec3d1 = avec3d[3];
                vec3d2 = avec3d[7];
                vec3d3 = avec3d[4];
            }
            tessellator.addVertexWithUV(vec3d.xCoord, vec3d.yCoord, vec3d.zCoord, f4, f7);
            tessellator.addVertexWithUV(vec3d1.xCoord, vec3d1.yCoord, vec3d1.zCoord, f5, f7);
            tessellator.addVertexWithUV(vec3d2.xCoord, vec3d2.yCoord, vec3d2.zCoord, f5, f6);
            tessellator.addVertexWithUV(vec3d3.xCoord, vec3d3.yCoord, vec3d3.zCoord, f4, f6);
        }
        return true;
    }

    public boolean renderBlockFire(Block par1Block, int par2, int par3, int par4) {
        Tessellator tessellator = Tessellator.instance;
        int i = par1Block.getBlockTextureFromSide(0);
        if (this.overrideBlockTexture >= 0) {
            i = this.overrideBlockTexture;
        }
        tessellator.setColorOpaque_F(1.0f, 1.0f, 1.0f);
        tessellator.setBrightness(par1Block.getMixedBrightnessForBlock(this.blockAccess, par2, par3, par4));
        int j = (i & 0xF) << 4;
        int k = i & 0xF0;
        double d = (float)j / 256.0f;
        double d1 = ((float)j + 15.99f) / 256.0f;
        double d2 = (float)k / 256.0f;
        double d3 = ((float)k + 15.99f) / 256.0f;
        float f = 1.4f;
        if (!this.blockAccess.isBlockNormalCube(par2, par3 - 1, par4) && !Block.fire.canBlockCatchFire(this.blockAccess, par2, par3 - 1, par4)) {
            float f1 = 0.2f;
            float f2 = 0.0625f;
            if ((par2 + par3 + par4 & 1) == 1) {
                d = (float)j / 256.0f;
                d1 = ((float)j + 15.99f) / 256.0f;
                d2 = (float)(k + 16) / 256.0f;
                d3 = ((float)k + 15.99f + 16.0f) / 256.0f;
            }
            if ((par2 / 2 + par3 / 2 + par4 / 2 & 1) == 1) {
                double d4 = d1;
                d1 = d;
                d = d4;
            }
            if (Block.fire.canBlockCatchFire(this.blockAccess, par2 - 1, par3, par4)) {
                tessellator.addVertexWithUV((float)par2 + f1, (float)par3 + f + f2, par4 + 1, d1, d2);
                tessellator.addVertexWithUV(par2 + 0, (float)(par3 + 0) + f2, par4 + 1, d1, d3);
                tessellator.addVertexWithUV(par2 + 0, (float)(par3 + 0) + f2, par4 + 0, d, d3);
                tessellator.addVertexWithUV((float)par2 + f1, (float)par3 + f + f2, par4 + 0, d, d2);
                tessellator.addVertexWithUV((float)par2 + f1, (float)par3 + f + f2, par4 + 0, d, d2);
                tessellator.addVertexWithUV(par2 + 0, (float)(par3 + 0) + f2, par4 + 0, d, d3);
                tessellator.addVertexWithUV(par2 + 0, (float)(par3 + 0) + f2, par4 + 1, d1, d3);
                tessellator.addVertexWithUV((float)par2 + f1, (float)par3 + f + f2, par4 + 1, d1, d2);
            }
            if (Block.fire.canBlockCatchFire(this.blockAccess, par2 + 1, par3, par4)) {
                tessellator.addVertexWithUV((float)(par2 + 1) - f1, (float)par3 + f + f2, par4 + 0, d, d2);
                tessellator.addVertexWithUV(par2 + 1 - 0, (float)(par3 + 0) + f2, par4 + 0, d, d3);
                tessellator.addVertexWithUV(par2 + 1 - 0, (float)(par3 + 0) + f2, par4 + 1, d1, d3);
                tessellator.addVertexWithUV((float)(par2 + 1) - f1, (float)par3 + f + f2, par4 + 1, d1, d2);
                tessellator.addVertexWithUV((float)(par2 + 1) - f1, (float)par3 + f + f2, par4 + 1, d1, d2);
                tessellator.addVertexWithUV(par2 + 1 - 0, (float)(par3 + 0) + f2, par4 + 1, d1, d3);
                tessellator.addVertexWithUV(par2 + 1 - 0, (float)(par3 + 0) + f2, par4 + 0, d, d3);
                tessellator.addVertexWithUV((float)(par2 + 1) - f1, (float)par3 + f + f2, par4 + 0, d, d2);
            }
            if (Block.fire.canBlockCatchFire(this.blockAccess, par2, par3, par4 - 1)) {
                tessellator.addVertexWithUV(par2 + 0, (float)par3 + f + f2, (float)par4 + f1, d1, d2);
                tessellator.addVertexWithUV(par2 + 0, (float)(par3 + 0) + f2, par4 + 0, d1, d3);
                tessellator.addVertexWithUV(par2 + 1, (float)(par3 + 0) + f2, par4 + 0, d, d3);
                tessellator.addVertexWithUV(par2 + 1, (float)par3 + f + f2, (float)par4 + f1, d, d2);
                tessellator.addVertexWithUV(par2 + 1, (float)par3 + f + f2, (float)par4 + f1, d, d2);
                tessellator.addVertexWithUV(par2 + 1, (float)(par3 + 0) + f2, par4 + 0, d, d3);
                tessellator.addVertexWithUV(par2 + 0, (float)(par3 + 0) + f2, par4 + 0, d1, d3);
                tessellator.addVertexWithUV(par2 + 0, (float)par3 + f + f2, (float)par4 + f1, d1, d2);
            }
            if (Block.fire.canBlockCatchFire(this.blockAccess, par2, par3, par4 + 1)) {
                tessellator.addVertexWithUV(par2 + 1, (float)par3 + f + f2, (float)(par4 + 1) - f1, d, d2);
                tessellator.addVertexWithUV(par2 + 1, (float)(par3 + 0) + f2, par4 + 1 - 0, d, d3);
                tessellator.addVertexWithUV(par2 + 0, (float)(par3 + 0) + f2, par4 + 1 - 0, d1, d3);
                tessellator.addVertexWithUV(par2 + 0, (float)par3 + f + f2, (float)(par4 + 1) - f1, d1, d2);
                tessellator.addVertexWithUV(par2 + 0, (float)par3 + f + f2, (float)(par4 + 1) - f1, d1, d2);
                tessellator.addVertexWithUV(par2 + 0, (float)(par3 + 0) + f2, par4 + 1 - 0, d1, d3);
                tessellator.addVertexWithUV(par2 + 1, (float)(par3 + 0) + f2, par4 + 1 - 0, d, d3);
                tessellator.addVertexWithUV(par2 + 1, (float)par3 + f + f2, (float)(par4 + 1) - f1, d, d2);
            }
            if (Block.fire.canBlockCatchFire(this.blockAccess, par2, par3 + 1, par4)) {
                double d5 = (double)par2 + 0.5 + 0.5;
                double d7 = (double)par2 + 0.5 - 0.5;
                double d9 = (double)par4 + 0.5 + 0.5;
                double d11 = (double)par4 + 0.5 - 0.5;
                double d13 = (double)par2 + 0.5 - 0.5;
                double d15 = (double)par2 + 0.5 + 0.5;
                double d17 = (double)par4 + 0.5 - 0.5;
                double d20 = (double)par4 + 0.5 + 0.5;
                d = (float)j / 256.0f;
                d1 = ((float)j + 15.99f) / 256.0f;
                d2 = (float)k / 256.0f;
                d3 = ((float)k + 15.99f) / 256.0f;
                f = -0.2f;
                if ((par2 + ++par3 + par4 & 1) == 0) {
                    tessellator.addVertexWithUV(d13, (float)par3 + f, par4 + 0, d1, d2);
                    tessellator.addVertexWithUV(d5, par3 + 0, par4 + 0, d1, d3);
                    tessellator.addVertexWithUV(d5, par3 + 0, par4 + 1, d, d3);
                    tessellator.addVertexWithUV(d13, (float)par3 + f, par4 + 1, d, d2);
                    d = (float)j / 256.0f;
                    d1 = ((float)j + 15.99f) / 256.0f;
                    d2 = (float)(k + 16) / 256.0f;
                    d3 = ((float)k + 15.99f + 16.0f) / 256.0f;
                    tessellator.addVertexWithUV(d15, (float)par3 + f, par4 + 1, d1, d2);
                    tessellator.addVertexWithUV(d7, par3 + 0, par4 + 1, d1, d3);
                    tessellator.addVertexWithUV(d7, par3 + 0, par4 + 0, d, d3);
                    tessellator.addVertexWithUV(d15, (float)par3 + f, par4 + 0, d, d2);
                } else {
                    tessellator.addVertexWithUV(par2 + 0, (float)par3 + f, d20, d1, d2);
                    tessellator.addVertexWithUV(par2 + 0, par3 + 0, d11, d1, d3);
                    tessellator.addVertexWithUV(par2 + 1, par3 + 0, d11, d, d3);
                    tessellator.addVertexWithUV(par2 + 1, (float)par3 + f, d20, d, d2);
                    d = (float)j / 256.0f;
                    d1 = ((float)j + 15.99f) / 256.0f;
                    d2 = (float)(k + 16) / 256.0f;
                    d3 = ((float)k + 15.99f + 16.0f) / 256.0f;
                    tessellator.addVertexWithUV(par2 + 1, (float)par3 + f, d17, d1, d2);
                    tessellator.addVertexWithUV(par2 + 1, par3 + 0, d9, d1, d3);
                    tessellator.addVertexWithUV(par2 + 0, par3 + 0, d9, d, d3);
                    tessellator.addVertexWithUV(par2 + 0, (float)par3 + f, d17, d, d2);
                }
            }
        } else {
            double d19 = (double)par2 + 0.5 + 0.2;
            double d6 = (double)par2 + 0.5 - 0.2;
            double d8 = (double)par4 + 0.5 + 0.2;
            double d10 = (double)par4 + 0.5 - 0.2;
            double d12 = (double)par2 + 0.5 - 0.3;
            double d14 = (double)par2 + 0.5 + 0.3;
            double d16 = (double)par4 + 0.5 - 0.3;
            double d18 = (double)par4 + 0.5 + 0.3;
            tessellator.addVertexWithUV(d12, (float)par3 + f, par4 + 1, d1, d2);
            tessellator.addVertexWithUV(d19, par3 + 0, par4 + 1, d1, d3);
            tessellator.addVertexWithUV(d19, par3 + 0, par4 + 0, d, d3);
            tessellator.addVertexWithUV(d12, (float)par3 + f, par4 + 0, d, d2);
            tessellator.addVertexWithUV(d14, (float)par3 + f, par4 + 0, d1, d2);
            tessellator.addVertexWithUV(d6, par3 + 0, par4 + 0, d1, d3);
            tessellator.addVertexWithUV(d6, par3 + 0, par4 + 1, d, d3);
            tessellator.addVertexWithUV(d14, (float)par3 + f, par4 + 1, d, d2);
            d = (float)j / 256.0f;
            d1 = ((float)j + 15.99f) / 256.0f;
            d2 = (float)(k + 16) / 256.0f;
            d3 = ((float)k + 15.99f + 16.0f) / 256.0f;
            tessellator.addVertexWithUV(par2 + 1, (float)par3 + f, d18, d1, d2);
            tessellator.addVertexWithUV(par2 + 1, par3 + 0, d10, d1, d3);
            tessellator.addVertexWithUV(par2 + 0, par3 + 0, d10, d, d3);
            tessellator.addVertexWithUV(par2 + 0, (float)par3 + f, d18, d, d2);
            tessellator.addVertexWithUV(par2 + 0, (float)par3 + f, d16, d1, d2);
            tessellator.addVertexWithUV(par2 + 0, par3 + 0, d8, d1, d3);
            tessellator.addVertexWithUV(par2 + 1, par3 + 0, d8, d, d3);
            tessellator.addVertexWithUV(par2 + 1, (float)par3 + f, d16, d, d2);
            d19 = (double)par2 + 0.5 - 0.5;
            d6 = (double)par2 + 0.5 + 0.5;
            d8 = (double)par4 + 0.5 - 0.5;
            d10 = (double)par4 + 0.5 + 0.5;
            d12 = (double)par2 + 0.5 - 0.4;
            d14 = (double)par2 + 0.5 + 0.4;
            d16 = (double)par4 + 0.5 - 0.4;
            d18 = (double)par4 + 0.5 + 0.4;
            tessellator.addVertexWithUV(d12, (float)par3 + f, par4 + 0, d, d2);
            tessellator.addVertexWithUV(d19, par3 + 0, par4 + 0, d, d3);
            tessellator.addVertexWithUV(d19, par3 + 0, par4 + 1, d1, d3);
            tessellator.addVertexWithUV(d12, (float)par3 + f, par4 + 1, d1, d2);
            tessellator.addVertexWithUV(d14, (float)par3 + f, par4 + 1, d, d2);
            tessellator.addVertexWithUV(d6, par3 + 0, par4 + 1, d, d3);
            tessellator.addVertexWithUV(d6, par3 + 0, par4 + 0, d1, d3);
            tessellator.addVertexWithUV(d14, (float)par3 + f, par4 + 0, d1, d2);
            d = (float)j / 256.0f;
            d1 = ((float)j + 15.99f) / 256.0f;
            d2 = (float)k / 256.0f;
            d3 = ((float)k + 15.99f) / 256.0f;
            tessellator.addVertexWithUV(par2 + 0, (float)par3 + f, d18, d, d2);
            tessellator.addVertexWithUV(par2 + 0, par3 + 0, d10, d, d3);
            tessellator.addVertexWithUV(par2 + 1, par3 + 0, d10, d1, d3);
            tessellator.addVertexWithUV(par2 + 1, (float)par3 + f, d18, d1, d2);
            tessellator.addVertexWithUV(par2 + 1, (float)par3 + f, d16, d, d2);
            tessellator.addVertexWithUV(par2 + 1, par3 + 0, d8, d, d3);
            tessellator.addVertexWithUV(par2 + 0, par3 + 0, d8, d1, d3);
            tessellator.addVertexWithUV(par2 + 0, (float)par3 + f, d16, d1, d2);
        }
        return true;
    }

    public boolean renderBlockRedstoneWire(Block par1Block, int par2, int par3, int par4) {
        boolean flag3;
        Tessellator tessellator = Tessellator.instance;
        int i = this.blockAccess.getBlockMetadata(par2, par3, par4);
        int j = par1Block.getBlockTextureFromSideAndMetadata(1, i);
        if (this.overrideBlockTexture >= 0) {
            j = this.overrideBlockTexture;
        }
        tessellator.setBrightness(par1Block.getMixedBrightnessForBlock(this.blockAccess, par2, par3, par4));
        float f = 1.0f;
        float f1 = (float)i / 15.0f;
        float f2 = f1 * 0.6f + 0.4f;
        if (i == 0) {
            f2 = 0.3f;
        }
        float f3 = f1 * f1 * 0.7f - 0.5f;
        float f4 = f1 * f1 * 0.6f - 0.7f;
        if (f3 < 0.0f) {
            f3 = 0.0f;
        }
        if (f4 < 0.0f) {
            f4 = 0.0f;
        }
        tessellator.setColorOpaque_F(f2, f3, f4);
        int k = (j & 0xF) << 4;
        int l = j & 0xF0;
        double d = (float)k / 256.0f;
        double d2 = ((float)k + 15.99f) / 256.0f;
        double d4 = (float)l / 256.0f;
        double d6 = ((float)l + 15.99f) / 256.0f;
        boolean flag = BlockRedstoneWire.isPowerProviderOrWire(this.blockAccess, par2 - 1, par3, par4, 1) || !this.blockAccess.isBlockNormalCube(par2 - 1, par3, par4) && BlockRedstoneWire.isPowerProviderOrWire(this.blockAccess, par2 - 1, par3 - 1, par4, -1);
        boolean flag1 = BlockRedstoneWire.isPowerProviderOrWire(this.blockAccess, par2 + 1, par3, par4, 3) || !this.blockAccess.isBlockNormalCube(par2 + 1, par3, par4) && BlockRedstoneWire.isPowerProviderOrWire(this.blockAccess, par2 + 1, par3 - 1, par4, -1);
        boolean flag2 = BlockRedstoneWire.isPowerProviderOrWire(this.blockAccess, par2, par3, par4 - 1, 2) || !this.blockAccess.isBlockNormalCube(par2, par3, par4 - 1) && BlockRedstoneWire.isPowerProviderOrWire(this.blockAccess, par2, par3 - 1, par4 - 1, -1);
        boolean bl = flag3 = BlockRedstoneWire.isPowerProviderOrWire(this.blockAccess, par2, par3, par4 + 1, 0) || !this.blockAccess.isBlockNormalCube(par2, par3, par4 + 1) && BlockRedstoneWire.isPowerProviderOrWire(this.blockAccess, par2, par3 - 1, par4 + 1, -1);
        if (!this.blockAccess.isBlockNormalCube(par2, par3 + 1, par4)) {
            if (this.blockAccess.isBlockNormalCube(par2 - 1, par3, par4) && BlockRedstoneWire.isPowerProviderOrWire(this.blockAccess, par2 - 1, par3 + 1, par4, -1)) {
                flag = true;
            }
            if (this.blockAccess.isBlockNormalCube(par2 + 1, par3, par4) && BlockRedstoneWire.isPowerProviderOrWire(this.blockAccess, par2 + 1, par3 + 1, par4, -1)) {
                flag1 = true;
            }
            if (this.blockAccess.isBlockNormalCube(par2, par3, par4 - 1) && BlockRedstoneWire.isPowerProviderOrWire(this.blockAccess, par2, par3 + 1, par4 - 1, -1)) {
                flag2 = true;
            }
            if (this.blockAccess.isBlockNormalCube(par2, par3, par4 + 1) && BlockRedstoneWire.isPowerProviderOrWire(this.blockAccess, par2, par3 + 1, par4 + 1, -1)) {
                flag3 = true;
            }
        }
        float f5 = par2 + 0;
        float f6 = par2 + 1;
        float f7 = par4 + 0;
        float f8 = par4 + 1;
        int byte0 = 0;
        if ((flag || flag1) && !flag2 && !flag3) {
            byte0 = 1;
        }
        if ((flag2 || flag3) && !flag1 && !flag) {
            byte0 = 2;
        }
        if (byte0 != 0) {
            d = (float)(k + 16) / 256.0f;
            d2 = ((float)(k + 16) + 15.99f) / 256.0f;
            d4 = (float)l / 256.0f;
            d6 = ((float)l + 15.99f) / 256.0f;
        }
        if (byte0 == 0) {
            if (!flag) {
                f5 += 0.3125f;
            }
            if (!flag) {
                d += 0.01953125;
            }
            if (!flag1) {
                f6 -= 0.3125f;
            }
            if (!flag1) {
                d2 -= 0.01953125;
            }
            if (!flag2) {
                f7 += 0.3125f;
            }
            if (!flag2) {
                d4 += 0.01953125;
            }
            if (!flag3) {
                f8 -= 0.3125f;
            }
            if (!flag3) {
                d6 -= 0.01953125;
            }
            tessellator.addVertexWithUV(f6, (double)par3 + 0.015625, f8, d2, d6);
            tessellator.addVertexWithUV(f6, (double)par3 + 0.015625, f7, d2, d4);
            tessellator.addVertexWithUV(f5, (double)par3 + 0.015625, f7, d, d4);
            tessellator.addVertexWithUV(f5, (double)par3 + 0.015625, f8, d, d6);
            tessellator.setColorOpaque_F(f, f, f);
            tessellator.addVertexWithUV(f6, (double)par3 + 0.015625, f8, d2, d6 + 0.0625);
            tessellator.addVertexWithUV(f6, (double)par3 + 0.015625, f7, d2, d4 + 0.0625);
            tessellator.addVertexWithUV(f5, (double)par3 + 0.015625, f7, d, d4 + 0.0625);
            tessellator.addVertexWithUV(f5, (double)par3 + 0.015625, f8, d, d6 + 0.0625);
        } else if (byte0 == 1) {
            tessellator.addVertexWithUV(f6, (double)par3 + 0.015625, f8, d2, d6);
            tessellator.addVertexWithUV(f6, (double)par3 + 0.015625, f7, d2, d4);
            tessellator.addVertexWithUV(f5, (double)par3 + 0.015625, f7, d, d4);
            tessellator.addVertexWithUV(f5, (double)par3 + 0.015625, f8, d, d6);
            tessellator.setColorOpaque_F(f, f, f);
            tessellator.addVertexWithUV(f6, (double)par3 + 0.015625, f8, d2, d6 + 0.0625);
            tessellator.addVertexWithUV(f6, (double)par3 + 0.015625, f7, d2, d4 + 0.0625);
            tessellator.addVertexWithUV(f5, (double)par3 + 0.015625, f7, d, d4 + 0.0625);
            tessellator.addVertexWithUV(f5, (double)par3 + 0.015625, f8, d, d6 + 0.0625);
        } else if (byte0 == 2) {
            tessellator.addVertexWithUV(f6, (double)par3 + 0.015625, f8, d2, d6);
            tessellator.addVertexWithUV(f6, (double)par3 + 0.015625, f7, d, d6);
            tessellator.addVertexWithUV(f5, (double)par3 + 0.015625, f7, d, d4);
            tessellator.addVertexWithUV(f5, (double)par3 + 0.015625, f8, d2, d4);
            tessellator.setColorOpaque_F(f, f, f);
            tessellator.addVertexWithUV(f6, (double)par3 + 0.015625, f8, d2, d6 + 0.0625);
            tessellator.addVertexWithUV(f6, (double)par3 + 0.015625, f7, d, d6 + 0.0625);
            tessellator.addVertexWithUV(f5, (double)par3 + 0.015625, f7, d, d4 + 0.0625);
            tessellator.addVertexWithUV(f5, (double)par3 + 0.015625, f8, d2, d4 + 0.0625);
        }
        if (!this.blockAccess.isBlockNormalCube(par2, par3 + 1, par4)) {
            double d1 = (float)(k + 16) / 256.0f;
            double d3 = ((float)(k + 16) + 15.99f) / 256.0f;
            double d5 = (float)l / 256.0f;
            double d7 = ((float)l + 15.99f) / 256.0f;
            if (this.blockAccess.isBlockNormalCube(par2 - 1, par3, par4) && this.blockAccess.getBlockId(par2 - 1, par3 + 1, par4) == Block.redstoneWire.blockID) {
                tessellator.setColorOpaque_F(f * f2, f * f3, f * f4);
                tessellator.addVertexWithUV((double)par2 + 0.015625, (float)(par3 + 1) + 0.021875f, par4 + 1, d3, d5);
                tessellator.addVertexWithUV((double)par2 + 0.015625, par3 + 0, par4 + 1, d1, d5);
                tessellator.addVertexWithUV((double)par2 + 0.015625, par3 + 0, par4 + 0, d1, d7);
                tessellator.addVertexWithUV((double)par2 + 0.015625, (float)(par3 + 1) + 0.021875f, par4 + 0, d3, d7);
                tessellator.setColorOpaque_F(f, f, f);
                tessellator.addVertexWithUV((double)par2 + 0.015625, (float)(par3 + 1) + 0.021875f, par4 + 1, d3, d5 + 0.0625);
                tessellator.addVertexWithUV((double)par2 + 0.015625, par3 + 0, par4 + 1, d1, d5 + 0.0625);
                tessellator.addVertexWithUV((double)par2 + 0.015625, par3 + 0, par4 + 0, d1, d7 + 0.0625);
                tessellator.addVertexWithUV((double)par2 + 0.015625, (float)(par3 + 1) + 0.021875f, par4 + 0, d3, d7 + 0.0625);
            }
            if (this.blockAccess.isBlockNormalCube(par2 + 1, par3, par4) && this.blockAccess.getBlockId(par2 + 1, par3 + 1, par4) == Block.redstoneWire.blockID) {
                tessellator.setColorOpaque_F(f * f2, f * f3, f * f4);
                tessellator.addVertexWithUV((double)(par2 + 1) - 0.015625, par3 + 0, par4 + 1, d1, d7);
                tessellator.addVertexWithUV((double)(par2 + 1) - 0.015625, (float)(par3 + 1) + 0.021875f, par4 + 1, d3, d7);
                tessellator.addVertexWithUV((double)(par2 + 1) - 0.015625, (float)(par3 + 1) + 0.021875f, par4 + 0, d3, d5);
                tessellator.addVertexWithUV((double)(par2 + 1) - 0.015625, par3 + 0, par4 + 0, d1, d5);
                tessellator.setColorOpaque_F(f, f, f);
                tessellator.addVertexWithUV((double)(par2 + 1) - 0.015625, par3 + 0, par4 + 1, d1, d7 + 0.0625);
                tessellator.addVertexWithUV((double)(par2 + 1) - 0.015625, (float)(par3 + 1) + 0.021875f, par4 + 1, d3, d7 + 0.0625);
                tessellator.addVertexWithUV((double)(par2 + 1) - 0.015625, (float)(par3 + 1) + 0.021875f, par4 + 0, d3, d5 + 0.0625);
                tessellator.addVertexWithUV((double)(par2 + 1) - 0.015625, par3 + 0, par4 + 0, d1, d5 + 0.0625);
            }
            if (this.blockAccess.isBlockNormalCube(par2, par3, par4 - 1) && this.blockAccess.getBlockId(par2, par3 + 1, par4 - 1) == Block.redstoneWire.blockID) {
                tessellator.setColorOpaque_F(f * f2, f * f3, f * f4);
                tessellator.addVertexWithUV(par2 + 1, par3 + 0, (double)par4 + 0.015625, d1, d7);
                tessellator.addVertexWithUV(par2 + 1, (float)(par3 + 1) + 0.021875f, (double)par4 + 0.015625, d3, d7);
                tessellator.addVertexWithUV(par2 + 0, (float)(par3 + 1) + 0.021875f, (double)par4 + 0.015625, d3, d5);
                tessellator.addVertexWithUV(par2 + 0, par3 + 0, (double)par4 + 0.015625, d1, d5);
                tessellator.setColorOpaque_F(f, f, f);
                tessellator.addVertexWithUV(par2 + 1, par3 + 0, (double)par4 + 0.015625, d1, d7 + 0.0625);
                tessellator.addVertexWithUV(par2 + 1, (float)(par3 + 1) + 0.021875f, (double)par4 + 0.015625, d3, d7 + 0.0625);
                tessellator.addVertexWithUV(par2 + 0, (float)(par3 + 1) + 0.021875f, (double)par4 + 0.015625, d3, d5 + 0.0625);
                tessellator.addVertexWithUV(par2 + 0, par3 + 0, (double)par4 + 0.015625, d1, d5 + 0.0625);
            }
            if (this.blockAccess.isBlockNormalCube(par2, par3, par4 + 1) && this.blockAccess.getBlockId(par2, par3 + 1, par4 + 1) == Block.redstoneWire.blockID) {
                tessellator.setColorOpaque_F(f * f2, f * f3, f * f4);
                tessellator.addVertexWithUV(par2 + 1, (float)(par3 + 1) + 0.021875f, (double)(par4 + 1) - 0.015625, d3, d5);
                tessellator.addVertexWithUV(par2 + 1, par3 + 0, (double)(par4 + 1) - 0.015625, d1, d5);
                tessellator.addVertexWithUV(par2 + 0, par3 + 0, (double)(par4 + 1) - 0.015625, d1, d7);
                tessellator.addVertexWithUV(par2 + 0, (float)(par3 + 1) + 0.021875f, (double)(par4 + 1) - 0.015625, d3, d7);
                tessellator.setColorOpaque_F(f, f, f);
                tessellator.addVertexWithUV(par2 + 1, (float)(par3 + 1) + 0.021875f, (double)(par4 + 1) - 0.015625, d3, d5 + 0.0625);
                tessellator.addVertexWithUV(par2 + 1, par3 + 0, (double)(par4 + 1) - 0.015625, d1, d5 + 0.0625);
                tessellator.addVertexWithUV(par2 + 0, par3 + 0, (double)(par4 + 1) - 0.015625, d1, d7 + 0.0625);
                tessellator.addVertexWithUV(par2 + 0, (float)(par3 + 1) + 0.021875f, (double)(par4 + 1) - 0.015625, d3, d7 + 0.0625);
            }
        }
        return true;
    }

    public boolean renderBlockMinecartTrack(BlockRail par1BlockRail, int par2, int par3, int par4) {
        Tessellator tessellator = Tessellator.instance;
        int i = this.blockAccess.getBlockMetadata(par2, par3, par4);
        int j = par1BlockRail.getBlockTextureFromSideAndMetadata(0, i);
        if (this.overrideBlockTexture >= 0) {
            j = this.overrideBlockTexture;
        }
        if (par1BlockRail.isPowered()) {
            i &= 7;
        }
        tessellator.setBrightness(par1BlockRail.getMixedBrightnessForBlock(this.blockAccess, par2, par3, par4));
        tessellator.setColorOpaque_F(1.0f, 1.0f, 1.0f);
        int k = (j & 0xF) << 4;
        int l = j & 0xF0;
        double d = (float)k / 256.0f;
        double d1 = ((float)k + 15.99f) / 256.0f;
        double d2 = (float)l / 256.0f;
        double d3 = ((float)l + 15.99f) / 256.0f;
        double d4 = 0.0625;
        double d5 = par2 + 1;
        double d6 = par2 + 1;
        double d7 = par2 + 0;
        double d8 = par2 + 0;
        double d9 = par4 + 0;
        double d10 = par4 + 1;
        double d11 = par4 + 1;
        double d12 = par4 + 0;
        double d13 = (double)par3 + d4;
        double d14 = (double)par3 + d4;
        double d15 = (double)par3 + d4;
        double d16 = (double)par3 + d4;
        if (i != 1 && i != 2 && i != 3 && i != 7) {
            if (i == 8) {
                d5 = d6 = (double)(par2 + 0);
                d7 = d8 = (double)(par2 + 1);
                d9 = d12 = (double)(par4 + 1);
                d10 = d11 = (double)(par4 + 0);
            } else if (i == 9) {
                d5 = d8 = (double)(par2 + 0);
                d6 = d7 = (double)(par2 + 1);
                d9 = d10 = (double)(par4 + 0);
                d11 = d12 = (double)(par4 + 1);
            }
        } else {
            d5 = d8 = (double)(par2 + 1);
            d6 = d7 = (double)(par2 + 0);
            d9 = d10 = (double)(par4 + 1);
            d11 = d12 = (double)(par4 + 0);
        }
        if (i != 2 && i != 4) {
            if (i == 3 || i == 5) {
                d14 += 1.0;
                d15 += 1.0;
            }
        } else {
            d13 += 1.0;
            d16 += 1.0;
        }
        tessellator.addVertexWithUV(d5, d13, d9, d1, d2);
        tessellator.addVertexWithUV(d6, d14, d10, d1, d3);
        tessellator.addVertexWithUV(d7, d15, d11, d, d3);
        tessellator.addVertexWithUV(d8, d16, d12, d, d2);
        tessellator.addVertexWithUV(d8, d16, d12, d, d2);
        tessellator.addVertexWithUV(d7, d15, d11, d, d3);
        tessellator.addVertexWithUV(d6, d14, d10, d1, d3);
        tessellator.addVertexWithUV(d5, d13, d9, d1, d2);
        return true;
    }

    public boolean renderBlockLadder(Block par1Block, int par2, int par3, int par4) {
        Tessellator tessellator = Tessellator.instance;
        int i = par1Block.getBlockTextureFromSide(0);
        if (this.overrideBlockTexture >= 0) {
            i = this.overrideBlockTexture;
        }
        tessellator.setBrightness(par1Block.getMixedBrightnessForBlock(this.blockAccess, par2, par3, par4));
        float f = 1.0f;
        tessellator.setColorOpaque_F(f, f, f);
        int j = (i & 0xF) << 4;
        int k = i & 0xF0;
        double d = (float)j / 256.0f;
        double d1 = ((float)j + 15.99f) / 256.0f;
        double d2 = (float)k / 256.0f;
        double d3 = ((float)k + 15.99f) / 256.0f;
        int l = this.blockAccess.getBlockMetadata(par2, par3, par4);
        double d4 = 0.0;
        double d5 = 0.05f;
        if (l == 5) {
            tessellator.addVertexWithUV((double)par2 + d5, (double)(par3 + 1) + d4, (double)(par4 + 1) + d4, d, d2);
            tessellator.addVertexWithUV((double)par2 + d5, (double)(par3 + 0) - d4, (double)(par4 + 1) + d4, d, d3);
            tessellator.addVertexWithUV((double)par2 + d5, (double)(par3 + 0) - d4, (double)(par4 + 0) - d4, d1, d3);
            tessellator.addVertexWithUV((double)par2 + d5, (double)(par3 + 1) + d4, (double)(par4 + 0) - d4, d1, d2);
        }
        if (l == 4) {
            tessellator.addVertexWithUV((double)(par2 + 1) - d5, (double)(par3 + 0) - d4, (double)(par4 + 1) + d4, d1, d3);
            tessellator.addVertexWithUV((double)(par2 + 1) - d5, (double)(par3 + 1) + d4, (double)(par4 + 1) + d4, d1, d2);
            tessellator.addVertexWithUV((double)(par2 + 1) - d5, (double)(par3 + 1) + d4, (double)(par4 + 0) - d4, d, d2);
            tessellator.addVertexWithUV((double)(par2 + 1) - d5, (double)(par3 + 0) - d4, (double)(par4 + 0) - d4, d, d3);
        }
        if (l == 3) {
            tessellator.addVertexWithUV((double)(par2 + 1) + d4, (double)(par3 + 0) - d4, (double)par4 + d5, d1, d3);
            tessellator.addVertexWithUV((double)(par2 + 1) + d4, (double)(par3 + 1) + d4, (double)par4 + d5, d1, d2);
            tessellator.addVertexWithUV((double)(par2 + 0) - d4, (double)(par3 + 1) + d4, (double)par4 + d5, d, d2);
            tessellator.addVertexWithUV((double)(par2 + 0) - d4, (double)(par3 + 0) - d4, (double)par4 + d5, d, d3);
        }
        if (l == 2) {
            tessellator.addVertexWithUV((double)(par2 + 1) + d4, (double)(par3 + 1) + d4, (double)(par4 + 1) - d5, d, d2);
            tessellator.addVertexWithUV((double)(par2 + 1) + d4, (double)(par3 + 0) - d4, (double)(par4 + 1) - d5, d, d3);
            tessellator.addVertexWithUV((double)(par2 + 0) - d4, (double)(par3 + 0) - d4, (double)(par4 + 1) - d5, d1, d3);
            tessellator.addVertexWithUV((double)(par2 + 0) - d4, (double)(par3 + 1) + d4, (double)(par4 + 1) - d5, d1, d2);
        }
        return true;
    }

    public boolean renderBlockVine(Block par1Block, int par2, int par3, int par4) {
        Tessellator tessellator = Tessellator.instance;
        int i = par1Block.getBlockTextureFromSide(0);
        if (this.overrideBlockTexture >= 0) {
            i = this.overrideBlockTexture;
        }
        float f = 1.0f;
        tessellator.setBrightness(par1Block.getMixedBrightnessForBlock(this.blockAccess, par2, par3, par4));
        int j = par1Block.colorMultiplier(this.blockAccess, par2, par3, par4);
        float f1 = (float)(j >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(j >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(j & 0xFF) / 255.0f;
        tessellator.setColorOpaque_F(f * f1, f * f2, f * f3);
        j = (i & 0xF) << 4;
        int k = i & 0xF0;
        double d = (float)j / 256.0f;
        double d1 = ((float)j + 15.99f) / 256.0f;
        double d2 = (float)k / 256.0f;
        double d3 = ((float)k + 15.99f) / 256.0f;
        double d4 = 0.05f;
        int l = this.blockAccess.getBlockMetadata(par2, par3, par4);
        if ((l & 2) != 0) {
            tessellator.addVertexWithUV((double)par2 + d4, par3 + 1, par4 + 1, d, d2);
            tessellator.addVertexWithUV((double)par2 + d4, par3 + 0, par4 + 1, d, d3);
            tessellator.addVertexWithUV((double)par2 + d4, par3 + 0, par4 + 0, d1, d3);
            tessellator.addVertexWithUV((double)par2 + d4, par3 + 1, par4 + 0, d1, d2);
            tessellator.addVertexWithUV((double)par2 + d4, par3 + 1, par4 + 0, d1, d2);
            tessellator.addVertexWithUV((double)par2 + d4, par3 + 0, par4 + 0, d1, d3);
            tessellator.addVertexWithUV((double)par2 + d4, par3 + 0, par4 + 1, d, d3);
            tessellator.addVertexWithUV((double)par2 + d4, par3 + 1, par4 + 1, d, d2);
        }
        if ((l & 8) != 0) {
            tessellator.addVertexWithUV((double)(par2 + 1) - d4, par3 + 0, par4 + 1, d1, d3);
            tessellator.addVertexWithUV((double)(par2 + 1) - d4, par3 + 1, par4 + 1, d1, d2);
            tessellator.addVertexWithUV((double)(par2 + 1) - d4, par3 + 1, par4 + 0, d, d2);
            tessellator.addVertexWithUV((double)(par2 + 1) - d4, par3 + 0, par4 + 0, d, d3);
            tessellator.addVertexWithUV((double)(par2 + 1) - d4, par3 + 0, par4 + 0, d, d3);
            tessellator.addVertexWithUV((double)(par2 + 1) - d4, par3 + 1, par4 + 0, d, d2);
            tessellator.addVertexWithUV((double)(par2 + 1) - d4, par3 + 1, par4 + 1, d1, d2);
            tessellator.addVertexWithUV((double)(par2 + 1) - d4, par3 + 0, par4 + 1, d1, d3);
        }
        if ((l & 4) != 0) {
            tessellator.addVertexWithUV(par2 + 1, par3 + 0, (double)par4 + d4, d1, d3);
            tessellator.addVertexWithUV(par2 + 1, par3 + 1, (double)par4 + d4, d1, d2);
            tessellator.addVertexWithUV(par2 + 0, par3 + 1, (double)par4 + d4, d, d2);
            tessellator.addVertexWithUV(par2 + 0, par3 + 0, (double)par4 + d4, d, d3);
            tessellator.addVertexWithUV(par2 + 0, par3 + 0, (double)par4 + d4, d, d3);
            tessellator.addVertexWithUV(par2 + 0, par3 + 1, (double)par4 + d4, d, d2);
            tessellator.addVertexWithUV(par2 + 1, par3 + 1, (double)par4 + d4, d1, d2);
            tessellator.addVertexWithUV(par2 + 1, par3 + 0, (double)par4 + d4, d1, d3);
        }
        if ((l & 1) != 0) {
            tessellator.addVertexWithUV(par2 + 1, par3 + 1, (double)(par4 + 1) - d4, d, d2);
            tessellator.addVertexWithUV(par2 + 1, par3 + 0, (double)(par4 + 1) - d4, d, d3);
            tessellator.addVertexWithUV(par2 + 0, par3 + 0, (double)(par4 + 1) - d4, d1, d3);
            tessellator.addVertexWithUV(par2 + 0, par3 + 1, (double)(par4 + 1) - d4, d1, d2);
            tessellator.addVertexWithUV(par2 + 0, par3 + 1, (double)(par4 + 1) - d4, d1, d2);
            tessellator.addVertexWithUV(par2 + 0, par3 + 0, (double)(par4 + 1) - d4, d1, d3);
            tessellator.addVertexWithUV(par2 + 1, par3 + 0, (double)(par4 + 1) - d4, d, d3);
            tessellator.addVertexWithUV(par2 + 1, par3 + 1, (double)(par4 + 1) - d4, d, d2);
        }
        if (this.blockAccess.isBlockNormalCube(par2, par3 + 1, par4)) {
            tessellator.addVertexWithUV(par2 + 1, (double)(par3 + 1) - d4, par4 + 0, d, d2);
            tessellator.addVertexWithUV(par2 + 1, (double)(par3 + 1) - d4, par4 + 1, d, d3);
            tessellator.addVertexWithUV(par2 + 0, (double)(par3 + 1) - d4, par4 + 1, d1, d3);
            tessellator.addVertexWithUV(par2 + 0, (double)(par3 + 1) - d4, par4 + 0, d1, d2);
        }
        return true;
    }

    public boolean renderBlockPane(BlockPane par1BlockPane, int par2, int par3, int par4) {
        int j1;
        int i1;
        int i = this.blockAccess.getHeight();
        Tessellator tessellator = Tessellator.instance;
        tessellator.setBrightness(par1BlockPane.getMixedBrightnessForBlock(this.blockAccess, par2, par3, par4));
        float f = 1.0f;
        int j = par1BlockPane.colorMultiplier(this.blockAccess, par2, par3, par4);
        float f1 = (float)(j >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(j >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(j & 0xFF) / 255.0f;
        if (EntityRenderer.anaglyphEnable) {
            float f4 = (f1 * 30.0f + f2 * 59.0f + f3 * 11.0f) / 100.0f;
            float f5 = (f1 * 30.0f + f2 * 70.0f) / 100.0f;
            float f6 = (f1 * 30.0f + f3 * 70.0f) / 100.0f;
            f1 = f4;
            f2 = f5;
            f3 = f6;
        }
        tessellator.setColorOpaque_F(f * f1, f * f2, f * f3);
        boolean flag = false;
        boolean flag1 = false;
        if (this.overrideBlockTexture >= 0) {
            i1 = this.overrideBlockTexture;
            j1 = this.overrideBlockTexture;
        } else {
            int k = this.blockAccess.getBlockMetadata(par2, par3, par4);
            i1 = par1BlockPane.getBlockTextureFromSideAndMetadata(0, k);
            j1 = par1BlockPane.getSideTextureIndex();
        }
        int l = (i1 & 0xF) << 4;
        int k1 = i1 & 0xF0;
        double d = (float)l / 256.0f;
        double d1 = ((float)l + 7.99f) / 256.0f;
        double d2 = ((float)l + 15.99f) / 256.0f;
        double d3 = (float)k1 / 256.0f;
        double d4 = ((float)k1 + 15.99f) / 256.0f;
        int l1 = (j1 & 0xF) << 4;
        int i2 = j1 & 0xF0;
        double d5 = (float)(l1 + 7) / 256.0f;
        double d6 = ((float)l1 + 8.99f) / 256.0f;
        double d7 = (float)i2 / 256.0f;
        double d8 = (float)(i2 + 8) / 256.0f;
        double d9 = ((float)i2 + 15.99f) / 256.0f;
        double d10 = par2;
        double d11 = (double)par2 + 0.5;
        double d12 = par2 + 1;
        double d13 = par4;
        double d14 = (double)par4 + 0.5;
        double d15 = par4 + 1;
        double d16 = (double)par2 + 0.5 - 0.0625;
        double d17 = (double)par2 + 0.5 + 0.0625;
        double d18 = (double)par4 + 0.5 - 0.0625;
        double d19 = (double)par4 + 0.5 + 0.0625;
        boolean flag2 = par1BlockPane.canThisPaneConnectToThisBlockID(this.blockAccess.getBlockId(par2, par3, par4 - 1));
        boolean flag3 = par1BlockPane.canThisPaneConnectToThisBlockID(this.blockAccess.getBlockId(par2, par3, par4 + 1));
        boolean flag4 = par1BlockPane.canThisPaneConnectToThisBlockID(this.blockAccess.getBlockId(par2 - 1, par3, par4));
        boolean flag5 = par1BlockPane.canThisPaneConnectToThisBlockID(this.blockAccess.getBlockId(par2 + 1, par3, par4));
        boolean flag6 = par1BlockPane.shouldSideBeRendered(this.blockAccess, par2, par3 + 1, par4, 1);
        boolean flag7 = par1BlockPane.shouldSideBeRendered(this.blockAccess, par2, par3 - 1, par4, 0);
        if ((!flag4 || !flag5) && (flag4 || flag5 || flag2 || flag3)) {
            if (flag4 && !flag5) {
                tessellator.addVertexWithUV(d10, par3 + 1, d14, d, d3);
                tessellator.addVertexWithUV(d10, par3 + 0, d14, d, d4);
                tessellator.addVertexWithUV(d11, par3 + 0, d14, d1, d4);
                tessellator.addVertexWithUV(d11, par3 + 1, d14, d1, d3);
                tessellator.addVertexWithUV(d11, par3 + 1, d14, d, d3);
                tessellator.addVertexWithUV(d11, par3 + 0, d14, d, d4);
                tessellator.addVertexWithUV(d10, par3 + 0, d14, d1, d4);
                tessellator.addVertexWithUV(d10, par3 + 1, d14, d1, d3);
                if (!flag3 && !flag2) {
                    tessellator.addVertexWithUV(d11, par3 + 1, d19, d5, d7);
                    tessellator.addVertexWithUV(d11, par3 + 0, d19, d5, d9);
                    tessellator.addVertexWithUV(d11, par3 + 0, d18, d6, d9);
                    tessellator.addVertexWithUV(d11, par3 + 1, d18, d6, d7);
                    tessellator.addVertexWithUV(d11, par3 + 1, d18, d5, d7);
                    tessellator.addVertexWithUV(d11, par3 + 0, d18, d5, d9);
                    tessellator.addVertexWithUV(d11, par3 + 0, d19, d6, d9);
                    tessellator.addVertexWithUV(d11, par3 + 1, d19, d6, d7);
                }
                if (flag6 || par3 < i - 1 && this.blockAccess.isAirBlock(par2 - 1, par3 + 1, par4)) {
                    tessellator.addVertexWithUV(d10, (double)(par3 + 1) + 0.01, d19, d6, d8);
                    tessellator.addVertexWithUV(d11, (double)(par3 + 1) + 0.01, d19, d6, d9);
                    tessellator.addVertexWithUV(d11, (double)(par3 + 1) + 0.01, d18, d5, d9);
                    tessellator.addVertexWithUV(d10, (double)(par3 + 1) + 0.01, d18, d5, d8);
                    tessellator.addVertexWithUV(d11, (double)(par3 + 1) + 0.01, d19, d6, d8);
                    tessellator.addVertexWithUV(d10, (double)(par3 + 1) + 0.01, d19, d6, d9);
                    tessellator.addVertexWithUV(d10, (double)(par3 + 1) + 0.01, d18, d5, d9);
                    tessellator.addVertexWithUV(d11, (double)(par3 + 1) + 0.01, d18, d5, d8);
                }
                if (flag7 || par3 > 1 && this.blockAccess.isAirBlock(par2 - 1, par3 - 1, par4)) {
                    tessellator.addVertexWithUV(d10, (double)par3 - 0.01, d19, d6, d8);
                    tessellator.addVertexWithUV(d11, (double)par3 - 0.01, d19, d6, d9);
                    tessellator.addVertexWithUV(d11, (double)par3 - 0.01, d18, d5, d9);
                    tessellator.addVertexWithUV(d10, (double)par3 - 0.01, d18, d5, d8);
                    tessellator.addVertexWithUV(d11, (double)par3 - 0.01, d19, d6, d8);
                    tessellator.addVertexWithUV(d10, (double)par3 - 0.01, d19, d6, d9);
                    tessellator.addVertexWithUV(d10, (double)par3 - 0.01, d18, d5, d9);
                    tessellator.addVertexWithUV(d11, (double)par3 - 0.01, d18, d5, d8);
                }
            } else if (!flag4 && flag5) {
                tessellator.addVertexWithUV(d11, par3 + 1, d14, d1, d3);
                tessellator.addVertexWithUV(d11, par3 + 0, d14, d1, d4);
                tessellator.addVertexWithUV(d12, par3 + 0, d14, d2, d4);
                tessellator.addVertexWithUV(d12, par3 + 1, d14, d2, d3);
                tessellator.addVertexWithUV(d12, par3 + 1, d14, d1, d3);
                tessellator.addVertexWithUV(d12, par3 + 0, d14, d1, d4);
                tessellator.addVertexWithUV(d11, par3 + 0, d14, d2, d4);
                tessellator.addVertexWithUV(d11, par3 + 1, d14, d2, d3);
                if (!flag3 && !flag2) {
                    tessellator.addVertexWithUV(d11, par3 + 1, d18, d5, d7);
                    tessellator.addVertexWithUV(d11, par3 + 0, d18, d5, d9);
                    tessellator.addVertexWithUV(d11, par3 + 0, d19, d6, d9);
                    tessellator.addVertexWithUV(d11, par3 + 1, d19, d6, d7);
                    tessellator.addVertexWithUV(d11, par3 + 1, d19, d5, d7);
                    tessellator.addVertexWithUV(d11, par3 + 0, d19, d5, d9);
                    tessellator.addVertexWithUV(d11, par3 + 0, d18, d6, d9);
                    tessellator.addVertexWithUV(d11, par3 + 1, d18, d6, d7);
                }
                if (flag6 || par3 < i - 1 && this.blockAccess.isAirBlock(par2 + 1, par3 + 1, par4)) {
                    tessellator.addVertexWithUV(d11, (double)(par3 + 1) + 0.01, d19, d6, d7);
                    tessellator.addVertexWithUV(d12, (double)(par3 + 1) + 0.01, d19, d6, d8);
                    tessellator.addVertexWithUV(d12, (double)(par3 + 1) + 0.01, d18, d5, d8);
                    tessellator.addVertexWithUV(d11, (double)(par3 + 1) + 0.01, d18, d5, d7);
                    tessellator.addVertexWithUV(d12, (double)(par3 + 1) + 0.01, d19, d6, d7);
                    tessellator.addVertexWithUV(d11, (double)(par3 + 1) + 0.01, d19, d6, d8);
                    tessellator.addVertexWithUV(d11, (double)(par3 + 1) + 0.01, d18, d5, d8);
                    tessellator.addVertexWithUV(d12, (double)(par3 + 1) + 0.01, d18, d5, d7);
                }
                if (flag7 || par3 > 1 && this.blockAccess.isAirBlock(par2 + 1, par3 - 1, par4)) {
                    tessellator.addVertexWithUV(d11, (double)par3 - 0.01, d19, d6, d7);
                    tessellator.addVertexWithUV(d12, (double)par3 - 0.01, d19, d6, d8);
                    tessellator.addVertexWithUV(d12, (double)par3 - 0.01, d18, d5, d8);
                    tessellator.addVertexWithUV(d11, (double)par3 - 0.01, d18, d5, d7);
                    tessellator.addVertexWithUV(d12, (double)par3 - 0.01, d19, d6, d7);
                    tessellator.addVertexWithUV(d11, (double)par3 - 0.01, d19, d6, d8);
                    tessellator.addVertexWithUV(d11, (double)par3 - 0.01, d18, d5, d8);
                    tessellator.addVertexWithUV(d12, (double)par3 - 0.01, d18, d5, d7);
                }
            }
        } else {
            tessellator.addVertexWithUV(d10, par3 + 1, d14, d, d3);
            tessellator.addVertexWithUV(d10, par3 + 0, d14, d, d4);
            tessellator.addVertexWithUV(d12, par3 + 0, d14, d2, d4);
            tessellator.addVertexWithUV(d12, par3 + 1, d14, d2, d3);
            tessellator.addVertexWithUV(d12, par3 + 1, d14, d, d3);
            tessellator.addVertexWithUV(d12, par3 + 0, d14, d, d4);
            tessellator.addVertexWithUV(d10, par3 + 0, d14, d2, d4);
            tessellator.addVertexWithUV(d10, par3 + 1, d14, d2, d3);
            if (flag6) {
                tessellator.addVertexWithUV(d10, (double)(par3 + 1) + 0.01, d19, d6, d9);
                tessellator.addVertexWithUV(d12, (double)(par3 + 1) + 0.01, d19, d6, d7);
                tessellator.addVertexWithUV(d12, (double)(par3 + 1) + 0.01, d18, d5, d7);
                tessellator.addVertexWithUV(d10, (double)(par3 + 1) + 0.01, d18, d5, d9);
                tessellator.addVertexWithUV(d12, (double)(par3 + 1) + 0.01, d19, d6, d9);
                tessellator.addVertexWithUV(d10, (double)(par3 + 1) + 0.01, d19, d6, d7);
                tessellator.addVertexWithUV(d10, (double)(par3 + 1) + 0.01, d18, d5, d7);
                tessellator.addVertexWithUV(d12, (double)(par3 + 1) + 0.01, d18, d5, d9);
            } else {
                if (par3 < i - 1 && this.blockAccess.isAirBlock(par2 - 1, par3 + 1, par4)) {
                    tessellator.addVertexWithUV(d10, (double)(par3 + 1) + 0.01, d19, d6, d8);
                    tessellator.addVertexWithUV(d11, (double)(par3 + 1) + 0.01, d19, d6, d9);
                    tessellator.addVertexWithUV(d11, (double)(par3 + 1) + 0.01, d18, d5, d9);
                    tessellator.addVertexWithUV(d10, (double)(par3 + 1) + 0.01, d18, d5, d8);
                    tessellator.addVertexWithUV(d11, (double)(par3 + 1) + 0.01, d19, d6, d8);
                    tessellator.addVertexWithUV(d10, (double)(par3 + 1) + 0.01, d19, d6, d9);
                    tessellator.addVertexWithUV(d10, (double)(par3 + 1) + 0.01, d18, d5, d9);
                    tessellator.addVertexWithUV(d11, (double)(par3 + 1) + 0.01, d18, d5, d8);
                }
                if (par3 < i - 1 && this.blockAccess.isAirBlock(par2 + 1, par3 + 1, par4)) {
                    tessellator.addVertexWithUV(d11, (double)(par3 + 1) + 0.01, d19, d6, d7);
                    tessellator.addVertexWithUV(d12, (double)(par3 + 1) + 0.01, d19, d6, d8);
                    tessellator.addVertexWithUV(d12, (double)(par3 + 1) + 0.01, d18, d5, d8);
                    tessellator.addVertexWithUV(d11, (double)(par3 + 1) + 0.01, d18, d5, d7);
                    tessellator.addVertexWithUV(d12, (double)(par3 + 1) + 0.01, d19, d6, d7);
                    tessellator.addVertexWithUV(d11, (double)(par3 + 1) + 0.01, d19, d6, d8);
                    tessellator.addVertexWithUV(d11, (double)(par3 + 1) + 0.01, d18, d5, d8);
                    tessellator.addVertexWithUV(d12, (double)(par3 + 1) + 0.01, d18, d5, d7);
                }
            }
            if (flag7) {
                tessellator.addVertexWithUV(d10, (double)par3 - 0.01, d19, d6, d9);
                tessellator.addVertexWithUV(d12, (double)par3 - 0.01, d19, d6, d7);
                tessellator.addVertexWithUV(d12, (double)par3 - 0.01, d18, d5, d7);
                tessellator.addVertexWithUV(d10, (double)par3 - 0.01, d18, d5, d9);
                tessellator.addVertexWithUV(d12, (double)par3 - 0.01, d19, d6, d9);
                tessellator.addVertexWithUV(d10, (double)par3 - 0.01, d19, d6, d7);
                tessellator.addVertexWithUV(d10, (double)par3 - 0.01, d18, d5, d7);
                tessellator.addVertexWithUV(d12, (double)par3 - 0.01, d18, d5, d9);
            } else {
                if (par3 > 1 && this.blockAccess.isAirBlock(par2 - 1, par3 - 1, par4)) {
                    tessellator.addVertexWithUV(d10, (double)par3 - 0.01, d19, d6, d8);
                    tessellator.addVertexWithUV(d11, (double)par3 - 0.01, d19, d6, d9);
                    tessellator.addVertexWithUV(d11, (double)par3 - 0.01, d18, d5, d9);
                    tessellator.addVertexWithUV(d10, (double)par3 - 0.01, d18, d5, d8);
                    tessellator.addVertexWithUV(d11, (double)par3 - 0.01, d19, d6, d8);
                    tessellator.addVertexWithUV(d10, (double)par3 - 0.01, d19, d6, d9);
                    tessellator.addVertexWithUV(d10, (double)par3 - 0.01, d18, d5, d9);
                    tessellator.addVertexWithUV(d11, (double)par3 - 0.01, d18, d5, d8);
                }
                if (par3 > 1 && this.blockAccess.isAirBlock(par2 + 1, par3 - 1, par4)) {
                    tessellator.addVertexWithUV(d11, (double)par3 - 0.01, d19, d6, d7);
                    tessellator.addVertexWithUV(d12, (double)par3 - 0.01, d19, d6, d8);
                    tessellator.addVertexWithUV(d12, (double)par3 - 0.01, d18, d5, d8);
                    tessellator.addVertexWithUV(d11, (double)par3 - 0.01, d18, d5, d7);
                    tessellator.addVertexWithUV(d12, (double)par3 - 0.01, d19, d6, d7);
                    tessellator.addVertexWithUV(d11, (double)par3 - 0.01, d19, d6, d8);
                    tessellator.addVertexWithUV(d11, (double)par3 - 0.01, d18, d5, d8);
                    tessellator.addVertexWithUV(d12, (double)par3 - 0.01, d18, d5, d7);
                }
            }
        }
        if ((!flag2 || !flag3) && (flag4 || flag5 || flag2 || flag3)) {
            if (flag2 && !flag3) {
                tessellator.addVertexWithUV(d11, par3 + 1, d13, d, d3);
                tessellator.addVertexWithUV(d11, par3 + 0, d13, d, d4);
                tessellator.addVertexWithUV(d11, par3 + 0, d14, d1, d4);
                tessellator.addVertexWithUV(d11, par3 + 1, d14, d1, d3);
                tessellator.addVertexWithUV(d11, par3 + 1, d14, d, d3);
                tessellator.addVertexWithUV(d11, par3 + 0, d14, d, d4);
                tessellator.addVertexWithUV(d11, par3 + 0, d13, d1, d4);
                tessellator.addVertexWithUV(d11, par3 + 1, d13, d1, d3);
                if (!flag5 && !flag4) {
                    tessellator.addVertexWithUV(d16, par3 + 1, d14, d5, d7);
                    tessellator.addVertexWithUV(d16, par3 + 0, d14, d5, d9);
                    tessellator.addVertexWithUV(d17, par3 + 0, d14, d6, d9);
                    tessellator.addVertexWithUV(d17, par3 + 1, d14, d6, d7);
                    tessellator.addVertexWithUV(d17, par3 + 1, d14, d5, d7);
                    tessellator.addVertexWithUV(d17, par3 + 0, d14, d5, d9);
                    tessellator.addVertexWithUV(d16, par3 + 0, d14, d6, d9);
                    tessellator.addVertexWithUV(d16, par3 + 1, d14, d6, d7);
                }
                if (flag6 || par3 < i - 1 && this.blockAccess.isAirBlock(par2, par3 + 1, par4 - 1)) {
                    tessellator.addVertexWithUV(d16, par3 + 1, d13, d6, d7);
                    tessellator.addVertexWithUV(d16, par3 + 1, d14, d6, d8);
                    tessellator.addVertexWithUV(d17, par3 + 1, d14, d5, d8);
                    tessellator.addVertexWithUV(d17, par3 + 1, d13, d5, d7);
                    tessellator.addVertexWithUV(d16, par3 + 1, d14, d6, d7);
                    tessellator.addVertexWithUV(d16, par3 + 1, d13, d6, d8);
                    tessellator.addVertexWithUV(d17, par3 + 1, d13, d5, d8);
                    tessellator.addVertexWithUV(d17, par3 + 1, d14, d5, d7);
                }
                if (flag7 || par3 > 1 && this.blockAccess.isAirBlock(par2, par3 - 1, par4 - 1)) {
                    tessellator.addVertexWithUV(d16, par3, d13, d6, d7);
                    tessellator.addVertexWithUV(d16, par3, d14, d6, d8);
                    tessellator.addVertexWithUV(d17, par3, d14, d5, d8);
                    tessellator.addVertexWithUV(d17, par3, d13, d5, d7);
                    tessellator.addVertexWithUV(d16, par3, d14, d6, d7);
                    tessellator.addVertexWithUV(d16, par3, d13, d6, d8);
                    tessellator.addVertexWithUV(d17, par3, d13, d5, d8);
                    tessellator.addVertexWithUV(d17, par3, d14, d5, d7);
                }
            } else if (!flag2 && flag3) {
                tessellator.addVertexWithUV(d11, par3 + 1, d14, d1, d3);
                tessellator.addVertexWithUV(d11, par3 + 0, d14, d1, d4);
                tessellator.addVertexWithUV(d11, par3 + 0, d15, d2, d4);
                tessellator.addVertexWithUV(d11, par3 + 1, d15, d2, d3);
                tessellator.addVertexWithUV(d11, par3 + 1, d15, d1, d3);
                tessellator.addVertexWithUV(d11, par3 + 0, d15, d1, d4);
                tessellator.addVertexWithUV(d11, par3 + 0, d14, d2, d4);
                tessellator.addVertexWithUV(d11, par3 + 1, d14, d2, d3);
                if (!flag5 && !flag4) {
                    tessellator.addVertexWithUV(d17, par3 + 1, d14, d5, d7);
                    tessellator.addVertexWithUV(d17, par3 + 0, d14, d5, d9);
                    tessellator.addVertexWithUV(d16, par3 + 0, d14, d6, d9);
                    tessellator.addVertexWithUV(d16, par3 + 1, d14, d6, d7);
                    tessellator.addVertexWithUV(d16, par3 + 1, d14, d5, d7);
                    tessellator.addVertexWithUV(d16, par3 + 0, d14, d5, d9);
                    tessellator.addVertexWithUV(d17, par3 + 0, d14, d6, d9);
                    tessellator.addVertexWithUV(d17, par3 + 1, d14, d6, d7);
                }
                if (flag6 || par3 < i - 1 && this.blockAccess.isAirBlock(par2, par3 + 1, par4 + 1)) {
                    tessellator.addVertexWithUV(d16, par3 + 1, d14, d5, d8);
                    tessellator.addVertexWithUV(d16, par3 + 1, d15, d5, d9);
                    tessellator.addVertexWithUV(d17, par3 + 1, d15, d6, d9);
                    tessellator.addVertexWithUV(d17, par3 + 1, d14, d6, d8);
                    tessellator.addVertexWithUV(d16, par3 + 1, d15, d5, d8);
                    tessellator.addVertexWithUV(d16, par3 + 1, d14, d5, d9);
                    tessellator.addVertexWithUV(d17, par3 + 1, d14, d6, d9);
                    tessellator.addVertexWithUV(d17, par3 + 1, d15, d6, d8);
                }
                if (flag7 || par3 > 1 && this.blockAccess.isAirBlock(par2, par3 - 1, par4 + 1)) {
                    tessellator.addVertexWithUV(d16, par3, d14, d5, d8);
                    tessellator.addVertexWithUV(d16, par3, d15, d5, d9);
                    tessellator.addVertexWithUV(d17, par3, d15, d6, d9);
                    tessellator.addVertexWithUV(d17, par3, d14, d6, d8);
                    tessellator.addVertexWithUV(d16, par3, d15, d5, d8);
                    tessellator.addVertexWithUV(d16, par3, d14, d5, d9);
                    tessellator.addVertexWithUV(d17, par3, d14, d6, d9);
                    tessellator.addVertexWithUV(d17, par3, d15, d6, d8);
                }
            }
        } else {
            tessellator.addVertexWithUV(d11, par3 + 1, d15, d, d3);
            tessellator.addVertexWithUV(d11, par3 + 0, d15, d, d4);
            tessellator.addVertexWithUV(d11, par3 + 0, d13, d2, d4);
            tessellator.addVertexWithUV(d11, par3 + 1, d13, d2, d3);
            tessellator.addVertexWithUV(d11, par3 + 1, d13, d, d3);
            tessellator.addVertexWithUV(d11, par3 + 0, d13, d, d4);
            tessellator.addVertexWithUV(d11, par3 + 0, d15, d2, d4);
            tessellator.addVertexWithUV(d11, par3 + 1, d15, d2, d3);
            if (flag6) {
                tessellator.addVertexWithUV(d17, par3 + 1, d15, d6, d9);
                tessellator.addVertexWithUV(d17, par3 + 1, d13, d6, d7);
                tessellator.addVertexWithUV(d16, par3 + 1, d13, d5, d7);
                tessellator.addVertexWithUV(d16, par3 + 1, d15, d5, d9);
                tessellator.addVertexWithUV(d17, par3 + 1, d13, d6, d9);
                tessellator.addVertexWithUV(d17, par3 + 1, d15, d6, d7);
                tessellator.addVertexWithUV(d16, par3 + 1, d15, d5, d7);
                tessellator.addVertexWithUV(d16, par3 + 1, d13, d5, d9);
            } else {
                if (par3 < i - 1 && this.blockAccess.isAirBlock(par2, par3 + 1, par4 - 1)) {
                    tessellator.addVertexWithUV(d16, par3 + 1, d13, d6, d7);
                    tessellator.addVertexWithUV(d16, par3 + 1, d14, d6, d8);
                    tessellator.addVertexWithUV(d17, par3 + 1, d14, d5, d8);
                    tessellator.addVertexWithUV(d17, par3 + 1, d13, d5, d7);
                    tessellator.addVertexWithUV(d16, par3 + 1, d14, d6, d7);
                    tessellator.addVertexWithUV(d16, par3 + 1, d13, d6, d8);
                    tessellator.addVertexWithUV(d17, par3 + 1, d13, d5, d8);
                    tessellator.addVertexWithUV(d17, par3 + 1, d14, d5, d7);
                }
                if (par3 < i - 1 && this.blockAccess.isAirBlock(par2, par3 + 1, par4 + 1)) {
                    tessellator.addVertexWithUV(d16, par3 + 1, d14, d5, d8);
                    tessellator.addVertexWithUV(d16, par3 + 1, d15, d5, d9);
                    tessellator.addVertexWithUV(d17, par3 + 1, d15, d6, d9);
                    tessellator.addVertexWithUV(d17, par3 + 1, d14, d6, d8);
                    tessellator.addVertexWithUV(d16, par3 + 1, d15, d5, d8);
                    tessellator.addVertexWithUV(d16, par3 + 1, d14, d5, d9);
                    tessellator.addVertexWithUV(d17, par3 + 1, d14, d6, d9);
                    tessellator.addVertexWithUV(d17, par3 + 1, d15, d6, d8);
                }
            }
            if (flag7) {
                tessellator.addVertexWithUV(d17, par3, d15, d6, d9);
                tessellator.addVertexWithUV(d17, par3, d13, d6, d7);
                tessellator.addVertexWithUV(d16, par3, d13, d5, d7);
                tessellator.addVertexWithUV(d16, par3, d15, d5, d9);
                tessellator.addVertexWithUV(d17, par3, d13, d6, d9);
                tessellator.addVertexWithUV(d17, par3, d15, d6, d7);
                tessellator.addVertexWithUV(d16, par3, d15, d5, d7);
                tessellator.addVertexWithUV(d16, par3, d13, d5, d9);
            } else {
                if (par3 > 1 && this.blockAccess.isAirBlock(par2, par3 - 1, par4 - 1)) {
                    tessellator.addVertexWithUV(d16, par3, d13, d6, d7);
                    tessellator.addVertexWithUV(d16, par3, d14, d6, d8);
                    tessellator.addVertexWithUV(d17, par3, d14, d5, d8);
                    tessellator.addVertexWithUV(d17, par3, d13, d5, d7);
                    tessellator.addVertexWithUV(d16, par3, d14, d6, d7);
                    tessellator.addVertexWithUV(d16, par3, d13, d6, d8);
                    tessellator.addVertexWithUV(d17, par3, d13, d5, d8);
                    tessellator.addVertexWithUV(d17, par3, d14, d5, d7);
                }
                if (par3 > 1 && this.blockAccess.isAirBlock(par2, par3 - 1, par4 + 1)) {
                    tessellator.addVertexWithUV(d16, par3, d14, d5, d8);
                    tessellator.addVertexWithUV(d16, par3, d15, d5, d9);
                    tessellator.addVertexWithUV(d17, par3, d15, d6, d9);
                    tessellator.addVertexWithUV(d17, par3, d14, d6, d8);
                    tessellator.addVertexWithUV(d16, par3, d15, d5, d8);
                    tessellator.addVertexWithUV(d16, par3, d14, d5, d9);
                    tessellator.addVertexWithUV(d17, par3, d14, d6, d9);
                    tessellator.addVertexWithUV(d17, par3, d15, d6, d8);
                }
            }
        }
        return true;
    }

    public boolean renderCrossedSquares(Block par1Block, int par2, int par3, int par4) {
        Tessellator tessellator = Tessellator.instance;
        tessellator.setBrightness(par1Block.getMixedBrightnessForBlock(this.blockAccess, par2, par3, par4));
        float f = 1.0f;
        int i = par1Block.colorMultiplier(this.blockAccess, par2, par3, par4);
        float f1 = (float)(i >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(i >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(i & 0xFF) / 255.0f;
        if (EntityRenderer.anaglyphEnable) {
            float f4 = (f1 * 30.0f + f2 * 59.0f + f3 * 11.0f) / 100.0f;
            float f5 = (f1 * 30.0f + f2 * 70.0f) / 100.0f;
            float f6 = (f1 * 30.0f + f3 * 70.0f) / 100.0f;
            f1 = f4;
            f2 = f5;
            f3 = f6;
        }
        tessellator.setColorOpaque_F(f * f1, f * f2, f * f3);
        double d = par2;
        double d1 = par3;
        double d2 = par4;
        if (par1Block == Block.tallGrass) {
            long l = (long)(par2 * 3129871) ^ (long)par4 * 116129781L ^ (long)par3;
            l = l * l * 42317861L + l * 11L;
            d += ((double)((float)(l >> 16 & 0xFL) / 15.0f) - 0.5) * 0.5;
            d1 += ((double)((float)(l >> 20 & 0xFL) / 15.0f) - 1.0) * 0.2;
            d2 += ((double)((float)(l >> 24 & 0xFL) / 15.0f) - 0.5) * 0.5;
        }
        this.drawCrossedSquares(par1Block, this.blockAccess.getBlockMetadata(par2, par3, par4), d, d1, d2);
        return true;
    }

    public boolean renderBlockStem(Block par1Block, int par2, int par3, int par4) {
        BlockStem blockstem = (BlockStem)par1Block;
        Tessellator tessellator = Tessellator.instance;
        tessellator.setBrightness(blockstem.getMixedBrightnessForBlock(this.blockAccess, par2, par3, par4));
        float f = 1.0f;
        int i = blockstem.colorMultiplier(this.blockAccess, par2, par3, par4);
        float f1 = (float)(i >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(i >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(i & 0xFF) / 255.0f;
        if (EntityRenderer.anaglyphEnable) {
            float f4 = (f1 * 30.0f + f2 * 59.0f + f3 * 11.0f) / 100.0f;
            float f5 = (f1 * 30.0f + f2 * 70.0f) / 100.0f;
            float f6 = (f1 * 30.0f + f3 * 70.0f) / 100.0f;
            f1 = f4;
            f2 = f5;
            f3 = f6;
        }
        tessellator.setColorOpaque_F(f * f1, f * f2, f * f3);
        blockstem.setBlockBoundsBasedOnState(this.blockAccess, par2, par3, par4);
        int j = blockstem.func_35296_f(this.blockAccess, par2, par3, par4);
        if (j < 0) {
            this.renderBlockStemSmall(blockstem, this.blockAccess.getBlockMetadata(par2, par3, par4), blockstem.maxY, par2, par3, par4);
        } else {
            this.renderBlockStemSmall(blockstem, this.blockAccess.getBlockMetadata(par2, par3, par4), 0.5, par2, par3, par4);
            this.renderBlockStemBig(blockstem, this.blockAccess.getBlockMetadata(par2, par3, par4), j, blockstem.maxY, par2, par3, par4);
        }
        return true;
    }

    public boolean renderBlockCrops(Block par1Block, int par2, int par3, int par4) {
        Tessellator tessellator = Tessellator.instance;
        tessellator.setBrightness(par1Block.getMixedBrightnessForBlock(this.blockAccess, par2, par3, par4));
        tessellator.setColorOpaque_F(1.0f, 1.0f, 1.0f);
        this.renderBlockCropsImpl(par1Block, this.blockAccess.getBlockMetadata(par2, par3, par4), par2, (float)par3 - 0.0625f, par4);
        return true;
    }

    public void renderTorchAtAngle(Block par1Block, double par2, double par4, double par6, double par8, double par10) {
        Tessellator tessellator = Tessellator.instance;
        int i = par1Block.getBlockTextureFromSide(0);
        if (this.overrideBlockTexture >= 0) {
            i = this.overrideBlockTexture;
        }
        int j = (i & 0xF) << 4;
        int k = i & 0xF0;
        float f = (float)j / 256.0f;
        float f1 = ((float)j + 15.99f) / 256.0f;
        float f2 = (float)k / 256.0f;
        float f3 = ((float)k + 15.99f) / 256.0f;
        double d = (double)f + 0.02734375;
        double d1 = (double)f2 + 0.0234375;
        double d2 = (double)f + 0.03515625;
        double d3 = (double)f2 + 0.03125;
        double d4 = (par2 += 0.5) - 0.5;
        double d5 = par2 + 0.5;
        double d6 = (par6 += 0.5) - 0.5;
        double d7 = par6 + 0.5;
        double d8 = 0.0625;
        double d9 = 0.625;
        tessellator.addVertexWithUV(par2 + par8 * (1.0 - d9) - d8, par4 + d9, par6 + par10 * (1.0 - d9) - d8, d, d1);
        tessellator.addVertexWithUV(par2 + par8 * (1.0 - d9) - d8, par4 + d9, par6 + par10 * (1.0 - d9) + d8, d, d3);
        tessellator.addVertexWithUV(par2 + par8 * (1.0 - d9) + d8, par4 + d9, par6 + par10 * (1.0 - d9) + d8, d2, d3);
        tessellator.addVertexWithUV(par2 + par8 * (1.0 - d9) + d8, par4 + d9, par6 + par10 * (1.0 - d9) - d8, d2, d1);
        tessellator.addVertexWithUV(par2 - d8, par4 + 1.0, d6, f, f2);
        tessellator.addVertexWithUV(par2 - d8 + par8, par4 + 0.0, d6 + par10, f, f3);
        tessellator.addVertexWithUV(par2 - d8 + par8, par4 + 0.0, d7 + par10, f1, f3);
        tessellator.addVertexWithUV(par2 - d8, par4 + 1.0, d7, f1, f2);
        tessellator.addVertexWithUV(par2 + d8, par4 + 1.0, d7, f, f2);
        tessellator.addVertexWithUV(par2 + par8 + d8, par4 + 0.0, d7 + par10, f, f3);
        tessellator.addVertexWithUV(par2 + par8 + d8, par4 + 0.0, d6 + par10, f1, f3);
        tessellator.addVertexWithUV(par2 + d8, par4 + 1.0, d6, f1, f2);
        tessellator.addVertexWithUV(d4, par4 + 1.0, par6 + d8, f, f2);
        tessellator.addVertexWithUV(d4 + par8, par4 + 0.0, par6 + d8 + par10, f, f3);
        tessellator.addVertexWithUV(d5 + par8, par4 + 0.0, par6 + d8 + par10, f1, f3);
        tessellator.addVertexWithUV(d5, par4 + 1.0, par6 + d8, f1, f2);
        tessellator.addVertexWithUV(d5, par4 + 1.0, par6 - d8, f, f2);
        tessellator.addVertexWithUV(d5 + par8, par4 + 0.0, par6 - d8 + par10, f, f3);
        tessellator.addVertexWithUV(d4 + par8, par4 + 0.0, par6 - d8 + par10, f1, f3);
        tessellator.addVertexWithUV(d4, par4 + 1.0, par6 - d8, f1, f2);
    }

    public void drawCrossedSquares(Block par1Block, int par2, double par3, double par5, double par7) {
        Tessellator tessellator = Tessellator.instance;
        int i = par1Block.getBlockTextureFromSideAndMetadata(0, par2);
        if (this.overrideBlockTexture >= 0) {
            i = this.overrideBlockTexture;
        }
        int j = (i & 0xF) << 4;
        int k = i & 0xF0;
        double d = (float)j / 256.0f;
        double d1 = ((float)j + 15.99f) / 256.0f;
        double d2 = (float)k / 256.0f;
        double d3 = ((float)k + 15.99f) / 256.0f;
        double d4 = par3 + 0.5 - 0.45;
        double d5 = par3 + 0.5 + 0.45;
        double d6 = par7 + 0.5 - 0.45;
        double d7 = par7 + 0.5 + 0.45;
        tessellator.addVertexWithUV(d4, par5 + 1.0, d6, d, d2);
        tessellator.addVertexWithUV(d4, par5 + 0.0, d6, d, d3);
        tessellator.addVertexWithUV(d5, par5 + 0.0, d7, d1, d3);
        tessellator.addVertexWithUV(d5, par5 + 1.0, d7, d1, d2);
        tessellator.addVertexWithUV(d5, par5 + 1.0, d7, d, d2);
        tessellator.addVertexWithUV(d5, par5 + 0.0, d7, d, d3);
        tessellator.addVertexWithUV(d4, par5 + 0.0, d6, d1, d3);
        tessellator.addVertexWithUV(d4, par5 + 1.0, d6, d1, d2);
        tessellator.addVertexWithUV(d4, par5 + 1.0, d7, d, d2);
        tessellator.addVertexWithUV(d4, par5 + 0.0, d7, d, d3);
        tessellator.addVertexWithUV(d5, par5 + 0.0, d6, d1, d3);
        tessellator.addVertexWithUV(d5, par5 + 1.0, d6, d1, d2);
        tessellator.addVertexWithUV(d5, par5 + 1.0, d6, d, d2);
        tessellator.addVertexWithUV(d5, par5 + 0.0, d6, d, d3);
        tessellator.addVertexWithUV(d4, par5 + 0.0, d7, d1, d3);
        tessellator.addVertexWithUV(d4, par5 + 1.0, d7, d1, d2);
    }

    public void renderBlockStemSmall(Block par1Block, int par2, double par3, double par5, double par7, double par9) {
        Tessellator tessellator = Tessellator.instance;
        int i = par1Block.getBlockTextureFromSideAndMetadata(0, par2);
        if (this.overrideBlockTexture >= 0) {
            i = this.overrideBlockTexture;
        }
        int j = (i & 0xF) << 4;
        int k = i & 0xF0;
        double d = (float)j / 256.0f;
        double d1 = ((float)j + 15.99f) / 256.0f;
        double d2 = (float)k / 256.0f;
        double d3 = ((double)k + (double)15.99f * par3) / 256.0;
        double d4 = par5 + 0.5 - (double)0.45f;
        double d5 = par5 + 0.5 + (double)0.45f;
        double d6 = par9 + 0.5 - (double)0.45f;
        double d7 = par9 + 0.5 + (double)0.45f;
        tessellator.addVertexWithUV(d4, par7 + par3, d6, d, d2);
        tessellator.addVertexWithUV(d4, par7 + 0.0, d6, d, d3);
        tessellator.addVertexWithUV(d5, par7 + 0.0, d7, d1, d3);
        tessellator.addVertexWithUV(d5, par7 + par3, d7, d1, d2);
        tessellator.addVertexWithUV(d5, par7 + par3, d7, d, d2);
        tessellator.addVertexWithUV(d5, par7 + 0.0, d7, d, d3);
        tessellator.addVertexWithUV(d4, par7 + 0.0, d6, d1, d3);
        tessellator.addVertexWithUV(d4, par7 + par3, d6, d1, d2);
        tessellator.addVertexWithUV(d4, par7 + par3, d7, d, d2);
        tessellator.addVertexWithUV(d4, par7 + 0.0, d7, d, d3);
        tessellator.addVertexWithUV(d5, par7 + 0.0, d6, d1, d3);
        tessellator.addVertexWithUV(d5, par7 + par3, d6, d1, d2);
        tessellator.addVertexWithUV(d5, par7 + par3, d6, d, d2);
        tessellator.addVertexWithUV(d5, par7 + 0.0, d6, d, d3);
        tessellator.addVertexWithUV(d4, par7 + 0.0, d7, d1, d3);
        tessellator.addVertexWithUV(d4, par7 + par3, d7, d1, d2);
    }

    public boolean renderBlockLilyPad(Block par1Block, int par2, int par3, int par4) {
        Tessellator tessellator = Tessellator.instance;
        int i = par1Block.blockIndexInTexture;
        if (this.overrideBlockTexture >= 0) {
            i = this.overrideBlockTexture;
        }
        int j = (i & 0xF) << 4;
        int k = i & 0xF0;
        float f = 0.015625f;
        double d = (float)j / 256.0f;
        double d1 = ((float)j + 15.99f) / 256.0f;
        double d2 = (float)k / 256.0f;
        double d3 = ((float)k + 15.99f) / 256.0f;
        long l = (long)(par2 * 3129871) ^ (long)par4 * 116129781L ^ (long)par3;
        l = l * l * 42317861L + l * 11L;
        int i1 = (int)(l >> 16 & 3L);
        tessellator.setBrightness(par1Block.getMixedBrightnessForBlock(this.blockAccess, par2, par3, par4));
        float f1 = (float)par2 + 0.5f;
        float f2 = (float)par4 + 0.5f;
        float f3 = (float)(i1 & 1) * 0.5f * (float)(1 - i1 / 2 % 2 * 2);
        float f4 = (float)(i1 + 1 & 1) * 0.5f * (float)(1 - (i1 + 1) / 2 % 2 * 2);
        tessellator.setColorOpaque_I(par1Block.getBlockColor());
        tessellator.addVertexWithUV(f1 + f3 - f4, (float)par3 + f, f2 + f3 + f4, d, d2);
        tessellator.addVertexWithUV(f1 + f3 + f4, (float)par3 + f, f2 - f3 + f4, d1, d2);
        tessellator.addVertexWithUV(f1 - f3 + f4, (float)par3 + f, f2 - f3 - f4, d1, d3);
        tessellator.addVertexWithUV(f1 - f3 - f4, (float)par3 + f, f2 + f3 - f4, d, d3);
        tessellator.setColorOpaque_I((par1Block.getBlockColor() & 0xFEFEFE) >> 1);
        tessellator.addVertexWithUV(f1 - f3 - f4, (float)par3 + f, f2 + f3 - f4, d, d3);
        tessellator.addVertexWithUV(f1 - f3 + f4, (float)par3 + f, f2 - f3 - f4, d1, d3);
        tessellator.addVertexWithUV(f1 + f3 + f4, (float)par3 + f, f2 - f3 + f4, d1, d2);
        tessellator.addVertexWithUV(f1 + f3 - f4, (float)par3 + f, f2 + f3 + f4, d, d2);
        return true;
    }

    public void renderBlockStemBig(Block par1Block, int par2, int par3, double par4, double par6, double par8, double par10) {
        Tessellator tessellator = Tessellator.instance;
        int i = par1Block.getBlockTextureFromSideAndMetadata(0, par2) + 16;
        if (this.overrideBlockTexture >= 0) {
            i = this.overrideBlockTexture;
        }
        int j = (i & 0xF) << 4;
        int k = i & 0xF0;
        double d = (float)j / 256.0f;
        double d1 = ((float)j + 15.99f) / 256.0f;
        double d2 = (float)k / 256.0f;
        double d3 = ((double)k + (double)15.99f * par4) / 256.0;
        double d4 = par6 + 0.5 - 0.5;
        double d5 = par6 + 0.5 + 0.5;
        double d6 = par10 + 0.5 - 0.5;
        double d7 = par10 + 0.5 + 0.5;
        double d8 = par6 + 0.5;
        double d9 = par10 + 0.5;
        if ((par3 + 1) / 2 % 2 == 1) {
            double d10 = d1;
            d1 = d;
            d = d10;
        }
        if (par3 < 2) {
            tessellator.addVertexWithUV(d4, par8 + par4, d9, d, d2);
            tessellator.addVertexWithUV(d4, par8 + 0.0, d9, d, d3);
            tessellator.addVertexWithUV(d5, par8 + 0.0, d9, d1, d3);
            tessellator.addVertexWithUV(d5, par8 + par4, d9, d1, d2);
            tessellator.addVertexWithUV(d5, par8 + par4, d9, d1, d2);
            tessellator.addVertexWithUV(d5, par8 + 0.0, d9, d1, d3);
            tessellator.addVertexWithUV(d4, par8 + 0.0, d9, d, d3);
            tessellator.addVertexWithUV(d4, par8 + par4, d9, d, d2);
        } else {
            tessellator.addVertexWithUV(d8, par8 + par4, d7, d, d2);
            tessellator.addVertexWithUV(d8, par8 + 0.0, d7, d, d3);
            tessellator.addVertexWithUV(d8, par8 + 0.0, d6, d1, d3);
            tessellator.addVertexWithUV(d8, par8 + par4, d6, d1, d2);
            tessellator.addVertexWithUV(d8, par8 + par4, d6, d1, d2);
            tessellator.addVertexWithUV(d8, par8 + 0.0, d6, d1, d3);
            tessellator.addVertexWithUV(d8, par8 + 0.0, d7, d, d3);
            tessellator.addVertexWithUV(d8, par8 + par4, d7, d, d2);
        }
    }

    public void renderBlockCropsImpl(Block par1Block, int par2, double par3, double par5, double par7) {
        Tessellator tessellator = Tessellator.instance;
        int i = par1Block.getBlockTextureFromSideAndMetadata(0, par2);
        if (this.overrideBlockTexture >= 0) {
            i = this.overrideBlockTexture;
        }
        int j = (i & 0xF) << 4;
        int k = i & 0xF0;
        double d = (float)j / 256.0f;
        double d1 = ((float)j + 15.99f) / 256.0f;
        double d2 = (float)k / 256.0f;
        double d3 = ((float)k + 15.99f) / 256.0f;
        double d4 = par3 + 0.5 - 0.25;
        double d5 = par3 + 0.5 + 0.25;
        double d6 = par7 + 0.5 - 0.5;
        double d7 = par7 + 0.5 + 0.5;
        tessellator.addVertexWithUV(d4, par5 + 1.0, d6, d, d2);
        tessellator.addVertexWithUV(d4, par5 + 0.0, d6, d, d3);
        tessellator.addVertexWithUV(d4, par5 + 0.0, d7, d1, d3);
        tessellator.addVertexWithUV(d4, par5 + 1.0, d7, d1, d2);
        tessellator.addVertexWithUV(d4, par5 + 1.0, d7, d, d2);
        tessellator.addVertexWithUV(d4, par5 + 0.0, d7, d, d3);
        tessellator.addVertexWithUV(d4, par5 + 0.0, d6, d1, d3);
        tessellator.addVertexWithUV(d4, par5 + 1.0, d6, d1, d2);
        tessellator.addVertexWithUV(d5, par5 + 1.0, d7, d, d2);
        tessellator.addVertexWithUV(d5, par5 + 0.0, d7, d, d3);
        tessellator.addVertexWithUV(d5, par5 + 0.0, d6, d1, d3);
        tessellator.addVertexWithUV(d5, par5 + 1.0, d6, d1, d2);
        tessellator.addVertexWithUV(d5, par5 + 1.0, d6, d, d2);
        tessellator.addVertexWithUV(d5, par5 + 0.0, d6, d, d3);
        tessellator.addVertexWithUV(d5, par5 + 0.0, d7, d1, d3);
        tessellator.addVertexWithUV(d5, par5 + 1.0, d7, d1, d2);
        d4 = par3 + 0.5 - 0.5;
        d5 = par3 + 0.5 + 0.5;
        d6 = par7 + 0.5 - 0.25;
        d7 = par7 + 0.5 + 0.25;
        tessellator.addVertexWithUV(d4, par5 + 1.0, d6, d, d2);
        tessellator.addVertexWithUV(d4, par5 + 0.0, d6, d, d3);
        tessellator.addVertexWithUV(d5, par5 + 0.0, d6, d1, d3);
        tessellator.addVertexWithUV(d5, par5 + 1.0, d6, d1, d2);
        tessellator.addVertexWithUV(d5, par5 + 1.0, d6, d, d2);
        tessellator.addVertexWithUV(d5, par5 + 0.0, d6, d, d3);
        tessellator.addVertexWithUV(d4, par5 + 0.0, d6, d1, d3);
        tessellator.addVertexWithUV(d4, par5 + 1.0, d6, d1, d2);
        tessellator.addVertexWithUV(d5, par5 + 1.0, d7, d, d2);
        tessellator.addVertexWithUV(d5, par5 + 0.0, d7, d, d3);
        tessellator.addVertexWithUV(d4, par5 + 0.0, d7, d1, d3);
        tessellator.addVertexWithUV(d4, par5 + 1.0, d7, d1, d2);
        tessellator.addVertexWithUV(d4, par5 + 1.0, d7, d, d2);
        tessellator.addVertexWithUV(d4, par5 + 0.0, d7, d, d3);
        tessellator.addVertexWithUV(d5, par5 + 0.0, d7, d1, d3);
        tessellator.addVertexWithUV(d5, par5 + 1.0, d7, d1, d2);
    }

    public boolean renderBlockFluids(Block par1Block, int par2, int par3, int par4) {
        Tessellator tessellator = Tessellator.instance;
        int i = par1Block.colorMultiplier(this.blockAccess, par2, par3, par4);
        float f = (float)(i >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(i >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(i & 0xFF) / 255.0f;
        boolean flag = par1Block.shouldSideBeRendered(this.blockAccess, par2, par3 + 1, par4, 1);
        boolean flag1 = par1Block.shouldSideBeRendered(this.blockAccess, par2, par3 - 1, par4, 0);
        boolean[] aflag = new boolean[]{par1Block.shouldSideBeRendered(this.blockAccess, par2, par3, par4 - 1, 2), par1Block.shouldSideBeRendered(this.blockAccess, par2, par3, par4 + 1, 3), par1Block.shouldSideBeRendered(this.blockAccess, par2 - 1, par3, par4, 4), par1Block.shouldSideBeRendered(this.blockAccess, par2 + 1, par3, par4, 5)};
        if (!(flag || flag1 || aflag[0] || aflag[1] || aflag[2] || aflag[3])) {
            return false;
        }
        boolean flag2 = false;
        float f3 = 0.5f;
        float f4 = 1.0f;
        float f5 = 0.8f;
        float f6 = 0.6f;
        double d = 0.0;
        double d1 = 1.0;
        Material material = par1Block.blockMaterial;
        int j = this.blockAccess.getBlockMetadata(par2, par3, par4);
        double d2 = this.getFluidHeight(par2, par3, par4, material);
        double d3 = this.getFluidHeight(par2, par3, par4 + 1, material);
        double d4 = this.getFluidHeight(par2 + 1, par3, par4 + 1, material);
        double d5 = this.getFluidHeight(par2 + 1, par3, par4, material);
        double d6 = 0.001f;
        if (this.renderAllFaces || flag) {
            flag2 = true;
            int k = par1Block.getBlockTextureFromSideAndMetadata(1, j);
            float f7 = (float)BlockFluid.func_293_a(this.blockAccess, par2, par3, par4, material);
            if (f7 > -999.0f) {
                k = par1Block.getBlockTextureFromSideAndMetadata(2, j);
            }
            d2 -= d6;
            d3 -= d6;
            d4 -= d6;
            d5 -= d6;
            int l1 = (k & 0xF) << 4;
            int i1 = k & 0xF0;
            double d7 = ((double)l1 + 8.0) / 256.0;
            double d8 = ((double)i1 + 8.0) / 256.0;
            if (f7 < -999.0f) {
                f7 = 0.0f;
            } else {
                d7 = (float)(l1 + 16) / 256.0f;
                d8 = (float)(i1 + 16) / 256.0f;
            }
            double d10 = (double)(MathHelper.sin(f7) * 8.0f) / 256.0;
            double d12 = (double)(MathHelper.cos(f7) * 8.0f) / 256.0;
            tessellator.setBrightness(par1Block.getMixedBrightnessForBlock(this.blockAccess, par2, par3, par4));
            float f9 = 1.0f;
            tessellator.setColorOpaque_F(f4 * f9 * f, f4 * f9 * f1, f4 * f9 * f2);
            tessellator.addVertexWithUV(par2 + 0, (double)par3 + d2, par4 + 0, d7 - d12 - d10, d8 - d12 + d10);
            tessellator.addVertexWithUV(par2 + 0, (double)par3 + d3, par4 + 1, d7 - d12 + d10, d8 + d12 + d10);
            tessellator.addVertexWithUV(par2 + 1, (double)par3 + d4, par4 + 1, d7 + d12 + d10, d8 + d12 - d10);
            tessellator.addVertexWithUV(par2 + 1, (double)par3 + d5, par4 + 0, d7 + d12 - d10, d8 - d12 - d10);
        }
        if (this.renderAllFaces || flag1) {
            tessellator.setBrightness(par1Block.getMixedBrightnessForBlock(this.blockAccess, par2, par3 - 1, par4));
            float f8 = 1.0f;
            tessellator.setColorOpaque_F(f3 * f8, f3 * f8, f3 * f8);
            this.renderBottomFace(par1Block, par2, (double)par3 + d6, par4, par1Block.getBlockTextureFromSide(0));
            flag2 = true;
        }
        for (int l = 0; l < 4; ++l) {
            double d15;
            double d13;
            double d16;
            double d14;
            double d9;
            double d11;
            int k1 = par2;
            int j1 = par4;
            if (l == 0) {
                j1 = par4 - 1;
            }
            if (l == 1) {
                ++j1;
            }
            if (l == 2) {
                k1 = par2 - 1;
            }
            if (l == 3) {
                ++k1;
            }
            int i2 = par1Block.getBlockTextureFromSideAndMetadata(l + 2, j);
            int j2 = (i2 & 0xF) << 4;
            int k2 = i2 & 0xF0;
            if (!this.renderAllFaces && !aflag[l]) continue;
            if (l == 0) {
                d11 = d2;
                d9 = d5;
                d14 = par2;
                d16 = par2 + 1;
                d13 = (double)par4 + d6;
                d15 = (double)par4 + d6;
            } else if (l == 1) {
                d11 = d4;
                d9 = d3;
                d14 = par2 + 1;
                d16 = par2;
                d13 = (double)(par4 + 1) - d6;
                d15 = (double)(par4 + 1) - d6;
            } else if (l == 2) {
                d11 = d3;
                d9 = d2;
                d14 = (double)par2 + d6;
                d16 = (double)par2 + d6;
                d13 = par4 + 1;
                d15 = par4;
            } else {
                d11 = d5;
                d9 = d4;
                d14 = (double)(par2 + 1) - d6;
                d16 = (double)(par2 + 1) - d6;
                d13 = par4;
                d15 = par4 + 1;
            }
            flag2 = true;
            double d17 = (float)(j2 + 0) / 256.0f;
            double d18 = ((double)(j2 + 16) - 0.01) / 256.0;
            double d19 = ((double)k2 + (1.0 - d11) * 16.0) / 256.0;
            double d20 = ((double)k2 + (1.0 - d9) * 16.0) / 256.0;
            double d21 = ((double)(k2 + 16) - 0.01) / 256.0;
            tessellator.setBrightness(par1Block.getMixedBrightnessForBlock(this.blockAccess, k1, par3, j1));
            float f10 = 1.0f;
            f10 = l < 2 ? (f10 *= f5) : (f10 *= f6);
            tessellator.setColorOpaque_F(f4 * f10 * f, f4 * f10 * f1, f4 * f10 * f2);
            tessellator.addVertexWithUV(d14, (double)par3 + d11, d13, d17, d19);
            tessellator.addVertexWithUV(d16, (double)par3 + d9, d15, d18, d20);
            tessellator.addVertexWithUV(d16, par3 + 0, d15, d18, d21);
            tessellator.addVertexWithUV(d14, par3 + 0, d13, d17, d21);
        }
        par1Block.minY = d;
        par1Block.maxY = d1;
        return flag2;
    }

    public float getFluidHeight(int par1, int par2, int par3, Material par4Material) {
        int i = 0;
        float f = 0.0f;
        for (int j = 0; j < 4; ++j) {
            int k = par1 - (j & 1);
            int l = par3 - (j >> 1 & 1);
            if (this.blockAccess.getBlockMaterial(k, par2 + 1, l) == par4Material) {
                return 1.0f;
            }
            Material material = this.blockAccess.getBlockMaterial(k, par2, l);
            if (material == par4Material) {
                int i1 = this.blockAccess.getBlockMetadata(k, par2, l);
                if (i1 >= 8 || i1 == 0) {
                    f += BlockFluid.getFluidHeightPercent(i1) * 10.0f;
                    i += 10;
                }
                f += BlockFluid.getFluidHeightPercent(i1);
                ++i;
                continue;
            }
            if (material.isSolid()) continue;
            f += 1.0f;
            ++i;
        }
        return 1.0f - f / (float)i;
    }

    public void renderBlockFallingSand(Block par1Block, World par2World, int par3, int par4, int par5) {
        float f = 0.5f;
        float f1 = 1.0f;
        float f2 = 0.8f;
        float f3 = 0.6f;
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawingQuads();
        tessellator.setBrightness(par1Block.getMixedBrightnessForBlock(par2World, par3, par4, par5));
        float f4 = 1.0f;
        float f5 = 1.0f;
        if (f5 < f4) {
            f5 = f4;
        }
        tessellator.setColorOpaque_F(f * f5, f * f5, f * f5);
        this.renderBottomFace(par1Block, -0.5, -0.5, -0.5, par1Block.getBlockTextureFromSide(0));
        f5 = 1.0f;
        if (f5 < f4) {
            f5 = f4;
        }
        tessellator.setColorOpaque_F(f1 * f5, f1 * f5, f1 * f5);
        this.renderTopFace(par1Block, -0.5, -0.5, -0.5, par1Block.getBlockTextureFromSide(1));
        f5 = 1.0f;
        if (f5 < f4) {
            f5 = f4;
        }
        tessellator.setColorOpaque_F(f2 * f5, f2 * f5, f2 * f5);
        this.renderEastFace(par1Block, -0.5, -0.5, -0.5, par1Block.getBlockTextureFromSide(2));
        f5 = 1.0f;
        if (f5 < f4) {
            f5 = f4;
        }
        tessellator.setColorOpaque_F(f2 * f5, f2 * f5, f2 * f5);
        this.renderWestFace(par1Block, -0.5, -0.5, -0.5, par1Block.getBlockTextureFromSide(3));
        f5 = 1.0f;
        if (f5 < f4) {
            f5 = f4;
        }
        tessellator.setColorOpaque_F(f3 * f5, f3 * f5, f3 * f5);
        this.renderNorthFace(par1Block, -0.5, -0.5, -0.5, par1Block.getBlockTextureFromSide(4));
        f5 = 1.0f;
        if (f5 < f4) {
            f5 = f4;
        }
        tessellator.setColorOpaque_F(f3 * f5, f3 * f5, f3 * f5);
        this.renderSouthFace(par1Block, -0.5, -0.5, -0.5, par1Block.getBlockTextureFromSide(5));
        tessellator.draw();
    }

    public boolean renderStandardBlock(Block par1Block, int par2, int par3, int par4) {
        int i = par1Block.colorMultiplier(this.blockAccess, par2, par3, par4);
        float f = (float)(i >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(i >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(i & 0xFF) / 255.0f;
        if (EntityRenderer.anaglyphEnable) {
            float f3 = (f * 30.0f + f1 * 59.0f + f2 * 11.0f) / 100.0f;
            float f4 = (f * 30.0f + f1 * 70.0f) / 100.0f;
            float f5 = (f * 30.0f + f2 * 70.0f) / 100.0f;
            f = f3;
            f1 = f4;
            f2 = f5;
        }
        return !Minecraft.isAmbientOcclusionEnabled() || Block.lightValue[par1Block.blockID] != 0 ? this.renderStandardBlockWithColorMultiplier(par1Block, par2, par3, par4, f, f1, f2) : this.renderStandardBlockWithAmbientOcclusion(par1Block, par2, par3, par4, f, f1, f2);
    }

    public boolean renderStandardBlockWithAmbientOcclusion(Block par1Block, int par2, int par3, int par4, float par5, float par6, float par7) {
        int i;
        this.enableAO = true;
        boolean flag = false;
        float f = this.lightValueOwn;
        float f7 = this.lightValueOwn;
        float f14 = this.lightValueOwn;
        float f21 = this.lightValueOwn;
        boolean flag1 = true;
        boolean flag2 = true;
        boolean flag3 = true;
        boolean flag4 = true;
        boolean flag5 = true;
        boolean flag6 = true;
        this.lightValueOwn = par1Block.getAmbientOcclusionLightValue(this.blockAccess, par2, par3, par4);
        this.aoLightValueXNeg = par1Block.getAmbientOcclusionLightValue(this.blockAccess, par2 - 1, par3, par4);
        this.aoLightValueYNeg = par1Block.getAmbientOcclusionLightValue(this.blockAccess, par2, par3 - 1, par4);
        this.aoLightValueZNeg = par1Block.getAmbientOcclusionLightValue(this.blockAccess, par2, par3, par4 - 1);
        this.aoLightValueXPos = par1Block.getAmbientOcclusionLightValue(this.blockAccess, par2 + 1, par3, par4);
        this.aoLightValueYPos = par1Block.getAmbientOcclusionLightValue(this.blockAccess, par2, par3 + 1, par4);
        this.aoLightValueZPos = par1Block.getAmbientOcclusionLightValue(this.blockAccess, par2, par3, par4 + 1);
        int j = i = par1Block.getMixedBrightnessForBlock(this.blockAccess, par2, par3, par4);
        int k = i;
        int l = i;
        int i1 = i;
        int j1 = i;
        int k1 = i;
        if (par1Block.minY <= 0.0) {
            k = par1Block.getMixedBrightnessForBlock(this.blockAccess, par2, par3 - 1, par4);
        }
        if (par1Block.maxY >= 1.0) {
            j1 = par1Block.getMixedBrightnessForBlock(this.blockAccess, par2, par3 + 1, par4);
        }
        if (par1Block.minX <= 0.0) {
            j = par1Block.getMixedBrightnessForBlock(this.blockAccess, par2 - 1, par3, par4);
        }
        if (par1Block.maxX >= 1.0) {
            i1 = par1Block.getMixedBrightnessForBlock(this.blockAccess, par2 + 1, par3, par4);
        }
        if (par1Block.minZ <= 0.0) {
            l = par1Block.getMixedBrightnessForBlock(this.blockAccess, par2, par3, par4 - 1);
        }
        if (par1Block.maxZ >= 1.0) {
            k1 = par1Block.getMixedBrightnessForBlock(this.blockAccess, par2, par3, par4 + 1);
        }
        Tessellator tessellator = Tessellator.instance;
        tessellator.setBrightness(983055);
        this.aoGrassXYZPPC = Block.canBlockGrass[this.blockAccess.getBlockId(par2 + 1, par3 + 1, par4)];
        this.aoGrassXYZPNC = Block.canBlockGrass[this.blockAccess.getBlockId(par2 + 1, par3 - 1, par4)];
        this.aoGrassXYZPCP = Block.canBlockGrass[this.blockAccess.getBlockId(par2 + 1, par3, par4 + 1)];
        this.aoGrassXYZPCN = Block.canBlockGrass[this.blockAccess.getBlockId(par2 + 1, par3, par4 - 1)];
        this.aoGrassXYZNPC = Block.canBlockGrass[this.blockAccess.getBlockId(par2 - 1, par3 + 1, par4)];
        this.aoGrassXYZNNC = Block.canBlockGrass[this.blockAccess.getBlockId(par2 - 1, par3 - 1, par4)];
        this.aoGrassXYZNCN = Block.canBlockGrass[this.blockAccess.getBlockId(par2 - 1, par3, par4 - 1)];
        this.aoGrassXYZNCP = Block.canBlockGrass[this.blockAccess.getBlockId(par2 - 1, par3, par4 + 1)];
        this.aoGrassXYZCPP = Block.canBlockGrass[this.blockAccess.getBlockId(par2, par3 + 1, par4 + 1)];
        this.aoGrassXYZCPN = Block.canBlockGrass[this.blockAccess.getBlockId(par2, par3 + 1, par4 - 1)];
        this.aoGrassXYZCNP = Block.canBlockGrass[this.blockAccess.getBlockId(par2, par3 - 1, par4 + 1)];
        this.aoGrassXYZCNN = Block.canBlockGrass[this.blockAccess.getBlockId(par2, par3 - 1, par4 - 1)];
        if (par1Block.blockIndexInTexture == 3) {
            flag6 = false;
            flag5 = false;
            flag4 = false;
            flag3 = false;
            flag1 = false;
        }
        if (this.overrideBlockTexture >= 0) {
            flag6 = false;
            flag5 = false;
            flag4 = false;
            flag3 = false;
            flag1 = false;
        }
        if (this.renderAllFaces || par1Block.shouldSideBeRendered(this.blockAccess, par2, par3 - 1, par4, 0)) {
            float f8;
            float f15;
            float f22;
            float f1;
            if (this.aoType > 0) {
                if (par1Block.minY <= 0.0) {
                    --par3;
                }
                this.aoBrightnessXYNN = par1Block.getMixedBrightnessForBlock(this.blockAccess, par2 - 1, par3, par4);
                this.aoBrightnessYZNN = par1Block.getMixedBrightnessForBlock(this.blockAccess, par2, par3, par4 - 1);
                this.aoBrightnessYZNP = par1Block.getMixedBrightnessForBlock(this.blockAccess, par2, par3, par4 + 1);
                this.aoBrightnessXYPN = par1Block.getMixedBrightnessForBlock(this.blockAccess, par2 + 1, par3, par4);
                this.aoLightValueScratchXYNN = par1Block.getAmbientOcclusionLightValue(this.blockAccess, par2 - 1, par3, par4);
                this.aoLightValueScratchYZNN = par1Block.getAmbientOcclusionLightValue(this.blockAccess, par2, par3, par4 - 1);
                this.aoLightValueScratchYZNP = par1Block.getAmbientOcclusionLightValue(this.blockAccess, par2, par3, par4 + 1);
                this.aoLightValueScratchXYPN = par1Block.getAmbientOcclusionLightValue(this.blockAccess, par2 + 1, par3, par4);
                if (!this.aoGrassXYZCNN && !this.aoGrassXYZNNC) {
                    this.aoLightValueScratchXYZNNN = this.aoLightValueScratchXYNN;
                    this.aoBrightnessXYZNNN = this.aoBrightnessXYNN;
                } else {
                    this.aoLightValueScratchXYZNNN = par1Block.getAmbientOcclusionLightValue(this.blockAccess, par2 - 1, par3, par4 - 1);
                    this.aoBrightnessXYZNNN = par1Block.getMixedBrightnessForBlock(this.blockAccess, par2 - 1, par3, par4 - 1);
                }
                if (!this.aoGrassXYZCNP && !this.aoGrassXYZNNC) {
                    this.aoLightValueScratchXYZNNP = this.aoLightValueScratchXYNN;
                    this.aoBrightnessXYZNNP = this.aoBrightnessXYNN;
                } else {
                    this.aoLightValueScratchXYZNNP = par1Block.getAmbientOcclusionLightValue(this.blockAccess, par2 - 1, par3, par4 + 1);
                    this.aoBrightnessXYZNNP = par1Block.getMixedBrightnessForBlock(this.blockAccess, par2 - 1, par3, par4 + 1);
                }
                if (!this.aoGrassXYZCNN && !this.aoGrassXYZPNC) {
                    this.aoLightValueScratchXYZPNN = this.aoLightValueScratchXYPN;
                    this.aoBrightnessXYZPNN = this.aoBrightnessXYPN;
                } else {
                    this.aoLightValueScratchXYZPNN = par1Block.getAmbientOcclusionLightValue(this.blockAccess, par2 + 1, par3, par4 - 1);
                    this.aoBrightnessXYZPNN = par1Block.getMixedBrightnessForBlock(this.blockAccess, par2 + 1, par3, par4 - 1);
                }
                if (!this.aoGrassXYZCNP && !this.aoGrassXYZPNC) {
                    this.aoLightValueScratchXYZPNP = this.aoLightValueScratchXYPN;
                    this.aoBrightnessXYZPNP = this.aoBrightnessXYPN;
                } else {
                    this.aoLightValueScratchXYZPNP = par1Block.getAmbientOcclusionLightValue(this.blockAccess, par2 + 1, par3, par4 + 1);
                    this.aoBrightnessXYZPNP = par1Block.getMixedBrightnessForBlock(this.blockAccess, par2 + 1, par3, par4 + 1);
                }
                if (par1Block.minY <= 0.0) {
                    ++par3;
                }
                f1 = (this.aoLightValueScratchXYZNNP + this.aoLightValueScratchXYNN + this.aoLightValueScratchYZNP + this.aoLightValueYNeg) / 4.0f;
                f22 = (this.aoLightValueScratchYZNP + this.aoLightValueYNeg + this.aoLightValueScratchXYZPNP + this.aoLightValueScratchXYPN) / 4.0f;
                f15 = (this.aoLightValueYNeg + this.aoLightValueScratchYZNN + this.aoLightValueScratchXYPN + this.aoLightValueScratchXYZPNN) / 4.0f;
                f8 = (this.aoLightValueScratchXYNN + this.aoLightValueScratchXYZNNN + this.aoLightValueYNeg + this.aoLightValueScratchYZNN) / 4.0f;
                this.brightnessTopLeft = this.getAoBrightness(this.aoBrightnessXYZNNP, this.aoBrightnessXYNN, this.aoBrightnessYZNP, k);
                this.brightnessTopRight = this.getAoBrightness(this.aoBrightnessYZNP, this.aoBrightnessXYZPNP, this.aoBrightnessXYPN, k);
                this.brightnessBottomRight = this.getAoBrightness(this.aoBrightnessYZNN, this.aoBrightnessXYPN, this.aoBrightnessXYZPNN, k);
                this.brightnessBottomLeft = this.getAoBrightness(this.aoBrightnessXYNN, this.aoBrightnessXYZNNN, this.aoBrightnessYZNN, k);
            } else {
                f22 = this.aoLightValueYNeg;
                f15 = this.aoLightValueYNeg;
                f8 = this.aoLightValueYNeg;
                f1 = this.aoLightValueYNeg;
                this.brightnessBottomRight = this.brightnessTopRight = this.aoBrightnessXYNN;
                this.brightnessBottomLeft = this.brightnessTopRight;
                this.brightnessTopLeft = this.brightnessTopRight;
            }
            this.colorRedBottomRight = this.colorRedTopRight = (flag1 ? par5 : 1.0f) * 0.5f;
            this.colorRedBottomLeft = this.colorRedTopRight;
            this.colorRedTopLeft = this.colorRedTopRight;
            this.colorGreenBottomRight = this.colorGreenTopRight = (flag1 ? par6 : 1.0f) * 0.5f;
            this.colorGreenBottomLeft = this.colorGreenTopRight;
            this.colorGreenTopLeft = this.colorGreenTopRight;
            this.colorBlueBottomRight = this.colorBlueTopRight = (flag1 ? par7 : 1.0f) * 0.5f;
            this.colorBlueBottomLeft = this.colorBlueTopRight;
            this.colorBlueTopLeft = this.colorBlueTopRight;
            this.colorRedTopLeft *= f1;
            this.colorGreenTopLeft *= f1;
            this.colorBlueTopLeft *= f1;
            this.colorRedBottomLeft *= f8;
            this.colorGreenBottomLeft *= f8;
            this.colorBlueBottomLeft *= f8;
            this.colorRedBottomRight *= f15;
            this.colorGreenBottomRight *= f15;
            this.colorBlueBottomRight *= f15;
            this.colorRedTopRight *= f22;
            this.colorGreenTopRight *= f22;
            this.colorBlueTopRight *= f22;
            this.renderBottomFace(par1Block, par2, par3, par4, par1Block.getBlockTexture(this.blockAccess, par2, par3, par4, 0));
            flag = true;
        }
        if (this.renderAllFaces || par1Block.shouldSideBeRendered(this.blockAccess, par2, par3 + 1, par4, 1)) {
            float f16;
            float f9;
            float f2;
            float f23;
            if (this.aoType > 0) {
                if (par1Block.maxY >= 1.0) {
                    ++par3;
                }
                this.aoBrightnessXYNP = par1Block.getMixedBrightnessForBlock(this.blockAccess, par2 - 1, par3, par4);
                this.aoBrightnessXYPP = par1Block.getMixedBrightnessForBlock(this.blockAccess, par2 + 1, par3, par4);
                this.aoBrightnessYZPN = par1Block.getMixedBrightnessForBlock(this.blockAccess, par2, par3, par4 - 1);
                this.aoBrightnessYZPP = par1Block.getMixedBrightnessForBlock(this.blockAccess, par2, par3, par4 + 1);
                this.aoLightValueScratchXYNP = par1Block.getAmbientOcclusionLightValue(this.blockAccess, par2 - 1, par3, par4);
                this.aoLightValueScratchXYPP = par1Block.getAmbientOcclusionLightValue(this.blockAccess, par2 + 1, par3, par4);
                this.aoLightValueScratchYZPN = par1Block.getAmbientOcclusionLightValue(this.blockAccess, par2, par3, par4 - 1);
                this.aoLightValueScratchYZPP = par1Block.getAmbientOcclusionLightValue(this.blockAccess, par2, par3, par4 + 1);
                if (!this.aoGrassXYZCPN && !this.aoGrassXYZNPC) {
                    this.aoLightValueScratchXYZNPN = this.aoLightValueScratchXYNP;
                    this.aoBrightnessXYZNPN = this.aoBrightnessXYNP;
                } else {
                    this.aoLightValueScratchXYZNPN = par1Block.getAmbientOcclusionLightValue(this.blockAccess, par2 - 1, par3, par4 - 1);
                    this.aoBrightnessXYZNPN = par1Block.getMixedBrightnessForBlock(this.blockAccess, par2 - 1, par3, par4 - 1);
                }
                if (!this.aoGrassXYZCPN && !this.aoGrassXYZPPC) {
                    this.aoLightValueScratchXYZPPN = this.aoLightValueScratchXYPP;
                    this.aoBrightnessXYZPPN = this.aoBrightnessXYPP;
                } else {
                    this.aoLightValueScratchXYZPPN = par1Block.getAmbientOcclusionLightValue(this.blockAccess, par2 + 1, par3, par4 - 1);
                    this.aoBrightnessXYZPPN = par1Block.getMixedBrightnessForBlock(this.blockAccess, par2 + 1, par3, par4 - 1);
                }
                if (!this.aoGrassXYZCPP && !this.aoGrassXYZNPC) {
                    this.aoLightValueScratchXYZNPP = this.aoLightValueScratchXYNP;
                    this.aoBrightnessXYZNPP = this.aoBrightnessXYNP;
                } else {
                    this.aoLightValueScratchXYZNPP = par1Block.getAmbientOcclusionLightValue(this.blockAccess, par2 - 1, par3, par4 + 1);
                    this.aoBrightnessXYZNPP = par1Block.getMixedBrightnessForBlock(this.blockAccess, par2 - 1, par3, par4 + 1);
                }
                if (!this.aoGrassXYZCPP && !this.aoGrassXYZPPC) {
                    this.aoLightValueScratchXYZPPP = this.aoLightValueScratchXYPP;
                    this.aoBrightnessXYZPPP = this.aoBrightnessXYPP;
                } else {
                    this.aoLightValueScratchXYZPPP = par1Block.getAmbientOcclusionLightValue(this.blockAccess, par2 + 1, par3, par4 + 1);
                    this.aoBrightnessXYZPPP = par1Block.getMixedBrightnessForBlock(this.blockAccess, par2 + 1, par3, par4 + 1);
                }
                if (par1Block.maxY >= 1.0) {
                    --par3;
                }
                f23 = (this.aoLightValueScratchXYZNPP + this.aoLightValueScratchXYNP + this.aoLightValueScratchYZPP + this.aoLightValueYPos) / 4.0f;
                f2 = (this.aoLightValueScratchYZPP + this.aoLightValueYPos + this.aoLightValueScratchXYZPPP + this.aoLightValueScratchXYPP) / 4.0f;
                f9 = (this.aoLightValueYPos + this.aoLightValueScratchYZPN + this.aoLightValueScratchXYPP + this.aoLightValueScratchXYZPPN) / 4.0f;
                f16 = (this.aoLightValueScratchXYNP + this.aoLightValueScratchXYZNPN + this.aoLightValueYPos + this.aoLightValueScratchYZPN) / 4.0f;
                this.brightnessTopRight = this.getAoBrightness(this.aoBrightnessXYZNPP, this.aoBrightnessXYNP, this.aoBrightnessYZPP, j1);
                this.brightnessTopLeft = this.getAoBrightness(this.aoBrightnessYZPP, this.aoBrightnessXYZPPP, this.aoBrightnessXYPP, j1);
                this.brightnessBottomLeft = this.getAoBrightness(this.aoBrightnessYZPN, this.aoBrightnessXYPP, this.aoBrightnessXYZPPN, j1);
                this.brightnessBottomRight = this.getAoBrightness(this.aoBrightnessXYNP, this.aoBrightnessXYZNPN, this.aoBrightnessYZPN, j1);
            } else {
                f23 = this.aoLightValueYPos;
                f16 = this.aoLightValueYPos;
                f9 = this.aoLightValueYPos;
                f2 = this.aoLightValueYPos;
                this.brightnessBottomRight = this.brightnessTopRight = j1;
                this.brightnessBottomLeft = this.brightnessTopRight;
                this.brightnessTopLeft = this.brightnessTopRight;
            }
            this.colorRedTopRight = flag2 ? par5 : 1.0f;
            this.colorRedBottomRight = this.colorRedTopRight;
            this.colorRedBottomLeft = this.colorRedTopRight;
            this.colorRedTopLeft = this.colorRedTopRight;
            this.colorGreenTopRight = flag2 ? par6 : 1.0f;
            this.colorGreenBottomRight = this.colorGreenTopRight;
            this.colorGreenBottomLeft = this.colorGreenTopRight;
            this.colorGreenTopLeft = this.colorGreenTopRight;
            this.colorBlueTopRight = flag2 ? par7 : 1.0f;
            this.colorBlueBottomRight = this.colorBlueTopRight;
            this.colorBlueBottomLeft = this.colorBlueTopRight;
            this.colorBlueTopLeft = this.colorBlueTopRight;
            this.colorRedTopLeft *= f2;
            this.colorGreenTopLeft *= f2;
            this.colorBlueTopLeft *= f2;
            this.colorRedBottomLeft *= f9;
            this.colorGreenBottomLeft *= f9;
            this.colorBlueBottomLeft *= f9;
            this.colorRedBottomRight *= f16;
            this.colorGreenBottomRight *= f16;
            this.colorBlueBottomRight *= f16;
            this.colorRedTopRight *= f23;
            this.colorGreenTopRight *= f23;
            this.colorBlueTopRight *= f23;
            this.renderTopFace(par1Block, par2, par3, par4, par1Block.getBlockTexture(this.blockAccess, par2, par3, par4, 1));
            flag = true;
        }
        if (this.renderAllFaces || par1Block.shouldSideBeRendered(this.blockAccess, par2, par3, par4 - 1, 2)) {
            float f24;
            float f17;
            float f10;
            float f3;
            if (this.aoType > 0) {
                if (par1Block.minZ <= 0.0) {
                    --par4;
                }
                this.aoLightValueScratchXZNN = par1Block.getAmbientOcclusionLightValue(this.blockAccess, par2 - 1, par3, par4);
                this.aoLightValueScratchYZNN = par1Block.getAmbientOcclusionLightValue(this.blockAccess, par2, par3 - 1, par4);
                this.aoLightValueScratchYZPN = par1Block.getAmbientOcclusionLightValue(this.blockAccess, par2, par3 + 1, par4);
                this.aoLightValueScratchXZPN = par1Block.getAmbientOcclusionLightValue(this.blockAccess, par2 + 1, par3, par4);
                this.aoBrightnessXZNN = par1Block.getMixedBrightnessForBlock(this.blockAccess, par2 - 1, par3, par4);
                this.aoBrightnessYZNN = par1Block.getMixedBrightnessForBlock(this.blockAccess, par2, par3 - 1, par4);
                this.aoBrightnessYZPN = par1Block.getMixedBrightnessForBlock(this.blockAccess, par2, par3 + 1, par4);
                this.aoBrightnessXZPN = par1Block.getMixedBrightnessForBlock(this.blockAccess, par2 + 1, par3, par4);
                if (!this.aoGrassXYZNCN && !this.aoGrassXYZCNN) {
                    this.aoLightValueScratchXYZNNN = this.aoLightValueScratchXZNN;
                    this.aoBrightnessXYZNNN = this.aoBrightnessXZNN;
                } else {
                    this.aoLightValueScratchXYZNNN = par1Block.getAmbientOcclusionLightValue(this.blockAccess, par2 - 1, par3 - 1, par4);
                    this.aoBrightnessXYZNNN = par1Block.getMixedBrightnessForBlock(this.blockAccess, par2 - 1, par3 - 1, par4);
                }
                if (!this.aoGrassXYZNCN && !this.aoGrassXYZCPN) {
                    this.aoLightValueScratchXYZNPN = this.aoLightValueScratchXZNN;
                    this.aoBrightnessXYZNPN = this.aoBrightnessXZNN;
                } else {
                    this.aoLightValueScratchXYZNPN = par1Block.getAmbientOcclusionLightValue(this.blockAccess, par2 - 1, par3 + 1, par4);
                    this.aoBrightnessXYZNPN = par1Block.getMixedBrightnessForBlock(this.blockAccess, par2 - 1, par3 + 1, par4);
                }
                if (!this.aoGrassXYZPCN && !this.aoGrassXYZCNN) {
                    this.aoLightValueScratchXYZPNN = this.aoLightValueScratchXZPN;
                    this.aoBrightnessXYZPNN = this.aoBrightnessXZPN;
                } else {
                    this.aoLightValueScratchXYZPNN = par1Block.getAmbientOcclusionLightValue(this.blockAccess, par2 + 1, par3 - 1, par4);
                    this.aoBrightnessXYZPNN = par1Block.getMixedBrightnessForBlock(this.blockAccess, par2 + 1, par3 - 1, par4);
                }
                if (!this.aoGrassXYZPCN && !this.aoGrassXYZCPN) {
                    this.aoLightValueScratchXYZPPN = this.aoLightValueScratchXZPN;
                    this.aoBrightnessXYZPPN = this.aoBrightnessXZPN;
                } else {
                    this.aoLightValueScratchXYZPPN = par1Block.getAmbientOcclusionLightValue(this.blockAccess, par2 + 1, par3 + 1, par4);
                    this.aoBrightnessXYZPPN = par1Block.getMixedBrightnessForBlock(this.blockAccess, par2 + 1, par3 + 1, par4);
                }
                if (par1Block.minZ <= 0.0) {
                    ++par4;
                }
                f3 = (this.aoLightValueScratchXZNN + this.aoLightValueScratchXYZNPN + this.aoLightValueZNeg + this.aoLightValueScratchYZPN) / 4.0f;
                f10 = (this.aoLightValueZNeg + this.aoLightValueScratchYZPN + this.aoLightValueScratchXZPN + this.aoLightValueScratchXYZPPN) / 4.0f;
                f17 = (this.aoLightValueScratchYZNN + this.aoLightValueZNeg + this.aoLightValueScratchXYZPNN + this.aoLightValueScratchXZPN) / 4.0f;
                f24 = (this.aoLightValueScratchXYZNNN + this.aoLightValueScratchXZNN + this.aoLightValueScratchYZNN + this.aoLightValueZNeg) / 4.0f;
                this.brightnessTopLeft = this.getAoBrightness(this.aoBrightnessXZNN, this.aoBrightnessXYZNPN, this.aoBrightnessYZPN, l);
                this.brightnessBottomLeft = this.getAoBrightness(this.aoBrightnessYZPN, this.aoBrightnessXZPN, this.aoBrightnessXYZPPN, l);
                this.brightnessBottomRight = this.getAoBrightness(this.aoBrightnessYZNN, this.aoBrightnessXYZPNN, this.aoBrightnessXZPN, l);
                this.brightnessTopRight = this.getAoBrightness(this.aoBrightnessXYZNNN, this.aoBrightnessXZNN, this.aoBrightnessYZNN, l);
            } else {
                f24 = this.aoLightValueZNeg;
                f17 = this.aoLightValueZNeg;
                f10 = this.aoLightValueZNeg;
                f3 = this.aoLightValueZNeg;
                this.brightnessBottomRight = this.brightnessTopRight = l;
                this.brightnessBottomLeft = this.brightnessTopRight;
                this.brightnessTopLeft = this.brightnessTopRight;
            }
            this.colorRedBottomRight = this.colorRedTopRight = (flag3 ? par5 : 1.0f) * 0.8f;
            this.colorRedBottomLeft = this.colorRedTopRight;
            this.colorRedTopLeft = this.colorRedTopRight;
            this.colorGreenBottomRight = this.colorGreenTopRight = (flag3 ? par6 : 1.0f) * 0.8f;
            this.colorGreenBottomLeft = this.colorGreenTopRight;
            this.colorGreenTopLeft = this.colorGreenTopRight;
            this.colorBlueBottomRight = this.colorBlueTopRight = (flag3 ? par7 : 1.0f) * 0.8f;
            this.colorBlueBottomLeft = this.colorBlueTopRight;
            this.colorBlueTopLeft = this.colorBlueTopRight;
            this.colorRedTopLeft *= f3;
            this.colorGreenTopLeft *= f3;
            this.colorBlueTopLeft *= f3;
            this.colorRedBottomLeft *= f10;
            this.colorGreenBottomLeft *= f10;
            this.colorBlueBottomLeft *= f10;
            this.colorRedBottomRight *= f17;
            this.colorGreenBottomRight *= f17;
            this.colorBlueBottomRight *= f17;
            this.colorRedTopRight *= f24;
            this.colorGreenTopRight *= f24;
            this.colorBlueTopRight *= f24;
            int l1 = par1Block.getBlockTexture(this.blockAccess, par2, par3, par4, 2);
            this.renderEastFace(par1Block, par2, par3, par4, l1);
            if (cfgGrassFix && l1 == 3 && this.overrideBlockTexture < 0) {
                this.colorRedTopLeft *= par5;
                this.colorRedBottomLeft *= par5;
                this.colorRedBottomRight *= par5;
                this.colorRedTopRight *= par5;
                this.colorGreenTopLeft *= par6;
                this.colorGreenBottomLeft *= par6;
                this.colorGreenBottomRight *= par6;
                this.colorGreenTopRight *= par6;
                this.colorBlueTopLeft *= par7;
                this.colorBlueBottomLeft *= par7;
                this.colorBlueBottomRight *= par7;
                this.colorBlueTopRight *= par7;
                this.renderEastFace(par1Block, par2, par3, par4, 38);
            }
            flag = true;
        }
        if (this.renderAllFaces || par1Block.shouldSideBeRendered(this.blockAccess, par2, par3, par4 + 1, 3)) {
            float f11;
            float f18;
            float f25;
            float f4;
            if (this.aoType > 0) {
                if (par1Block.maxZ >= 1.0) {
                    ++par4;
                }
                this.aoLightValueScratchXZNP = par1Block.getAmbientOcclusionLightValue(this.blockAccess, par2 - 1, par3, par4);
                this.aoLightValueScratchXZPP = par1Block.getAmbientOcclusionLightValue(this.blockAccess, par2 + 1, par3, par4);
                this.aoLightValueScratchYZNP = par1Block.getAmbientOcclusionLightValue(this.blockAccess, par2, par3 - 1, par4);
                this.aoLightValueScratchYZPP = par1Block.getAmbientOcclusionLightValue(this.blockAccess, par2, par3 + 1, par4);
                this.aoBrightnessXZNP = par1Block.getMixedBrightnessForBlock(this.blockAccess, par2 - 1, par3, par4);
                this.aoBrightnessXZPP = par1Block.getMixedBrightnessForBlock(this.blockAccess, par2 + 1, par3, par4);
                this.aoBrightnessYZNP = par1Block.getMixedBrightnessForBlock(this.blockAccess, par2, par3 - 1, par4);
                this.aoBrightnessYZPP = par1Block.getMixedBrightnessForBlock(this.blockAccess, par2, par3 + 1, par4);
                if (!this.aoGrassXYZNCP && !this.aoGrassXYZCNP) {
                    this.aoLightValueScratchXYZNNP = this.aoLightValueScratchXZNP;
                    this.aoBrightnessXYZNNP = this.aoBrightnessXZNP;
                } else {
                    this.aoLightValueScratchXYZNNP = par1Block.getAmbientOcclusionLightValue(this.blockAccess, par2 - 1, par3 - 1, par4);
                    this.aoBrightnessXYZNNP = par1Block.getMixedBrightnessForBlock(this.blockAccess, par2 - 1, par3 - 1, par4);
                }
                if (!this.aoGrassXYZNCP && !this.aoGrassXYZCPP) {
                    this.aoLightValueScratchXYZNPP = this.aoLightValueScratchXZNP;
                    this.aoBrightnessXYZNPP = this.aoBrightnessXZNP;
                } else {
                    this.aoLightValueScratchXYZNPP = par1Block.getAmbientOcclusionLightValue(this.blockAccess, par2 - 1, par3 + 1, par4);
                    this.aoBrightnessXYZNPP = par1Block.getMixedBrightnessForBlock(this.blockAccess, par2 - 1, par3 + 1, par4);
                }
                if (!this.aoGrassXYZPCP && !this.aoGrassXYZCNP) {
                    this.aoLightValueScratchXYZPNP = this.aoLightValueScratchXZPP;
                    this.aoBrightnessXYZPNP = this.aoBrightnessXZPP;
                } else {
                    this.aoLightValueScratchXYZPNP = par1Block.getAmbientOcclusionLightValue(this.blockAccess, par2 + 1, par3 - 1, par4);
                    this.aoBrightnessXYZPNP = par1Block.getMixedBrightnessForBlock(this.blockAccess, par2 + 1, par3 - 1, par4);
                }
                if (!this.aoGrassXYZPCP && !this.aoGrassXYZCPP) {
                    this.aoLightValueScratchXYZPPP = this.aoLightValueScratchXZPP;
                    this.aoBrightnessXYZPPP = this.aoBrightnessXZPP;
                } else {
                    this.aoLightValueScratchXYZPPP = par1Block.getAmbientOcclusionLightValue(this.blockAccess, par2 + 1, par3 + 1, par4);
                    this.aoBrightnessXYZPPP = par1Block.getMixedBrightnessForBlock(this.blockAccess, par2 + 1, par3 + 1, par4);
                }
                if (par1Block.maxZ >= 1.0) {
                    --par4;
                }
                f4 = (this.aoLightValueScratchXZNP + this.aoLightValueScratchXYZNPP + this.aoLightValueZPos + this.aoLightValueScratchYZPP) / 4.0f;
                f25 = (this.aoLightValueZPos + this.aoLightValueScratchYZPP + this.aoLightValueScratchXZPP + this.aoLightValueScratchXYZPPP) / 4.0f;
                f18 = (this.aoLightValueScratchYZNP + this.aoLightValueZPos + this.aoLightValueScratchXYZPNP + this.aoLightValueScratchXZPP) / 4.0f;
                f11 = (this.aoLightValueScratchXYZNNP + this.aoLightValueScratchXZNP + this.aoLightValueScratchYZNP + this.aoLightValueZPos) / 4.0f;
                this.brightnessTopLeft = this.getAoBrightness(this.aoBrightnessXZNP, this.aoBrightnessXYZNPP, this.aoBrightnessYZPP, k1);
                this.brightnessTopRight = this.getAoBrightness(this.aoBrightnessYZPP, this.aoBrightnessXZPP, this.aoBrightnessXYZPPP, k1);
                this.brightnessBottomRight = this.getAoBrightness(this.aoBrightnessYZNP, this.aoBrightnessXYZPNP, this.aoBrightnessXZPP, k1);
                this.brightnessBottomLeft = this.getAoBrightness(this.aoBrightnessXYZNNP, this.aoBrightnessXZNP, this.aoBrightnessYZNP, k1);
            } else {
                f25 = this.aoLightValueZPos;
                f18 = this.aoLightValueZPos;
                f11 = this.aoLightValueZPos;
                f4 = this.aoLightValueZPos;
                this.brightnessBottomRight = this.brightnessTopRight = k1;
                this.brightnessBottomLeft = this.brightnessTopRight;
                this.brightnessTopLeft = this.brightnessTopRight;
            }
            this.colorRedBottomRight = this.colorRedTopRight = (flag4 ? par5 : 1.0f) * 0.8f;
            this.colorRedBottomLeft = this.colorRedTopRight;
            this.colorRedTopLeft = this.colorRedTopRight;
            this.colorGreenBottomRight = this.colorGreenTopRight = (flag4 ? par6 : 1.0f) * 0.8f;
            this.colorGreenBottomLeft = this.colorGreenTopRight;
            this.colorGreenTopLeft = this.colorGreenTopRight;
            this.colorBlueBottomRight = this.colorBlueTopRight = (flag4 ? par7 : 1.0f) * 0.8f;
            this.colorBlueBottomLeft = this.colorBlueTopRight;
            this.colorBlueTopLeft = this.colorBlueTopRight;
            this.colorRedTopLeft *= f4;
            this.colorGreenTopLeft *= f4;
            this.colorBlueTopLeft *= f4;
            this.colorRedBottomLeft *= f11;
            this.colorGreenBottomLeft *= f11;
            this.colorBlueBottomLeft *= f11;
            this.colorRedBottomRight *= f18;
            this.colorGreenBottomRight *= f18;
            this.colorBlueBottomRight *= f18;
            this.colorRedTopRight *= f25;
            this.colorGreenTopRight *= f25;
            this.colorBlueTopRight *= f25;
            int i2 = par1Block.getBlockTexture(this.blockAccess, par2, par3, par4, 3);
            this.renderWestFace(par1Block, par2, par3, par4, par1Block.getBlockTexture(this.blockAccess, par2, par3, par4, 3));
            if (cfgGrassFix && i2 == 3 && this.overrideBlockTexture < 0) {
                this.colorRedTopLeft *= par5;
                this.colorRedBottomLeft *= par5;
                this.colorRedBottomRight *= par5;
                this.colorRedTopRight *= par5;
                this.colorGreenTopLeft *= par6;
                this.colorGreenBottomLeft *= par6;
                this.colorGreenBottomRight *= par6;
                this.colorGreenTopRight *= par6;
                this.colorBlueTopLeft *= par7;
                this.colorBlueBottomLeft *= par7;
                this.colorBlueBottomRight *= par7;
                this.colorBlueTopRight *= par7;
                this.renderWestFace(par1Block, par2, par3, par4, 38);
            }
            flag = true;
        }
        if (this.renderAllFaces || par1Block.shouldSideBeRendered(this.blockAccess, par2 - 1, par3, par4, 4)) {
            float f19;
            float f12;
            float f5;
            float f26;
            if (this.aoType > 0) {
                if (par1Block.minX <= 0.0) {
                    --par2;
                }
                this.aoLightValueScratchXYNN = par1Block.getAmbientOcclusionLightValue(this.blockAccess, par2, par3 - 1, par4);
                this.aoLightValueScratchXZNN = par1Block.getAmbientOcclusionLightValue(this.blockAccess, par2, par3, par4 - 1);
                this.aoLightValueScratchXZNP = par1Block.getAmbientOcclusionLightValue(this.blockAccess, par2, par3, par4 + 1);
                this.aoLightValueScratchXYNP = par1Block.getAmbientOcclusionLightValue(this.blockAccess, par2, par3 + 1, par4);
                this.aoBrightnessXYNN = par1Block.getMixedBrightnessForBlock(this.blockAccess, par2, par3 - 1, par4);
                this.aoBrightnessXZNN = par1Block.getMixedBrightnessForBlock(this.blockAccess, par2, par3, par4 - 1);
                this.aoBrightnessXZNP = par1Block.getMixedBrightnessForBlock(this.blockAccess, par2, par3, par4 + 1);
                this.aoBrightnessXYNP = par1Block.getMixedBrightnessForBlock(this.blockAccess, par2, par3 + 1, par4);
                if (!this.aoGrassXYZNCN && !this.aoGrassXYZNNC) {
                    this.aoLightValueScratchXYZNNN = this.aoLightValueScratchXZNN;
                    this.aoBrightnessXYZNNN = this.aoBrightnessXZNN;
                } else {
                    this.aoLightValueScratchXYZNNN = par1Block.getAmbientOcclusionLightValue(this.blockAccess, par2, par3 - 1, par4 - 1);
                    this.aoBrightnessXYZNNN = par1Block.getMixedBrightnessForBlock(this.blockAccess, par2, par3 - 1, par4 - 1);
                }
                if (!this.aoGrassXYZNCP && !this.aoGrassXYZNNC) {
                    this.aoLightValueScratchXYZNNP = this.aoLightValueScratchXZNP;
                    this.aoBrightnessXYZNNP = this.aoBrightnessXZNP;
                } else {
                    this.aoLightValueScratchXYZNNP = par1Block.getAmbientOcclusionLightValue(this.blockAccess, par2, par3 - 1, par4 + 1);
                    this.aoBrightnessXYZNNP = par1Block.getMixedBrightnessForBlock(this.blockAccess, par2, par3 - 1, par4 + 1);
                }
                if (!this.aoGrassXYZNCN && !this.aoGrassXYZNPC) {
                    this.aoLightValueScratchXYZNPN = this.aoLightValueScratchXZNN;
                    this.aoBrightnessXYZNPN = this.aoBrightnessXZNN;
                } else {
                    this.aoLightValueScratchXYZNPN = par1Block.getAmbientOcclusionLightValue(this.blockAccess, par2, par3 + 1, par4 - 1);
                    this.aoBrightnessXYZNPN = par1Block.getMixedBrightnessForBlock(this.blockAccess, par2, par3 + 1, par4 - 1);
                }
                if (!this.aoGrassXYZNCP && !this.aoGrassXYZNPC) {
                    this.aoLightValueScratchXYZNPP = this.aoLightValueScratchXZNP;
                    this.aoBrightnessXYZNPP = this.aoBrightnessXZNP;
                } else {
                    this.aoLightValueScratchXYZNPP = par1Block.getAmbientOcclusionLightValue(this.blockAccess, par2, par3 + 1, par4 + 1);
                    this.aoBrightnessXYZNPP = par1Block.getMixedBrightnessForBlock(this.blockAccess, par2, par3 + 1, par4 + 1);
                }
                if (par1Block.minX <= 0.0) {
                    ++par2;
                }
                f26 = (this.aoLightValueScratchXYNN + this.aoLightValueScratchXYZNNP + this.aoLightValueXNeg + this.aoLightValueScratchXZNP) / 4.0f;
                f5 = (this.aoLightValueXNeg + this.aoLightValueScratchXZNP + this.aoLightValueScratchXYNP + this.aoLightValueScratchXYZNPP) / 4.0f;
                f12 = (this.aoLightValueScratchXZNN + this.aoLightValueXNeg + this.aoLightValueScratchXYZNPN + this.aoLightValueScratchXYNP) / 4.0f;
                f19 = (this.aoLightValueScratchXYZNNN + this.aoLightValueScratchXYNN + this.aoLightValueScratchXZNN + this.aoLightValueXNeg) / 4.0f;
                this.brightnessTopRight = this.getAoBrightness(this.aoBrightnessXYNN, this.aoBrightnessXYZNNP, this.aoBrightnessXZNP, j);
                this.brightnessTopLeft = this.getAoBrightness(this.aoBrightnessXZNP, this.aoBrightnessXYNP, this.aoBrightnessXYZNPP, j);
                this.brightnessBottomLeft = this.getAoBrightness(this.aoBrightnessXZNN, this.aoBrightnessXYZNPN, this.aoBrightnessXYNP, j);
                this.brightnessBottomRight = this.getAoBrightness(this.aoBrightnessXYZNNN, this.aoBrightnessXYNN, this.aoBrightnessXZNN, j);
            } else {
                f26 = this.aoLightValueXNeg;
                f19 = this.aoLightValueXNeg;
                f12 = this.aoLightValueXNeg;
                f5 = this.aoLightValueXNeg;
                this.brightnessBottomRight = this.brightnessTopRight = j;
                this.brightnessBottomLeft = this.brightnessTopRight;
                this.brightnessTopLeft = this.brightnessTopRight;
            }
            this.colorRedBottomRight = this.colorRedTopRight = (flag5 ? par5 : 1.0f) * 0.6f;
            this.colorRedBottomLeft = this.colorRedTopRight;
            this.colorRedTopLeft = this.colorRedTopRight;
            this.colorGreenBottomRight = this.colorGreenTopRight = (flag5 ? par6 : 1.0f) * 0.6f;
            this.colorGreenBottomLeft = this.colorGreenTopRight;
            this.colorGreenTopLeft = this.colorGreenTopRight;
            this.colorBlueBottomRight = this.colorBlueTopRight = (flag5 ? par7 : 1.0f) * 0.6f;
            this.colorBlueBottomLeft = this.colorBlueTopRight;
            this.colorBlueTopLeft = this.colorBlueTopRight;
            this.colorRedTopLeft *= f5;
            this.colorGreenTopLeft *= f5;
            this.colorBlueTopLeft *= f5;
            this.colorRedBottomLeft *= f12;
            this.colorGreenBottomLeft *= f12;
            this.colorBlueBottomLeft *= f12;
            this.colorRedBottomRight *= f19;
            this.colorGreenBottomRight *= f19;
            this.colorBlueBottomRight *= f19;
            this.colorRedTopRight *= f26;
            this.colorGreenTopRight *= f26;
            this.colorBlueTopRight *= f26;
            int j2 = par1Block.getBlockTexture(this.blockAccess, par2, par3, par4, 4);
            this.renderNorthFace(par1Block, par2, par3, par4, j2);
            if (cfgGrassFix && j2 == 3 && this.overrideBlockTexture < 0) {
                this.colorRedTopLeft *= par5;
                this.colorRedBottomLeft *= par5;
                this.colorRedBottomRight *= par5;
                this.colorRedTopRight *= par5;
                this.colorGreenTopLeft *= par6;
                this.colorGreenBottomLeft *= par6;
                this.colorGreenBottomRight *= par6;
                this.colorGreenTopRight *= par6;
                this.colorBlueTopLeft *= par7;
                this.colorBlueBottomLeft *= par7;
                this.colorBlueBottomRight *= par7;
                this.colorBlueTopRight *= par7;
                this.renderNorthFace(par1Block, par2, par3, par4, 38);
            }
            flag = true;
        }
        if (this.renderAllFaces || par1Block.shouldSideBeRendered(this.blockAccess, par2 + 1, par3, par4, 5)) {
            float f13;
            float f20;
            float f27;
            float f6;
            if (this.aoType > 0) {
                if (par1Block.maxX >= 1.0) {
                    ++par2;
                }
                this.aoLightValueScratchXYPN = par1Block.getAmbientOcclusionLightValue(this.blockAccess, par2, par3 - 1, par4);
                this.aoLightValueScratchXZPN = par1Block.getAmbientOcclusionLightValue(this.blockAccess, par2, par3, par4 - 1);
                this.aoLightValueScratchXZPP = par1Block.getAmbientOcclusionLightValue(this.blockAccess, par2, par3, par4 + 1);
                this.aoLightValueScratchXYPP = par1Block.getAmbientOcclusionLightValue(this.blockAccess, par2, par3 + 1, par4);
                this.aoBrightnessXYPN = par1Block.getMixedBrightnessForBlock(this.blockAccess, par2, par3 - 1, par4);
                this.aoBrightnessXZPN = par1Block.getMixedBrightnessForBlock(this.blockAccess, par2, par3, par4 - 1);
                this.aoBrightnessXZPP = par1Block.getMixedBrightnessForBlock(this.blockAccess, par2, par3, par4 + 1);
                this.aoBrightnessXYPP = par1Block.getMixedBrightnessForBlock(this.blockAccess, par2, par3 + 1, par4);
                if (!this.aoGrassXYZPNC && !this.aoGrassXYZPCN) {
                    this.aoLightValueScratchXYZPNN = this.aoLightValueScratchXZPN;
                    this.aoBrightnessXYZPNN = this.aoBrightnessXZPN;
                } else {
                    this.aoLightValueScratchXYZPNN = par1Block.getAmbientOcclusionLightValue(this.blockAccess, par2, par3 - 1, par4 - 1);
                    this.aoBrightnessXYZPNN = par1Block.getMixedBrightnessForBlock(this.blockAccess, par2, par3 - 1, par4 - 1);
                }
                if (!this.aoGrassXYZPNC && !this.aoGrassXYZPCP) {
                    this.aoLightValueScratchXYZPNP = this.aoLightValueScratchXZPP;
                    this.aoBrightnessXYZPNP = this.aoBrightnessXZPP;
                } else {
                    this.aoLightValueScratchXYZPNP = par1Block.getAmbientOcclusionLightValue(this.blockAccess, par2, par3 - 1, par4 + 1);
                    this.aoBrightnessXYZPNP = par1Block.getMixedBrightnessForBlock(this.blockAccess, par2, par3 - 1, par4 + 1);
                }
                if (!this.aoGrassXYZPPC && !this.aoGrassXYZPCN) {
                    this.aoLightValueScratchXYZPPN = this.aoLightValueScratchXZPN;
                    this.aoBrightnessXYZPPN = this.aoBrightnessXZPN;
                } else {
                    this.aoLightValueScratchXYZPPN = par1Block.getAmbientOcclusionLightValue(this.blockAccess, par2, par3 + 1, par4 - 1);
                    this.aoBrightnessXYZPPN = par1Block.getMixedBrightnessForBlock(this.blockAccess, par2, par3 + 1, par4 - 1);
                }
                if (!this.aoGrassXYZPPC && !this.aoGrassXYZPCP) {
                    this.aoLightValueScratchXYZPPP = this.aoLightValueScratchXZPP;
                    this.aoBrightnessXYZPPP = this.aoBrightnessXZPP;
                } else {
                    this.aoLightValueScratchXYZPPP = par1Block.getAmbientOcclusionLightValue(this.blockAccess, par2, par3 + 1, par4 + 1);
                    this.aoBrightnessXYZPPP = par1Block.getMixedBrightnessForBlock(this.blockAccess, par2, par3 + 1, par4 + 1);
                }
                if (par1Block.maxX >= 1.0) {
                    --par2;
                }
                f6 = (this.aoLightValueScratchXYPN + this.aoLightValueScratchXYZPNP + this.aoLightValueXPos + this.aoLightValueScratchXZPP) / 4.0f;
                f27 = (this.aoLightValueXPos + this.aoLightValueScratchXZPP + this.aoLightValueScratchXYPP + this.aoLightValueScratchXYZPPP) / 4.0f;
                f20 = (this.aoLightValueScratchXZPN + this.aoLightValueXPos + this.aoLightValueScratchXYZPPN + this.aoLightValueScratchXYPP) / 4.0f;
                f13 = (this.aoLightValueScratchXYZPNN + this.aoLightValueScratchXYPN + this.aoLightValueScratchXZPN + this.aoLightValueXPos) / 4.0f;
                this.brightnessTopLeft = this.getAoBrightness(this.aoBrightnessXYPN, this.aoBrightnessXYZPNP, this.aoBrightnessXZPP, i1);
                this.brightnessTopRight = this.getAoBrightness(this.aoBrightnessXZPP, this.aoBrightnessXYPP, this.aoBrightnessXYZPPP, i1);
                this.brightnessBottomRight = this.getAoBrightness(this.aoBrightnessXZPN, this.aoBrightnessXYZPPN, this.aoBrightnessXYPP, i1);
                this.brightnessBottomLeft = this.getAoBrightness(this.aoBrightnessXYZPNN, this.aoBrightnessXYPN, this.aoBrightnessXZPN, i1);
            } else {
                f27 = this.aoLightValueXPos;
                f20 = this.aoLightValueXPos;
                f13 = this.aoLightValueXPos;
                f6 = this.aoLightValueXPos;
                this.brightnessBottomRight = this.brightnessTopRight = i1;
                this.brightnessBottomLeft = this.brightnessTopRight;
                this.brightnessTopLeft = this.brightnessTopRight;
            }
            this.colorRedBottomRight = this.colorRedTopRight = (flag6 ? par5 : 1.0f) * 0.6f;
            this.colorRedBottomLeft = this.colorRedTopRight;
            this.colorRedTopLeft = this.colorRedTopRight;
            this.colorGreenBottomRight = this.colorGreenTopRight = (flag6 ? par6 : 1.0f) * 0.6f;
            this.colorGreenBottomLeft = this.colorGreenTopRight;
            this.colorGreenTopLeft = this.colorGreenTopRight;
            this.colorBlueBottomRight = this.colorBlueTopRight = (flag6 ? par7 : 1.0f) * 0.6f;
            this.colorBlueBottomLeft = this.colorBlueTopRight;
            this.colorBlueTopLeft = this.colorBlueTopRight;
            this.colorRedTopLeft *= f6;
            this.colorGreenTopLeft *= f6;
            this.colorBlueTopLeft *= f6;
            this.colorRedBottomLeft *= f13;
            this.colorGreenBottomLeft *= f13;
            this.colorBlueBottomLeft *= f13;
            this.colorRedBottomRight *= f20;
            this.colorGreenBottomRight *= f20;
            this.colorBlueBottomRight *= f20;
            this.colorRedTopRight *= f27;
            this.colorGreenTopRight *= f27;
            this.colorBlueTopRight *= f27;
            int k2 = par1Block.getBlockTexture(this.blockAccess, par2, par3, par4, 5);
            this.renderSouthFace(par1Block, par2, par3, par4, k2);
            if (cfgGrassFix && k2 == 3 && this.overrideBlockTexture < 0) {
                this.colorRedTopLeft *= par5;
                this.colorRedBottomLeft *= par5;
                this.colorRedBottomRight *= par5;
                this.colorRedTopRight *= par5;
                this.colorGreenTopLeft *= par6;
                this.colorGreenBottomLeft *= par6;
                this.colorGreenBottomRight *= par6;
                this.colorGreenTopRight *= par6;
                this.colorBlueTopLeft *= par7;
                this.colorBlueBottomLeft *= par7;
                this.colorBlueBottomRight *= par7;
                this.colorBlueTopRight *= par7;
                this.renderSouthFace(par1Block, par2, par3, par4, 38);
            }
            flag = true;
        }
        this.enableAO = false;
        return flag;
    }

    public int getAoBrightness(int par1, int par2, int par3, int par4) {
        if (par1 == 0) {
            par1 = par4;
        }
        if (par2 == 0) {
            par2 = par4;
        }
        if (par3 == 0) {
            par3 = par4;
        }
        return par1 + par2 + par3 + par4 >> 2 & 0xFF00FF;
    }

    public boolean renderStandardBlockWithColorMultiplier(Block par1Block, int par2, int par3, int par4, float par5, float par6, float par7) {
        this.enableAO = false;
        Tessellator tessellator = Tessellator.instance;
        boolean flag = false;
        float f = 0.5f;
        float f1 = 1.0f;
        float f2 = 0.8f;
        float f3 = 0.6f;
        float f4 = f1 * par5;
        float f5 = f1 * par6;
        float f6 = f1 * par7;
        float f7 = f;
        float f8 = f2;
        float f9 = f3;
        float f10 = f;
        float f11 = f2;
        float f12 = f3;
        float f13 = f;
        float f14 = f2;
        float f15 = f3;
        if (par1Block != Block.grass) {
            f7 = f * par5;
            f8 = f2 * par5;
            f9 = f3 * par5;
            f10 = f * par6;
            f11 = f2 * par6;
            f12 = f3 * par6;
            f13 = f * par7;
            f14 = f2 * par7;
            f15 = f3 * par7;
        }
        int i = par1Block.getMixedBrightnessForBlock(this.blockAccess, par2, par3, par4);
        if (this.renderAllFaces || par1Block.shouldSideBeRendered(this.blockAccess, par2, par3 - 1, par4, 0)) {
            tessellator.setBrightness(par1Block.minY <= 0.0 ? par1Block.getMixedBrightnessForBlock(this.blockAccess, par2, par3 - 1, par4) : i);
            tessellator.setColorOpaque_F(f7, f10, f13);
            this.renderBottomFace(par1Block, par2, par3, par4, par1Block.getBlockTexture(this.blockAccess, par2, par3, par4, 0));
            flag = true;
        }
        if (this.renderAllFaces || par1Block.shouldSideBeRendered(this.blockAccess, par2, par3 + 1, par4, 1)) {
            tessellator.setBrightness(par1Block.maxY >= 1.0 ? par1Block.getMixedBrightnessForBlock(this.blockAccess, par2, par3 + 1, par4) : i);
            tessellator.setColorOpaque_F(f4, f5, f6);
            this.renderTopFace(par1Block, par2, par3, par4, par1Block.getBlockTexture(this.blockAccess, par2, par3, par4, 1));
            flag = true;
        }
        if (this.renderAllFaces || par1Block.shouldSideBeRendered(this.blockAccess, par2, par3, par4 - 1, 2)) {
            tessellator.setBrightness(par1Block.minZ <= 0.0 ? par1Block.getMixedBrightnessForBlock(this.blockAccess, par2, par3, par4 - 1) : i);
            tessellator.setColorOpaque_F(f8, f11, f14);
            int j = par1Block.getBlockTexture(this.blockAccess, par2, par3, par4, 2);
            this.renderEastFace(par1Block, par2, par3, par4, j);
            if (cfgGrassFix && j == 3 && this.overrideBlockTexture < 0) {
                tessellator.setColorOpaque_F(f8 * par5, f11 * par6, f14 * par7);
                this.renderEastFace(par1Block, par2, par3, par4, 38);
            }
            flag = true;
        }
        if (this.renderAllFaces || par1Block.shouldSideBeRendered(this.blockAccess, par2, par3, par4 + 1, 3)) {
            tessellator.setBrightness(par1Block.maxZ >= 1.0 ? par1Block.getMixedBrightnessForBlock(this.blockAccess, par2, par3, par4 + 1) : i);
            tessellator.setColorOpaque_F(f8, f11, f14);
            int k = par1Block.getBlockTexture(this.blockAccess, par2, par3, par4, 3);
            this.renderWestFace(par1Block, par2, par3, par4, k);
            if (cfgGrassFix && k == 3 && this.overrideBlockTexture < 0) {
                tessellator.setColorOpaque_F(f8 * par5, f11 * par6, f14 * par7);
                this.renderWestFace(par1Block, par2, par3, par4, 38);
            }
            flag = true;
        }
        if (this.renderAllFaces || par1Block.shouldSideBeRendered(this.blockAccess, par2 - 1, par3, par4, 4)) {
            tessellator.setBrightness(par1Block.minX <= 0.0 ? par1Block.getMixedBrightnessForBlock(this.blockAccess, par2 - 1, par3, par4) : i);
            tessellator.setColorOpaque_F(f9, f12, f15);
            int l = par1Block.getBlockTexture(this.blockAccess, par2, par3, par4, 4);
            this.renderNorthFace(par1Block, par2, par3, par4, l);
            if (cfgGrassFix && l == 3 && this.overrideBlockTexture < 0) {
                tessellator.setColorOpaque_F(f9 * par5, f12 * par6, f15 * par7);
                this.renderNorthFace(par1Block, par2, par3, par4, 38);
            }
            flag = true;
        }
        if (this.renderAllFaces || par1Block.shouldSideBeRendered(this.blockAccess, par2 + 1, par3, par4, 5)) {
            tessellator.setBrightness(par1Block.maxX >= 1.0 ? par1Block.getMixedBrightnessForBlock(this.blockAccess, par2 + 1, par3, par4) : i);
            tessellator.setColorOpaque_F(f9, f12, f15);
            int i1 = par1Block.getBlockTexture(this.blockAccess, par2, par3, par4, 5);
            this.renderSouthFace(par1Block, par2, par3, par4, i1);
            if (cfgGrassFix && i1 == 3 && this.overrideBlockTexture < 0) {
                tessellator.setColorOpaque_F(f9 * par5, f12 * par6, f15 * par7);
                this.renderSouthFace(par1Block, par2, par3, par4, 38);
            }
            flag = true;
        }
        return flag;
    }

    public boolean renderBlockCactus(Block par1Block, int par2, int par3, int par4) {
        int i = par1Block.colorMultiplier(this.blockAccess, par2, par3, par4);
        float f = (float)(i >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(i >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(i & 0xFF) / 255.0f;
        if (EntityRenderer.anaglyphEnable) {
            float f3 = (f * 30.0f + f1 * 59.0f + f2 * 11.0f) / 100.0f;
            float f4 = (f * 30.0f + f1 * 70.0f) / 100.0f;
            float f5 = (f * 30.0f + f2 * 70.0f) / 100.0f;
            f = f3;
            f1 = f4;
            f2 = f5;
        }
        return this.renderBlockCactusImpl(par1Block, par2, par3, par4, f, f1, f2);
    }

    public boolean renderBlockCactusImpl(Block par1Block, int par2, int par3, int par4, float par5, float par6, float par7) {
        Tessellator tessellator = Tessellator.instance;
        boolean flag = false;
        float f = 0.5f;
        float f1 = 1.0f;
        float f2 = 0.8f;
        float f3 = 0.6f;
        float f4 = f * par5;
        float f5 = f1 * par5;
        float f6 = f2 * par5;
        float f7 = f3 * par5;
        float f8 = f * par6;
        float f9 = f1 * par6;
        float f10 = f2 * par6;
        float f11 = f3 * par6;
        float f12 = f * par7;
        float f13 = f1 * par7;
        float f14 = f2 * par7;
        float f15 = f3 * par7;
        float f16 = 0.0625f;
        int i = par1Block.getMixedBrightnessForBlock(this.blockAccess, par2, par3, par4);
        if (this.renderAllFaces || par1Block.shouldSideBeRendered(this.blockAccess, par2, par3 - 1, par4, 0)) {
            tessellator.setBrightness(par1Block.minY <= 0.0 ? par1Block.getMixedBrightnessForBlock(this.blockAccess, par2, par3 - 1, par4) : i);
            tessellator.setColorOpaque_F(f4, f8, f12);
            this.renderBottomFace(par1Block, par2, par3, par4, par1Block.getBlockTexture(this.blockAccess, par2, par3, par4, 0));
            flag = true;
        }
        if (this.renderAllFaces || par1Block.shouldSideBeRendered(this.blockAccess, par2, par3 + 1, par4, 1)) {
            tessellator.setBrightness(par1Block.maxY >= 1.0 ? par1Block.getMixedBrightnessForBlock(this.blockAccess, par2, par3 + 1, par4) : i);
            tessellator.setColorOpaque_F(f5, f9, f13);
            this.renderTopFace(par1Block, par2, par3, par4, par1Block.getBlockTexture(this.blockAccess, par2, par3, par4, 1));
            flag = true;
        }
        if (this.renderAllFaces || par1Block.shouldSideBeRendered(this.blockAccess, par2, par3, par4 - 1, 2)) {
            tessellator.setBrightness(par1Block.minZ <= 0.0 ? par1Block.getMixedBrightnessForBlock(this.blockAccess, par2, par3, par4 - 1) : i);
            tessellator.setColorOpaque_F(f6, f10, f14);
            tessellator.addTranslation(0.0f, 0.0f, f16);
            this.renderEastFace(par1Block, par2, par3, par4, par1Block.getBlockTexture(this.blockAccess, par2, par3, par4, 2));
            tessellator.addTranslation(0.0f, 0.0f, -f16);
            flag = true;
        }
        if (this.renderAllFaces || par1Block.shouldSideBeRendered(this.blockAccess, par2, par3, par4 + 1, 3)) {
            tessellator.setBrightness(par1Block.maxZ >= 1.0 ? par1Block.getMixedBrightnessForBlock(this.blockAccess, par2, par3, par4 + 1) : i);
            tessellator.setColorOpaque_F(f6, f10, f14);
            tessellator.addTranslation(0.0f, 0.0f, -f16);
            this.renderWestFace(par1Block, par2, par3, par4, par1Block.getBlockTexture(this.blockAccess, par2, par3, par4, 3));
            tessellator.addTranslation(0.0f, 0.0f, f16);
            flag = true;
        }
        if (this.renderAllFaces || par1Block.shouldSideBeRendered(this.blockAccess, par2 - 1, par3, par4, 4)) {
            tessellator.setBrightness(par1Block.minX <= 0.0 ? par1Block.getMixedBrightnessForBlock(this.blockAccess, par2 - 1, par3, par4) : i);
            tessellator.setColorOpaque_F(f7, f11, f15);
            tessellator.addTranslation(f16, 0.0f, 0.0f);
            this.renderNorthFace(par1Block, par2, par3, par4, par1Block.getBlockTexture(this.blockAccess, par2, par3, par4, 4));
            tessellator.addTranslation(-f16, 0.0f, 0.0f);
            flag = true;
        }
        if (this.renderAllFaces || par1Block.shouldSideBeRendered(this.blockAccess, par2 + 1, par3, par4, 5)) {
            tessellator.setBrightness(par1Block.maxX >= 1.0 ? par1Block.getMixedBrightnessForBlock(this.blockAccess, par2 + 1, par3, par4) : i);
            tessellator.setColorOpaque_F(f7, f11, f15);
            tessellator.addTranslation(-f16, 0.0f, 0.0f);
            this.renderSouthFace(par1Block, par2, par3, par4, par1Block.getBlockTexture(this.blockAccess, par2, par3, par4, 5));
            tessellator.addTranslation(f16, 0.0f, 0.0f);
            flag = true;
        }
        return flag;
    }

    public boolean renderBlockFence(BlockFence par1BlockFence, int par2, int par3, int par4) {
        float f7;
        boolean flag = false;
        float f = 0.375f;
        float f1 = 0.625f;
        par1BlockFence.setBlockBounds(f, 0.0f, f, f1, 1.0f, f1);
        this.renderStandardBlock(par1BlockFence, par2, par3, par4);
        flag = true;
        boolean flag1 = false;
        boolean flag2 = false;
        if (par1BlockFence.canConnectFenceTo(this.blockAccess, par2 - 1, par3, par4) || par1BlockFence.canConnectFenceTo(this.blockAccess, par2 + 1, par3, par4)) {
            flag1 = true;
        }
        if (par1BlockFence.canConnectFenceTo(this.blockAccess, par2, par3, par4 - 1) || par1BlockFence.canConnectFenceTo(this.blockAccess, par2, par3, par4 + 1)) {
            flag2 = true;
        }
        boolean flag3 = par1BlockFence.canConnectFenceTo(this.blockAccess, par2 - 1, par3, par4);
        boolean flag4 = par1BlockFence.canConnectFenceTo(this.blockAccess, par2 + 1, par3, par4);
        boolean flag5 = par1BlockFence.canConnectFenceTo(this.blockAccess, par2, par3, par4 - 1);
        boolean flag6 = par1BlockFence.canConnectFenceTo(this.blockAccess, par2, par3, par4 + 1);
        if (!flag1 && !flag2) {
            flag1 = true;
        }
        f = 0.4375f;
        f1 = 0.5625f;
        float f2 = 0.75f;
        float f3 = 0.9375f;
        float f4 = flag3 ? 0.0f : f;
        float f5 = flag4 ? 1.0f : f1;
        float f6 = flag5 ? 0.0f : f;
        float f8 = f7 = flag6 ? 1.0f : f1;
        if (flag1) {
            par1BlockFence.setBlockBounds(f4, f2, f, f5, f3, f1);
            this.renderStandardBlock(par1BlockFence, par2, par3, par4);
            flag = true;
        }
        if (flag2) {
            par1BlockFence.setBlockBounds(f, f2, f6, f1, f3, f7);
            this.renderStandardBlock(par1BlockFence, par2, par3, par4);
            flag = true;
        }
        f2 = 0.375f;
        f3 = 0.5625f;
        if (flag1) {
            par1BlockFence.setBlockBounds(f4, f2, f, f5, f3, f1);
            this.renderStandardBlock(par1BlockFence, par2, par3, par4);
            flag = true;
        }
        if (flag2) {
            par1BlockFence.setBlockBounds(f, f2, f6, f1, f3, f7);
            this.renderStandardBlock(par1BlockFence, par2, par3, par4);
            flag = true;
        }
        par1BlockFence.setBlockBoundsBasedOnState(this.blockAccess, par2, par3, par4);
        return flag;
    }

    public boolean renderBlockDragonEgg(BlockDragonEgg par1BlockDragonEgg, int par2, int par3, int par4) {
        boolean flag = false;
        int i = 0;
        for (int j = 0; j < 8; ++j) {
            int k = 0;
            int byte0 = 1;
            if (j == 0) {
                k = 2;
            }
            if (j == 1) {
                k = 3;
            }
            if (j == 2) {
                k = 4;
            }
            if (j == 3) {
                k = 5;
                byte0 = 2;
            }
            if (j == 4) {
                k = 6;
                byte0 = 3;
            }
            if (j == 5) {
                k = 7;
                byte0 = 5;
            }
            if (j == 6) {
                k = 6;
                byte0 = 2;
            }
            if (j == 7) {
                k = 3;
            }
            float f = (float)k / 16.0f;
            float f1 = 1.0f - (float)i / 16.0f;
            float f2 = 1.0f - (float)(i + byte0) / 16.0f;
            i += byte0;
            par1BlockDragonEgg.setBlockBounds(0.5f - f, f2, 0.5f - f, 0.5f + f, f1, 0.5f + f);
            this.renderStandardBlock(par1BlockDragonEgg, par2, par3, par4);
        }
        flag = true;
        par1BlockDragonEgg.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        return flag;
    }

    public boolean renderBlockFenceGate(BlockFenceGate par1BlockFenceGate, int par2, int par3, int par4) {
        boolean flag = true;
        int i = this.blockAccess.getBlockMetadata(par2, par3, par4);
        boolean flag1 = BlockFenceGate.isFenceGateOpen(i);
        int j = BlockDirectional.getDirection(i);
        if (j != 3 && j != 1) {
            float f = 0.0f;
            float f8 = 0.125f;
            float f4 = 0.4375f;
            float f12 = 0.5625f;
            par1BlockFenceGate.setBlockBounds(f, 0.3125f, f4, f8, 1.0f, f12);
            this.renderStandardBlock(par1BlockFenceGate, par2, par3, par4);
            f = 0.875f;
            f8 = 1.0f;
            par1BlockFenceGate.setBlockBounds(f, 0.3125f, f4, f8, 1.0f, f12);
            this.renderStandardBlock(par1BlockFenceGate, par2, par3, par4);
        } else {
            float f1 = 0.4375f;
            float f9 = 0.5625f;
            float f5 = 0.0f;
            float f13 = 0.125f;
            par1BlockFenceGate.setBlockBounds(f1, 0.3125f, f5, f9, 1.0f, f13);
            this.renderStandardBlock(par1BlockFenceGate, par2, par3, par4);
            f5 = 0.875f;
            f13 = 1.0f;
            par1BlockFenceGate.setBlockBounds(f1, 0.3125f, f5, f9, 1.0f, f13);
            this.renderStandardBlock(par1BlockFenceGate, par2, par3, par4);
        }
        if (!flag1) {
            if (j != 3 && j != 1) {
                float f2 = 0.375f;
                float f10 = 0.5f;
                float f6 = 0.4375f;
                float f14 = 0.5625f;
                par1BlockFenceGate.setBlockBounds(f2, 0.375f, f6, f10, 0.9375f, f14);
                this.renderStandardBlock(par1BlockFenceGate, par2, par3, par4);
                f2 = 0.5f;
                f10 = 0.625f;
                par1BlockFenceGate.setBlockBounds(f2, 0.375f, f6, f10, 0.9375f, f14);
                this.renderStandardBlock(par1BlockFenceGate, par2, par3, par4);
                f2 = 0.625f;
                f10 = 0.875f;
                par1BlockFenceGate.setBlockBounds(f2, 0.375f, f6, f10, 0.5625f, f14);
                this.renderStandardBlock(par1BlockFenceGate, par2, par3, par4);
                par1BlockFenceGate.setBlockBounds(f2, 0.75f, f6, f10, 0.9375f, f14);
                this.renderStandardBlock(par1BlockFenceGate, par2, par3, par4);
                f2 = 0.125f;
                f10 = 0.375f;
                par1BlockFenceGate.setBlockBounds(f2, 0.375f, f6, f10, 0.5625f, f14);
                this.renderStandardBlock(par1BlockFenceGate, par2, par3, par4);
                par1BlockFenceGate.setBlockBounds(f2, 0.75f, f6, f10, 0.9375f, f14);
                this.renderStandardBlock(par1BlockFenceGate, par2, par3, par4);
            } else {
                float f3 = 0.4375f;
                float f11 = 0.5625f;
                float f7 = 0.375f;
                float f15 = 0.5f;
                par1BlockFenceGate.setBlockBounds(f3, 0.375f, f7, f11, 0.9375f, f15);
                this.renderStandardBlock(par1BlockFenceGate, par2, par3, par4);
                f7 = 0.5f;
                f15 = 0.625f;
                par1BlockFenceGate.setBlockBounds(f3, 0.375f, f7, f11, 0.9375f, f15);
                this.renderStandardBlock(par1BlockFenceGate, par2, par3, par4);
                f7 = 0.625f;
                f15 = 0.875f;
                par1BlockFenceGate.setBlockBounds(f3, 0.375f, f7, f11, 0.5625f, f15);
                this.renderStandardBlock(par1BlockFenceGate, par2, par3, par4);
                par1BlockFenceGate.setBlockBounds(f3, 0.75f, f7, f11, 0.9375f, f15);
                this.renderStandardBlock(par1BlockFenceGate, par2, par3, par4);
                f7 = 0.125f;
                f15 = 0.375f;
                par1BlockFenceGate.setBlockBounds(f3, 0.375f, f7, f11, 0.5625f, f15);
                this.renderStandardBlock(par1BlockFenceGate, par2, par3, par4);
                par1BlockFenceGate.setBlockBounds(f3, 0.75f, f7, f11, 0.9375f, f15);
                this.renderStandardBlock(par1BlockFenceGate, par2, par3, par4);
            }
        } else if (j == 3) {
            par1BlockFenceGate.setBlockBounds(0.8125f, 0.375f, 0.0f, 0.9375f, 0.9375f, 0.125f);
            this.renderStandardBlock(par1BlockFenceGate, par2, par3, par4);
            par1BlockFenceGate.setBlockBounds(0.8125f, 0.375f, 0.875f, 0.9375f, 0.9375f, 1.0f);
            this.renderStandardBlock(par1BlockFenceGate, par2, par3, par4);
            par1BlockFenceGate.setBlockBounds(0.5625f, 0.375f, 0.0f, 0.8125f, 0.5625f, 0.125f);
            this.renderStandardBlock(par1BlockFenceGate, par2, par3, par4);
            par1BlockFenceGate.setBlockBounds(0.5625f, 0.375f, 0.875f, 0.8125f, 0.5625f, 1.0f);
            this.renderStandardBlock(par1BlockFenceGate, par2, par3, par4);
            par1BlockFenceGate.setBlockBounds(0.5625f, 0.75f, 0.0f, 0.8125f, 0.9375f, 0.125f);
            this.renderStandardBlock(par1BlockFenceGate, par2, par3, par4);
            par1BlockFenceGate.setBlockBounds(0.5625f, 0.75f, 0.875f, 0.8125f, 0.9375f, 1.0f);
            this.renderStandardBlock(par1BlockFenceGate, par2, par3, par4);
        } else if (j == 1) {
            par1BlockFenceGate.setBlockBounds(0.0625f, 0.375f, 0.0f, 0.1875f, 0.9375f, 0.125f);
            this.renderStandardBlock(par1BlockFenceGate, par2, par3, par4);
            par1BlockFenceGate.setBlockBounds(0.0625f, 0.375f, 0.875f, 0.1875f, 0.9375f, 1.0f);
            this.renderStandardBlock(par1BlockFenceGate, par2, par3, par4);
            par1BlockFenceGate.setBlockBounds(0.1875f, 0.375f, 0.0f, 0.4375f, 0.5625f, 0.125f);
            this.renderStandardBlock(par1BlockFenceGate, par2, par3, par4);
            par1BlockFenceGate.setBlockBounds(0.1875f, 0.375f, 0.875f, 0.4375f, 0.5625f, 1.0f);
            this.renderStandardBlock(par1BlockFenceGate, par2, par3, par4);
            par1BlockFenceGate.setBlockBounds(0.1875f, 0.75f, 0.0f, 0.4375f, 0.9375f, 0.125f);
            this.renderStandardBlock(par1BlockFenceGate, par2, par3, par4);
            par1BlockFenceGate.setBlockBounds(0.1875f, 0.75f, 0.875f, 0.4375f, 0.9375f, 1.0f);
            this.renderStandardBlock(par1BlockFenceGate, par2, par3, par4);
        } else if (j == 0) {
            par1BlockFenceGate.setBlockBounds(0.0f, 0.375f, 0.8125f, 0.125f, 0.9375f, 0.9375f);
            this.renderStandardBlock(par1BlockFenceGate, par2, par3, par4);
            par1BlockFenceGate.setBlockBounds(0.875f, 0.375f, 0.8125f, 1.0f, 0.9375f, 0.9375f);
            this.renderStandardBlock(par1BlockFenceGate, par2, par3, par4);
            par1BlockFenceGate.setBlockBounds(0.0f, 0.375f, 0.5625f, 0.125f, 0.5625f, 0.8125f);
            this.renderStandardBlock(par1BlockFenceGate, par2, par3, par4);
            par1BlockFenceGate.setBlockBounds(0.875f, 0.375f, 0.5625f, 1.0f, 0.5625f, 0.8125f);
            this.renderStandardBlock(par1BlockFenceGate, par2, par3, par4);
            par1BlockFenceGate.setBlockBounds(0.0f, 0.75f, 0.5625f, 0.125f, 0.9375f, 0.8125f);
            this.renderStandardBlock(par1BlockFenceGate, par2, par3, par4);
            par1BlockFenceGate.setBlockBounds(0.875f, 0.75f, 0.5625f, 1.0f, 0.9375f, 0.8125f);
            this.renderStandardBlock(par1BlockFenceGate, par2, par3, par4);
        } else if (j == 2) {
            par1BlockFenceGate.setBlockBounds(0.0f, 0.375f, 0.0625f, 0.125f, 0.9375f, 0.1875f);
            this.renderStandardBlock(par1BlockFenceGate, par2, par3, par4);
            par1BlockFenceGate.setBlockBounds(0.875f, 0.375f, 0.0625f, 1.0f, 0.9375f, 0.1875f);
            this.renderStandardBlock(par1BlockFenceGate, par2, par3, par4);
            par1BlockFenceGate.setBlockBounds(0.0f, 0.375f, 0.1875f, 0.125f, 0.5625f, 0.4375f);
            this.renderStandardBlock(par1BlockFenceGate, par2, par3, par4);
            par1BlockFenceGate.setBlockBounds(0.875f, 0.375f, 0.1875f, 1.0f, 0.5625f, 0.4375f);
            this.renderStandardBlock(par1BlockFenceGate, par2, par3, par4);
            par1BlockFenceGate.setBlockBounds(0.0f, 0.75f, 0.1875f, 0.125f, 0.9375f, 0.4375f);
            this.renderStandardBlock(par1BlockFenceGate, par2, par3, par4);
            par1BlockFenceGate.setBlockBounds(0.875f, 0.75f, 0.1875f, 1.0f, 0.9375f, 0.4375f);
            this.renderStandardBlock(par1BlockFenceGate, par2, par3, par4);
        }
        par1BlockFenceGate.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        return flag;
    }

    public boolean renderBlockStairs(Block par1Block, int par2, int par3, int par4) {
        int i = this.blockAccess.getBlockMetadata(par2, par3, par4);
        int j = i & 3;
        float f = 0.0f;
        float f1 = 0.5f;
        float f2 = 0.5f;
        float f3 = 1.0f;
        if ((i & 4) != 0) {
            f = 0.5f;
            f1 = 1.0f;
            f2 = 0.0f;
            f3 = 0.5f;
        }
        par1Block.setBlockBounds(0.0f, f, 0.0f, 1.0f, f1, 1.0f);
        this.renderStandardBlock(par1Block, par2, par3, par4);
        if (j == 0) {
            par1Block.setBlockBounds(0.5f, f2, 0.0f, 1.0f, f3, 1.0f);
            this.renderStandardBlock(par1Block, par2, par3, par4);
        } else if (j == 1) {
            par1Block.setBlockBounds(0.0f, f2, 0.0f, 0.5f, f3, 1.0f);
            this.renderStandardBlock(par1Block, par2, par3, par4);
        } else if (j == 2) {
            par1Block.setBlockBounds(0.0f, f2, 0.5f, 1.0f, f3, 1.0f);
            this.renderStandardBlock(par1Block, par2, par3, par4);
        } else if (j == 3) {
            par1Block.setBlockBounds(0.0f, f2, 0.0f, 1.0f, f3, 0.5f);
            this.renderStandardBlock(par1Block, par2, par3, par4);
        }
        par1Block.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        return true;
    }

    public boolean renderBlockDoor(Block par1Block, int par2, int par3, int par4) {
        Tessellator tessellator = Tessellator.instance;
        BlockDoor blockdoor = (BlockDoor)par1Block;
        boolean flag = false;
        float f = 0.5f;
        float f1 = 1.0f;
        float f2 = 0.8f;
        float f3 = 0.6f;
        int i = par1Block.getMixedBrightnessForBlock(this.blockAccess, par2, par3, par4);
        tessellator.setBrightness(par1Block.minY <= 0.0 ? par1Block.getMixedBrightnessForBlock(this.blockAccess, par2, par3 - 1, par4) : i);
        tessellator.setColorOpaque_F(f, f, f);
        this.renderBottomFace(par1Block, par2, par3, par4, par1Block.getBlockTexture(this.blockAccess, par2, par3, par4, 0));
        flag = true;
        tessellator.setBrightness(par1Block.maxY >= 1.0 ? par1Block.getMixedBrightnessForBlock(this.blockAccess, par2, par3 + 1, par4) : i);
        tessellator.setColorOpaque_F(f1, f1, f1);
        this.renderTopFace(par1Block, par2, par3, par4, par1Block.getBlockTexture(this.blockAccess, par2, par3, par4, 1));
        flag = true;
        tessellator.setBrightness(par1Block.minZ <= 0.0 ? par1Block.getMixedBrightnessForBlock(this.blockAccess, par2, par3, par4 - 1) : i);
        tessellator.setColorOpaque_F(f2, f2, f2);
        int j = par1Block.getBlockTexture(this.blockAccess, par2, par3, par4, 2);
        if (j < 0) {
            this.flipTexture = true;
            j = -j;
        }
        this.renderEastFace(par1Block, par2, par3, par4, j);
        flag = true;
        this.flipTexture = false;
        tessellator.setBrightness(par1Block.maxZ >= 1.0 ? par1Block.getMixedBrightnessForBlock(this.blockAccess, par2, par3, par4 + 1) : i);
        tessellator.setColorOpaque_F(f2, f2, f2);
        j = par1Block.getBlockTexture(this.blockAccess, par2, par3, par4, 3);
        if (j < 0) {
            this.flipTexture = true;
            j = -j;
        }
        this.renderWestFace(par1Block, par2, par3, par4, j);
        flag = true;
        this.flipTexture = false;
        tessellator.setBrightness(par1Block.minX <= 0.0 ? par1Block.getMixedBrightnessForBlock(this.blockAccess, par2 - 1, par3, par4) : i);
        tessellator.setColorOpaque_F(f3, f3, f3);
        j = par1Block.getBlockTexture(this.blockAccess, par2, par3, par4, 4);
        if (j < 0) {
            this.flipTexture = true;
            j = -j;
        }
        this.renderNorthFace(par1Block, par2, par3, par4, j);
        flag = true;
        this.flipTexture = false;
        tessellator.setBrightness(par1Block.maxX >= 1.0 ? par1Block.getMixedBrightnessForBlock(this.blockAccess, par2 + 1, par3, par4) : i);
        tessellator.setColorOpaque_F(f3, f3, f3);
        j = par1Block.getBlockTexture(this.blockAccess, par2, par3, par4, 5);
        if (j < 0) {
            this.flipTexture = true;
            j = -j;
        }
        this.renderSouthFace(par1Block, par2, par3, par4, j);
        flag = true;
        this.flipTexture = false;
        return flag;
    }

    public void renderBottomFace(Block par1Block, double par2, double par4, double par6, int par8) {
        Tessellator tessellator = Tessellator.instance;
        if (this.overrideBlockTexture >= 0) {
            par8 = this.overrideBlockTexture;
        }
        int i = (par8 & 0xF) << 4;
        int j = par8 & 0xF0;
        double d = ((double)i + par1Block.minX * 16.0) / 256.0;
        double d1 = ((double)i + par1Block.maxX * 16.0 - 0.01) / 256.0;
        double d2 = ((double)j + par1Block.minZ * 16.0) / 256.0;
        double d3 = ((double)j + par1Block.maxZ * 16.0 - 0.01) / 256.0;
        if (par1Block.minX < 0.0 || par1Block.maxX > 1.0) {
            d = ((float)i + 0.0f) / 256.0f;
            d1 = ((float)i + 15.99f) / 256.0f;
        }
        if (par1Block.minZ < 0.0 || par1Block.maxZ > 1.0) {
            d2 = ((float)j + 0.0f) / 256.0f;
            d3 = ((float)j + 15.99f) / 256.0f;
        }
        double d4 = d1;
        double d5 = d;
        double d6 = d2;
        double d7 = d3;
        if (this.uvRotateBottom == 2) {
            d = ((double)i + par1Block.minZ * 16.0) / 256.0;
            d2 = ((double)(j + 16) - par1Block.maxX * 16.0) / 256.0;
            d1 = ((double)i + par1Block.maxZ * 16.0) / 256.0;
            d3 = ((double)(j + 16) - par1Block.minX * 16.0) / 256.0;
            d6 = d2;
            d7 = d3;
            d4 = d;
            d5 = d1;
            d2 = d3;
            d3 = d6;
        } else if (this.uvRotateBottom == 1) {
            d = ((double)(i + 16) - par1Block.maxZ * 16.0) / 256.0;
            d2 = ((double)j + par1Block.minX * 16.0) / 256.0;
            d1 = ((double)(i + 16) - par1Block.minZ * 16.0) / 256.0;
            d3 = ((double)j + par1Block.maxX * 16.0) / 256.0;
            d4 = d1;
            d5 = d;
            d = d1;
            d1 = d5;
            d6 = d3;
            d7 = d2;
        } else if (this.uvRotateBottom == 3) {
            d = ((double)(i + 16) - par1Block.minX * 16.0) / 256.0;
            d1 = ((double)(i + 16) - par1Block.maxX * 16.0 - 0.01) / 256.0;
            d2 = ((double)(j + 16) - par1Block.minZ * 16.0) / 256.0;
            d3 = ((double)(j + 16) - par1Block.maxZ * 16.0 - 0.01) / 256.0;
            d4 = d1;
            d5 = d;
            d6 = d2;
            d7 = d3;
        }
        double d8 = par2 + par1Block.minX;
        double d9 = par2 + par1Block.maxX;
        double d10 = par4 + par1Block.minY;
        double d11 = par6 + par1Block.minZ;
        double d12 = par6 + par1Block.maxZ;
        if (this.enableAO) {
            tessellator.setColorOpaque_F(this.colorRedTopLeft, this.colorGreenTopLeft, this.colorBlueTopLeft);
            tessellator.setBrightness(this.brightnessTopLeft);
            tessellator.addVertexWithUV(d8, d10, d12, d5, d7);
            tessellator.setColorOpaque_F(this.colorRedBottomLeft, this.colorGreenBottomLeft, this.colorBlueBottomLeft);
            tessellator.setBrightness(this.brightnessBottomLeft);
            tessellator.addVertexWithUV(d8, d10, d11, d, d2);
            tessellator.setColorOpaque_F(this.colorRedBottomRight, this.colorGreenBottomRight, this.colorBlueBottomRight);
            tessellator.setBrightness(this.brightnessBottomRight);
            tessellator.addVertexWithUV(d9, d10, d11, d4, d6);
            tessellator.setColorOpaque_F(this.colorRedTopRight, this.colorGreenTopRight, this.colorBlueTopRight);
            tessellator.setBrightness(this.brightnessTopRight);
            tessellator.addVertexWithUV(d9, d10, d12, d1, d3);
        } else {
            tessellator.addVertexWithUV(d8, d10, d12, d5, d7);
            tessellator.addVertexWithUV(d8, d10, d11, d, d2);
            tessellator.addVertexWithUV(d9, d10, d11, d4, d6);
            tessellator.addVertexWithUV(d9, d10, d12, d1, d3);
        }
    }

    public void renderTopFace(Block par1Block, double par2, double par4, double par6, int par8) {
        Tessellator tessellator = Tessellator.instance;
        if (this.overrideBlockTexture >= 0) {
            par8 = this.overrideBlockTexture;
        }
        int i = (par8 & 0xF) << 4;
        int j = par8 & 0xF0;
        double d = ((double)i + par1Block.minX * 16.0) / 256.0;
        double d1 = ((double)i + par1Block.maxX * 16.0 - 0.01) / 256.0;
        double d2 = ((double)j + par1Block.minZ * 16.0) / 256.0;
        double d3 = ((double)j + par1Block.maxZ * 16.0 - 0.01) / 256.0;
        if (par1Block.minX < 0.0 || par1Block.maxX > 1.0) {
            d = ((float)i + 0.0f) / 256.0f;
            d1 = ((float)i + 15.99f) / 256.0f;
        }
        if (par1Block.minZ < 0.0 || par1Block.maxZ > 1.0) {
            d2 = ((float)j + 0.0f) / 256.0f;
            d3 = ((float)j + 15.99f) / 256.0f;
        }
        double d4 = d1;
        double d5 = d;
        double d6 = d2;
        double d7 = d3;
        if (this.uvRotateTop == 1) {
            d = ((double)i + par1Block.minZ * 16.0) / 256.0;
            d2 = ((double)(j + 16) - par1Block.maxX * 16.0) / 256.0;
            d1 = ((double)i + par1Block.maxZ * 16.0) / 256.0;
            d3 = ((double)(j + 16) - par1Block.minX * 16.0) / 256.0;
            d6 = d2;
            d7 = d3;
            d4 = d;
            d5 = d1;
            d2 = d3;
            d3 = d6;
        } else if (this.uvRotateTop == 2) {
            d = ((double)(i + 16) - par1Block.maxZ * 16.0) / 256.0;
            d2 = ((double)j + par1Block.minX * 16.0) / 256.0;
            d1 = ((double)(i + 16) - par1Block.minZ * 16.0) / 256.0;
            d3 = ((double)j + par1Block.maxX * 16.0) / 256.0;
            d4 = d1;
            d5 = d;
            d = d1;
            d1 = d5;
            d6 = d3;
            d7 = d2;
        } else if (this.uvRotateTop == 3) {
            d = ((double)(i + 16) - par1Block.minX * 16.0) / 256.0;
            d1 = ((double)(i + 16) - par1Block.maxX * 16.0 - 0.01) / 256.0;
            d2 = ((double)(j + 16) - par1Block.minZ * 16.0) / 256.0;
            d3 = ((double)(j + 16) - par1Block.maxZ * 16.0 - 0.01) / 256.0;
            d4 = d1;
            d5 = d;
            d6 = d2;
            d7 = d3;
        }
        double d8 = par2 + par1Block.minX;
        double d9 = par2 + par1Block.maxX;
        double d10 = par4 + par1Block.maxY;
        double d11 = par6 + par1Block.minZ;
        double d12 = par6 + par1Block.maxZ;
        if (this.enableAO) {
            tessellator.setColorOpaque_F(this.colorRedTopLeft, this.colorGreenTopLeft, this.colorBlueTopLeft);
            tessellator.setBrightness(this.brightnessTopLeft);
            tessellator.addVertexWithUV(d9, d10, d12, d1, d3);
            tessellator.setColorOpaque_F(this.colorRedBottomLeft, this.colorGreenBottomLeft, this.colorBlueBottomLeft);
            tessellator.setBrightness(this.brightnessBottomLeft);
            tessellator.addVertexWithUV(d9, d10, d11, d4, d6);
            tessellator.setColorOpaque_F(this.colorRedBottomRight, this.colorGreenBottomRight, this.colorBlueBottomRight);
            tessellator.setBrightness(this.brightnessBottomRight);
            tessellator.addVertexWithUV(d8, d10, d11, d, d2);
            tessellator.setColorOpaque_F(this.colorRedTopRight, this.colorGreenTopRight, this.colorBlueTopRight);
            tessellator.setBrightness(this.brightnessTopRight);
            tessellator.addVertexWithUV(d8, d10, d12, d5, d7);
        } else {
            tessellator.addVertexWithUV(d9, d10, d12, d1, d3);
            tessellator.addVertexWithUV(d9, d10, d11, d4, d6);
            tessellator.addVertexWithUV(d8, d10, d11, d, d2);
            tessellator.addVertexWithUV(d8, d10, d12, d5, d7);
        }
    }

    public void renderEastFace(Block par1Block, double par2, double par4, double par6, int par8) {
        Tessellator tessellator = Tessellator.instance;
        if (this.overrideBlockTexture >= 0) {
            par8 = this.overrideBlockTexture;
        }
        int i = (par8 & 0xF) << 4;
        int j = par8 & 0xF0;
        double d = ((double)i + par1Block.minX * 16.0) / 256.0;
        double d1 = ((double)i + par1Block.maxX * 16.0 - 0.01) / 256.0;
        double d2 = ((double)(j + 16) - par1Block.maxY * 16.0) / 256.0;
        double d3 = ((double)(j + 16) - par1Block.minY * 16.0 - 0.01) / 256.0;
        if (this.flipTexture) {
            double d4 = d;
            d = d1;
            d1 = d4;
        }
        if (par1Block.minX < 0.0 || par1Block.maxX > 1.0) {
            d = ((float)i + 0.0f) / 256.0f;
            d1 = ((float)i + 15.99f) / 256.0f;
        }
        if (par1Block.minY < 0.0 || par1Block.maxY > 1.0) {
            d2 = ((float)j + 0.0f) / 256.0f;
            d3 = ((float)j + 15.99f) / 256.0f;
        }
        double d5 = d1;
        double d6 = d;
        double d7 = d2;
        double d8 = d3;
        if (this.uvRotateEast == 2) {
            d = ((double)i + par1Block.minY * 16.0) / 256.0;
            d2 = ((double)(j + 16) - par1Block.minX * 16.0) / 256.0;
            d1 = ((double)i + par1Block.maxY * 16.0) / 256.0;
            d3 = ((double)(j + 16) - par1Block.maxX * 16.0) / 256.0;
            d7 = d2;
            d8 = d3;
            d5 = d;
            d6 = d1;
            d2 = d3;
            d3 = d7;
        } else if (this.uvRotateEast == 1) {
            d = ((double)(i + 16) - par1Block.maxY * 16.0) / 256.0;
            d2 = ((double)j + par1Block.maxX * 16.0) / 256.0;
            d1 = ((double)(i + 16) - par1Block.minY * 16.0) / 256.0;
            d3 = ((double)j + par1Block.minX * 16.0) / 256.0;
            d5 = d1;
            d6 = d;
            d = d1;
            d1 = d6;
            d7 = d3;
            d8 = d2;
        } else if (this.uvRotateEast == 3) {
            d = ((double)(i + 16) - par1Block.minX * 16.0) / 256.0;
            d1 = ((double)(i + 16) - par1Block.maxX * 16.0 - 0.01) / 256.0;
            d2 = ((double)j + par1Block.maxY * 16.0) / 256.0;
            d3 = ((double)j + par1Block.minY * 16.0 - 0.01) / 256.0;
            d5 = d1;
            d6 = d;
            d7 = d2;
            d8 = d3;
        }
        double d9 = par2 + par1Block.minX;
        double d10 = par2 + par1Block.maxX;
        double d11 = par4 + par1Block.minY;
        double d12 = par4 + par1Block.maxY;
        double d13 = par6 + par1Block.minZ;
        if (this.enableAO) {
            tessellator.setColorOpaque_F(this.colorRedTopLeft, this.colorGreenTopLeft, this.colorBlueTopLeft);
            tessellator.setBrightness(this.brightnessTopLeft);
            tessellator.addVertexWithUV(d9, d12, d13, d5, d7);
            tessellator.setColorOpaque_F(this.colorRedBottomLeft, this.colorGreenBottomLeft, this.colorBlueBottomLeft);
            tessellator.setBrightness(this.brightnessBottomLeft);
            tessellator.addVertexWithUV(d10, d12, d13, d, d2);
            tessellator.setColorOpaque_F(this.colorRedBottomRight, this.colorGreenBottomRight, this.colorBlueBottomRight);
            tessellator.setBrightness(this.brightnessBottomRight);
            tessellator.addVertexWithUV(d10, d11, d13, d6, d8);
            tessellator.setColorOpaque_F(this.colorRedTopRight, this.colorGreenTopRight, this.colorBlueTopRight);
            tessellator.setBrightness(this.brightnessTopRight);
            tessellator.addVertexWithUV(d9, d11, d13, d1, d3);
        } else {
            tessellator.addVertexWithUV(d9, d12, d13, d5, d7);
            tessellator.addVertexWithUV(d10, d12, d13, d, d2);
            tessellator.addVertexWithUV(d10, d11, d13, d6, d8);
            tessellator.addVertexWithUV(d9, d11, d13, d1, d3);
        }
    }

    public void renderWestFace(Block par1Block, double par2, double par4, double par6, int par8) {
        Tessellator tessellator = Tessellator.instance;
        if (this.overrideBlockTexture >= 0) {
            par8 = this.overrideBlockTexture;
        }
        int i = (par8 & 0xF) << 4;
        int j = par8 & 0xF0;
        double d = ((double)i + par1Block.minX * 16.0) / 256.0;
        double d1 = ((double)i + par1Block.maxX * 16.0 - 0.01) / 256.0;
        double d2 = ((double)(j + 16) - par1Block.maxY * 16.0) / 256.0;
        double d3 = ((double)(j + 16) - par1Block.minY * 16.0 - 0.01) / 256.0;
        if (this.flipTexture) {
            double d4 = d;
            d = d1;
            d1 = d4;
        }
        if (par1Block.minX < 0.0 || par1Block.maxX > 1.0) {
            d = ((float)i + 0.0f) / 256.0f;
            d1 = ((float)i + 15.99f) / 256.0f;
        }
        if (par1Block.minY < 0.0 || par1Block.maxY > 1.0) {
            d2 = ((float)j + 0.0f) / 256.0f;
            d3 = ((float)j + 15.99f) / 256.0f;
        }
        double d5 = d1;
        double d6 = d;
        double d7 = d2;
        double d8 = d3;
        if (this.uvRotateWest == 1) {
            d = ((double)i + par1Block.minY * 16.0) / 256.0;
            d3 = ((double)(j + 16) - par1Block.minX * 16.0) / 256.0;
            d1 = ((double)i + par1Block.maxY * 16.0) / 256.0;
            d7 = d2 = ((double)(j + 16) - par1Block.maxX * 16.0) / 256.0;
            d8 = d3;
            d5 = d;
            d6 = d1;
            d2 = d3;
            d3 = d7;
        } else if (this.uvRotateWest == 2) {
            d = ((double)(i + 16) - par1Block.maxY * 16.0) / 256.0;
            d2 = ((double)j + par1Block.minX * 16.0) / 256.0;
            d1 = ((double)(i + 16) - par1Block.minY * 16.0) / 256.0;
            d3 = ((double)j + par1Block.maxX * 16.0) / 256.0;
            d5 = d1;
            d6 = d;
            d = d1;
            d1 = d6;
            d7 = d3;
            d8 = d2;
        } else if (this.uvRotateWest == 3) {
            d = ((double)(i + 16) - par1Block.minX * 16.0) / 256.0;
            d1 = ((double)(i + 16) - par1Block.maxX * 16.0 - 0.01) / 256.0;
            d2 = ((double)j + par1Block.maxY * 16.0) / 256.0;
            d3 = ((double)j + par1Block.minY * 16.0 - 0.01) / 256.0;
            d5 = d1;
            d6 = d;
            d7 = d2;
            d8 = d3;
        }
        double d9 = par2 + par1Block.minX;
        double d10 = par2 + par1Block.maxX;
        double d11 = par4 + par1Block.minY;
        double d12 = par4 + par1Block.maxY;
        double d13 = par6 + par1Block.maxZ;
        if (this.enableAO) {
            tessellator.setColorOpaque_F(this.colorRedTopLeft, this.colorGreenTopLeft, this.colorBlueTopLeft);
            tessellator.setBrightness(this.brightnessTopLeft);
            tessellator.addVertexWithUV(d9, d12, d13, d, d2);
            tessellator.setColorOpaque_F(this.colorRedBottomLeft, this.colorGreenBottomLeft, this.colorBlueBottomLeft);
            tessellator.setBrightness(this.brightnessBottomLeft);
            tessellator.addVertexWithUV(d9, d11, d13, d6, d8);
            tessellator.setColorOpaque_F(this.colorRedBottomRight, this.colorGreenBottomRight, this.colorBlueBottomRight);
            tessellator.setBrightness(this.brightnessBottomRight);
            tessellator.addVertexWithUV(d10, d11, d13, d1, d3);
            tessellator.setColorOpaque_F(this.colorRedTopRight, this.colorGreenTopRight, this.colorBlueTopRight);
            tessellator.setBrightness(this.brightnessTopRight);
            tessellator.addVertexWithUV(d10, d12, d13, d5, d7);
        } else {
            tessellator.addVertexWithUV(d9, d12, d13, d, d2);
            tessellator.addVertexWithUV(d9, d11, d13, d6, d8);
            tessellator.addVertexWithUV(d10, d11, d13, d1, d3);
            tessellator.addVertexWithUV(d10, d12, d13, d5, d7);
        }
    }

    public void renderNorthFace(Block par1Block, double par2, double par4, double par6, int par8) {
        Tessellator tessellator = Tessellator.instance;
        if (this.overrideBlockTexture >= 0) {
            par8 = this.overrideBlockTexture;
        }
        int i = (par8 & 0xF) << 4;
        int j = par8 & 0xF0;
        double d = ((double)i + par1Block.minZ * 16.0) / 256.0;
        double d1 = ((double)i + par1Block.maxZ * 16.0 - 0.01) / 256.0;
        double d2 = ((double)(j + 16) - par1Block.maxY * 16.0) / 256.0;
        double d3 = ((double)(j + 16) - par1Block.minY * 16.0 - 0.01) / 256.0;
        if (this.flipTexture) {
            double d4 = d;
            d = d1;
            d1 = d4;
        }
        if (par1Block.minZ < 0.0 || par1Block.maxZ > 1.0) {
            d = ((float)i + 0.0f) / 256.0f;
            d1 = ((float)i + 15.99f) / 256.0f;
        }
        if (par1Block.minY < 0.0 || par1Block.maxY > 1.0) {
            d2 = ((float)j + 0.0f) / 256.0f;
            d3 = ((float)j + 15.99f) / 256.0f;
        }
        double d5 = d1;
        double d6 = d;
        double d7 = d2;
        double d8 = d3;
        if (this.uvRotateNorth == 1) {
            d = ((double)i + par1Block.minY * 16.0) / 256.0;
            d2 = ((double)(j + 16) - par1Block.maxZ * 16.0) / 256.0;
            d1 = ((double)i + par1Block.maxY * 16.0) / 256.0;
            d3 = ((double)(j + 16) - par1Block.minZ * 16.0) / 256.0;
            d7 = d2;
            d8 = d3;
            d5 = d;
            d6 = d1;
            d2 = d3;
            d3 = d7;
        } else if (this.uvRotateNorth == 2) {
            d = ((double)(i + 16) - par1Block.maxY * 16.0) / 256.0;
            d2 = ((double)j + par1Block.minZ * 16.0) / 256.0;
            d1 = ((double)(i + 16) - par1Block.minY * 16.0) / 256.0;
            d3 = ((double)j + par1Block.maxZ * 16.0) / 256.0;
            d5 = d1;
            d6 = d;
            d = d1;
            d1 = d6;
            d7 = d3;
            d8 = d2;
        } else if (this.uvRotateNorth == 3) {
            d = ((double)(i + 16) - par1Block.minZ * 16.0) / 256.0;
            d1 = ((double)(i + 16) - par1Block.maxZ * 16.0 - 0.01) / 256.0;
            d2 = ((double)j + par1Block.maxY * 16.0) / 256.0;
            d3 = ((double)j + par1Block.minY * 16.0 - 0.01) / 256.0;
            d5 = d1;
            d6 = d;
            d7 = d2;
            d8 = d3;
        }
        double d9 = par2 + par1Block.minX;
        double d10 = par4 + par1Block.minY;
        double d11 = par4 + par1Block.maxY;
        double d12 = par6 + par1Block.minZ;
        double d13 = par6 + par1Block.maxZ;
        if (this.enableAO) {
            tessellator.setColorOpaque_F(this.colorRedTopLeft, this.colorGreenTopLeft, this.colorBlueTopLeft);
            tessellator.setBrightness(this.brightnessTopLeft);
            tessellator.addVertexWithUV(d9, d11, d13, d5, d7);
            tessellator.setColorOpaque_F(this.colorRedBottomLeft, this.colorGreenBottomLeft, this.colorBlueBottomLeft);
            tessellator.setBrightness(this.brightnessBottomLeft);
            tessellator.addVertexWithUV(d9, d11, d12, d, d2);
            tessellator.setColorOpaque_F(this.colorRedBottomRight, this.colorGreenBottomRight, this.colorBlueBottomRight);
            tessellator.setBrightness(this.brightnessBottomRight);
            tessellator.addVertexWithUV(d9, d10, d12, d6, d8);
            tessellator.setColorOpaque_F(this.colorRedTopRight, this.colorGreenTopRight, this.colorBlueTopRight);
            tessellator.setBrightness(this.brightnessTopRight);
            tessellator.addVertexWithUV(d9, d10, d13, d1, d3);
        } else {
            tessellator.addVertexWithUV(d9, d11, d13, d5, d7);
            tessellator.addVertexWithUV(d9, d11, d12, d, d2);
            tessellator.addVertexWithUV(d9, d10, d12, d6, d8);
            tessellator.addVertexWithUV(d9, d10, d13, d1, d3);
        }
    }

    public void renderSouthFace(Block par1Block, double par2, double par4, double par6, int par8) {
        Tessellator tessellator = Tessellator.instance;
        if (this.overrideBlockTexture >= 0) {
            par8 = this.overrideBlockTexture;
        }
        int i = (par8 & 0xF) << 4;
        int j = par8 & 0xF0;
        double d = ((double)i + par1Block.minZ * 16.0) / 256.0;
        double d1 = ((double)i + par1Block.maxZ * 16.0 - 0.01) / 256.0;
        double d2 = ((double)(j + 16) - par1Block.maxY * 16.0) / 256.0;
        double d3 = ((double)(j + 16) - par1Block.minY * 16.0 - 0.01) / 256.0;
        if (this.flipTexture) {
            double d4 = d;
            d = d1;
            d1 = d4;
        }
        if (par1Block.minZ < 0.0 || par1Block.maxZ > 1.0) {
            d = ((float)i + 0.0f) / 256.0f;
            d1 = ((float)i + 15.99f) / 256.0f;
        }
        if (par1Block.minY < 0.0 || par1Block.maxY > 1.0) {
            d2 = ((float)j + 0.0f) / 256.0f;
            d3 = ((float)j + 15.99f) / 256.0f;
        }
        double d5 = d1;
        double d6 = d;
        double d7 = d2;
        double d8 = d3;
        if (this.uvRotateSouth == 2) {
            d = ((double)i + par1Block.minY * 16.0) / 256.0;
            d2 = ((double)(j + 16) - par1Block.minZ * 16.0) / 256.0;
            d1 = ((double)i + par1Block.maxY * 16.0) / 256.0;
            d3 = ((double)(j + 16) - par1Block.maxZ * 16.0) / 256.0;
            d7 = d2;
            d8 = d3;
            d5 = d;
            d6 = d1;
            d2 = d3;
            d3 = d7;
        } else if (this.uvRotateSouth == 1) {
            d = ((double)(i + 16) - par1Block.maxY * 16.0) / 256.0;
            d2 = ((double)j + par1Block.maxZ * 16.0) / 256.0;
            d1 = ((double)(i + 16) - par1Block.minY * 16.0) / 256.0;
            d3 = ((double)j + par1Block.minZ * 16.0) / 256.0;
            d5 = d1;
            d6 = d;
            d = d1;
            d1 = d6;
            d7 = d3;
            d8 = d2;
        } else if (this.uvRotateSouth == 3) {
            d = ((double)(i + 16) - par1Block.minZ * 16.0) / 256.0;
            d1 = ((double)(i + 16) - par1Block.maxZ * 16.0 - 0.01) / 256.0;
            d2 = ((double)j + par1Block.maxY * 16.0) / 256.0;
            d3 = ((double)j + par1Block.minY * 16.0 - 0.01) / 256.0;
            d5 = d1;
            d6 = d;
            d7 = d2;
            d8 = d3;
        }
        double d9 = par2 + par1Block.maxX;
        double d10 = par4 + par1Block.minY;
        double d11 = par4 + par1Block.maxY;
        double d12 = par6 + par1Block.minZ;
        double d13 = par6 + par1Block.maxZ;
        if (this.enableAO) {
            tessellator.setColorOpaque_F(this.colorRedTopLeft, this.colorGreenTopLeft, this.colorBlueTopLeft);
            tessellator.setBrightness(this.brightnessTopLeft);
            tessellator.addVertexWithUV(d9, d10, d13, d6, d8);
            tessellator.setColorOpaque_F(this.colorRedBottomLeft, this.colorGreenBottomLeft, this.colorBlueBottomLeft);
            tessellator.setBrightness(this.brightnessBottomLeft);
            tessellator.addVertexWithUV(d9, d10, d12, d1, d3);
            tessellator.setColorOpaque_F(this.colorRedBottomRight, this.colorGreenBottomRight, this.colorBlueBottomRight);
            tessellator.setBrightness(this.brightnessBottomRight);
            tessellator.addVertexWithUV(d9, d11, d12, d5, d7);
            tessellator.setColorOpaque_F(this.colorRedTopRight, this.colorGreenTopRight, this.colorBlueTopRight);
            tessellator.setBrightness(this.brightnessTopRight);
            tessellator.addVertexWithUV(d9, d11, d13, d, d2);
        } else {
            tessellator.addVertexWithUV(d9, d10, d13, d6, d8);
            tessellator.addVertexWithUV(d9, d10, d12, d1, d3);
            tessellator.addVertexWithUV(d9, d11, d12, d5, d7);
            tessellator.addVertexWithUV(d9, d11, d13, d, d2);
        }
    }

    public void renderBlockAsItem(Block par1Block, int par2, float par3) {
        int j;
        boolean flag;
        Tessellator tessellator = Tessellator.instance;
        boolean bl = flag = par1Block.blockID == Block.grass.blockID;
        if (this.useInventoryTint) {
            int i = par1Block.getRenderColor(par2);
            if (flag) {
                i = 0xFFFFFF;
            }
            float f = (float)(i >> 16 & 0xFF) / 255.0f;
            float f2 = (float)(i >> 8 & 0xFF) / 255.0f;
            float f6 = (float)(i & 0xFF) / 255.0f;
            GL11.glColor4f((float)(f * par3), (float)(f2 * par3), (float)(f6 * par3), (float)1.0f);
        }
        if ((j = par1Block.getRenderType()) != 0 && j != 16) {
            if (j == 1) {
                tessellator.startDrawingQuads();
                tessellator.setNormal(0.0f, -1.0f, 0.0f);
                this.drawCrossedSquares(par1Block, par2, -0.5, -0.5, -0.5);
                tessellator.draw();
            } else if (j == 19) {
                tessellator.startDrawingQuads();
                tessellator.setNormal(0.0f, -1.0f, 0.0f);
                par1Block.setBlockBoundsForItemRender();
                this.renderBlockStemSmall(par1Block, par2, par1Block.maxY, -0.5, -0.5, -0.5);
                tessellator.draw();
            } else if (j == 23) {
                tessellator.startDrawingQuads();
                tessellator.setNormal(0.0f, -1.0f, 0.0f);
                par1Block.setBlockBoundsForItemRender();
                tessellator.draw();
            } else if (j == 13) {
                par1Block.setBlockBoundsForItemRender();
                GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
                float f1 = 0.0625f;
                tessellator.startDrawingQuads();
                tessellator.setNormal(0.0f, -1.0f, 0.0f);
                this.renderBottomFace(par1Block, 0.0, 0.0, 0.0, par1Block.getBlockTextureFromSide(0));
                tessellator.draw();
                tessellator.startDrawingQuads();
                tessellator.setNormal(0.0f, 1.0f, 0.0f);
                this.renderTopFace(par1Block, 0.0, 0.0, 0.0, par1Block.getBlockTextureFromSide(1));
                tessellator.draw();
                tessellator.startDrawingQuads();
                tessellator.setNormal(0.0f, 0.0f, -1.0f);
                tessellator.addTranslation(0.0f, 0.0f, f1);
                this.renderEastFace(par1Block, 0.0, 0.0, 0.0, par1Block.getBlockTextureFromSide(2));
                tessellator.addTranslation(0.0f, 0.0f, -f1);
                tessellator.draw();
                tessellator.startDrawingQuads();
                tessellator.setNormal(0.0f, 0.0f, 1.0f);
                tessellator.addTranslation(0.0f, 0.0f, -f1);
                this.renderWestFace(par1Block, 0.0, 0.0, 0.0, par1Block.getBlockTextureFromSide(3));
                tessellator.addTranslation(0.0f, 0.0f, f1);
                tessellator.draw();
                tessellator.startDrawingQuads();
                tessellator.setNormal(-1.0f, 0.0f, 0.0f);
                tessellator.addTranslation(f1, 0.0f, 0.0f);
                this.renderNorthFace(par1Block, 0.0, 0.0, 0.0, par1Block.getBlockTextureFromSide(4));
                tessellator.addTranslation(-f1, 0.0f, 0.0f);
                tessellator.draw();
                tessellator.startDrawingQuads();
                tessellator.setNormal(1.0f, 0.0f, 0.0f);
                tessellator.addTranslation(-f1, 0.0f, 0.0f);
                this.renderSouthFace(par1Block, 0.0, 0.0, 0.0, par1Block.getBlockTextureFromSide(5));
                tessellator.addTranslation(f1, 0.0f, 0.0f);
                tessellator.draw();
                GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
            } else if (j == 22) {
                ChestItemRenderHelper.instance.func_35609_a(par1Block, par2, par3);
                GL11.glEnable((int)32826);
            } else if (j == 6) {
                tessellator.startDrawingQuads();
                tessellator.setNormal(0.0f, -1.0f, 0.0f);
                this.renderBlockCropsImpl(par1Block, par2, -0.5, -0.5, -0.5);
                tessellator.draw();
            } else if (j == 2) {
                tessellator.startDrawingQuads();
                tessellator.setNormal(0.0f, -1.0f, 0.0f);
                this.renderTorchAtAngle(par1Block, -0.5, -0.5, -0.5, 0.0, 0.0);
                tessellator.draw();
            } else if (j == 10) {
                for (int k = 0; k < 2; ++k) {
                    if (k == 0) {
                        par1Block.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.5f);
                    }
                    if (k == 1) {
                        par1Block.setBlockBounds(0.0f, 0.0f, 0.5f, 1.0f, 0.5f, 1.0f);
                    }
                    GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
                    tessellator.startDrawingQuads();
                    tessellator.setNormal(0.0f, -1.0f, 0.0f);
                    this.renderBottomFace(par1Block, 0.0, 0.0, 0.0, par1Block.getBlockTextureFromSide(0));
                    tessellator.draw();
                    tessellator.startDrawingQuads();
                    tessellator.setNormal(0.0f, 1.0f, 0.0f);
                    this.renderTopFace(par1Block, 0.0, 0.0, 0.0, par1Block.getBlockTextureFromSide(1));
                    tessellator.draw();
                    tessellator.startDrawingQuads();
                    tessellator.setNormal(0.0f, 0.0f, -1.0f);
                    this.renderEastFace(par1Block, 0.0, 0.0, 0.0, par1Block.getBlockTextureFromSide(2));
                    tessellator.draw();
                    tessellator.startDrawingQuads();
                    tessellator.setNormal(0.0f, 0.0f, 1.0f);
                    this.renderWestFace(par1Block, 0.0, 0.0, 0.0, par1Block.getBlockTextureFromSide(3));
                    tessellator.draw();
                    tessellator.startDrawingQuads();
                    tessellator.setNormal(-1.0f, 0.0f, 0.0f);
                    this.renderNorthFace(par1Block, 0.0, 0.0, 0.0, par1Block.getBlockTextureFromSide(4));
                    tessellator.draw();
                    tessellator.startDrawingQuads();
                    tessellator.setNormal(1.0f, 0.0f, 0.0f);
                    this.renderSouthFace(par1Block, 0.0, 0.0, 0.0, par1Block.getBlockTextureFromSide(5));
                    tessellator.draw();
                    GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
                }
            } else if (j == 27) {
                int l = 0;
                GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
                tessellator.startDrawingQuads();
                for (int l1 = 0; l1 < 8; ++l1) {
                    int i2 = 0;
                    int byte0 = 1;
                    if (l1 == 0) {
                        i2 = 2;
                    }
                    if (l1 == 1) {
                        i2 = 3;
                    }
                    if (l1 == 2) {
                        i2 = 4;
                    }
                    if (l1 == 3) {
                        i2 = 5;
                        byte0 = 2;
                    }
                    if (l1 == 4) {
                        i2 = 6;
                        byte0 = 3;
                    }
                    if (l1 == 5) {
                        i2 = 7;
                        byte0 = 5;
                    }
                    if (l1 == 6) {
                        i2 = 6;
                        byte0 = 2;
                    }
                    if (l1 == 7) {
                        i2 = 3;
                    }
                    float f9 = (float)i2 / 16.0f;
                    float f10 = 1.0f - (float)l / 16.0f;
                    float f11 = 1.0f - (float)(l + byte0) / 16.0f;
                    l += byte0;
                    par1Block.setBlockBounds(0.5f - f9, f11, 0.5f - f9, 0.5f + f9, f10, 0.5f + f9);
                    tessellator.setNormal(0.0f, -1.0f, 0.0f);
                    this.renderBottomFace(par1Block, 0.0, 0.0, 0.0, par1Block.getBlockTextureFromSide(0));
                    tessellator.setNormal(0.0f, 1.0f, 0.0f);
                    this.renderTopFace(par1Block, 0.0, 0.0, 0.0, par1Block.getBlockTextureFromSide(1));
                    tessellator.setNormal(0.0f, 0.0f, -1.0f);
                    this.renderEastFace(par1Block, 0.0, 0.0, 0.0, par1Block.getBlockTextureFromSide(2));
                    tessellator.setNormal(0.0f, 0.0f, 1.0f);
                    this.renderWestFace(par1Block, 0.0, 0.0, 0.0, par1Block.getBlockTextureFromSide(3));
                    tessellator.setNormal(-1.0f, 0.0f, 0.0f);
                    this.renderNorthFace(par1Block, 0.0, 0.0, 0.0, par1Block.getBlockTextureFromSide(4));
                    tessellator.setNormal(1.0f, 0.0f, 0.0f);
                    this.renderSouthFace(par1Block, 0.0, 0.0, 0.0, par1Block.getBlockTextureFromSide(5));
                }
                tessellator.draw();
                GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
                par1Block.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            } else if (j == 11) {
                for (int i1 = 0; i1 < 4; ++i1) {
                    float f3 = 0.125f;
                    if (i1 == 0) {
                        par1Block.setBlockBounds(0.5f - f3, 0.0f, 0.0f, 0.5f + f3, 1.0f, f3 * 2.0f);
                    }
                    if (i1 == 1) {
                        par1Block.setBlockBounds(0.5f - f3, 0.0f, 1.0f - f3 * 2.0f, 0.5f + f3, 1.0f, 1.0f);
                    }
                    f3 = 0.0625f;
                    if (i1 == 2) {
                        par1Block.setBlockBounds(0.5f - f3, 1.0f - f3 * 3.0f, -f3 * 2.0f, 0.5f + f3, 1.0f - f3, 1.0f + f3 * 2.0f);
                    }
                    if (i1 == 3) {
                        par1Block.setBlockBounds(0.5f - f3, 0.5f - f3 * 3.0f, -f3 * 2.0f, 0.5f + f3, 0.5f - f3, 1.0f + f3 * 2.0f);
                    }
                    GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
                    tessellator.startDrawingQuads();
                    tessellator.setNormal(0.0f, -1.0f, 0.0f);
                    this.renderBottomFace(par1Block, 0.0, 0.0, 0.0, par1Block.getBlockTextureFromSide(0));
                    tessellator.draw();
                    tessellator.startDrawingQuads();
                    tessellator.setNormal(0.0f, 1.0f, 0.0f);
                    this.renderTopFace(par1Block, 0.0, 0.0, 0.0, par1Block.getBlockTextureFromSide(1));
                    tessellator.draw();
                    tessellator.startDrawingQuads();
                    tessellator.setNormal(0.0f, 0.0f, -1.0f);
                    this.renderEastFace(par1Block, 0.0, 0.0, 0.0, par1Block.getBlockTextureFromSide(2));
                    tessellator.draw();
                    tessellator.startDrawingQuads();
                    tessellator.setNormal(0.0f, 0.0f, 1.0f);
                    this.renderWestFace(par1Block, 0.0, 0.0, 0.0, par1Block.getBlockTextureFromSide(3));
                    tessellator.draw();
                    tessellator.startDrawingQuads();
                    tessellator.setNormal(-1.0f, 0.0f, 0.0f);
                    this.renderNorthFace(par1Block, 0.0, 0.0, 0.0, par1Block.getBlockTextureFromSide(4));
                    tessellator.draw();
                    tessellator.startDrawingQuads();
                    tessellator.setNormal(1.0f, 0.0f, 0.0f);
                    this.renderSouthFace(par1Block, 0.0, 0.0, 0.0, par1Block.getBlockTextureFromSide(5));
                    tessellator.draw();
                    GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
                }
                par1Block.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            } else if (j == 21) {
                for (int j1 = 0; j1 < 3; ++j1) {
                    float f4 = 0.0625f;
                    if (j1 == 0) {
                        par1Block.setBlockBounds(0.5f - f4, 0.3f, 0.0f, 0.5f + f4, 1.0f, f4 * 2.0f);
                    }
                    if (j1 == 1) {
                        par1Block.setBlockBounds(0.5f - f4, 0.3f, 1.0f - f4 * 2.0f, 0.5f + f4, 1.0f, 1.0f);
                    }
                    f4 = 0.0625f;
                    if (j1 == 2) {
                        par1Block.setBlockBounds(0.5f - f4, 0.5f, 0.0f, 0.5f + f4, 1.0f - f4, 1.0f);
                    }
                    GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
                    tessellator.startDrawingQuads();
                    tessellator.setNormal(0.0f, -1.0f, 0.0f);
                    this.renderBottomFace(par1Block, 0.0, 0.0, 0.0, par1Block.getBlockTextureFromSide(0));
                    tessellator.draw();
                    tessellator.startDrawingQuads();
                    tessellator.setNormal(0.0f, 1.0f, 0.0f);
                    this.renderTopFace(par1Block, 0.0, 0.0, 0.0, par1Block.getBlockTextureFromSide(1));
                    tessellator.draw();
                    tessellator.startDrawingQuads();
                    tessellator.setNormal(0.0f, 0.0f, -1.0f);
                    this.renderEastFace(par1Block, 0.0, 0.0, 0.0, par1Block.getBlockTextureFromSide(2));
                    tessellator.draw();
                    tessellator.startDrawingQuads();
                    tessellator.setNormal(0.0f, 0.0f, 1.0f);
                    this.renderWestFace(par1Block, 0.0, 0.0, 0.0, par1Block.getBlockTextureFromSide(3));
                    tessellator.draw();
                    tessellator.startDrawingQuads();
                    tessellator.setNormal(-1.0f, 0.0f, 0.0f);
                    this.renderNorthFace(par1Block, 0.0, 0.0, 0.0, par1Block.getBlockTextureFromSide(4));
                    tessellator.draw();
                    tessellator.startDrawingQuads();
                    tessellator.setNormal(1.0f, 0.0f, 0.0f);
                    this.renderSouthFace(par1Block, 0.0, 0.0, 0.0, par1Block.getBlockTextureFromSide(5));
                    tessellator.draw();
                    GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
                }
                par1Block.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            } else {
                ModLoader.renderInvBlock(this, par1Block, par2, j);
            }
        } else {
            if (j == 16) {
                par2 = 1;
            }
            par1Block.setBlockBoundsForItemRender();
            GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, -1.0f, 0.0f);
            this.renderBottomFace(par1Block, 0.0, 0.0, 0.0, par1Block.getBlockTextureFromSideAndMetadata(0, par2));
            tessellator.draw();
            if (flag && this.useInventoryTint) {
                int k1 = par1Block.getRenderColor(par2);
                float f5 = (float)(k1 >> 16 & 0xFF) / 255.0f;
                float f7 = (float)(k1 >> 8 & 0xFF) / 255.0f;
                float f8 = (float)(k1 & 0xFF) / 255.0f;
                GL11.glColor4f((float)(f5 * par3), (float)(f7 * par3), (float)(f8 * par3), (float)1.0f);
            }
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, 1.0f, 0.0f);
            this.renderTopFace(par1Block, 0.0, 0.0, 0.0, par1Block.getBlockTextureFromSideAndMetadata(1, par2));
            tessellator.draw();
            if (flag && this.useInventoryTint) {
                GL11.glColor4f((float)par3, (float)par3, (float)par3, (float)1.0f);
            }
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, 0.0f, -1.0f);
            this.renderEastFace(par1Block, 0.0, 0.0, 0.0, par1Block.getBlockTextureFromSideAndMetadata(2, par2));
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, 0.0f, 1.0f);
            this.renderWestFace(par1Block, 0.0, 0.0, 0.0, par1Block.getBlockTextureFromSideAndMetadata(3, par2));
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(-1.0f, 0.0f, 0.0f);
            this.renderNorthFace(par1Block, 0.0, 0.0, 0.0, par1Block.getBlockTextureFromSideAndMetadata(4, par2));
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(1.0f, 0.0f, 0.0f);
            this.renderSouthFace(par1Block, 0.0, 0.0, 0.0, par1Block.getBlockTextureFromSideAndMetadata(5, par2));
            tessellator.draw();
            GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        }
    }

    public static boolean renderItemIn3d(int par0) {
        return par0 != 0 ? (par0 != 13 ? (par0 != 10 ? (par0 != 11 ? (par0 != 27 ? (par0 != 22 ? (par0 != 21 ? ModLoader.renderBlockIsItemFull3D(par0) : true) : true) : true) : true) : true) : true) : true;
    }
}

