/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.Block;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityAnimal;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.FontRenderer;
import net.minecraft.src.MathHelper;
import net.minecraft.src.ModelBase;
import net.minecraft.src.ModelBiped;
import net.minecraft.src.RenderBlocks;
import net.minecraft.src.RenderEngine;
import net.minecraft.src.RenderManager;
import net.minecraft.src.Tessellator;
import net.minecraft.src.World;
import org.lwjgl.opengl.GL11;

public abstract class Render {
    protected RenderManager renderManager;
    private ModelBase modelBase = new ModelBiped();
    protected RenderBlocks renderBlocks = new RenderBlocks();
    protected float shadowSize = 0.0f;
    protected float shadowOpaque = 1.0f;

    public abstract void doRender(Entity var1, double var2, double var4, double var6, float var8, float var9);

    protected void loadTexture(String par1Str) {
        RenderEngine renderengine = this.renderManager.renderEngine;
        renderengine.bindTexture(renderengine.getTexture(par1Str));
    }

    protected boolean loadDownloadableImageTexture(String par1Str, String par2Str) {
        RenderEngine renderengine = this.renderManager.renderEngine;
        int i = renderengine.getTextureForDownloadableImage(par1Str, par2Str);
        if (i >= 0) {
            renderengine.bindTexture(i);
            return true;
        }
        return false;
    }

    private void renderEntityOnFire(Entity par1Entity, double par2, double par4, double par6, float par8) {
        GL11.glDisable((int)2896);
        int i = Block.fire.blockIndexInTexture;
        int j = (i & 0xF) << 4;
        int k = i & 0xF0;
        float f = (float)j / 256.0f;
        float f2 = ((float)j + 15.99f) / 256.0f;
        float f4 = (float)k / 256.0f;
        float f6 = ((float)k + 15.99f) / 256.0f;
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)par2), (float)((float)par4), (float)((float)par6));
        float f8 = par1Entity.width * 1.4f;
        GL11.glScalef((float)f8, (float)f8, (float)f8);
        this.loadTexture("/terrain.png");
        Tessellator tessellator = Tessellator.instance;
        float f9 = 0.5f;
        float f10 = 0.0f;
        float f11 = par1Entity.height / f8;
        float f12 = (float)(par1Entity.posY - par1Entity.boundingBox.minY);
        GL11.glRotatef((float)(-this.renderManager.playerViewY), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)(-0.3f + (float)((int)f11) * 0.02f));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float f13 = 0.0f;
        int l = 0;
        tessellator.startDrawingQuads();
        while (f11 > 0.0f) {
            float f7;
            float f5;
            float f3;
            float f1;
            if (l % 2 == 0) {
                f1 = (float)j / 256.0f;
                f3 = ((float)j + 15.99f) / 256.0f;
                f5 = (float)k / 256.0f;
                f7 = ((float)k + 15.99f) / 256.0f;
            } else {
                f1 = (float)j / 256.0f;
                f3 = ((float)j + 15.99f) / 256.0f;
                f5 = (float)(k + 16) / 256.0f;
                f7 = ((float)(k + 16) + 15.99f) / 256.0f;
            }
            if (l / 2 % 2 == 0) {
                float f14 = f3;
                f3 = f1;
                f1 = f14;
            }
            tessellator.addVertexWithUV(f9 - f10, 0.0f - f12, f13, f3, f7);
            tessellator.addVertexWithUV(-f9 - f10, 0.0f - f12, f13, f1, f7);
            tessellator.addVertexWithUV(-f9 - f10, 1.4f - f12, f13, f1, f5);
            tessellator.addVertexWithUV(f9 - f10, 1.4f - f12, f13, f3, f5);
            f11 -= 0.45f;
            f12 -= 0.45f;
            f9 *= 0.9f;
            f13 += 0.03f;
            ++l;
        }
        tessellator.draw();
        GL11.glPopMatrix();
        GL11.glEnable((int)2896);
    }

    private void renderShadow(Entity par1Entity, double par2, double par4, double par6, float par8, float par9) {
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        RenderEngine renderengine = this.renderManager.renderEngine;
        renderengine.bindTexture(renderengine.getTexture("%clamp%/misc/shadow.png"));
        World world = this.getWorldFromRenderManager();
        GL11.glDepthMask((boolean)false);
        float f = this.shadowSize;
        if (par1Entity instanceof EntityLiving) {
            EntityAnimal entityanimal;
            EntityLiving entityliving = (EntityLiving)par1Entity;
            f *= entityliving.getRenderSizeModifier();
            if (entityliving instanceof EntityAnimal && (entityanimal = (EntityAnimal)entityliving).isChild()) {
                f *= 0.5f;
            }
        }
        double d = par1Entity.lastTickPosX + (par1Entity.posX - par1Entity.lastTickPosX) * (double)par9;
        double d1 = par1Entity.lastTickPosY + (par1Entity.posY - par1Entity.lastTickPosY) * (double)par9 + (double)par1Entity.getShadowSize();
        double d2 = par1Entity.lastTickPosZ + (par1Entity.posZ - par1Entity.lastTickPosZ) * (double)par9;
        int i = MathHelper.floor_double(d - (double)f);
        int j = MathHelper.floor_double(d + (double)f);
        int k = MathHelper.floor_double(d1 - (double)f);
        int l = MathHelper.floor_double(d1);
        int i1 = MathHelper.floor_double(d2 - (double)f);
        int j1 = MathHelper.floor_double(d2 + (double)f);
        double d3 = par2 - d;
        double d4 = par4 - d1;
        double d5 = par6 - d2;
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawingQuads();
        for (int k1 = i; k1 <= j; ++k1) {
            for (int l1 = k; l1 <= l; ++l1) {
                for (int i2 = i1; i2 <= j1; ++i2) {
                    int j2 = world.getBlockId(k1, l1 - 1, i2);
                    if (j2 <= 0 || world.getBlockLightValue(k1, l1, i2) <= 3) continue;
                    this.renderShadowOnBlock(Block.blocksList[j2], par2, par4 + (double)par1Entity.getShadowSize(), par6, k1, l1, i2, par8, f, d3, d4 + (double)par1Entity.getShadowSize(), d5);
                }
            }
        }
        tessellator.draw();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3042);
        GL11.glDepthMask((boolean)true);
    }

    private World getWorldFromRenderManager() {
        return this.renderManager.worldObj;
    }

    private void renderShadowOnBlock(Block par1Block, double par2, double par4, double par6, int par8, int par9, int par10, float par11, float par12, double par13, double par15, double par17) {
        Tessellator tessellator = Tessellator.instance;
        if (!par1Block.renderAsNormalBlock()) {
            return;
        }
        double d = ((double)par11 - (par4 - ((double)par9 + par15)) / 2.0) * 0.5 * (double)this.getWorldFromRenderManager().getLightBrightness(par8, par9, par10);
        if (d < 0.0) {
            return;
        }
        if (d > 1.0) {
            d = 1.0;
        }
        tessellator.setColorRGBA_F(1.0f, 1.0f, 1.0f, (float)d);
        double d1 = (double)par8 + par1Block.minX + par13;
        double d2 = (double)par8 + par1Block.maxX + par13;
        double d3 = (double)par9 + par1Block.minY + par15 + 0.015625;
        double d4 = (double)par10 + par1Block.minZ + par17;
        double d5 = (double)par10 + par1Block.maxZ + par17;
        float f = (float)((par2 - d1) / 2.0 / (double)par12 + 0.5);
        float f1 = (float)((par2 - d2) / 2.0 / (double)par12 + 0.5);
        float f2 = (float)((par6 - d4) / 2.0 / (double)par12 + 0.5);
        float f3 = (float)((par6 - d5) / 2.0 / (double)par12 + 0.5);
        tessellator.addVertexWithUV(d1, d3, d4, f, f2);
        tessellator.addVertexWithUV(d1, d3, d5, f, f3);
        tessellator.addVertexWithUV(d2, d3, d5, f1, f3);
        tessellator.addVertexWithUV(d2, d3, d4, f1, f2);
    }

    public static void renderOffsetAABB(AxisAlignedBB par0AxisAlignedBB, double par1, double par3, double par5) {
        GL11.glDisable((int)3553);
        Tessellator tessellator = Tessellator.instance;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        tessellator.startDrawingQuads();
        tessellator.setTranslation(par1, par3, par5);
        tessellator.setNormal(0.0f, 0.0f, -1.0f);
        tessellator.addVertex(par0AxisAlignedBB.minX, par0AxisAlignedBB.maxY, par0AxisAlignedBB.minZ);
        tessellator.addVertex(par0AxisAlignedBB.maxX, par0AxisAlignedBB.maxY, par0AxisAlignedBB.minZ);
        tessellator.addVertex(par0AxisAlignedBB.maxX, par0AxisAlignedBB.minY, par0AxisAlignedBB.minZ);
        tessellator.addVertex(par0AxisAlignedBB.minX, par0AxisAlignedBB.minY, par0AxisAlignedBB.minZ);
        tessellator.setNormal(0.0f, 0.0f, 1.0f);
        tessellator.addVertex(par0AxisAlignedBB.minX, par0AxisAlignedBB.minY, par0AxisAlignedBB.maxZ);
        tessellator.addVertex(par0AxisAlignedBB.maxX, par0AxisAlignedBB.minY, par0AxisAlignedBB.maxZ);
        tessellator.addVertex(par0AxisAlignedBB.maxX, par0AxisAlignedBB.maxY, par0AxisAlignedBB.maxZ);
        tessellator.addVertex(par0AxisAlignedBB.minX, par0AxisAlignedBB.maxY, par0AxisAlignedBB.maxZ);
        tessellator.setNormal(0.0f, -1.0f, 0.0f);
        tessellator.addVertex(par0AxisAlignedBB.minX, par0AxisAlignedBB.minY, par0AxisAlignedBB.minZ);
        tessellator.addVertex(par0AxisAlignedBB.maxX, par0AxisAlignedBB.minY, par0AxisAlignedBB.minZ);
        tessellator.addVertex(par0AxisAlignedBB.maxX, par0AxisAlignedBB.minY, par0AxisAlignedBB.maxZ);
        tessellator.addVertex(par0AxisAlignedBB.minX, par0AxisAlignedBB.minY, par0AxisAlignedBB.maxZ);
        tessellator.setNormal(0.0f, 1.0f, 0.0f);
        tessellator.addVertex(par0AxisAlignedBB.minX, par0AxisAlignedBB.maxY, par0AxisAlignedBB.maxZ);
        tessellator.addVertex(par0AxisAlignedBB.maxX, par0AxisAlignedBB.maxY, par0AxisAlignedBB.maxZ);
        tessellator.addVertex(par0AxisAlignedBB.maxX, par0AxisAlignedBB.maxY, par0AxisAlignedBB.minZ);
        tessellator.addVertex(par0AxisAlignedBB.minX, par0AxisAlignedBB.maxY, par0AxisAlignedBB.minZ);
        tessellator.setNormal(-1.0f, 0.0f, 0.0f);
        tessellator.addVertex(par0AxisAlignedBB.minX, par0AxisAlignedBB.minY, par0AxisAlignedBB.maxZ);
        tessellator.addVertex(par0AxisAlignedBB.minX, par0AxisAlignedBB.maxY, par0AxisAlignedBB.maxZ);
        tessellator.addVertex(par0AxisAlignedBB.minX, par0AxisAlignedBB.maxY, par0AxisAlignedBB.minZ);
        tessellator.addVertex(par0AxisAlignedBB.minX, par0AxisAlignedBB.minY, par0AxisAlignedBB.minZ);
        tessellator.setNormal(1.0f, 0.0f, 0.0f);
        tessellator.addVertex(par0AxisAlignedBB.maxX, par0AxisAlignedBB.minY, par0AxisAlignedBB.minZ);
        tessellator.addVertex(par0AxisAlignedBB.maxX, par0AxisAlignedBB.maxY, par0AxisAlignedBB.minZ);
        tessellator.addVertex(par0AxisAlignedBB.maxX, par0AxisAlignedBB.maxY, par0AxisAlignedBB.maxZ);
        tessellator.addVertex(par0AxisAlignedBB.maxX, par0AxisAlignedBB.minY, par0AxisAlignedBB.maxZ);
        tessellator.setTranslation(0.0, 0.0, 0.0);
        tessellator.draw();
        GL11.glEnable((int)3553);
    }

    public static void renderAABB(AxisAlignedBB par0AxisAlignedBB) {
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawingQuads();
        tessellator.addVertex(par0AxisAlignedBB.minX, par0AxisAlignedBB.maxY, par0AxisAlignedBB.minZ);
        tessellator.addVertex(par0AxisAlignedBB.maxX, par0AxisAlignedBB.maxY, par0AxisAlignedBB.minZ);
        tessellator.addVertex(par0AxisAlignedBB.maxX, par0AxisAlignedBB.minY, par0AxisAlignedBB.minZ);
        tessellator.addVertex(par0AxisAlignedBB.minX, par0AxisAlignedBB.minY, par0AxisAlignedBB.minZ);
        tessellator.addVertex(par0AxisAlignedBB.minX, par0AxisAlignedBB.minY, par0AxisAlignedBB.maxZ);
        tessellator.addVertex(par0AxisAlignedBB.maxX, par0AxisAlignedBB.minY, par0AxisAlignedBB.maxZ);
        tessellator.addVertex(par0AxisAlignedBB.maxX, par0AxisAlignedBB.maxY, par0AxisAlignedBB.maxZ);
        tessellator.addVertex(par0AxisAlignedBB.minX, par0AxisAlignedBB.maxY, par0AxisAlignedBB.maxZ);
        tessellator.addVertex(par0AxisAlignedBB.minX, par0AxisAlignedBB.minY, par0AxisAlignedBB.minZ);
        tessellator.addVertex(par0AxisAlignedBB.maxX, par0AxisAlignedBB.minY, par0AxisAlignedBB.minZ);
        tessellator.addVertex(par0AxisAlignedBB.maxX, par0AxisAlignedBB.minY, par0AxisAlignedBB.maxZ);
        tessellator.addVertex(par0AxisAlignedBB.minX, par0AxisAlignedBB.minY, par0AxisAlignedBB.maxZ);
        tessellator.addVertex(par0AxisAlignedBB.minX, par0AxisAlignedBB.maxY, par0AxisAlignedBB.maxZ);
        tessellator.addVertex(par0AxisAlignedBB.maxX, par0AxisAlignedBB.maxY, par0AxisAlignedBB.maxZ);
        tessellator.addVertex(par0AxisAlignedBB.maxX, par0AxisAlignedBB.maxY, par0AxisAlignedBB.minZ);
        tessellator.addVertex(par0AxisAlignedBB.minX, par0AxisAlignedBB.maxY, par0AxisAlignedBB.minZ);
        tessellator.addVertex(par0AxisAlignedBB.minX, par0AxisAlignedBB.minY, par0AxisAlignedBB.maxZ);
        tessellator.addVertex(par0AxisAlignedBB.minX, par0AxisAlignedBB.maxY, par0AxisAlignedBB.maxZ);
        tessellator.addVertex(par0AxisAlignedBB.minX, par0AxisAlignedBB.maxY, par0AxisAlignedBB.minZ);
        tessellator.addVertex(par0AxisAlignedBB.minX, par0AxisAlignedBB.minY, par0AxisAlignedBB.minZ);
        tessellator.addVertex(par0AxisAlignedBB.maxX, par0AxisAlignedBB.minY, par0AxisAlignedBB.minZ);
        tessellator.addVertex(par0AxisAlignedBB.maxX, par0AxisAlignedBB.maxY, par0AxisAlignedBB.minZ);
        tessellator.addVertex(par0AxisAlignedBB.maxX, par0AxisAlignedBB.maxY, par0AxisAlignedBB.maxZ);
        tessellator.addVertex(par0AxisAlignedBB.maxX, par0AxisAlignedBB.minY, par0AxisAlignedBB.maxZ);
        tessellator.draw();
    }

    public void setRenderManager(RenderManager par1RenderManager) {
        this.renderManager = par1RenderManager;
    }

    public void doRenderShadowAndFire(Entity par1Entity, double par2, double par4, double par6, float par8, float par9) {
        double d;
        float f;
        if (this.renderManager.options.fancyGraphics && this.shadowSize > 0.0f && (f = (float)((1.0 - (d = this.renderManager.getDistanceToCamera(par1Entity.posX, par1Entity.posY, par1Entity.posZ)) / 256.0) * (double)this.shadowOpaque)) > 0.0f) {
            this.renderShadow(par1Entity, par2, par4, par6, f, par9);
        }
        if (par1Entity.isBurning()) {
            this.renderEntityOnFire(par1Entity, par2, par4, par6, par9);
        }
    }

    public FontRenderer getFontRendererFromRenderManager() {
        return this.renderManager.getFontRenderer();
    }
}

