/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.src.RegionFile;

public class RegionFileCache {
    private static final Map regionsByFilename = new HashMap();

    private RegionFileCache() {
    }

    public static synchronized RegionFile createOrLoadRegionFile(File par0File, int par1, int par2) {
        RegionFile regionfile;
        File file = new File(par0File, "region");
        File file1 = new File(file, "r." + (par1 >> 5) + "." + (par2 >> 5) + ".mca");
        Reference reference = (Reference)regionsByFilename.get(file1);
        if (reference != null && (regionfile = (RegionFile)reference.get()) != null) {
            return regionfile;
        }
        if (!file.exists()) {
            file.mkdirs();
        }
        if (regionsByFilename.size() >= 256) {
            RegionFileCache.clearRegionFileReferences();
        }
        RegionFile regionfile1 = new RegionFile(file1);
        regionsByFilename.put(file1, new SoftReference<RegionFile>(regionfile1));
        return regionfile1;
    }

    public static synchronized void clearRegionFileReferences() {
        for (Reference reference : regionsByFilename.values()) {
            try {
                RegionFile regionfile = (RegionFile)reference.get();
                if (regionfile == null) continue;
                regionfile.close();
            }
            catch (IOException ioexception) {
                ioexception.printStackTrace();
            }
        }
        regionsByFilename.clear();
    }

    public static DataInputStream getChunkInputStream(File par0File, int par1, int par2) {
        RegionFile regionfile = RegionFileCache.createOrLoadRegionFile(par0File, par1, par2);
        return regionfile.getChunkDataInputStream(par1 & 0x1F, par2 & 0x1F);
    }

    public static DataOutputStream getChunkOutputStream(File par0File, int par1, int par2) {
        RegionFile regionfile = RegionFileCache.createOrLoadRegionFile(par0File, par1, par2);
        return regionfile.getChunkDataOutputStream(par1 & 0x1F, par2 & 0x1F);
    }
}

