/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import net.minecraft.src.RegionFileChunkBuffer;

public class RegionFile {
    private static final byte[] emptySector = new byte[4096];
    private final File fileName;
    private RandomAccessFile dataFile;
    private final int[] offsets = new int[1024];
    private final int[] chunkTimestamps = new int[1024];
    private ArrayList sectorFree;
    private int sizeDelta;
    private long lastModified = 0L;

    public RegionFile(File par1File) {
        this.fileName = par1File;
        this.debugln("REGION LOAD " + this.fileName);
        this.sizeDelta = 0;
        try {
            if (par1File.exists()) {
                this.lastModified = par1File.lastModified();
            }
            this.dataFile = new RandomAccessFile(par1File, "rw");
            if (this.dataFile.length() < 4096L) {
                for (int i = 0; i < 1024; ++i) {
                    this.dataFile.writeInt(0);
                }
                for (int j = 0; j < 1024; ++j) {
                    this.dataFile.writeInt(0);
                }
                this.sizeDelta += 8192;
            }
            if ((this.dataFile.length() & 0xFFFL) != 0L) {
                int k = 0;
                while ((long)k < (this.dataFile.length() & 0xFFFL)) {
                    this.dataFile.write(0);
                    ++k;
                }
            }
            int l = (int)this.dataFile.length() / 4096;
            this.sectorFree = new ArrayList(l);
            for (int i1 = 0; i1 < l; ++i1) {
                this.sectorFree.add(true);
            }
            this.sectorFree.set(0, false);
            this.sectorFree.set(1, false);
            this.dataFile.seek(0L);
            for (int j1 = 0; j1 < 1024; ++j1) {
                int l1;
                this.offsets[j1] = l1 = this.dataFile.readInt();
                if (l1 == 0 || (l1 >> 8) + (l1 & 0xFF) > this.sectorFree.size()) continue;
                for (int j2 = 0; j2 < (l1 & 0xFF); ++j2) {
                    this.sectorFree.set((l1 >> 8) + j2, false);
                }
            }
            for (int k1 = 0; k1 < 1024; ++k1) {
                int i2;
                this.chunkTimestamps[k1] = i2 = this.dataFile.readInt();
            }
        }
        catch (IOException ioexception) {
            ioexception.printStackTrace();
        }
    }

    private void debug(String s) {
    }

    private void debugln(String par1Str) {
        this.debug(par1Str + "\n");
    }

    private void debug(String par1Str, int par2, int par3, String par4Str) {
        this.debug("REGION " + par1Str + " " + this.fileName.getName() + "[" + par2 + "," + par3 + "] = " + par4Str);
    }

    private void debug(String par1Str, int par2, int par3, int par4, String par5Str) {
        this.debug("REGION " + par1Str + " " + this.fileName.getName() + "[" + par2 + "," + par3 + "] " + par4 + "B = " + par5Str);
    }

    private void debugln(String par1Str, int par2, int par3, String par4Str) {
        this.debug(par1Str, par2, par3, par4Str + "\n");
    }

    public synchronized DataInputStream getChunkDataInputStream(int par1, int par2) {
        if (this.outOfBounds(par1, par2)) {
            this.debugln("READ", par1, par2, "out of bounds");
            return null;
        }
        try {
            int i = this.getOffset(par1, par2);
            if (i == 0) {
                return null;
            }
            int j = i >> 8;
            int k = i & 0xFF;
            if (j + k > this.sectorFree.size()) {
                this.debugln("READ", par1, par2, "invalid sector");
                return null;
            }
            this.dataFile.seek(j * 4096);
            int l = this.dataFile.readInt();
            if (l > 4096 * k) {
                this.debugln("READ", par1, par2, "invalid length: " + l + " > 4096 * " + k);
                return null;
            }
            if (l <= 0) {
                this.debugln("READ", par1, par2, "invalid length: " + l + " < 1");
                return null;
            }
            byte byte0 = this.dataFile.readByte();
            if (byte0 == 1) {
                byte[] abyte0 = new byte[l - 1];
                this.dataFile.read(abyte0);
                DataInputStream datainputstream = new DataInputStream(new BufferedInputStream(new GZIPInputStream(new ByteArrayInputStream(abyte0))));
                return datainputstream;
            }
            if (byte0 == 2) {
                byte[] abyte1 = new byte[l - 1];
                this.dataFile.read(abyte1);
                DataInputStream datainputstream1 = new DataInputStream(new BufferedInputStream(new InflaterInputStream(new ByteArrayInputStream(abyte1))));
                return datainputstream1;
            }
            this.debugln("READ", par1, par2, "unknown version " + byte0);
            return null;
        }
        catch (IOException ioexception) {
            this.debugln("READ", par1, par2, "exception");
            return null;
        }
    }

    public DataOutputStream getChunkDataOutputStream(int par1, int par2) {
        if (this.outOfBounds(par1, par2)) {
            return null;
        }
        return new DataOutputStream(new DeflaterOutputStream(new RegionFileChunkBuffer(this, par1, par2)));
    }

    protected synchronized void write(int par1, int par2, byte[] par3ArrayOfByte, int par4) {
        try {
            int i = this.getOffset(par1, par2);
            int j = i >> 8;
            int i1 = i & 0xFF;
            int j1 = (par4 + 5) / 4096 + 1;
            if (j1 >= 256) {
                return;
            }
            if (j != 0 && i1 == j1) {
                this.debug("SAVE", par1, par2, par4, "rewrite");
                this.write(j, par3ArrayOfByte, par4);
            } else {
                for (int k1 = 0; k1 < i1; ++k1) {
                    this.sectorFree.set(j + k1, true);
                }
                int l1 = this.sectorFree.indexOf(true);
                int i2 = 0;
                if (l1 != -1) {
                    for (int j2 = l1; j2 < this.sectorFree.size(); ++j2) {
                        if (i2 != 0) {
                            i2 = ((Boolean)this.sectorFree.get(j2)).booleanValue() ? ++i2 : 0;
                        } else if (((Boolean)this.sectorFree.get(j2)).booleanValue()) {
                            l1 = j2;
                            i2 = 1;
                        }
                        if (i2 >= j1) break;
                    }
                }
                if (i2 >= j1) {
                    this.debug("SAVE", par1, par2, par4, "reuse");
                    int k = l1;
                    this.setOffset(par1, par2, k << 8 | j1);
                    for (int k2 = 0; k2 < j1; ++k2) {
                        this.sectorFree.set(k + k2, false);
                    }
                    this.write(k, par3ArrayOfByte, par4);
                } else {
                    this.debug("SAVE", par1, par2, par4, "grow");
                    this.dataFile.seek(this.dataFile.length());
                    int l = this.sectorFree.size();
                    for (int l2 = 0; l2 < j1; ++l2) {
                        this.dataFile.write(emptySector);
                        this.sectorFree.add(false);
                    }
                    this.sizeDelta += 4096 * j1;
                    this.write(l, par3ArrayOfByte, par4);
                    this.setOffset(par1, par2, l << 8 | j1);
                }
            }
            this.setChunkTimestamp(par1, par2, (int)(System.currentTimeMillis() / 1000L));
        }
        catch (IOException ioexception) {
            ioexception.printStackTrace();
        }
    }

    private void write(int par1, byte[] par2ArrayOfByte, int par3) throws IOException {
        this.debugln(" " + par1);
        this.dataFile.seek(par1 * 4096);
        this.dataFile.writeInt(par3 + 1);
        this.dataFile.writeByte(2);
        this.dataFile.write(par2ArrayOfByte, 0, par3);
    }

    private boolean outOfBounds(int par1, int par2) {
        return par1 < 0 || par1 >= 32 || par2 < 0 || par2 >= 32;
    }

    private int getOffset(int par1, int par2) {
        return this.offsets[par1 + par2 * 32];
    }

    public boolean isChunkSaved(int par1, int par2) {
        return this.getOffset(par1, par2) != 0;
    }

    private void setOffset(int par1, int par2, int par3) throws IOException {
        this.offsets[par1 + par2 * 32] = par3;
        this.dataFile.seek((par1 + par2 * 32) * 4);
        this.dataFile.writeInt(par3);
    }

    private void setChunkTimestamp(int par1, int par2, int par3) throws IOException {
        this.chunkTimestamps[par1 + par2 * 32] = par3;
        this.dataFile.seek(4096 + (par1 + par2 * 32) * 4);
        this.dataFile.writeInt(par3);
    }

    public void close() throws IOException {
        this.dataFile.close();
    }
}

