/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.src.Block;
import net.minecraft.src.BlockRail;
import net.minecraft.src.ChunkPosition;
import net.minecraft.src.World;

class RailLogic {
    private World worldObj;
    private int trackX;
    private int trackY;
    private int trackZ;
    private final boolean isPoweredRail;
    private List connectedTracks;
    final BlockRail rail;

    public RailLogic(BlockRail par1BlockRail, World par2World, int par3, int par4, int par5) {
        this.rail = par1BlockRail;
        this.connectedTracks = new ArrayList();
        this.worldObj = par2World;
        this.trackX = par3;
        this.trackY = par4;
        this.trackZ = par5;
        int i = par2World.getBlockId(par3, par4, par5);
        int j = par2World.getBlockMetadata(par3, par4, par5);
        if (BlockRail.isPoweredBlockRail((BlockRail)Block.blocksList[i])) {
            this.isPoweredRail = true;
            j &= 0xFFFFFFF7;
        } else {
            this.isPoweredRail = false;
        }
        this.setConnections(j);
    }

    private void setConnections(int par1) {
        this.connectedTracks.clear();
        if (par1 == 0) {
            this.connectedTracks.add(new ChunkPosition(this.trackX, this.trackY, this.trackZ - 1));
            this.connectedTracks.add(new ChunkPosition(this.trackX, this.trackY, this.trackZ + 1));
        } else if (par1 == 1) {
            this.connectedTracks.add(new ChunkPosition(this.trackX - 1, this.trackY, this.trackZ));
            this.connectedTracks.add(new ChunkPosition(this.trackX + 1, this.trackY, this.trackZ));
        } else if (par1 == 2) {
            this.connectedTracks.add(new ChunkPosition(this.trackX - 1, this.trackY, this.trackZ));
            this.connectedTracks.add(new ChunkPosition(this.trackX + 1, this.trackY + 1, this.trackZ));
        } else if (par1 == 3) {
            this.connectedTracks.add(new ChunkPosition(this.trackX - 1, this.trackY + 1, this.trackZ));
            this.connectedTracks.add(new ChunkPosition(this.trackX + 1, this.trackY, this.trackZ));
        } else if (par1 == 4) {
            this.connectedTracks.add(new ChunkPosition(this.trackX, this.trackY + 1, this.trackZ - 1));
            this.connectedTracks.add(new ChunkPosition(this.trackX, this.trackY, this.trackZ + 1));
        } else if (par1 == 5) {
            this.connectedTracks.add(new ChunkPosition(this.trackX, this.trackY, this.trackZ - 1));
            this.connectedTracks.add(new ChunkPosition(this.trackX, this.trackY + 1, this.trackZ + 1));
        } else if (par1 == 6) {
            this.connectedTracks.add(new ChunkPosition(this.trackX + 1, this.trackY, this.trackZ));
            this.connectedTracks.add(new ChunkPosition(this.trackX, this.trackY, this.trackZ + 1));
        } else if (par1 == 7) {
            this.connectedTracks.add(new ChunkPosition(this.trackX - 1, this.trackY, this.trackZ));
            this.connectedTracks.add(new ChunkPosition(this.trackX, this.trackY, this.trackZ + 1));
        } else if (par1 == 8) {
            this.connectedTracks.add(new ChunkPosition(this.trackX - 1, this.trackY, this.trackZ));
            this.connectedTracks.add(new ChunkPosition(this.trackX, this.trackY, this.trackZ - 1));
        } else if (par1 == 9) {
            this.connectedTracks.add(new ChunkPosition(this.trackX + 1, this.trackY, this.trackZ));
            this.connectedTracks.add(new ChunkPosition(this.trackX, this.trackY, this.trackZ - 1));
        }
    }

    private void refreshConnectedTracks() {
        for (int i = 0; i < this.connectedTracks.size(); ++i) {
            RailLogic raillogic = this.getMinecartTrackLogic((ChunkPosition)this.connectedTracks.get(i));
            if (raillogic == null || !raillogic.isConnectedTo(this)) {
                this.connectedTracks.remove(i--);
                continue;
            }
            this.connectedTracks.set(i, new ChunkPosition(raillogic.trackX, raillogic.trackY, raillogic.trackZ));
        }
    }

    private boolean isMinecartTrack(int par1, int par2, int par3) {
        if (BlockRail.isRailBlockAt(this.worldObj, par1, par2, par3)) {
            return true;
        }
        if (BlockRail.isRailBlockAt(this.worldObj, par1, par2 + 1, par3)) {
            return true;
        }
        return BlockRail.isRailBlockAt(this.worldObj, par1, par2 - 1, par3);
    }

    private RailLogic getMinecartTrackLogic(ChunkPosition par1ChunkPosition) {
        if (BlockRail.isRailBlockAt(this.worldObj, par1ChunkPosition.x, par1ChunkPosition.y, par1ChunkPosition.z)) {
            return new RailLogic(this.rail, this.worldObj, par1ChunkPosition.x, par1ChunkPosition.y, par1ChunkPosition.z);
        }
        if (BlockRail.isRailBlockAt(this.worldObj, par1ChunkPosition.x, par1ChunkPosition.y + 1, par1ChunkPosition.z)) {
            return new RailLogic(this.rail, this.worldObj, par1ChunkPosition.x, par1ChunkPosition.y + 1, par1ChunkPosition.z);
        }
        if (BlockRail.isRailBlockAt(this.worldObj, par1ChunkPosition.x, par1ChunkPosition.y - 1, par1ChunkPosition.z)) {
            return new RailLogic(this.rail, this.worldObj, par1ChunkPosition.x, par1ChunkPosition.y - 1, par1ChunkPosition.z);
        }
        return null;
    }

    private boolean isConnectedTo(RailLogic par1RailLogic) {
        for (int i = 0; i < this.connectedTracks.size(); ++i) {
            ChunkPosition chunkposition = (ChunkPosition)this.connectedTracks.get(i);
            if (chunkposition.x != par1RailLogic.trackX || chunkposition.z != par1RailLogic.trackZ) continue;
            return true;
        }
        return false;
    }

    private boolean isInTrack(int par1, int par2, int par3) {
        for (int i = 0; i < this.connectedTracks.size(); ++i) {
            ChunkPosition chunkposition = (ChunkPosition)this.connectedTracks.get(i);
            if (chunkposition.x != par1 || chunkposition.z != par3) continue;
            return true;
        }
        return false;
    }

    private int getAdjacentTracks() {
        int i = 0;
        if (this.isMinecartTrack(this.trackX, this.trackY, this.trackZ - 1)) {
            ++i;
        }
        if (this.isMinecartTrack(this.trackX, this.trackY, this.trackZ + 1)) {
            ++i;
        }
        if (this.isMinecartTrack(this.trackX - 1, this.trackY, this.trackZ)) {
            ++i;
        }
        if (this.isMinecartTrack(this.trackX + 1, this.trackY, this.trackZ)) {
            ++i;
        }
        return i;
    }

    private boolean canConnectTo(RailLogic par1RailLogic) {
        if (this.isConnectedTo(par1RailLogic)) {
            return true;
        }
        if (this.connectedTracks.size() == 2) {
            return false;
        }
        if (this.connectedTracks.size() == 0) {
            return true;
        }
        ChunkPosition chunkposition = (ChunkPosition)this.connectedTracks.get(0);
        return par1RailLogic.trackY != this.trackY || chunkposition.y != this.trackY ? true : true;
    }

    private void connectToNeighbor(RailLogic par1RailLogic) {
        this.connectedTracks.add(new ChunkPosition(par1RailLogic.trackX, par1RailLogic.trackY, par1RailLogic.trackZ));
        boolean flag = this.isInTrack(this.trackX, this.trackY, this.trackZ - 1);
        boolean flag1 = this.isInTrack(this.trackX, this.trackY, this.trackZ + 1);
        boolean flag2 = this.isInTrack(this.trackX - 1, this.trackY, this.trackZ);
        boolean flag3 = this.isInTrack(this.trackX + 1, this.trackY, this.trackZ);
        int byte0 = -1;
        if (flag || flag1) {
            byte0 = 0;
        }
        if (flag2 || flag3) {
            byte0 = 1;
        }
        if (!this.isPoweredRail) {
            if (flag1 && flag3 && !flag && !flag2) {
                byte0 = 6;
            }
            if (flag1 && flag2 && !flag && !flag3) {
                byte0 = 7;
            }
            if (flag && flag2 && !flag1 && !flag3) {
                byte0 = 8;
            }
            if (flag && flag3 && !flag1 && !flag2) {
                byte0 = 9;
            }
        }
        if (byte0 == 0) {
            if (BlockRail.isRailBlockAt(this.worldObj, this.trackX, this.trackY + 1, this.trackZ - 1)) {
                byte0 = 4;
            }
            if (BlockRail.isRailBlockAt(this.worldObj, this.trackX, this.trackY + 1, this.trackZ + 1)) {
                byte0 = 5;
            }
        }
        if (byte0 == 1) {
            if (BlockRail.isRailBlockAt(this.worldObj, this.trackX + 1, this.trackY + 1, this.trackZ)) {
                byte0 = 2;
            }
            if (BlockRail.isRailBlockAt(this.worldObj, this.trackX - 1, this.trackY + 1, this.trackZ)) {
                byte0 = 3;
            }
        }
        if (byte0 < 0) {
            byte0 = 0;
        }
        int i = byte0;
        if (this.isPoweredRail) {
            i = this.worldObj.getBlockMetadata(this.trackX, this.trackY, this.trackZ) & 8 | byte0;
        }
        this.worldObj.setBlockMetadataWithNotify(this.trackX, this.trackY, this.trackZ, i);
    }

    private boolean canConnectFrom(int par1, int par2, int par3) {
        RailLogic raillogic = this.getMinecartTrackLogic(new ChunkPosition(par1, par2, par3));
        if (raillogic == null) {
            return false;
        }
        raillogic.refreshConnectedTracks();
        return raillogic.canConnectTo(this);
    }

    public void refreshTrackShape(boolean par1, boolean par2) {
        boolean flag = this.canConnectFrom(this.trackX, this.trackY, this.trackZ - 1);
        boolean flag1 = this.canConnectFrom(this.trackX, this.trackY, this.trackZ + 1);
        boolean flag2 = this.canConnectFrom(this.trackX - 1, this.trackY, this.trackZ);
        boolean flag3 = this.canConnectFrom(this.trackX + 1, this.trackY, this.trackZ);
        int byte0 = -1;
        if ((flag || flag1) && !flag2 && !flag3) {
            byte0 = 0;
        }
        if ((flag2 || flag3) && !flag && !flag1) {
            byte0 = 1;
        }
        if (!this.isPoweredRail) {
            if (flag1 && flag3 && !flag && !flag2) {
                byte0 = 6;
            }
            if (flag1 && flag2 && !flag && !flag3) {
                byte0 = 7;
            }
            if (flag && flag2 && !flag1 && !flag3) {
                byte0 = 8;
            }
            if (flag && flag3 && !flag1 && !flag2) {
                byte0 = 9;
            }
        }
        if (byte0 == -1) {
            if (flag || flag1) {
                byte0 = 0;
            }
            if (flag2 || flag3) {
                byte0 = 1;
            }
            if (!this.isPoweredRail) {
                if (par1) {
                    if (flag1 && flag3) {
                        byte0 = 6;
                    }
                    if (flag2 && flag1) {
                        byte0 = 7;
                    }
                    if (flag3 && flag) {
                        byte0 = 9;
                    }
                    if (flag && flag2) {
                        byte0 = 8;
                    }
                } else {
                    if (flag && flag2) {
                        byte0 = 8;
                    }
                    if (flag3 && flag) {
                        byte0 = 9;
                    }
                    if (flag2 && flag1) {
                        byte0 = 7;
                    }
                    if (flag1 && flag3) {
                        byte0 = 6;
                    }
                }
            }
        }
        if (byte0 == 0) {
            if (BlockRail.isRailBlockAt(this.worldObj, this.trackX, this.trackY + 1, this.trackZ - 1)) {
                byte0 = 4;
            }
            if (BlockRail.isRailBlockAt(this.worldObj, this.trackX, this.trackY + 1, this.trackZ + 1)) {
                byte0 = 5;
            }
        }
        if (byte0 == 1) {
            if (BlockRail.isRailBlockAt(this.worldObj, this.trackX + 1, this.trackY + 1, this.trackZ)) {
                byte0 = 2;
            }
            if (BlockRail.isRailBlockAt(this.worldObj, this.trackX - 1, this.trackY + 1, this.trackZ)) {
                byte0 = 3;
            }
        }
        if (byte0 < 0) {
            byte0 = 0;
        }
        this.setConnections(byte0);
        int i = byte0;
        if (this.isPoweredRail) {
            i = this.worldObj.getBlockMetadata(this.trackX, this.trackY, this.trackZ) & 8 | byte0;
        }
        if (par2 || this.worldObj.getBlockMetadata(this.trackX, this.trackY, this.trackZ) != i) {
            this.worldObj.setBlockMetadataWithNotify(this.trackX, this.trackY, this.trackZ, i);
            for (int j = 0; j < this.connectedTracks.size(); ++j) {
                RailLogic raillogic = this.getMinecartTrackLogic((ChunkPosition)this.connectedTracks.get(j));
                if (raillogic == null) continue;
                raillogic.refreshConnectedTracks();
                if (!raillogic.canConnectTo(this)) continue;
                raillogic.connectToNeighbor(this);
            }
        }
    }

    static int getNAdjacentTracks(RailLogic par0RailLogic) {
        return par0RailLogic.getAdjacentTracks();
    }
}

