/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.PathPoint;

public class Path {
    private PathPoint[] pathPoints = new PathPoint[1024];
    private int count = 0;

    public PathPoint addPoint(PathPoint par1PathPoint) {
        if (par1PathPoint.index >= 0) {
            throw new IllegalStateException("OW KNOWS!");
        }
        if (this.count == this.pathPoints.length) {
            PathPoint[] apathpoint = new PathPoint[this.count << 1];
            System.arraycopy(this.pathPoints, 0, apathpoint, 0, this.count);
            this.pathPoints = apathpoint;
        }
        this.pathPoints[this.count] = par1PathPoint;
        par1PathPoint.index = this.count;
        this.sortBack(this.count++);
        return par1PathPoint;
    }

    public void clearPath() {
        this.count = 0;
    }

    public PathPoint dequeue() {
        PathPoint pathpoint = this.pathPoints[0];
        this.pathPoints[0] = this.pathPoints[--this.count];
        this.pathPoints[this.count] = null;
        if (this.count > 0) {
            this.sortForward(0);
        }
        pathpoint.index = -1;
        return pathpoint;
    }

    public void changeDistance(PathPoint par1PathPoint, float par2) {
        float f = par1PathPoint.distanceToTarget;
        par1PathPoint.distanceToTarget = par2;
        if (par2 < f) {
            this.sortBack(par1PathPoint.index);
        } else {
            this.sortForward(par1PathPoint.index);
        }
    }

    private void sortBack(int par1) {
        PathPoint pathpoint = this.pathPoints[par1];
        float f = pathpoint.distanceToTarget;
        while (par1 > 0) {
            int i = par1 - 1 >> 1;
            PathPoint pathpoint1 = this.pathPoints[i];
            if (f >= pathpoint1.distanceToTarget) break;
            this.pathPoints[par1] = pathpoint1;
            pathpoint1.index = par1;
            par1 = i;
        }
        this.pathPoints[par1] = pathpoint;
        pathpoint.index = par1;
    }

    private void sortForward(int par1) {
        PathPoint pathpoint = this.pathPoints[par1];
        float f = pathpoint.distanceToTarget;
        while (true) {
            float f2;
            PathPoint pathpoint2;
            int i = 1 + (par1 << 1);
            int j = i + 1;
            if (i >= this.count) break;
            PathPoint pathpoint1 = this.pathPoints[i];
            float f1 = pathpoint1.distanceToTarget;
            if (j >= this.count) {
                pathpoint2 = null;
                f2 = Float.POSITIVE_INFINITY;
            } else {
                pathpoint2 = this.pathPoints[j];
                f2 = pathpoint2.distanceToTarget;
            }
            if (f1 < f2) {
                if (f1 >= f) break;
                this.pathPoints[par1] = pathpoint1;
                pathpoint1.index = par1;
                par1 = i;
                continue;
            }
            if (f2 >= f) break;
            this.pathPoints[par1] = pathpoint2;
            pathpoint2.index = par1;
            par1 = j;
        }
        this.pathPoints[par1] = pathpoint;
        pathpoint.index = par1;
    }

    public boolean isPathEmpty() {
        return this.count == 0;
    }
}

