/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.src.ChunkPosition;
import net.minecraft.src.NetHandler;
import net.minecraft.src.Packet;

public class Packet60Explosion
extends Packet {
    public double explosionX;
    public double explosionY;
    public double explosionZ;
    public float explosionSize;
    public Set destroyedBlockPositions;

    @Override
    public void readPacketData(DataInputStream par1DataInputStream) throws IOException {
        this.explosionX = par1DataInputStream.readDouble();
        this.explosionY = par1DataInputStream.readDouble();
        this.explosionZ = par1DataInputStream.readDouble();
        this.explosionSize = par1DataInputStream.readFloat();
        int i = par1DataInputStream.readInt();
        this.destroyedBlockPositions = new HashSet();
        int j = (int)this.explosionX;
        int k = (int)this.explosionY;
        int l = (int)this.explosionZ;
        for (int i1 = 0; i1 < i; ++i1) {
            int j1 = par1DataInputStream.readByte() + j;
            int k1 = par1DataInputStream.readByte() + k;
            int l1 = par1DataInputStream.readByte() + l;
            this.destroyedBlockPositions.add(new ChunkPosition(j1, k1, l1));
        }
    }

    @Override
    public void writePacketData(DataOutputStream par1DataOutputStream) throws IOException {
        par1DataOutputStream.writeDouble(this.explosionX);
        par1DataOutputStream.writeDouble(this.explosionY);
        par1DataOutputStream.writeDouble(this.explosionZ);
        par1DataOutputStream.writeFloat(this.explosionSize);
        par1DataOutputStream.writeInt(this.destroyedBlockPositions.size());
        int i = (int)this.explosionX;
        int j = (int)this.explosionY;
        int k = (int)this.explosionZ;
        for (ChunkPosition chunkposition : this.destroyedBlockPositions) {
            int l = chunkposition.x - i;
            int i1 = chunkposition.y - j;
            int j1 = chunkposition.z - k;
            par1DataOutputStream.writeByte(l);
            par1DataOutputStream.writeByte(i1);
            par1DataOutputStream.writeByte(j1);
        }
    }

    @Override
    public void processPacket(NetHandler par1NetHandler) {
        par1NetHandler.handleExplosion(this);
    }

    @Override
    public int getPacketSize() {
        return 32 + this.destroyedBlockPositions.size() * 3;
    }
}

