/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.src.Entity;
import net.minecraft.src.MathHelper;
import net.minecraft.src.NetHandler;
import net.minecraft.src.Packet;

public class Packet34EntityTeleport
extends Packet {
    public int entityId;
    public int xPosition;
    public int yPosition;
    public int zPosition;
    public byte yaw;
    public byte pitch;

    public Packet34EntityTeleport() {
    }

    public Packet34EntityTeleport(Entity par1Entity) {
        this.entityId = par1Entity.entityId;
        this.xPosition = MathHelper.floor_double(par1Entity.posX * 32.0);
        this.yPosition = MathHelper.floor_double(par1Entity.posY * 32.0);
        this.zPosition = MathHelper.floor_double(par1Entity.posZ * 32.0);
        this.yaw = (byte)(par1Entity.rotationYaw * 256.0f / 360.0f);
        this.pitch = (byte)(par1Entity.rotationPitch * 256.0f / 360.0f);
    }

    @Override
    public void readPacketData(DataInputStream par1DataInputStream) throws IOException {
        this.entityId = par1DataInputStream.readInt();
        this.xPosition = par1DataInputStream.readInt();
        this.yPosition = par1DataInputStream.readInt();
        this.zPosition = par1DataInputStream.readInt();
        this.yaw = (byte)par1DataInputStream.read();
        this.pitch = (byte)par1DataInputStream.read();
    }

    @Override
    public void writePacketData(DataOutputStream par1DataOutputStream) throws IOException {
        par1DataOutputStream.writeInt(this.entityId);
        par1DataOutputStream.writeInt(this.xPosition);
        par1DataOutputStream.writeInt(this.yPosition);
        par1DataOutputStream.writeInt(this.zPosition);
        par1DataOutputStream.write(this.yaw);
        par1DataOutputStream.write(this.pitch);
    }

    @Override
    public void processPacket(NetHandler par1NetHandler) {
        par1NetHandler.handleEntityTeleport(this);
    }

    @Override
    public int getPacketSize() {
        return 34;
    }
}

