/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.src.EntityItem;
import net.minecraft.src.MathHelper;
import net.minecraft.src.NetHandler;
import net.minecraft.src.Packet;

public class Packet21PickupSpawn
extends Packet {
    public int entityId;
    public int xPosition;
    public int yPosition;
    public int zPosition;
    public byte rotation;
    public byte pitch;
    public byte roll;
    public int itemID;
    public int count;
    public int itemDamage;

    public Packet21PickupSpawn() {
    }

    public Packet21PickupSpawn(EntityItem par1EntityItem) {
        this.entityId = par1EntityItem.entityId;
        this.itemID = par1EntityItem.item.itemID;
        this.count = par1EntityItem.item.stackSize;
        this.itemDamage = par1EntityItem.item.getItemDamage();
        this.xPosition = MathHelper.floor_double(par1EntityItem.posX * 32.0);
        this.yPosition = MathHelper.floor_double(par1EntityItem.posY * 32.0);
        this.zPosition = MathHelper.floor_double(par1EntityItem.posZ * 32.0);
        this.rotation = (byte)(par1EntityItem.motionX * 128.0);
        this.pitch = (byte)(par1EntityItem.motionY * 128.0);
        this.roll = (byte)(par1EntityItem.motionZ * 128.0);
    }

    @Override
    public void readPacketData(DataInputStream par1DataInputStream) throws IOException {
        this.entityId = par1DataInputStream.readInt();
        this.itemID = par1DataInputStream.readShort();
        this.count = par1DataInputStream.readByte();
        this.itemDamage = par1DataInputStream.readShort();
        this.xPosition = par1DataInputStream.readInt();
        this.yPosition = par1DataInputStream.readInt();
        this.zPosition = par1DataInputStream.readInt();
        this.rotation = par1DataInputStream.readByte();
        this.pitch = par1DataInputStream.readByte();
        this.roll = par1DataInputStream.readByte();
    }

    @Override
    public void writePacketData(DataOutputStream par1DataOutputStream) throws IOException {
        par1DataOutputStream.writeInt(this.entityId);
        par1DataOutputStream.writeShort(this.itemID);
        par1DataOutputStream.writeByte(this.count);
        par1DataOutputStream.writeShort(this.itemDamage);
        par1DataOutputStream.writeInt(this.xPosition);
        par1DataOutputStream.writeInt(this.yPosition);
        par1DataOutputStream.writeInt(this.zPosition);
        par1DataOutputStream.writeByte(this.rotation);
        par1DataOutputStream.writeByte(this.pitch);
        par1DataOutputStream.writeByte(this.roll);
    }

    @Override
    public void processPacket(NetHandler par1NetHandler) {
        par1NetHandler.handlePickupSpawn(this);
    }

    @Override
    public int getPacketSize() {
        return 24;
    }
}

