/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.src.NetHandler;
import net.minecraft.src.Packet;
import net.minecraft.src.WorldType;

public class Packet1Login
extends Packet {
    public int protocolVersion;
    public String username;
    public WorldType terrainType;
    public int serverMode;
    public int field_48170_e;
    public byte difficultySetting;
    public byte worldHeight;
    public byte maxPlayers;

    public Packet1Login() {
    }

    public Packet1Login(String par1Str, int par2) {
        this.username = par1Str;
        this.protocolVersion = par2;
    }

    @Override
    public void readPacketData(DataInputStream par1DataInputStream) throws IOException {
        this.protocolVersion = par1DataInputStream.readInt();
        this.username = Packet1Login.readString(par1DataInputStream, 16);
        String s = Packet1Login.readString(par1DataInputStream, 16);
        this.terrainType = WorldType.parseWorldType(s);
        if (this.terrainType == null) {
            this.terrainType = WorldType.DEFAULT;
        }
        this.serverMode = par1DataInputStream.readInt();
        this.field_48170_e = par1DataInputStream.readInt();
        this.difficultySetting = par1DataInputStream.readByte();
        this.worldHeight = par1DataInputStream.readByte();
        this.maxPlayers = par1DataInputStream.readByte();
    }

    @Override
    public void writePacketData(DataOutputStream par1DataOutputStream) throws IOException {
        par1DataOutputStream.writeInt(this.protocolVersion);
        Packet1Login.writeString(this.username, par1DataOutputStream);
        if (this.terrainType == null) {
            Packet1Login.writeString("", par1DataOutputStream);
        } else {
            Packet1Login.writeString(this.terrainType.func_48628_a(), par1DataOutputStream);
        }
        par1DataOutputStream.writeInt(this.serverMode);
        par1DataOutputStream.writeInt(this.field_48170_e);
        par1DataOutputStream.writeByte(this.difficultySetting);
        par1DataOutputStream.writeByte(this.worldHeight);
        par1DataOutputStream.writeByte(this.maxPlayers);
    }

    @Override
    public void processPacket(NetHandler par1NetHandler) {
        par1NetHandler.handleLogin(this);
    }

    @Override
    public int getPacketSize() {
        int i = 0;
        if (this.terrainType != null) {
            i = this.terrainType.func_48628_a().length();
        }
        return 4 + this.username.length() + 4 + 7 + 7 + i;
    }
}

