/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Random;
import net.minecraft.src.Block;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityBlaze;
import net.minecraft.src.EntityChicken;
import net.minecraft.src.EntityCow;
import net.minecraft.src.EntityCreeper;
import net.minecraft.src.EntityEnderman;
import net.minecraft.src.EntityIronGolem;
import net.minecraft.src.EntityItem;
import net.minecraft.src.EntityMagmaCube;
import net.minecraft.src.EntityMooshroom;
import net.minecraft.src.EntityOcelot;
import net.minecraft.src.EntityPig;
import net.minecraft.src.EntityPigZombie;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.EntitySheep;
import net.minecraft.src.EntitySkeleton;
import net.minecraft.src.EntitySlime;
import net.minecraft.src.EntitySnowman;
import net.minecraft.src.EntitySpider;
import net.minecraft.src.EntityWolf;
import net.minecraft.src.EntityXPOrb;
import net.minecraft.src.EntityZombie;
import net.minecraft.src.IInventory;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.NBTTagList;
import net.minecraft.src.PCtr_BlockConveyor;
import net.minecraft.src.PCtr_BlockConveyorSeparator;
import net.minecraft.src.TileEntity;
import net.minecraft.src.mod_PCtransport;

public class PCtr_TileEntitySeparationBelt
extends TileEntity
implements IInventory {
    Random rand = new Random();
    private Hashtable<Entity, Integer> redirList = new Hashtable();
    private ItemStack[] separatorContents = new ItemStack[18];

    @Override
    public int getSizeInventory() {
        return 18;
    }

    @Override
    public void openChest() {
    }

    @Override
    public void closeChest() {
    }

    public boolean canUpdate() {
        return true;
    }

    @Override
    public void updateEntity() {
        Enumeration<Entity> e = this.redirList.keys();
        while (e.hasMoreElements()) {
            Entity thisItem = e.nextElement();
            if (!(thisItem.posX < (double)((float)this.xCoord - 0.2f) || thisItem.posY < (double)((float)this.yCoord - 0.2f) || thisItem.posZ < (double)((float)this.zCoord - 0.2f) || thisItem.posX > (double)((float)this.xCoord + 1.2f) || thisItem.posY > (double)((float)this.yCoord + 1.2f)) && !(thisItem.posZ > (double)((float)this.zCoord + 1.2f))) continue;
            this.redirList.remove(thisItem);
        }
    }

    public int newDirection(Entity entity) {
        boolean notItem = false;
        ItemStack itemstack = null;
        if (entity instanceof EntityItem) {
            itemstack = ((EntityItem)entity).item;
        } else {
            notItem = true;
            if (entity instanceof EntityPig) {
                itemstack = new ItemStack(Item.porkRaw, 1, 0);
            }
            if (entity instanceof EntitySheep) {
                itemstack = new ItemStack(Block.cloth, 1, 0);
            }
            if (entity instanceof EntityCow) {
                itemstack = new ItemStack(Item.beefRaw, 1, 0);
            }
            if (entity instanceof EntityCreeper) {
                itemstack = new ItemStack(Item.gunpowder, 1, 0);
            }
            if (entity instanceof EntityZombie) {
                itemstack = new ItemStack(Item.rottenFlesh, 1, 0);
            }
            if (entity instanceof EntitySkeleton) {
                itemstack = new ItemStack(Item.bone, 1, 0);
            }
            if (entity instanceof EntitySlime) {
                itemstack = new ItemStack(Item.slimeBall, 1, 0);
            }
            if (entity instanceof EntityEnderman) {
                itemstack = new ItemStack(Item.enderPearl, 1, 0);
            }
            if (entity instanceof EntitySnowman) {
                itemstack = new ItemStack(Item.snowball, 1, 0);
            }
            if (entity instanceof EntityChicken) {
                itemstack = new ItemStack(Item.chickenRaw, 1, 0);
            }
            if (entity instanceof EntityXPOrb) {
                itemstack = new ItemStack(Item.diamond, 1, 0);
            }
            if (entity instanceof EntitySpider) {
                itemstack = new ItemStack(Item.silk, 1, 0);
            }
            if (entity instanceof EntityOcelot) {
                itemstack = new ItemStack(Item.fishRaw, 1, 0);
            }
            if (entity instanceof EntityMooshroom) {
                itemstack = new ItemStack(Block.mushroomRed, 1, 0);
            }
            if (entity instanceof EntityWolf) {
                itemstack = new ItemStack(Item.cookie, 1, 0);
            }
            if (entity instanceof EntityBlaze) {
                itemstack = new ItemStack(Item.blazePowder, 1, 0);
            }
            if (entity instanceof EntityMagmaCube) {
                itemstack = new ItemStack(Item.magmaCream, 1, 0);
            }
            if (entity instanceof EntityPigZombie) {
                itemstack = new ItemStack(Item.goldNugget, 1, 0);
            }
            if (entity instanceof EntityIronGolem) {
                itemstack = new ItemStack(Item.ingotIron, 1, 0);
            }
        }
        if (itemstack == null) {
            return 0;
        }
        if (this.redirList.containsKey(entity)) {
            return this.redirList.get(entity);
        }
        int countLeft = 0;
        int countRight = 0;
        boolean group_logs = !mod_PCtransport.separate_wood_types;
        boolean group_planks = !mod_PCtransport.separate_plank_types;
        for (int i = 0; i < this.getSizeInventory(); ++i) {
            ItemStack stack = this.getStackInSlot(i);
            if (stack == null || !stack.isItemEqual(itemstack) && (!group_logs || stack.itemID != Block.wood.blockID || itemstack.itemID != Block.wood.blockID) && (!group_planks || stack.itemID != Block.planks.blockID || itemstack.itemID != Block.planks.blockID)) continue;
            int tmpi = i % 6;
            if (tmpi >= 3) {
                countRight += stack.stackSize;
            }
            if (tmpi > 2) continue;
            countLeft += stack.stackSize;
        }
        if (countLeft == 0 && countRight == 0) {
            return 0;
        }
        if (countLeft == 0 && countRight > 0) {
            return -1;
        }
        if (countLeft > 0 && countRight == 0) {
            return 1;
        }
        if (countLeft > 0 && countRight > 0) {
            if (notItem) {
                this.redirList.put(entity, 0);
                return 0;
            }
            int[] translate = new int[]{1, 0, -1};
            int meta = this.worldObj.getBlockMetadata(this.xCoord, this.yCoord, this.zCoord);
            int leftX = this.xCoord;
            int leftZ = this.zCoord;
            int rightX = this.xCoord;
            int rightZ = this.zCoord;
            switch (((PCtr_BlockConveyorSeparator)mod_PCtransport.separationBelt).getRotation(meta)) {
                case 0: {
                    ++leftX;
                    --rightX;
                    break;
                }
                case 1: {
                    ++leftZ;
                    --rightZ;
                    break;
                }
                case 2: {
                    --leftX;
                    ++rightX;
                    break;
                }
                case 3: {
                    --leftZ;
                    ++rightZ;
                }
            }
            translate[2] = PCtr_BlockConveyor.isConveyorOrElevatorAt(this.worldObj, leftX, this.yCoord, leftZ) ? -1 : 0;
            int n = translate[0] = PCtr_BlockConveyor.isConveyorOrElevatorAt(this.worldObj, rightX, this.yCoord, rightZ) ? 1 : 0;
            if (translate[0] == translate[2]) {
                translate[0] = 1;
                translate[2] = -1;
            }
            if (itemstack.stackSize == 1) {
                int newredir = 1 + this.rand.nextInt(countLeft + countRight) <= countLeft ? 1 : -1;
                this.redirList.put(entity, translate[1 - newredir]);
                return translate[1 - newredir];
            }
            float fractionLeft = (float)countLeft / (float)(countLeft + countRight);
            int partLeft = Math.round((float)itemstack.stackSize * fractionLeft);
            int partRight = itemstack.stackSize - partLeft;
            if (partLeft <= 0) {
                this.redirList.put(entity, translate[2]);
                return translate[2];
            }
            itemstack.stackSize = partLeft;
            this.redirList.put(entity, translate[0]);
            if (partRight <= 0) {
                this.redirList.put(entity, translate[0]);
                return translate[0];
            }
            ItemStack rightStack = itemstack.copy();
            rightStack.stackSize = partRight;
            EntityItem entityitem2 = new EntityItem(this.worldObj, entity.posX, entity.posY, entity.posZ, rightStack);
            entityitem2.motionX = entity.motionX;
            entityitem2.motionY = entity.motionY;
            entityitem2.motionZ = entity.motionZ;
            this.worldObj.spawnEntityInWorld(entityitem2);
            this.redirList.put(entityitem2, translate[2]);
            return translate[0];
        }
        return 0;
    }

    @Override
    public ItemStack getStackInSlot(int i) {
        return this.separatorContents[i];
    }

    @Override
    public ItemStack decrStackSize(int i, int j) {
        if (this.separatorContents[i] != null) {
            if (this.separatorContents[i].stackSize <= j) {
                ItemStack itemstack = this.separatorContents[i];
                this.separatorContents[i] = null;
                this.onInventoryChanged();
                return itemstack;
            }
            ItemStack itemstack1 = this.separatorContents[i].splitStack(j);
            if (this.separatorContents[i].stackSize == 0) {
                this.separatorContents[i] = null;
            }
            this.onInventoryChanged();
            return itemstack1;
        }
        return null;
    }

    @Override
    public void setInventorySlotContents(int i, ItemStack itemstack) {
        this.separatorContents[i] = itemstack;
        if (itemstack != null && itemstack.stackSize > this.getInventoryStackLimit()) {
            itemstack.stackSize = this.getInventoryStackLimit();
        }
        this.onInventoryChanged();
    }

    @Override
    public String getInvName() {
        return "Item Separator";
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        NBTTagList nbttaglist = nbttagcompound.getTagList("Items");
        this.separatorContents = new ItemStack[this.getSizeInventory()];
        for (int i = 0; i < nbttaglist.tagCount(); ++i) {
            NBTTagCompound nbttagcompound1 = (NBTTagCompound)nbttaglist.tagAt(i);
            int j = nbttagcompound1.getByte("Slot") & 0xFF;
            if (j < 0 || j >= this.separatorContents.length) continue;
            this.separatorContents[j] = ItemStack.loadItemStackFromNBT(nbttagcompound1);
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.separatorContents.length; ++i) {
            if (this.separatorContents[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.setByte("Slot", (byte)i);
            this.separatorContents[i].writeToNBT(nbttagcompound1);
            nbttaglist.appendTag(nbttagcompound1);
        }
        nbttagcompound.setTag("Items", nbttaglist);
    }

    @Override
    public int getInventoryStackLimit() {
        return 64;
    }

    public boolean canInteractWith(EntityPlayer entityplayer) {
        if (this.worldObj.getBlockTileEntity(this.xCoord, this.yCoord, this.zCoord) != this) {
            return false;
        }
        return entityplayer.getDistanceSq((double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5) <= 64.0;
    }

    @Override
    public boolean isUseableByPlayer(EntityPlayer entityplayer) {
        return true;
    }

    @Override
    public ItemStack getStackInSlotOnClosing(int par1) {
        if (this.separatorContents[par1] != null) {
            ItemStack itemstack = this.separatorContents[par1];
            this.separatorContents[par1] = null;
            return itemstack;
        }
        return null;
    }
}

