/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Hashtable;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.src.Entity;
import net.minecraft.src.ModLoader;
import net.minecraft.src.PC_CoordI;
import net.minecraft.src.PCtr_BlockConveyor;
import net.minecraft.src.World;
import net.minecraft.src.mod_PCtransport;

public class PCtr_TeleporterManagerUNUSED {
    private static Minecraft mc = ModLoader.getMinecraftInstance();
    private static Hashtable<PC_CoordI, String> targets = new Hashtable();
    private static World world = null;

    private static void checkWorldChange() {
        if (PCtr_TeleporterManagerUNUSED.mc.theWorld != world) {
            targets.clear();
            world = PCtr_TeleporterManagerUNUSED.mc.theWorld;
        }
    }

    public static void registerTarget(PC_CoordI pos, String name) {
        PCtr_TeleporterManagerUNUSED.checkWorldChange();
        targets.put(pos, name);
    }

    public static void unregisterTarget(PC_CoordI pos) {
        PCtr_TeleporterManagerUNUSED.checkWorldChange();
        targets.remove(pos);
    }

    private static PC_CoordI getTargetCoord(String name) {
        PCtr_TeleporterManagerUNUSED.checkWorldChange();
        for (Map.Entry<PC_CoordI, String> a : targets.entrySet()) {
            if (!a.getValue().equals(name)) continue;
            return a.getKey();
        }
        return null;
    }

    public static boolean targetExists(String name) {
        PCtr_TeleporterManagerUNUSED.checkWorldChange();
        return targets.contains(name);
    }

    public static boolean targetExistsExcept(String name, PC_CoordI coord) {
        PCtr_TeleporterManagerUNUSED.checkWorldChange();
        if (name.equals("")) {
            return false;
        }
        for (Map.Entry<PC_CoordI, String> a : targets.entrySet()) {
            if (!a.getValue().equals(name) || a.getKey().equals(coord)) continue;
            return true;
        }
        return false;
    }

    private static final boolean isTeleporter(int id) {
        return id == mod_PCtransport.teleporter.blockID;
    }

    public static boolean teleportEntityTo(Entity entity, String target) {
        PC_CoordI tc = PCtr_TeleporterManagerUNUSED.getTargetCoord(target);
        if (tc == null) {
            return false;
        }
        World world = entity.worldObj;
        if (world.getBlockId(tc.x, tc.y, tc.z) != mod_PCtransport.teleporter.blockID) {
            return false;
        }
        int[] good = new int[]{0, 0, 0, 0};
        PC_CoordI[] coords = new PC_CoordI[]{new PC_CoordI(0, 0, -1), new PC_CoordI(1, 0, 0), new PC_CoordI(0, 0, 1), new PC_CoordI(-1, 0, 0)};
        for (int i = 0; i < 4; ++i) {
            int x = tc.x + coords[i].x;
            int y = tc.y + coords[i].y;
            int z = tc.z + coords[i].z;
            if (PCtr_BlockConveyor.isConveyorAt(world, x, y, z)) {
                int meta = world.getBlockMetadata(x, y, z);
                int rotation = PCtr_BlockConveyor.getRotation_(meta);
                if (rotation == i) {
                    good[i] = 3;
                    continue;
                }
                if (rotation == (i + 2) % 4) continue;
                good[i] = 2;
                continue;
            }
            if (PCtr_BlockConveyor.isBlocked(world, x, y, z)) continue;
            good[i] = 1;
        }
        if (good[0] + good[1] + good[2] + good[3] > 0) {
            for (int need = 3; need > 0; --need) {
                for (int i = 0; i < 4; ++i) {
                    if (good[i] < need) continue;
                    entity.prevPosX = entity.lastTickPosX = (double)((float)tc.x + 0.5f) + (double)coords[i].x * 0.7;
                    entity.posX = entity.lastTickPosX;
                    entity.prevPosY = entity.lastTickPosY = (double)((float)tc.y + entity.yOffset + 0.25f);
                    entity.posY = entity.lastTickPosY;
                    entity.prevPosZ = entity.lastTickPosZ = (double)((float)tc.z + 0.5f) + (double)coords[i].z * 0.7;
                    entity.posZ = entity.lastTickPosZ;
                    entity.setPosition(entity.posX, entity.posY, entity.posZ);
                    entity.motionX = (float)coords[i].x * 0.2f;
                    entity.motionZ = (float)coords[i].z * 0.2f;
                    entity.rotationYaw = (float)i * 90.0f + 180.0f;
                    entity.fallDistance = 0.0f;
                    entity.distanceWalkedModified = 0.0f;
                    return true;
                }
            }
            return false;
        }
        return false;
    }
}

