/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.io.File;
import java.util.Hashtable;
import net.minecraft.client.Minecraft;
import net.minecraft.src.Entity;
import net.minecraft.src.ModLoader;
import net.minecraft.src.PC_BlockUtils;
import net.minecraft.src.PC_CoordI;
import net.minecraft.src.PC_Logger;
import net.minecraft.src.PCtr_BlockConveyor;
import net.minecraft.src.PCtr_TeleporterEntry;
import net.minecraft.src.PCtr_TileEntityTeleporter;
import net.minecraft.src.World;
import net.minecraft.src.mod_PCtransport;

public class PCtr_TeleporterHelper {
    public static Minecraft mc = ModLoader.getMinecraftInstance();
    private static Hashtable<String, PCtr_TeleporterEntry> targets = new Hashtable();
    private static boolean listsLoaded = false;
    private static World listsWorld = null;
    private static String listSaveDir = null;

    private static void loadAllLists() {
        listsWorld = PCtr_TeleporterHelper.mc.theWorld;
        listSaveDir = PCtr_TeleporterEntry.getSaveDir(PCtr_TeleporterHelper.mc.theWorld);
        listsLoaded = true;
        PCtr_TeleporterHelper.loadDevices();
    }

    private static void loadIfNeeded() {
        if (listsWorld == null || listSaveDir == null || !listsLoaded || listsWorld != PCtr_TeleporterHelper.mc.theWorld || !listSaveDir.equals(PCtr_TeleporterEntry.getSaveDir(PCtr_TeleporterHelper.mc.theWorld))) {
            PC_Logger.fine("Loading teleporter list...");
            targets.clear();
            PCtr_TeleporterHelper.loadAllLists();
        }
    }

    private static void loadDevices() {
        String dirPath = PCtr_TeleporterEntry.getSaveDir(PCtr_TeleporterHelper.mc.theWorld);
        File dir = new File(dirPath);
        String[] children = dir.list();
        if (children == null) {
            return;
        }
        for (String filename : children) {
            PCtr_TeleporterHelper.loadSingleDevice(dirPath + filename);
        }
    }

    private static void loadSingleDevice(String filePath) {
        PCtr_TeleporterEntry entry = new PCtr_TeleporterEntry(filePath);
        PC_CoordI coord = entry.getCoord();
        if (!PCtr_TeleporterHelper.isTeleporter(PCtr_TeleporterHelper.mc.theWorld.getBlockId(coord.x, coord.y, coord.z))) {
            entry.dimension = PCtr_TeleporterHelper.mc.thePlayer.dimension == 0 ? -1 : 0;
        }
        targets.put(new String(entry.getIdentifier()), entry);
        for (PCtr_TeleporterEntry e : targets.values()) {
            e.save();
        }
    }

    private static PC_CoordI getTargetCoord(String identifier) {
        PCtr_TeleporterHelper.loadIfNeeded();
        PCtr_TeleporterEntry e = targets.get(identifier);
        if (e == null) {
            return null;
        }
        return e.getCoord();
    }

    public static boolean targetExists(String identifier) {
        PCtr_TeleporterHelper.loadIfNeeded();
        if (identifier.equals("")) {
            return false;
        }
        return targets.get(identifier) != null;
    }

    public static boolean targetExistsExcept(String identifier, PC_CoordI coord) {
        PCtr_TeleporterHelper.loadIfNeeded();
        if (identifier.equals("")) {
            return false;
        }
        PCtr_TeleporterEntry entry = targets.get(identifier);
        return entry != null && !entry.getCoord().equals(coord);
    }

    public static boolean isTargetInThisDimension(String identifier) {
        PCtr_TeleporterHelper.loadIfNeeded();
        return PCtr_TeleporterHelper.mc.thePlayer.dimension == PCtr_TeleporterHelper.getTargetDimension(identifier);
    }

    public static int getTargetDimension(String identifier) {
        PCtr_TeleporterHelper.loadIfNeeded();
        if (identifier.equals("")) {
            return 0;
        }
        PCtr_TeleporterEntry entry = targets.get(identifier);
        if (entry == null) {
            return 0;
        }
        return entry.getDimension();
    }

    public static void registerNewDevice(int i, int j, int k, String identifier) {
        PCtr_TeleporterHelper.loadIfNeeded();
        int dim = PCtr_TeleporterHelper.mc.thePlayer.dimension;
        PCtr_TeleporterEntry newDev = new PCtr_TeleporterEntry(i, j, k, identifier, dim);
        newDev.save();
        targets.put(identifier, newDev);
    }

    public static boolean renameDevice(String id1, String id2) {
        PCtr_TeleporterHelper.loadIfNeeded();
        if (!PCtr_TeleporterHelper.targetExists(id1) || PCtr_TeleporterHelper.targetExists(id2)) {
            return false;
        }
        PCtr_TeleporterEntry dev = targets.get(id1);
        if (dev == null) {
            return false;
        }
        dev.removeFile();
        dev.setIdentifier(id2);
        dev.save();
        targets.put(id2, dev.copy());
        targets.remove(id1);
        return true;
    }

    public static void unregisterDevice(String identifier) {
        PCtr_TeleporterHelper.loadIfNeeded();
        PCtr_TeleporterEntry dev = targets.get(identifier);
        if (dev == null) {
            return;
        }
        dev.removeFile();
        targets.remove(identifier);
    }

    private static final boolean isTeleporter(int id) {
        return id == mod_PCtransport.teleporter.blockID;
    }

    public static boolean teleportEntityTo(Entity entity, String target) {
        PC_CoordI tc = PCtr_TeleporterHelper.getTargetCoord(target);
        if (tc == null) {
            return false;
        }
        World world = entity.worldObj;
        if (world.getBlockId(tc.x, tc.y, tc.z) != mod_PCtransport.teleporter.blockID) {
            return false;
        }
        PCtr_TileEntityTeleporter tet = (PCtr_TileEntityTeleporter)tc.getTileEntity(world);
        if (tet == null) {
            return false;
        }
        int[] good = new int[]{0, 0, 0, 0};
        PC_CoordI[] coords = new PC_CoordI[]{new PC_CoordI(0, 0, -1), new PC_CoordI(1, 0, 0), new PC_CoordI(0, 0, 1), new PC_CoordI(-1, 0, 0)};
        String[] side = new String[]{"N", "E", "S", "W"};
        for (int i = 0; i < 4; ++i) {
            PC_CoordI tmp = tc.offset(coords[i]);
            if (PC_BlockUtils.hasFlag(world, tmp, "BELT") && !PC_BlockUtils.hasFlag(world, tmp, "TELEPORTER")) {
                int meta = tmp.getMeta(world);
                int rotation = PCtr_BlockConveyor.getRotation_(meta);
                if (rotation == i) {
                    good[i] = 3;
                } else if (rotation != (i + 2) % 4) {
                    good[i] = 2;
                }
            } else if (!PCtr_BlockConveyor.isBlocked(world, tmp.x, tmp.y, tmp.z)) {
                good[i] = 1;
            }
            if (tet.direction.equals(side[i])) {
                int n = i;
                good[n] = good[n] + 1;
            }
            if (!PC_BlockUtils.hasFlag(world, tmp, "TELEPORTER")) continue;
            good[i] = 0;
        }
        if (good[0] + good[1] + good[2] + good[3] > 0) {
            for (int need = 6; need > 0; --need) {
                for (int i = 0; i < 4; ++i) {
                    if (good[i] < need) continue;
                    entity.prevPosX = entity.lastTickPosX = (double)((float)tc.x + 0.5f) + (double)coords[i].x * 0.7;
                    entity.posX = entity.lastTickPosX;
                    entity.prevPosY = entity.lastTickPosY = (double)((float)tc.y + entity.yOffset + 0.2f);
                    entity.posY = entity.lastTickPosY;
                    entity.prevPosZ = entity.lastTickPosZ = (double)((float)tc.z + 0.5f) + (double)coords[i].z * 0.7;
                    entity.posZ = entity.lastTickPosZ;
                    entity.setPosition(entity.posX, entity.posY, entity.posZ);
                    entity.motionX = (float)coords[i].x * 0.2f;
                    entity.motionZ = (float)coords[i].z * 0.2f;
                    entity.rotationYaw = (float)i * 90.0f + 180.0f;
                    entity.fallDistance = 0.0f;
                    entity.distanceWalkedModified = 0.0f;
                    return true;
                }
            }
            return false;
        }
        return false;
    }
}

