/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import net.minecraft.client.Minecraft;
import net.minecraft.src.ModLoader;
import net.minecraft.src.PC_CoordI;
import net.minecraft.src.PC_Logger;
import net.minecraft.src.SaveHandler;
import net.minecraft.src.World;

public class PCtr_TeleporterEntry {
    private static Minecraft mc = ModLoader.getMinecraftInstance();
    public int i = 0;
    public int j = 0;
    public int k = 0;
    public String identifier;
    public int dimension = 0;

    public PCtr_TeleporterEntry(int pi, int pj, int pk) {
        this.setPos(pi, pj, pk);
    }

    public PCtr_TeleporterEntry(int pi, int pj, int pk, String id) {
        this.setPos(pi, pj, pk);
        this.setIdentifier(id);
        this.setDimension(PCtr_TeleporterEntry.mc.theWorld.worldInfo.getDimension());
    }

    public PCtr_TeleporterEntry(int pi, int pj, int pk, String id, int dim) {
        this.setPos(pi, pj, pk);
        this.setIdentifier(id);
        this.setDimension(dim);
    }

    public PCtr_TeleporterEntry(String file) {
        this.load(file);
    }

    public PCtr_TeleporterEntry copy() {
        return new PCtr_TeleporterEntry(this.i, this.j, this.k, this.identifier);
    }

    public void load(String file) {
        Properties props = new Properties();
        try {
            props.load(new FileInputStream(file));
        }
        catch (IOException e) {
            return;
        }
        try {
            this.setPos(Integer.valueOf(props.getProperty("x")), Integer.valueOf(props.getProperty("y")), Integer.valueOf(props.getProperty("z")));
            this.setIdentifier(props.getProperty("id"));
            this.setDimension(props.getProperty("dim"));
        }
        catch (NumberFormatException nfe) {
            return;
        }
    }

    public void removeFile() {
        PC_Logger.finest("Deleting teleporter's file.");
        File f = new File(this.getSavePath(PCtr_TeleporterEntry.mc.theWorld));
        if (!f.exists()) {
            PC_Logger.warning("file does not exist");
            return;
        }
        if (!f.canWrite()) {
            PC_Logger.warning("file not accessible");
            return;
        }
        if (f.isDirectory()) {
            PC_Logger.warning("file is dir");
            return;
        }
        f.delete();
    }

    public void save() {
        new File(PCtr_TeleporterEntry.getSaveDir(PCtr_TeleporterEntry.mc.theWorld)).mkdirs();
        Properties props = new Properties();
        props.setProperty("x", Integer.toString(this.i));
        props.setProperty("y", Integer.toString(this.j));
        props.setProperty("z", Integer.toString(this.k));
        props.setProperty("id", this.identifier);
        props.setProperty("dim", Integer.toString(this.dimension));
        try {
            props.store(new FileOutputStream(this.getSavePath(PCtr_TeleporterEntry.mc.theWorld)), "Teleporter save file - do not touch!");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public PC_CoordI getCoord() {
        return new PC_CoordI(this.i, this.j, this.k);
    }

    public static String getSaveDir(World world) {
        if (mc == null || world == null) {
            return null;
        }
        return ((SaveHandler)world.saveHandler).getSaveDirectory().toString().concat("/teleporter/");
    }

    private String getSavePath(World world) {
        if (mc == null || world == null) {
            return null;
        }
        return ((SaveHandler)world.saveHandler).getSaveDirectory().toString().concat("/teleporter/").concat(this.getIdentifier()).concat(".dat");
    }

    public int getDimension() {
        return this.dimension;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public int getI() {
        return this.i;
    }

    public int getJ() {
        return this.j;
    }

    public int getK() {
        return this.k;
    }

    public int getX() {
        return this.i;
    }

    public int getY() {
        return this.j;
    }

    public int getZ() {
        return this.k;
    }

    private void setDimension(int dim) {
        this.dimension = dim;
    }

    private void setDimension(String property) {
        int dim;
        if (property == null) {
            this.dimension = 0;
            return;
        }
        try {
            dim = Integer.parseInt(property);
        }
        catch (NumberFormatException e) {
            dim = 0;
        }
        this.dimension = dim;
    }

    public void setIdentifier(String id) {
        this.identifier = id;
    }

    public void setPos(int i, int j, int k) {
        this.i = i;
        this.j = j;
        this.k = k;
    }
}

