/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.Block;
import net.minecraft.src.BlockContainer;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityDiggingFX;
import net.minecraft.src.EntityFishHook;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.EntityPainting;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.ItemBlock;
import net.minecraft.src.ItemStack;
import net.minecraft.src.Material;
import net.minecraft.src.PC_CoordI;
import net.minecraft.src.PC_IBlockType;
import net.minecraft.src.PC_Utils;
import net.minecraft.src.PCtr_GuiTeleporter;
import net.minecraft.src.PCtr_GuiTeleporterDecide;
import net.minecraft.src.PCtr_Renderer;
import net.minecraft.src.PCtr_TeleporterHelper;
import net.minecraft.src.PCtr_TileEntityTeleporter;
import net.minecraft.src.TileEntity;
import net.minecraft.src.World;
import net.minecraft.src.mod_PCcore;

public class PCtr_BlockTeleporter
extends BlockContainer
implements PC_IBlockType {
    public PCtr_BlockTeleporter(int id, int tindex, Material material) {
        super(id, tindex, material);
        this.setBlockBounds(0.125f, 0.0f, 0.125f, 0.875f, 0.875f, 0.875f);
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int i, int j, int k) {
        return AxisAlignedBB.getBoundingBoxFromPool(i, j, k, i + 1, (double)j + 0.03125, k + 1);
    }

    @Override
    public AxisAlignedBB getSelectedBoundingBoxFromPool(World world, int i, int j, int k) {
        return AxisAlignedBB.getBoundingBoxFromPool((double)i + 0.125, j, (double)k + 0.125, (double)i + 1.0 - 0.125, (double)j + 1.0, (double)k + 1.0 - 0.125);
    }

    @Override
    public int getRenderType() {
        return PCtr_Renderer.teleporterRenderer;
    }

    @Override
    public boolean blockActivated(World world, int i, int j, int k, EntityPlayer entityplayer) {
        Block bhold;
        ItemStack ihold = entityplayer.getCurrentEquippedItem();
        if (ihold != null && ihold.getItem() instanceof ItemBlock && ihold.getItem().shiftedIndex != this.blockID && (bhold = Block.blocksList[ihold.getItem().shiftedIndex]) instanceof PC_IBlockType) {
            return false;
        }
        PCtr_TileEntityTeleporter te = (PCtr_TileEntityTeleporter)world.getBlockTileEntity(i, j, k);
        PC_Utils.openGres(entityplayer, new PCtr_GuiTeleporter(te));
        return true;
    }

    @Override
    public void onBlockPlacedBy(World world, int i, int j, int k, EntityLiving entityliving) {
        super.onBlockPlacedBy(world, i, j, k, entityliving);
        if (entityliving instanceof EntityPlayer) {
            PCtr_TileEntityTeleporter te = (PCtr_TileEntityTeleporter)world.getBlockTileEntity(i, j, k);
            if (te == null) {
                return;
            }
            PC_Utils.openGres((EntityPlayer)entityliving, new PCtr_GuiTeleporterDecide(te));
        }
    }

    @Override
    public void onBlockRemoval(World world, int i, int j, int k) {
        PCtr_TeleporterHelper.unregisterDevice(PCtr_BlockTeleporter.getTE((IBlockAccess)world, (int)i, (int)j, (int)k).identifier);
        world.setBlockAndMetadataWithNotify(i, j, k, 0, 0);
        world.notifyBlocksOfNeighborChange(i, j, k, this.blockID);
        super.onBlockRemoval(world, i, j, k);
    }

    @Override
    public TileEntity getBlockEntity() {
        return new PCtr_TileEntityTeleporter();
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public int quantityDropped(Random par1Random) {
        return 1;
    }

    @Override
    public int getRenderBlockPass() {
        return 1;
    }

    @Override
    public void onEntityCollidedWithBlock(World world, int i, int j, int k, Entity entity) {
        if (entity instanceof EntityFishHook || entity instanceof EntityPainting || entity instanceof EntityDiggingFX) {
            return;
        }
        PCtr_TileEntityTeleporter te = PCtr_BlockTeleporter.getTE(world, i, j, k);
        if (te.isSender() && te.isActive() && te.acceptsEntity(entity)) {
            PCtr_TeleporterHelper.teleportEntityTo(entity, te.target);
        }
    }

    @Override
    public void randomDisplayTick(World world, int x, int y, int z, Random random) {
        if (!PCtr_BlockTeleporter.isActive(world, x, y, z)) {
            return;
        }
        if (random.nextInt(60) == 0 && mod_PCcore.soundsEnabled) {
            world.playSoundEffect((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "portal.portal", 0.1f, random.nextFloat() * 0.4f + 0.8f);
        }
        for (int i = 0; i < 8; ++i) {
            double d = (float)x + random.nextFloat();
            double d1 = (float)y + random.nextFloat();
            double d2 = (float)z + random.nextFloat();
            double d3 = 0.0;
            double d4 = 0.0;
            double d5 = 0.0;
            d3 = -0.75f + random.nextFloat() * 1.5f;
            d4 = -0.25f + random.nextFloat() * 1.0f;
            d5 = -0.75f + random.nextFloat() * 1.5f;
            world.spawnParticle("portal", d, d1, d2, d3, d4, d5);
        }
    }

    public static PCtr_TileEntityTeleporter getTE(IBlockAccess iblockaccess, int i, int j, int k) {
        TileEntity te = iblockaccess.getBlockTileEntity(i, j, k);
        if (te == null) {
            return null;
        }
        PCtr_TileEntityTeleporter tet = (PCtr_TileEntityTeleporter)te;
        return tet;
    }

    public static boolean isActive(IBlockAccess iblockaccess, int i, int j, int k) {
        return PCtr_BlockTeleporter.getTE(iblockaccess, i, j, k).isActive();
    }

    public static boolean isTarget(IBlockAccess iblockaccess, int i, int j, int k) {
        return PCtr_BlockTeleporter.getTE(iblockaccess, i, j, k).isReceiver();
    }

    @Override
    public Set<String> getBlockFlags(World world, PC_CoordI pos) {
        HashSet<String> set = new HashSet<String>();
        set.add("NO_HARVEST");
        set.add("TRANSLUCENT");
        set.add("BELT");
        set.add("TELEPORTER");
        return set;
    }

    @Override
    public Set<String> getItemFlags(int damage) {
        HashSet<String> set = new HashSet<String>();
        set.add("NO_BUILD");
        return set;
    }
}

