/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.Block;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityFX;
import net.minecraft.src.EntityItem;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.EntityXPOrb;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.MapColor;
import net.minecraft.src.PC_CoordI;
import net.minecraft.src.PC_IBlockType;
import net.minecraft.src.PC_ISwapTerrain;
import net.minecraft.src.PC_Renderer;
import net.minecraft.src.PCtr_BlockConveyor;
import net.minecraft.src.PCtr_MaterialElevator;
import net.minecraft.src.World;
import net.minecraft.src.forge.ITextureProvider;
import net.minecraft.src.mod_PCtransport;

public class PCtr_BlockItemElevator
extends Block
implements PC_IBlockType,
PC_ISwapTerrain,
ITextureProvider {
    public static final double MAX_HORIZONTAL_SPEED = 0.16000000000000003;
    public static final double HORIZONTAL_BOOST = 0.055;
    public static final double BORDERS3 = 0.45;
    public static final double BORDERS2 = 0.25;
    public static final double BORDERS = 0.1;
    public static final double BORDER_BOOST = 0.07;

    @Override
    public String getTextureFile() {
        return this.getTerrainFile();
    }

    public PCtr_BlockItemElevator(int i, int tx) {
        super(i, tx, new PCtr_MaterialElevator(MapColor.airColor));
    }

    @Override
    protected int damageDropped(int i) {
        return i;
    }

    @Override
    public boolean shouldSideBeRendered(IBlockAccess iblockaccess, int i, int j, int k, int l) {
        return true;
    }

    @Override
    public void onEntityCollidedWithBlock(World world, int i, int j, int k, Entity entity) {
        boolean down;
        PCtr_BlockConveyor.packItems(world, i, j, k);
        boolean bl = down = world.getBlockMetadata(i, j, k) == 1;
        if (entity instanceof EntityItem) {
            ((EntityItem)entity).delayBeforeCanPickup = 10;
            if (((EntityItem)entity).age >= 5000 && world.getEntitiesWithinAABBExcludingEntity(null, AxisAlignedBB.getBoundingBoxFromPool(i, j, k, i + 1, j + 1, k + 1)).size() < 60) {
                ((EntityItem)entity).age = 4000;
            }
            if (((PCtr_BlockConveyor)mod_PCtransport.conveyorBelt).storeAllSides(world, i, j, k, (EntityItem)entity)) {
                return;
            }
        }
        if (entity instanceof EntityXPOrb && ((EntityXPOrb)entity).xpOrbAge >= 5000 && world.getEntitiesWithinAABBExcludingEntity(null, AxisAlignedBB.getBoundingBoxFromPool(i, j, k, i + 1, j + 1, k + 1)).size() < 60) {
            ((EntityXPOrb)entity).xpOrbAge = 4000;
        }
        if (entity instanceof EntityFX) {
            return;
        }
        if (!entity.isEntityAlive()) {
            return;
        }
        boolean halted = world.isBlockGettingPowered(i, j, k) || world.isBlockGettingPowered(i, j - 1, k);
        double BBOOST = entity instanceof EntityPlayer ? 0.0175 : 0.07;
        int id = world.getBlockId(i, j + (down ? -1 : 1), k);
        if (entity instanceof EntityItem || entity instanceof EntityXPOrb) {
            if (entity.motionX > 0.16000000000000003) {
                entity.motionX *= 0.2;
            }
            if (entity.motionX < -0.16000000000000003) {
                entity.motionX *= 0.2;
            }
            if (entity.motionZ > 0.16000000000000003) {
                entity.motionZ *= 0.2;
            }
            if (entity.motionZ < -0.16000000000000003) {
                entity.motionZ *= 0.2;
            }
            if (Math.abs(entity.motionY) > 0.25) {
                entity.motionY *= 0.3;
            }
        }
        entity.fallDistance = 0.0f;
        entity.updateFallState(0.0, true);
        if (halted && entity instanceof EntityPlayer) {
            if (world.isAirBlock(i + 1, j, k) && !world.isAirBlock(i + 1, j - 1, k)) {
                if (entity.motionX <= 0.16000000000000003) {
                    entity.motionX += 0.055;
                }
                if (entity.posZ > (double)k + 0.1) {
                    entity.motionZ -= BBOOST;
                }
                if (entity.posZ < (double)k + 0.9) {
                    entity.motionZ += BBOOST;
                }
            } else if (world.isAirBlock(i - 1, j, k) && !world.isAirBlock(i - 1, j - 1, k)) {
                if (entity.motionX >= -0.16000000000000003) {
                    entity.motionX -= 0.055;
                }
                if (entity.posZ > (double)k + 0.1) {
                    entity.motionZ -= BBOOST;
                }
                if (entity.posZ < (double)k + 0.9) {
                    entity.motionZ += BBOOST;
                }
            } else if (world.isAirBlock(i, j, k + 1) && !world.isAirBlock(i, j - 1, k + 1)) {
                if (entity.motionZ <= 0.16000000000000003) {
                    entity.motionZ += 0.055;
                }
                if (entity.posX > (double)i + 0.9) {
                    entity.motionX -= BBOOST;
                }
                if (entity.posX < (double)i + 0.1) {
                    entity.motionX += BBOOST;
                }
            } else if (world.isAirBlock(i, j, k - 1) && world.isAirBlock(i, j - 1, k - 1)) {
                if (entity.motionZ >= -0.16000000000000003) {
                    entity.motionZ -= 0.055;
                }
                if (entity.posX > (double)i + 0.9) {
                    entity.motionX -= BBOOST;
                }
                if (entity.posX < (double)i + 0.1) {
                    entity.motionX += BBOOST;
                }
            }
        }
        if (id != this.blockID || halted && !(entity instanceof EntityPlayer)) {
            entity.motionY = !(entity instanceof EntityPlayer) && Math.abs(entity.motionY) > 0.3 ? (entity.motionY *= 0.3) : (entity.motionY += 0.02);
            if (down && entity.posY < (double)j + 0.7 || !down && entity.posY > (double)j + 0.1) {
                if (PCtr_BlockConveyor.isConveyorAt(world, i + 1, j, k)) {
                    if (entity.motionX <= 0.16000000000000003) {
                        entity.motionX = entity.motionX + 0.055 * (down ? 1.2 : 1.0);
                    }
                    if (entity.posZ > (double)k + 0.1) {
                        entity.motionZ -= BBOOST;
                    }
                    if (entity.posZ < (double)k + 0.9) {
                        entity.motionZ += BBOOST;
                    }
                } else if (PCtr_BlockConveyor.isConveyorAt(world, i - 1, j, k)) {
                    if (entity.motionX >= -0.16000000000000003) {
                        entity.motionX = entity.motionX - 0.055 * (down ? 1.2 : 1.0);
                    }
                    if (entity.posZ > (double)k + 0.1) {
                        entity.motionZ -= BBOOST;
                    }
                    if (entity.posZ < (double)k + 0.9) {
                        entity.motionZ += BBOOST;
                    }
                } else if (PCtr_BlockConveyor.isConveyorAt(world, i, j, k + 1)) {
                    if (entity.motionZ <= 0.16000000000000003) {
                        entity.motionZ = entity.motionZ + 0.055 * (down ? 1.2 : 1.0);
                    }
                    if (entity.posX > (double)i + 0.9) {
                        entity.motionX -= BBOOST;
                    }
                    if (entity.posX < (double)i + 0.1) {
                        entity.motionX += BBOOST;
                    }
                } else if (PCtr_BlockConveyor.isConveyorAt(world, i, j, k - 1)) {
                    if (entity.motionZ >= -0.16000000000000003) {
                        entity.motionZ = entity.motionZ - 0.055 * (down ? 1.2 : 1.0);
                    }
                    if (entity.posX > (double)i + 0.9) {
                        entity.motionX -= BBOOST;
                    }
                    if (entity.posX < (double)i + 0.1) {
                        entity.motionX += BBOOST;
                    }
                }
            }
        } else {
            if (!down) {
                double d = entity.motionY;
                double d2 = halted ? 0.15 : 0.3;
                if (d < d2) {
                    entity.motionY = entity.motionY + (halted ? 0.06 : 0.1);
                }
            }
            if (entity.posZ < (double)k + 0.45) {
                entity.motionZ += BBOOST / 7.0;
            }
            if (entity.posZ > (double)k + 0.55) {
                entity.motionZ -= BBOOST / 7.0;
            }
            if (entity.posX < (double)i + 0.55) {
                entity.motionX += BBOOST / 7.0;
            }
            if (entity.posX > (double)i + 0.45) {
                entity.motionX -= BBOOST / 7.0;
            }
            if (entity.posZ < (double)k + 0.25) {
                entity.motionZ += BBOOST / 4.0;
            }
            if (entity.posZ > (double)k + 0.75) {
                entity.motionZ -= BBOOST / 4.0;
            }
            if (entity.posX < (double)i + 0.75) {
                entity.motionX += BBOOST / 4.0;
            }
            if (entity.posX > (double)i + 0.25) {
                entity.motionX -= BBOOST / 4.0;
            }
            if (entity.posZ < (double)k + 0.1) {
                entity.motionZ += BBOOST;
            }
            if (entity.posZ > (double)k + 0.9) {
                entity.motionZ -= BBOOST;
            }
            if (entity.posX < (double)i + 0.9) {
                entity.motionX += BBOOST;
            }
            if (entity.posX > (double)i + 0.1) {
                entity.motionX -= BBOOST;
            }
        }
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int i, int j, int k) {
        boolean bottom;
        boolean down = world.getBlockMetadata(i, j, k) == 1;
        boolean bl = bottom = world.getBlockId(i, j - 1, k) != this.blockID;
        if (down && bottom) {
            return mod_PCtransport.conveyorBelt.getCollisionBoundingBoxFromPool(world, i, j, k);
        }
        return null;
    }

    @Override
    public int getRenderBlockPass() {
        return 0;
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public int getRenderType() {
        return PC_Renderer.swapTerrainRenderer;
    }

    @Override
    public String getTerrainFile() {
        return mod_PCtransport.getTerrainFile();
    }

    @Override
    public int getBlockColor() {
        return 0xFFFFFF;
    }

    @Override
    public int getRenderColor(int i) {
        return i == 0 ? 0xFFFFFF : 0xFF9999;
    }

    @Override
    public int colorMultiplier(IBlockAccess world, int i, int j, int k) {
        return this.getRenderColor(world.getBlockMetadata(i, j, k));
    }

    @Override
    public Set<String> getBlockFlags(World world, PC_CoordI pos) {
        HashSet<String> set = new HashSet<String>();
        set.add("NO_HARVEST");
        set.add("TRANSLUCENT");
        set.add("LIFT");
        if (pos.getMeta(world) == 0) {
            set.add("LIFT_UP");
        } else {
            set.add("LIFT_DOWN");
        }
        return set;
    }

    @Override
    public Set<String> getItemFlags(int damage) {
        HashSet<String> set = new HashSet<String>();
        set.add("NO_BUILD");
        return set;
    }
}

