/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.Block;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityFX;
import net.minecraft.src.EntityItem;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.EntityMinecart;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.EntityXPOrb;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.IInventory;
import net.minecraft.src.InventoryLargeChest;
import net.minecraft.src.Item;
import net.minecraft.src.ItemMinecart;
import net.minecraft.src.ItemStack;
import net.minecraft.src.MathHelper;
import net.minecraft.src.ModLoader;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.PC_BlockUtils;
import net.minecraft.src.PC_CoordI;
import net.minecraft.src.PC_IBlockType;
import net.minecraft.src.PC_IRotatedBox;
import net.minecraft.src.PC_ISpecialInsertInventory;
import net.minecraft.src.PC_ISwapTerrain;
import net.minecraft.src.PC_InvUtils;
import net.minecraft.src.PC_Renderer;
import net.minecraft.src.PC_Utils;
import net.minecraft.src.PCma_TileEntityAutomaticWorkbench;
import net.minecraft.src.PCtr_EnumConv;
import net.minecraft.src.PCtr_MaterialConveyor;
import net.minecraft.src.PCtr_TileEntitySeparationBelt;
import net.minecraft.src.TileEntity;
import net.minecraft.src.TileEntityBrewingStand;
import net.minecraft.src.TileEntityChest;
import net.minecraft.src.TileEntityFurnace;
import net.minecraft.src.World;
import net.minecraft.src.forge.ITextureProvider;
import net.minecraft.src.mod_PCcore;
import net.minecraft.src.mod_PCmachines;
import net.minecraft.src.mod_PCtransport;

public class PCtr_BlockConveyor
extends Block
implements PC_IBlockType,
PC_IRotatedBox,
PC_ISwapTerrain,
ITextureProvider {
    public static final double MAX_HORIZONTAL_SPEED = 0.4;
    public static final double HORIZONTAL_BOOST = 0.11;
    public static final double BORDERS = 0.35;
    public static final double BORDER_BOOST = 0.063;
    public static final float HEIGHT_BOUNDS = 0.0625f;
    public static final float HEIGHT_COLLISION = 0.05f;
    public static final float HEIGHT_SELECTED = 0.0625f;
    public static final float HEIGHT_MIN = 0.0f;
    public PCtr_EnumConv type = PCtr_EnumConv.belt;
    public static final float STORAGE_BORDER = 0.5f;
    public static final float STORAGE_BORDER_LONG = 0.8f;
    public static final float STORAGE_BORDER_V = 0.6f;

    @Override
    public String getTextureFile() {
        return this.getTerrainFile();
    }

    @Override
    public boolean renderItemOnSide() {
        return true;
    }

    protected PCtr_BlockConveyor(int i, PCtr_EnumConv type) {
        super(i, new PCtr_MaterialConveyor());
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.0625f, 1.0f);
        this.blockIndexInTexture = 0;
        this.type = type;
        this.setStepSound(Block.soundPowderFootstep);
    }

    public boolean getIsBlockSolid(IBlockAccess iblockaccess, int i, int j, int k, int l) {
        return true;
    }

    @Override
    public int tickRate() {
        return 4;
    }

    @Override
    public boolean canProvidePower() {
        return this.type == PCtr_EnumConv.detector || this.type == PCtr_EnumConv.ejector || this.type == PCtr_EnumConv.brake;
    }

    @Override
    public boolean blockActivated(World world, int i, int j, int k, EntityPlayer entityplayer) {
        ItemStack stack = entityplayer.getCurrentEquippedItem();
        if (stack == null) {
            return false;
        }
        Item equip_item = stack.getItem();
        if (equip_item instanceof ItemMinecart) {
            if (!world.isRemote) {
                world.spawnEntityInWorld(new EntityMinecart(world, (float)i + 0.5f, (float)j + 0.5f, (float)k + 0.5f, ((ItemMinecart)equip_item).minecartType));
            }
            if (!ModLoader.getMinecraftInstance().playerController.isInCreativeMode()) {
                entityplayer.inventory.decrStackSize(entityplayer.inventory.currentItem, 1);
            }
            return true;
        }
        return false;
    }

    @Override
    public void onNeighborBlockChange(World world, int i, int j, int k, int l) {
        if (this.type == PCtr_EnumConv.ejector && l > 0) {
            world.scheduleBlockUpdate(i, j, k, this.blockID, this.tickRate());
        }
    }

    @Override
    public void onBlockPlacedBy(World world, int i, int j, int k, EntityLiving entityliving) {
        int l = MathHelper.floor_double((double)(entityliving.rotationYaw * 4.0f / 360.0f) + 2.5) & 3;
        if (PC_Utils.isPlacingReversed()) {
            l = PC_Utils.reverseSide(l);
        }
        if (l == 2) {
            l = 8;
        }
        if (l == 3) {
            l = 9;
        }
        world.setBlockMetadataWithNotify(i, j, k, l);
    }

    @Override
    public boolean isPoweringTo(IBlockAccess iblockaccess, int i, int j, int k, int l) {
        int meta = iblockaccess.getBlockMetadata(i, j, k);
        return this.isActive(meta) && this.type == PCtr_EnumConv.detector;
    }

    @Override
    public boolean isIndirectlyPoweringTo(World world, int i, int j, int k, int l) {
        return this.type == PCtr_EnumConv.detector && this.isActive(world, i, j, k) && l == 1;
    }

    @Override
    public void updateTick(World world, int i, int j, int k, Random random) {
        if (this.type == PCtr_EnumConv.ejector) {
            int meta = world.getBlockMetadata(i, j, k);
            if (world.isBlockGettingPowered(i, j, k) || world.isBlockIndirectlyGettingPowered(i, j, k) || world.isBlockGettingPowered(i, j - 1, k) || world.isBlockIndirectlyGettingPowered(i, j - 1, k)) {
                if (!this.isActive(meta)) {
                    if (!PCtr_BlockConveyor.dispenseStackFromMinecart(world, i, j, k)) {
                        PCtr_BlockConveyor.tryToDispenseItem(world, i, j, k);
                    }
                    world.setBlockMetadata(i, j, k, this.getActiveMeta(meta));
                }
            } else if (this.isActive(meta)) {
                world.setBlockMetadata(i, j, k, this.getPassiveMeta(meta));
            }
        } else if (this.type == PCtr_EnumConv.detector && this.isActive(world, i, j, k)) {
            this.setStateIfEntityInteractsWithDetector(world, i, j, k);
        }
    }

    public void setStateIfEntityInteractsWithDetector(World world, int i, int j, int k) {
        if (this.type == PCtr_EnumConv.detector) {
            int meta = world.getBlockMetadata(i, j, k);
            boolean isAlreadyActive = this.isActive(meta);
            boolean isPressed = false;
            List list = null;
            list = world.getEntitiesWithinAABBExcludingEntity(null, AxisAlignedBB.getBoundingBoxFromPool(i, j, k, i + 1, (double)j + 1.0, k + 1));
            if (list.size() > 0) {
                isPressed = true;
            }
            boolean shallNotify = false;
            if (isPressed && !isAlreadyActive) {
                world.setBlockMetadataWithNotify(i, j, k, this.getActiveMeta(meta));
                shallNotify = true;
            } else if (!isPressed && isAlreadyActive) {
                world.setBlockMetadataWithNotify(i, j, k, this.getPassiveMeta(meta));
                shallNotify = true;
            }
            if (shallNotify) {
                world.notifyBlocksOfNeighborChange(i, j, k, this.blockID);
                world.notifyBlocksOfNeighborChange(i, j - 1, k, this.blockID);
                world.notifyBlocksOfNeighborChange(i, j + 1, k, this.blockID);
                world.markBlocksDirty(i, j, k, i, j, k);
                if (mod_PCcore.soundsEnabled) {
                    world.playSoundEffect((double)i + 0.5, (double)j + 0.125, (double)k + 0.5, "random.click", 0.15f, 0.5f);
                }
            }
            if (isPressed) {
                world.scheduleBlockUpdate(i, j, k, this.blockID, this.tickRate());
            }
        }
    }

    public static final void soundEffectChest(World world, int i, int j, int k) {
        if (mod_PCcore.soundsEnabled) {
            world.playSoundEffect((double)i + 0.5, (double)j + 0.5, (double)k + 0.5, "random.pop", (world.rand.nextFloat() + 0.7f) / 5.0f, 0.5f + world.rand.nextFloat() * 0.3f);
        }
    }

    public static final void soundEffectBelt(World world, int i, int j, int k) {
        if (mod_PCcore.soundsEnabled) {
            world.playSoundEffect((double)i + 0.5, (double)j + 0.625, (double)k + 0.5, "random.wood click", (world.rand.nextFloat() + 0.2f) / 10.0f, 1.0f + (world.rand.nextFloat() - world.rand.nextFloat()) * 0.6f);
        }
    }

    public static final boolean isConveyorAt(World world, int i, int j, int k) {
        return PC_BlockUtils.hasFlag(world, new PC_CoordI(i, j, k), "BELT");
    }

    public static final boolean isElevatorAt(World world, int i, int j, int k) {
        return PC_BlockUtils.hasFlag(world, new PC_CoordI(i, j, k), "LIFT");
    }

    public static final boolean isConveyorOrElevatorAt(World world, int i, int j, int k) {
        Set<String> set = PC_BlockUtils.getBlockFlags(world, new PC_CoordI(i, j, k));
        return set.contains("BELT") || set.contains("LIFT");
    }

    public boolean isActive(World world, int i, int j, int k) {
        int meta = world.getBlockMetadata(i, j, k);
        return this.isActive(meta);
    }

    public boolean isActive(int meta) {
        return meta == this.getActiveMeta(meta);
    }

    public int getActiveMeta(int meta) {
        switch (meta) {
            case 0: {
                return 6;
            }
            case 1: {
                return 7;
            }
            case 8: {
                return 14;
            }
            case 9: {
                return 15;
            }
        }
        return meta;
    }

    public int getPassiveMeta(int meta) {
        switch (meta) {
            case 6: {
                return 0;
            }
            case 7: {
                return 1;
            }
            case 14: {
                return 8;
            }
            case 15: {
                return 9;
            }
        }
        return meta;
    }

    public static boolean dispenseFromInventoryAt(World world, int i, int j, int k, int beltx, int belty, int beltz) {
        IInventory inventory = PCtr_BlockConveyor.getInventoryAt(world, i, j, k);
        if (inventory == null) {
            return false;
        }
        if (inventory instanceof PCma_TileEntityAutomaticWorkbench) {
            return false;
        }
        return PCtr_BlockConveyor.dispenseItem(world, inventory, beltx, belty, beltz);
    }

    public static void tryToDispenseItem(World world, int i, int j, int k) {
        int rot = PCtr_BlockConveyor.getRotation_(world.getBlockMetadata(i, j, k));
        if (rot == 2 && PCtr_BlockConveyor.dispenseFromInventoryAt(world, i, j, k - 1, i, j, k)) {
            return;
        }
        if (rot == 3 && PCtr_BlockConveyor.dispenseFromInventoryAt(world, i + 1, j, k, i, j, k)) {
            return;
        }
        if (rot == 0 && PCtr_BlockConveyor.dispenseFromInventoryAt(world, i, j, k + 1, i, j, k)) {
            return;
        }
        if (rot == 1 && PCtr_BlockConveyor.dispenseFromInventoryAt(world, i - 1, j, k, i, j, k)) {
            return;
        }
        if (rot != 2 && PCtr_BlockConveyor.dispenseFromInventoryAt(world, i, j, k - 1, i, j, k)) {
            return;
        }
        if (rot != 3 && PCtr_BlockConveyor.dispenseFromInventoryAt(world, i + 1, j, k, i, j, k)) {
            return;
        }
        if (rot != 0 && PCtr_BlockConveyor.dispenseFromInventoryAt(world, i, j, k + 1, i, j, k)) {
            return;
        }
        if (rot != 4 && PCtr_BlockConveyor.dispenseFromInventoryAt(world, i - 1, j, k, i, j, k)) {
            return;
        }
    }

    public static IInventory getInventoryAt(IBlockAccess blockaccess, int i, int j, int k) {
        if (j < 0 || j > 255) {
            return null;
        }
        TileEntity tileEntity = blockaccess.getBlockTileEntity(i, j, k);
        if (tileEntity == null || !(tileEntity instanceof IInventory) || tileEntity instanceof PCtr_TileEntitySeparationBelt) {
            return null;
        }
        IInventory inventory = (IInventory)((Object)tileEntity);
        if (!(inventory instanceof TileEntityChest)) {
            return inventory;
        }
        int blockID = blockaccess.getBlockId(i, j, k);
        if (blockaccess.getBlockId(i + 1, j, k) == blockID) {
            IInventory neighbourInventory = (IInventory)((Object)blockaccess.getBlockTileEntity(i + 1, j, k));
            return new InventoryLargeChest("", inventory, neighbourInventory);
        }
        if (blockaccess.getBlockId(i - 1, j, k) == blockID) {
            IInventory neighbourInventory = (IInventory)((Object)blockaccess.getBlockTileEntity(i - 1, j, k));
            return new InventoryLargeChest("", neighbourInventory, inventory);
        }
        if (blockaccess.getBlockId(i, j, k + 1) == blockID) {
            IInventory neighbourInventory = (IInventory)((Object)blockaccess.getBlockTileEntity(i, j, k + 1));
            return new InventoryLargeChest("", inventory, neighbourInventory);
        }
        if (blockaccess.getBlockId(i, j, k - 1) == blockID) {
            IInventory neighbourInventory = (IInventory)((Object)blockaccess.getBlockTileEntity(i, j, k - 1));
            return new InventoryLargeChest("", neighbourInventory, inventory);
        }
        return inventory;
    }

    private static boolean dispenseItem(World world, IInventory inventory, int x, int y, int z) {
        if (inventory instanceof TileEntityFurnace) {
            ItemStack stack = inventory.getStackInSlot(2);
            if (stack != null && stack.stackSize > 0) {
                EntityItem item = new EntityItem(world, (double)x + 0.4 + world.rand.nextDouble() * 0.2, (double)y + 0.4 + world.rand.nextDouble() * 0.2, (double)z + world.rand.nextDouble() * 0.2, stack);
                item.motionX = 0.0;
                item.motionY = 0.0;
                item.motionZ = 0.0;
                item.delayBeforeCanPickup = 7;
                world.spawnEntityInWorld(item);
                inventory.setInventorySlotContents(2, null);
                return true;
            }
            return false;
        }
        if (inventory instanceof TileEntityBrewingStand) {
            NBTTagCompound tmpTag = new NBTTagCompound();
            ((TileEntityBrewingStand)inventory).writeToNBT(tmpTag);
            if (tmpTag.getShort("BrewTime") != 0) {
                return false;
            }
            for (int i = 0; i < 4; ++i) {
                ItemStack stack = inventory.getStackInSlot(i);
                if ((i >= 3 || stack == null || stack.stackSize <= 0 || stack.itemID != Item.potion.shiftedIndex || stack.getItemDamage() == 0) && (i != 3 || stack == null)) continue;
                EntityItem item = new EntityItem(world, (double)x + 0.4 + world.rand.nextDouble() * 0.2, (double)y + 0.4 + world.rand.nextDouble() * 0.2, (double)z + world.rand.nextDouble() * 0.2, stack);
                item.motionX = 0.0;
                item.motionY = 0.0;
                item.motionZ = 0.0;
                item.delayBeforeCanPickup = 7;
                world.spawnEntityInWorld(item);
                inventory.setInventorySlotContents(i, null);
            }
            return false;
        }
        int n = inventory.getSizeInventory();
        for (int i = 0; i < n; ++i) {
            ItemStack stack = inventory.getStackInSlot(i);
            if (stack == null || stack.stackSize <= 0) continue;
            EntityItem item = new EntityItem(world, (double)x + 0.4 + world.rand.nextDouble() * 0.2, (double)y + 0.4 + world.rand.nextDouble() * 0.2, (double)z + world.rand.nextDouble() * 0.2, stack);
            item.motionX = 0.0;
            item.motionY = 0.0;
            item.motionZ = 0.0;
            item.delayBeforeCanPickup = 7;
            world.spawnEntityInWorld(item);
            inventory.setInventorySlotContents(i, null);
            return true;
        }
        return false;
    }

    public static boolean storeEntityItemAt(World world, int i, int j, int k, EntityItem entity) {
        ItemStack stackToStore;
        IInventory inventory = PCtr_BlockConveyor.getInventoryAt(world, i, j, k);
        if (inventory != null && entity != null && entity.isEntityAlive() && (stackToStore = entity.item) != null && PCtr_BlockConveyor.storeItem(inventory, stackToStore)) {
            PCtr_BlockConveyor.soundEffectChest(world, i, j, k);
            if (stackToStore.stackSize <= 0) {
                entity.setDead();
                stackToStore.stackSize = 0;
                return true;
            }
        }
        return false;
    }

    public static boolean storeEntityItemIntoMinecart(World world, int i, int j, int k, EntityItem entity) {
        List hitList = world.getEntitiesWithinAABB(EntityMinecart.class, AxisAlignedBB.getBoundingBoxFromPool(i, j, k, i + 1, j + 1, k + 1).expand(1.0, 1.0, 1.0));
        if (hitList.size() > 0) {
            for (EntityMinecart cart : hitList) {
                ItemStack stackToStore;
                EntityMinecart inventory;
                if (cart.minecartType != 1 || (inventory = cart) == null || entity == null || !entity.isEntityAlive() || (stackToStore = entity.item) == null || !PCtr_BlockConveyor.storeItem(inventory, stackToStore)) continue;
                PCtr_BlockConveyor.soundEffectChest(world, i, j, k);
                if (stackToStore.stackSize > 0) continue;
                entity.setDead();
                stackToStore.stackSize = 0;
                return true;
            }
        }
        return false;
    }

    public static boolean dispenseStackFromMinecart(World world, int i, int j, int k) {
        List hitList = world.getEntitiesWithinAABB(EntityMinecart.class, AxisAlignedBB.getBoundingBoxFromPool(i, j, k, i + 1, j + 1, k + 1).expand(1.0, 1.0, 1.0));
        if (hitList.size() > 0) {
            for (EntityMinecart cart : hitList) {
                EntityMinecart inventory;
                if (cart.minecartType != 1 || (inventory = cart) == null || !PCtr_BlockConveyor.dispenseItem(world, inventory, i, j, k)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean checkCanStore(IInventory inventory, ItemStack stackToStore) {
        if (inventory instanceof TileEntityFurnace) {
            if (PC_Utils.isSmeltable(stackToStore)) {
                return PCtr_BlockConveyor.checkCanAddToStack(inventory.getStackInSlot(0), stackToStore);
            }
            if (PC_Utils.isFuel(stackToStore)) {
                return PCtr_BlockConveyor.checkCanAddToStack(inventory.getStackInSlot(1), stackToStore);
            }
            return false;
        }
        if (inventory instanceof PCma_TileEntityAutomaticWorkbench) {
            for (int i = 0; i < 9; ++i) {
                ItemStack destination = inventory.getStackInSlot(i);
                ItemStack recipeStackAtDestination = inventory.getStackInSlot(i + 9);
                if (recipeStackAtDestination == null || !(destination == null ? recipeStackAtDestination.itemID == stackToStore.itemID && (!recipeStackAtDestination.getHasSubtypes() || recipeStackAtDestination.getItemDamage() == stackToStore.getItemDamage()) : PCtr_BlockConveyor.checkCanAddToStack(destination, stackToStore))) continue;
                return true;
            }
            return false;
        }
        for (int i = 0; i < inventory.getSizeInventory(); ++i) {
            if (!PCtr_BlockConveyor.checkCanAddToStack(inventory.getStackInSlot(i), stackToStore)) continue;
            return true;
        }
        return false;
    }

    public static boolean checkCanStoreAt(World world, int i, int j, int k, EntityItem entity) {
        IInventory inventory = PCtr_BlockConveyor.getInventoryAt(world, i, j, k);
        if (inventory != null && entity != null && entity.isEntityAlive()) {
            ItemStack stackToStore = entity.item;
            return PCtr_BlockConveyor.checkCanStore(inventory, stackToStore);
        }
        return false;
    }

    public static boolean checkCanAddToStack(ItemStack stackTarget, ItemStack stackAdded) {
        if (stackTarget == null) {
            return true;
        }
        return stackAdded != null && stackTarget.itemID == stackAdded.itemID && stackTarget.isStackable() && stackTarget.stackSize < stackTarget.getMaxStackSize() && (!stackTarget.getHasSubtypes() || stackTarget.getItemDamage() == stackAdded.getItemDamage());
    }

    public static boolean storeItem(IInventory inventory, ItemStack stackToStore) {
        if (inventory instanceof TileEntityFurnace) {
            if (PC_Utils.isSmeltable(stackToStore)) {
                return PC_InvUtils.storeItemInSlot(inventory, stackToStore, 0);
            }
            if (PC_Utils.isFuel(stackToStore)) {
                return PC_InvUtils.storeItemInSlot(inventory, stackToStore, 1);
            }
            return false;
        }
        if (inventory instanceof TileEntityBrewingStand) {
            if (stackToStore.itemID == Item.potion.shiftedIndex) {
                if (PC_InvUtils.storeItemInSlot(inventory, stackToStore, 0)) {
                    return true;
                }
                if (PC_InvUtils.storeItemInSlot(inventory, stackToStore, 1)) {
                    return true;
                }
                return PC_InvUtils.storeItemInSlot(inventory, stackToStore, 2);
            }
            if (stackToStore.getItem().isPotionIngredient()) {
                return PC_InvUtils.storeItemInSlot(inventory, stackToStore, 3);
            }
            return false;
        }
        if (inventory instanceof PC_ISpecialInsertInventory) {
            boolean result2 = ((PC_ISpecialInsertInventory)((Object)inventory)).insertStackIntoInventory(stackToStore);
            ((PC_ISpecialInsertInventory)((Object)inventory)).onStackInserted();
            return result2;
        }
        return PC_InvUtils.addWholeItemStackToInventory(inventory, stackToStore);
    }

    private boolean isBeyondStorageBorder(World world, int i, int j, int k, Entity entity, float border) {
        switch (PCtr_BlockConveyor.getRotation_(world.getBlockMetadata(i, j, k))) {
            case 0: {
                if (!(entity.posZ > (double)((float)(k + 1) - border))) break;
                return false;
            }
            case 1: {
                if (!(entity.posX < (double)((float)i + border))) break;
                return false;
            }
            case 2: {
                if (!(entity.posZ < (double)((float)k + border))) break;
                return false;
            }
            case 3: {
                if (!(entity.posX > (double)((float)(i + 1) - border))) break;
                return false;
            }
        }
        return true;
    }

    public boolean storeNearby(World world, int i, int j, int k, EntityItem entity) {
        if (PCtr_BlockConveyor.storeEntityItemIntoMinecart(world, i, j, k, entity)) {
            return true;
        }
        if (entity.posY > (double)((float)(j + 1) - 0.6f)) {
            return false;
        }
        boolean waiting_for_front = false;
        int rot = this.getRotation(world.getBlockMetadata(i, j, k));
        if (rot == 0 && PCtr_BlockConveyor.checkCanStoreAt(world, i, j, k - 1, entity)) {
            waiting_for_front = true;
        }
        if (rot == 1 && PCtr_BlockConveyor.checkCanStoreAt(world, i + 1, j, k, entity)) {
            waiting_for_front = true;
        }
        if (rot == 2 && PCtr_BlockConveyor.checkCanStoreAt(world, i, j, k + 1, entity)) {
            waiting_for_front = true;
        }
        if (rot == 3 && PCtr_BlockConveyor.checkCanStoreAt(world, i - 1, j, k, entity)) {
            waiting_for_front = true;
        }
        if (this.isBeyondStorageBorder(world, i, j, k, entity, 0.8f) || this.isPowered(world, i, j, k) && this.type == PCtr_EnumConv.brake) {
            if (rot == 0 && PCtr_BlockConveyor.storeEntityItemAt(world, i, j, k - 1, entity)) {
                return true;
            }
            if (rot == 1 && PCtr_BlockConveyor.storeEntityItemAt(world, i + 1, j, k, entity)) {
                return true;
            }
            if (rot == 2 && PCtr_BlockConveyor.storeEntityItemAt(world, i, j, k + 1, entity)) {
                return true;
            }
            if (rot == 3 && PCtr_BlockConveyor.storeEntityItemAt(world, i - 1, j, k, entity)) {
                return true;
            }
        }
        if (!waiting_for_front && this.isBeyondStorageBorder(world, i, j, k, entity, 0.5f) || this.isPowered(world, i, j, k) && this.type == PCtr_EnumConv.brake) {
            if (rot != 0 && rot != 2 && PCtr_BlockConveyor.storeEntityItemAt(world, i, j, k - 1, entity)) {
                return true;
            }
            if (rot != 1 && rot != 3 && PCtr_BlockConveyor.storeEntityItemAt(world, i + 1, j, k, entity)) {
                return true;
            }
            if (rot != 2 && rot != 0 && PCtr_BlockConveyor.storeEntityItemAt(world, i, j, k + 1, entity)) {
                return true;
            }
            if (rot != 3 && rot != 1 && PCtr_BlockConveyor.storeEntityItemAt(world, i - 1, j, k, entity)) {
                return true;
            }
            if (PCtr_BlockConveyor.storeEntityItemAt(world, i, j + 1, k, entity)) {
                return true;
            }
            if (Block.blocksList[world.getBlockId(i, j - 1, k)] != null && world.getBlockId(i, j - 1, k) != mod_PCmachines.roaster.blockID && PCtr_BlockConveyor.storeEntityItemAt(world, i, j - 1, k, entity)) {
                return true;
            }
        }
        return false;
    }

    public boolean storeAllSides(World world, int i, int j, int k, EntityItem entity) {
        if (PCtr_BlockConveyor.storeEntityItemIntoMinecart(world, i, j, k, entity)) {
            return true;
        }
        if (PCtr_BlockConveyor.storeEntityItemAt(world, i, j, k - 1, entity)) {
            return true;
        }
        if (PCtr_BlockConveyor.storeEntityItemAt(world, i + 1, j, k, entity)) {
            return true;
        }
        if (PCtr_BlockConveyor.storeEntityItemAt(world, i, j, k + 1, entity)) {
            return true;
        }
        if (PCtr_BlockConveyor.storeEntityItemAt(world, i - 1, j, k, entity)) {
            return true;
        }
        if (PCtr_BlockConveyor.storeEntityItemAt(world, i, j + 1, k, entity)) {
            return true;
        }
        return PCtr_BlockConveyor.storeEntityItemAt(world, i, j - 1, k, entity);
    }

    private boolean try2fillCauldron(World world, int i, int j, int k) {
        if (world.getBlockId(i, j, k) == Block.cauldron.blockID && world.getBlockMetadata(i, j, k) < 3) {
            world.setBlockMetadataWithNotify(i, j, k, 3);
            return true;
        }
        return false;
    }

    public void fillCauldron(World world, int i, int j, int k, EntityItem entity) {
        if (entity == null || entity.item == null || entity.item.itemID != Item.bucketWater.shiftedIndex) {
            return;
        }
        if (!(this.try2fillCauldron(world, i, j, k - 1) || this.try2fillCauldron(world, i, j, k + 1) || this.try2fillCauldron(world, i - 1, j, k) || this.try2fillCauldron(world, i + 1, j, k) || this.try2fillCauldron(world, i, j - 1, k) || this.try2fillCauldron(world, i, j + 1, k))) {
            return;
        }
        entity.item.itemID = Item.bucketEmpty.shiftedIndex;
    }

    private boolean try2fillBucket(World world, int i, int j, int k) {
        if (world.getBlockId(i, j, k) == Block.waterStill.blockID || world.getBlockId(i, j, k) == Block.waterMoving.blockID && world.getBlockMetadata(i, j, k) == 0) {
            world.setBlockWithNotify(i, j, k, 0);
            return true;
        }
        return false;
    }

    public void fillBucket(World world, int i, int j, int k, EntityItem entity) {
        if (entity == null || entity.item == null || entity.item.itemID != Item.bucketEmpty.shiftedIndex) {
            return;
        }
        if (!(this.try2fillBucket(world, i, j - 1, k - 1) || this.try2fillBucket(world, i, j - 1, k + 1) || this.try2fillBucket(world, i - 1, j - 1, k) || this.try2fillBucket(world, i + 1, j - 1, k) || this.try2fillBucket(world, i, j, k - 1) || this.try2fillBucket(world, i, j, k + 1) || this.try2fillBucket(world, i - 1, j, k) || this.try2fillBucket(world, i + 1, j, k) || this.try2fillBucket(world, i, j - 1, k) || this.try2fillBucket(world, i, j + 1, k))) {
            return;
        }
        entity.item.itemID = Item.bucketWater.shiftedIndex;
    }

    private boolean try2fillBottle(World world, int i, int j, int k) {
        if (world.getBlockId(i, j, k) == Block.cauldron.blockID && world.getBlockMetadata(i, j, k) > 0) {
            int meta = world.getBlockMetadata(i, j, k);
            world.setBlockMetadataWithNotify(i, j, k, meta - 1);
            return true;
        }
        return false;
    }

    public void fillBottle(World world, int i, int j, int k, EntityItem entity) {
        if (entity == null || entity.item == null || entity.item.itemID != Item.glassBottle.shiftedIndex) {
            return;
        }
        if (!(this.try2fillBottle(world, i, j, k - 1) || this.try2fillBottle(world, i, j, k + 1) || this.try2fillBottle(world, i - 1, j, k) || this.try2fillBottle(world, i + 1, j, k) || this.try2fillBottle(world, i, j - 1, k) || this.try2fillBottle(world, i, j + 1, k))) {
            return;
        }
        EntityItem entity2 = new EntityItem(world, entity.posX, entity.posY, entity.posZ, new ItemStack(Item.potion.shiftedIndex, 1, 0));
        entity2.motionX = entity.motionX;
        entity2.motionY = entity.motionY;
        entity2.motionZ = entity.motionZ;
        entity2.delayBeforeCanPickup = 7;
        world.spawnEntityInWorld(entity2);
        --entity.item.stackSize;
        if (entity.item.stackSize <= 0) {
            entity.item.stackSize = 0;
            entity.setDead();
        }
    }

    public static boolean isBlocked(World world, int i, int j, int k) {
        Block block;
        boolean isWall;
        boolean bl = isWall = !world.isAirBlock(i, j, k) && !PCtr_BlockConveyor.isConveyorOrElevatorAt(world, i, j, k);
        if (isWall && (block = Block.blocksList[world.getBlockId(i, j, k)]) != null && !block.blockMaterial.blocksMovement()) {
            isWall = false;
        }
        return isWall;
    }

    @Override
    public int getRotation(int meta) {
        switch (meta) {
            case 0: 
            case 6: {
                return 0;
            }
            case 1: 
            case 7: {
                return 1;
            }
            case 8: 
            case 14: {
                return 2;
            }
            case 9: 
            case 15: {
                return 3;
            }
        }
        return 0;
    }

    public static int getRotation_(int meta) {
        switch (meta) {
            case 0: 
            case 6: {
                return 0;
            }
            case 1: 
            case 7: {
                return 1;
            }
            case 8: 
            case 14: {
                return 2;
            }
            case 9: 
            case 15: {
                return 3;
            }
        }
        return 0;
    }

    public static void packItems(World world, int i, int j, int k) {
        List items = world.getEntitiesWithinAABB(EntityItem.class, AxisAlignedBB.getBoundingBoxFromPool(i, j, k, i + 1, j + 1, k + 1));
        if (items.size() < 5) {
            return;
        }
        block0: for (EntityItem item1 : items) {
            ItemStack stackTarget;
            if (item1 == null || item1.isDead || item1.item == null) continue;
            if (item1.item.stackSize < 1) {
                item1.setDead();
                continue;
            }
            if (item1.item.isItemStackDamageable() || item1.item.isItemEnchanted() || !item1.item.isStackable() || stackTarget.stackSize == (stackTarget = item1.item).getMaxStackSize()) continue;
            for (EntityItem item2 : items) {
                if (item2.isDead) continue block0;
                ItemStack stackAdded = item2.item;
                if (item2 == item1 || !stackTarget.isItemEqual(stackAdded) || stackTarget.stackSize >= stackTarget.getMaxStackSize()) continue;
                int sizeRemain = stackTarget.getMaxStackSize() - stackTarget.stackSize;
                if (sizeRemain >= stackAdded.stackSize) {
                    stackTarget.stackSize += stackAdded.stackSize;
                    item2.setDead();
                    continue;
                }
                stackTarget.stackSize = stackTarget.getMaxStackSize();
                stackAdded.stackSize -= sizeRemain;
                continue block0;
            }
        }
    }

    private boolean isPowered(World world, int i, int j, int k) {
        return world.isBlockIndirectlyGettingPowered(i, j, k) || world.isBlockIndirectlyGettingPowered(i, j - 1, k) || world.isBlockIndirectlyGettingPowered(i, j + 1, k);
    }

    @Override
    public void onEntityCollidedWithBlock(World world, int i, int j, int k, Entity entity) {
        boolean halted;
        if (!entity.isEntityAlive()) {
            return;
        }
        if (entity instanceof EntityPlayer && ((EntityPlayer)entity).isSneaking()) {
            return;
        }
        if (entity instanceof EntityFX) {
            return;
        }
        if (entity instanceof EntityItem) {
            PCtr_BlockConveyor.packItems(world, i, j, k);
        }
        if (!this.isActive(world, i, j, k) && this.type == PCtr_EnumConv.detector) {
            this.setStateIfEntityInteractsWithDetector(world, i, j, k);
        }
        if (entity instanceof EntityItem && this.type != PCtr_EnumConv.ejector && this.type != PCtr_EnumConv.speedy) {
            this.fillCauldron(world, i, j, k, (EntityItem)entity);
            this.fillBucket(world, i, j, k, (EntityItem)entity);
            this.fillBottle(world, i, j, k, (EntityItem)entity);
            if (this.storeNearby(world, i, j, k, (EntityItem)entity)) {
                return;
            }
        }
        if (!entity.isEntityAlive()) {
            return;
        }
        boolean bl = halted = this.isPowered(world, i, j, k) && this.type == PCtr_EnumConv.brake;
        if (halted) {
            if (entity instanceof EntityMinecart && halted) {
                entity.motionX *= 0.2;
                entity.motionZ *= 0.2;
            } else {
                entity.motionX *= 0.6;
                entity.motionZ *= 0.6;
            }
        }
        if (entity instanceof EntityItem || entity instanceof EntityXPOrb) {
            entity.stepHeight = 0.25f;
            if (entity.motionX > 0.4) {
                entity.motionX *= 0.6;
            }
            if (entity.motionX < -0.4) {
                entity.motionX *= 0.6;
            }
            if (entity.motionZ > 0.4) {
                entity.motionZ *= 0.6;
            }
            if (entity.motionZ < -0.4) {
                entity.motionZ *= 0.6;
            }
            if (entity.motionY > 0.3) {
                entity.motionY *= 0.3;
            }
        }
        int meta = this.getRotation(world.getBlockMetadata(i, j, k));
        int redir = 0;
        if (this.type == PCtr_EnumConv.redirector && this.isPowered(world, i, j, k)) {
            switch (meta) {
                case 0: {
                    if (PCtr_BlockConveyor.isConveyorOrElevatorAt(world, i + 1, j, k)) {
                        redir = -1;
                        break;
                    }
                    if (!PCtr_BlockConveyor.isConveyorOrElevatorAt(world, i - 1, j, k)) break;
                    redir = 1;
                    break;
                }
                case 1: {
                    if (PCtr_BlockConveyor.isConveyorOrElevatorAt(world, i, j, k + 1)) {
                        redir = -1;
                        break;
                    }
                    if (!PCtr_BlockConveyor.isConveyorOrElevatorAt(world, i, j, k - 1)) break;
                    redir = 1;
                    break;
                }
                case 2: {
                    if (PCtr_BlockConveyor.isConveyorOrElevatorAt(world, i - 1, j, k)) {
                        redir = -1;
                        break;
                    }
                    if (!PCtr_BlockConveyor.isConveyorOrElevatorAt(world, i + 1, j, k)) break;
                    redir = 1;
                    break;
                }
                case 3: {
                    if (PCtr_BlockConveyor.isConveyorOrElevatorAt(world, i, j, k - 1)) {
                        redir = -1;
                        break;
                    }
                    if (!PCtr_BlockConveyor.isConveyorOrElevatorAt(world, i, j, k + 1)) break;
                    redir = 1;
                }
            }
        }
        if (this.type == PCtr_EnumConv.redirector && redir == 0) {
            switch (meta) {
                case 0: {
                    if (!PCtr_BlockConveyor.isConveyorOrElevatorAt(world, i + 1, j, k) || !PCtr_BlockConveyor.isConveyorOrElevatorAt(world, i - 1, j, k) || PCtr_BlockConveyor.isConveyorOrElevatorAt(world, i, j, k - 1)) break;
                    redir = 1;
                    break;
                }
                case 1: {
                    if (!PCtr_BlockConveyor.isConveyorOrElevatorAt(world, i, j, k + 1) || !PCtr_BlockConveyor.isConveyorOrElevatorAt(world, i, j, k - 1) || PCtr_BlockConveyor.isConveyorOrElevatorAt(world, i + 1, j, k)) break;
                    redir = 1;
                    break;
                }
                case 2: {
                    if (!PCtr_BlockConveyor.isConveyorOrElevatorAt(world, i - 1, j, k) || !PCtr_BlockConveyor.isConveyorOrElevatorAt(world, i + 1, j, k) || PCtr_BlockConveyor.isConveyorOrElevatorAt(world, i, j, k + 1)) break;
                    redir = 1;
                    break;
                }
                case 3: {
                    if (!PCtr_BlockConveyor.isConveyorOrElevatorAt(world, i, j, k - 1) || !PCtr_BlockConveyor.isConveyorOrElevatorAt(world, i, j, k + 1) || PCtr_BlockConveyor.isConveyorOrElevatorAt(world, i - 1, j, k)) break;
                    redir = 1;
                }
            }
        }
        int i2 = i;
        int j2 = j;
        int k2 = k;
        switch (meta) {
            case 0: {
                --k2;
                break;
            }
            case 1: {
                ++i2;
                break;
            }
            case 2: {
                ++k2;
                break;
            }
            case 3: {
                --i2;
            }
        }
        boolean leadsToNowhere = PCtr_BlockConveyor.isBlocked(world, i2, j2, k2);
        boolean bl2 = leadsToNowhere = leadsToNowhere && this.isBeyondStorageBorder(world, i, j, k, entity, 0.8f);
        if (entity instanceof EntityItem) {
            if (!halted && !leadsToNowhere) {
                ((EntityItem)entity).delayBeforeCanPickup = 7;
            }
            if (((EntityItem)entity).age >= 5000 && world.getEntitiesWithinAABBExcludingEntity(null, AxisAlignedBB.getBoundingBoxFromPool(i, j, k, i + 1, j + 1, k + 1)).size() < 40) {
                ((EntityItem)entity).age = 4000;
            }
        }
        if (entity instanceof EntityXPOrb && !leadsToNowhere && ((EntityXPOrb)entity).xpOrbAge >= 5000 && world.getEntitiesWithinAABBExcludingEntity(null, AxisAlignedBB.getBoundingBoxFromPool(i, j, k, i + 1, j + 1, k + 1)).size() < 40) {
            ((EntityXPOrb)entity).xpOrbAge = 4000;
        }
        if (!halted && !leadsToNowhere && world.rand.nextInt(35) == 0) {
            List list = world.getEntitiesWithinAABBExcludingEntity(entity, AxisAlignedBB.getBoundingBoxFromPool(i, j, k, i + 1, j + 1, k + 1));
            if (list.size() == 0) {
                PCtr_BlockConveyor.soundEffectBelt(world, i, j, k);
            } else if (world.rand.nextInt(10) == 0) {
                PCtr_BlockConveyor.soundEffectBelt(world, i, j, k);
            }
        }
        double TMP_MAX_HORIZONTAL_SPEED = 0.4;
        if (this.type == PCtr_EnumConv.brake) {
            TMP_MAX_HORIZONTAL_SPEED *= 0.6;
        }
        if (this.type == PCtr_EnumConv.speedy) {
            TMP_MAX_HORIZONTAL_SPEED *= 2.0;
        }
        double TMP_HORIZONTAL_BOOST = 0.11;
        if (this.type == PCtr_EnumConv.brake) {
            TMP_HORIZONTAL_BOOST *= 0.6;
        }
        if (this.type == PCtr_EnumConv.speedy) {
            TMP_HORIZONTAL_BOOST *= 2.0;
        }
        double TMP_BORDERS = 0.35;
        double TMP_BORDER_BOOST = 0.063;
        if (meta == 0 && redir == 0 || meta == 1 && redir == 1 || meta == 3 && redir == -1) {
            if (entity.motionZ >= -TMP_MAX_HORIZONTAL_SPEED && !halted && !leadsToNowhere) {
                entity.motionZ -= TMP_HORIZONTAL_BOOST;
            }
            if (entity.posX > (double)i + (1.0 - TMP_BORDERS)) {
                entity.motionX -= TMP_BORDER_BOOST;
            }
            if (entity.posX < (double)i + TMP_BORDERS) {
                entity.motionX += TMP_BORDER_BOOST;
            }
            return;
        }
        if (meta == 1 && redir == 0 || meta == 0 && redir == -1 || meta == 2 && redir == 1) {
            if (entity.motionX <= TMP_MAX_HORIZONTAL_SPEED && !halted && !leadsToNowhere) {
                entity.motionX += TMP_HORIZONTAL_BOOST;
            }
            if (entity.posZ > (double)k + TMP_BORDERS) {
                entity.motionZ -= TMP_BORDER_BOOST;
            }
            if (entity.posZ < (double)k + (1.0 - TMP_BORDERS)) {
                entity.motionZ += TMP_BORDER_BOOST;
            }
            return;
        }
        if (meta == 2 && redir == 0 || meta == 1 && redir == -1 || meta == 3 && redir == 1) {
            if (entity.motionZ <= TMP_MAX_HORIZONTAL_SPEED && !halted && !leadsToNowhere) {
                entity.motionZ += TMP_HORIZONTAL_BOOST;
            }
            if (entity.posX > (double)i + (1.0 - TMP_BORDERS)) {
                entity.motionX -= TMP_BORDER_BOOST;
            }
            if (entity.posX < (double)i + TMP_BORDERS) {
                entity.motionX += TMP_BORDER_BOOST;
            }
            return;
        }
        if (meta == 3 && redir == 0 || meta == 0 && redir == 1 || meta == 2 && redir == -1) {
            if (entity.motionX >= -TMP_MAX_HORIZONTAL_SPEED && !halted && !leadsToNowhere) {
                entity.motionX -= TMP_HORIZONTAL_BOOST;
            }
            if (entity.posZ > (double)k + TMP_BORDERS) {
                entity.motionZ -= TMP_BORDER_BOOST;
            }
            if (entity.posZ < (double)k + (1.0 - TMP_BORDERS)) {
                entity.motionZ += TMP_BORDER_BOOST;
            }
            return;
        }
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int i, int j, int k) {
        return AxisAlignedBB.getBoundingBoxFromPool(i, 0.0f + (float)j, k, i + 1, (float)j + 0.05f + 0.0f, k + 1);
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public AxisAlignedBB getSelectedBoundingBoxFromPool(World world, int i, int j, int k) {
        float f = 0.0f;
        f = 0.0625f;
        return AxisAlignedBB.getBoundingBoxFromPool(i, 0.0f + (float)j, k, i + 1, (float)j + f, (float)k + 1.0f);
    }

    @Override
    public void setBlockBoundsBasedOnState(IBlockAccess iblockaccess, int i, int j, int k) {
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.0625f, 1.0f);
    }

    @Override
    public void setBlockBoundsForItemRender() {
        this.setBlockBounds(0.0f, 0.5f, 0.0f, 1.0f, 0.6f, 1.0f);
    }

    @Override
    public int getBlockTextureFromSideAndMetadata(int i, int j) {
        if (i == 0) {
            return 1;
        }
        if (i == 1) {
            return this.getIndexTop(j);
        }
        return 2;
    }

    public int getIndexTop(int meta) {
        if (this.type == PCtr_EnumConv.belt) {
            return 0;
        }
        if (this.type == PCtr_EnumConv.speedy) {
            return 4;
        }
        if (this.type == PCtr_EnumConv.ejector) {
            return 3;
        }
        if (this.type == PCtr_EnumConv.detector) {
            return 6;
        }
        if (this.type == PCtr_EnumConv.brake) {
            return 5;
        }
        if (this.type == PCtr_EnumConv.redirector) {
            return 8;
        }
        return 0;
    }

    @Override
    public boolean shouldSideBeRendered(IBlockAccess iblockaccess, int i, int j, int k, int l) {
        return l != 1;
    }

    @Override
    public int getBlockTexture(IBlockAccess iblockaccess, int i, int j, int k, int l) {
        return this.getBlockTextureFromSideAndMetadata(l, iblockaccess.getBlockMetadata(i, j, k));
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public int getRenderType() {
        return PC_Renderer.rotatedBoxRenderer;
    }

    @Override
    public String getTerrainFile() {
        return mod_PCtransport.getTerrainFile();
    }

    @Override
    public int quantityDropped(Random random) {
        return 1;
    }

    @Override
    public int getMobilityFlag() {
        return 0;
    }

    @Override
    public Set<String> getBlockFlags(World world, PC_CoordI pos) {
        HashSet<String> set = new HashSet<String>();
        set.add("NO_HARVEST");
        set.add("TRANSLUCENT");
        set.add("BELT");
        switch (this.type) {
            case belt: {
                set.add("BELT_NORMAL");
                break;
            }
            case speedy: {
                set.add("BELT_SPEEDY");
                break;
            }
            case ejector: {
                set.add("BELT_BRAKE");
                set.add("REDSTONE");
                break;
            }
            case detector: {
                set.add("BELT_DETECTOR");
                set.add("REDSTONE");
                break;
            }
            case redirector: {
                set.add("BELT_REDIRECTOR");
                set.add("REDSTONE");
            }
        }
        return set;
    }

    @Override
    public Set<String> getItemFlags(int damage) {
        HashSet<String> set = new HashSet<String>();
        set.add("NO_BUILD");
        return set;
    }
}

