/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.TileEntity;

public class PCma_TileEntityOptical
extends TileEntity {
    public String type = "MIRROR";
    private boolean[] prismSides = new boolean[]{false, false, false, false, false, false, false, false, false, false};
    private int mirrorColor = -1;

    public void setPrism() {
        this.type = "PRISM";
    }

    public void setMirror() {
        this.type = "MIRROR";
    }

    public boolean isPrism() {
        return this.type.equals("PRISM");
    }

    public boolean isMirror() {
        return this.type.equals("MIRROR");
    }

    public boolean getPrismSide(int i) {
        if (i < 0 || i > 9) {
            return false;
        }
        return this.prismSides[i];
    }

    public void setPrismSide(int i, boolean state) {
        if (i < 0 || i > 9) {
            return;
        }
        this.prismSides[i] = state;
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.setString("opttype", this.type);
        tag.setInteger("optMirrorColor", 1 + this.mirrorColor);
        tag.setBoolean("prismSide0", this.prismSides[0]);
        tag.setBoolean("prismSide1", this.prismSides[1]);
        tag.setBoolean("prismSide2", this.prismSides[2]);
        tag.setBoolean("prismSide3", this.prismSides[3]);
        tag.setBoolean("prismSide4", this.prismSides[4]);
        tag.setBoolean("prismSide5", this.prismSides[5]);
        tag.setBoolean("prismSide6", this.prismSides[6]);
        tag.setBoolean("prismSide7", this.prismSides[7]);
        tag.setBoolean("prismSide8", this.prismSides[8]);
        tag.setBoolean("prismSide9", this.prismSides[9]);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.type = tag.getString("opttype");
        this.prismSides[0] = tag.getBoolean("prismSide0");
        this.prismSides[1] = tag.getBoolean("prismSide1");
        this.prismSides[2] = tag.getBoolean("prismSide2");
        this.prismSides[3] = tag.getBoolean("prismSide3");
        this.prismSides[4] = tag.getBoolean("prismSide4");
        this.prismSides[5] = tag.getBoolean("prismSide5");
        this.prismSides[6] = tag.getBoolean("prismSide6");
        this.prismSides[7] = tag.getBoolean("prismSide7");
        this.prismSides[8] = tag.getBoolean("prismSide8");
        this.prismSides[9] = tag.getBoolean("prismSide9");
        this.mirrorColor = tag.getInteger("optMirrorColor") - 1;
    }

    public boolean canUpdate() {
        return false;
    }

    public void setMirrorColor(int crystalMeta) {
        this.mirrorColor = crystalMeta;
    }

    public int getMirrorColor() {
        return this.mirrorColor;
    }
}

