/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.Block;
import net.minecraft.src.BlockPane;
import net.minecraft.src.DamageSource;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityArrow;
import net.minecraft.src.EntityEnderEye;
import net.minecraft.src.EntityEnderPearl;
import net.minecraft.src.EntityFX;
import net.minecraft.src.EntityFishHook;
import net.minecraft.src.EntityItem;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.EntityPainting;
import net.minecraft.src.EntityPlayerSP;
import net.minecraft.src.EntityWeatherEffect;
import net.minecraft.src.EntityXPOrb;
import net.minecraft.src.Facing;
import net.minecraft.src.Material;
import net.minecraft.src.MathHelper;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.PC_BlockUtils;
import net.minecraft.src.PC_Color;
import net.minecraft.src.PC_CoordI;
import net.minecraft.src.PC_FakePlayer;
import net.minecraft.src.PC_IBeamHandler;
import net.minecraft.src.PC_InvUtils;
import net.minecraft.src.PCma_BeamTracer;
import net.minecraft.src.PCma_BlockRoaster;
import net.minecraft.src.TileEntity;
import net.minecraft.src.World;
import net.minecraft.src.mod_PCmachines;

public class PCma_TileEntityLaser
extends TileEntity
implements PC_IBeamHandler {
    private PCma_BeamTracer beamTracer;
    public boolean active = false;
    private boolean loadedLegacyLaser = false;
    private boolean hitObjectThisShot = false;
    private int type;
    public int receiverCooldownTimer = 0;

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.active = nbttagcompound.getBoolean("on");
        this.type = nbttagcompound.getInteger("ltype");
        this.receiverCooldownTimer = nbttagcompound.getInteger("lrecflag");
        if (this.type == 0) {
            this.loadedLegacyLaser = true;
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.setBoolean("on", this.active);
        nbttagcompound.setInteger("ltype", this.type);
        nbttagcompound.setInteger("lrecflag", this.receiverCooldownTimer);
    }

    public boolean canUpdate() {
        return true;
    }

    @Override
    public void updateEntity() {
        if (this.beamTracer == null) {
            int l = this.getDirection();
            PC_CoordI move = new PC_CoordI(Facing.offsetsXForSide[l], 0, Facing.offsetsZForSide[l]);
            PC_CoordI cnt = new PC_CoordI(this.xCoord, this.yCoord, this.zCoord);
            this.beamTracer = new PCma_BeamTracer(this.worldObj, this);
            this.beamTracer.setStartCoord(cnt);
            this.beamTracer.setStartMove(move);
            this.beamTracer.setCanChangeColor(true);
            this.beamTracer.setReflectedByMirror(true);
            this.beamTracer.setReflectedByPrism(true);
            this.beamTracer.setTotalLengthLimit(10000);
            this.beamTracer.setMaxLengthAfterCrystal(8000);
            this.beamTracer.setStartLength(180);
            this.beamTracer.setCrystalAddedLength(100);
        }
        if (this.type == 0 && this.loadedLegacyLaser) {
            this.type = this.worldObj.getBlockId(this.xCoord, this.yCoord - 1, this.zCoord) == mod_PCmachines.roaster.blockID ? 1 : 2;
            this.loadedLegacyLaser = false;
        }
        if (this.type == 0) {
            return;
        }
        if (this.isKiller() && !this.isKillerActive()) {
            return;
        }
        if (this.isRsReceiver()) {
            if (this.receiverCooldownTimer > 0) {
                this.notifyChange(true);
                this.receiverCooldownTimer = this.receiverCooldownTimer > 1 ? 1 : 0;
            } else {
                this.notifyChange(false);
            }
            return;
        }
        if (this.isRsTransmitter() && !this.isRedstonePowered()) {
            return;
        }
        PC_Color color = new PC_Color();
        if (this.isKiller()) {
            color.setTo(1.0, 0.001, 0.001);
            color.setMeta(1);
        } else if (this.isSensor()) {
            color.setTo(1.0, 0.001, 0.5);
            color.setMeta(5);
        } else if (this.isRsTransmitter()) {
            color.setTo(0.001, 1.0, 0.001);
            color.setMeta(2);
        } else {
            color.setMeta(-1);
        }
        this.hitObjectThisShot = false;
        this.beamTracer.setColor(color).setDetectEntities(this.isKiller() || this.isSensor()).setParticlesBidirectional(this.isSensor());
        this.beamTracer.flash();
        if (this.isSensor()) {
            this.notifyChange(this.hitObjectThisShot);
        }
    }

    private void notifyChange(boolean state) {
        if (state) {
            if (!this.active) {
                this.active = true;
                this.worldObj.notifyBlocksOfNeighborChange(this.xCoord, this.yCoord, this.zCoord, this.getBlockType().blockID);
                this.worldObj.notifyBlocksOfNeighborChange(this.xCoord, this.yCoord - 1, this.zCoord, this.getBlockType().blockID);
                this.worldObj.markBlocksDirty(this.xCoord, this.yCoord, this.zCoord, this.xCoord, this.yCoord, this.zCoord);
                this.worldObj.markBlockNeedsUpdate(this.xCoord, this.yCoord, this.zCoord);
            }
        } else if (this.active) {
            this.active = false;
            this.worldObj.notifyBlocksOfNeighborChange(this.xCoord, this.yCoord, this.zCoord, this.getBlockType().blockID);
            this.worldObj.notifyBlocksOfNeighborChange(this.xCoord, this.yCoord - 1, this.zCoord, this.getBlockType().blockID);
            this.worldObj.markBlocksDirty(this.xCoord, this.yCoord, this.zCoord, this.xCoord, this.yCoord, this.zCoord);
            this.worldObj.markBlockNeedsUpdate(this.xCoord, this.yCoord, this.zCoord);
        }
    }

    private int getDirection() {
        return this.worldObj.getBlockMetadata(this.xCoord, this.yCoord, this.zCoord);
    }

    public boolean isKiller() {
        return this.type == 1;
    }

    public boolean isSensor() {
        return this.type == 2;
    }

    public boolean isRsTransmitter() {
        return this.type == 3;
    }

    public boolean isRsReceiver() {
        return this.type == 4;
    }

    private boolean isKillerActive() {
        if (this.isKiller()) {
            return PCma_BlockRoaster.isBurning(this.worldObj, this.xCoord, this.yCoord - 1, this.zCoord);
        }
        return false;
    }

    private boolean isRedstonePowered() {
        if (this.worldObj.isBlockGettingPowered(this.xCoord, this.yCoord, this.zCoord)) {
            return true;
        }
        if (this.worldObj.isBlockIndirectlyGettingPowered(this.xCoord, this.yCoord, this.zCoord)) {
            return true;
        }
        if (this.worldObj.isBlockGettingPowered(this.xCoord, this.yCoord, this.zCoord)) {
            return true;
        }
        return this.worldObj.isBlockIndirectlyGettingPowered(this.xCoord, this.yCoord, this.zCoord);
    }

    public void setType(int type) {
        this.type = type;
    }

    @Override
    public boolean onBlockHit(World world, PC_CoordI coord, PC_CoordI startCoord) {
        int id = coord.getId(world);
        if (Block.blocksList[id] == null) {
            return false;
        }
        if (id == Block.tnt.blockID && (this.isKiller() || this.isRsTransmitter())) {
            Block.tnt.onBlockDestroyedByPlayer(this.worldObj, coord.x, coord.y, coord.z, 1);
            coord.setBlock(world, 0, 0);
            return false;
        }
        Material mat = Block.blocksList[id].blockMaterial;
        Block block = Block.blocksList[id];
        if (mat == Material.glass || mat == Material.snow || mat == Material.plants || mat == Material.circuits || mat == Material.vine || id == Block.signPost.blockID || id == Block.signWall.blockID || block instanceof BlockPane || PC_BlockUtils.hasFlag(world, coord, "TRANSLUCENT")) {
            return false;
        }
        if (id == mod_PCmachines.laser.blockID) {
            PCma_TileEntityLaser tel;
            if (this.isKiller() && coord.equals(startCoord)) {
                this.worldObj.createExplosion(null, coord.x, coord.y, coord.z, 3.0f);
            } else if (this.isRsTransmitter() && (tel = (PCma_TileEntityLaser)coord.getTileEntity(world)).isRsReceiver()) {
                tel.receiverCooldownTimer = 2;
                tel.notifyChange(true);
            }
            return true;
        }
        return Block.blocksList[id].isOpaqueCube();
    }

    @Override
    public boolean onEntityHit(World world, Entity[] array, PC_CoordI startCoord) {
        if (this.isSensor()) {
            int cnte = 0;
            for (Entity entity : array) {
                if (entity instanceof EntityFX || entity instanceof EntityArrow || entity instanceof EntityEnderEye || entity instanceof EntityEnderPearl || entity instanceof EntityFishHook || entity instanceof EntityPainting || entity instanceof EntityWeatherEffect || entity instanceof EntityItem || entity instanceof EntityXPOrb) continue;
                ++cnte;
                break;
            }
            if (cnte < 1) {
                return false;
            }
            this.hitObjectThisShot = true;
            return true;
        }
        if (this.isKiller()) {
            for (Entity entity : array) {
                if (!(entity instanceof EntityLiving) || !entity.isEntityAlive()) continue;
                ((EntityLiving)entity).experienceValue /= 2;
                if (entity instanceof EntityPlayerSP) {
                    EntityPlayerSP player = (EntityPlayerSP)entity;
                    int armourValue = PC_InvUtils.getPlayerArmourValue(player);
                    if (!this.worldObj.rand.nextBoolean()) continue;
                    player.attackEntityFrom(DamageSource.generic, MathHelper.clamp_int(Math.round(5.0f * (0.7f - (float)(armourValue / 8))), 0, 8));
                    continue;
                }
                entity.attackEntityFrom(DamageSource.causePlayerDamage(new PC_FakePlayer(this.worldObj)), 200);
            }
        }
        return false;
    }
}

