/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.Block;
import net.minecraft.src.BlockContainer;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.ItemBlock;
import net.minecraft.src.ItemStack;
import net.minecraft.src.Material;
import net.minecraft.src.PC_CoordI;
import net.minecraft.src.PC_IBlockType;
import net.minecraft.src.PC_ISwapTerrain;
import net.minecraft.src.PCma_Renderer;
import net.minecraft.src.PCma_TileEntityXPBank;
import net.minecraft.src.TileEntity;
import net.minecraft.src.World;
import net.minecraft.src.forge.ITextureProvider;
import net.minecraft.src.mod_PCmachines;

public class PCma_BlockXPBank
extends BlockContainer
implements PC_ISwapTerrain,
PC_IBlockType,
ITextureProvider {
    public boolean rendering = false;

    @Override
    public String getTerrainFile() {
        return mod_PCmachines.getTerrainFile();
    }

    @Override
    public String getTextureFile() {
        return this.getTerrainFile();
    }

    @Override
    public TileEntity getBlockEntity() {
        return new PCma_TileEntityXPBank();
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public int getRenderType() {
        return PCma_Renderer.xpbankRenderer;
    }

    @Override
    public int getBlockTextureFromSideAndMetadata(int s, int m) {
        return 24;
    }

    protected PCma_BlockXPBank(int i) {
        super(i, Material.ground);
        this.setStepSound(Block.soundPowderFootstep);
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    @Override
    public AxisAlignedBB getSelectedBoundingBoxFromPool(World world, int i, int j, int k) {
        return AxisAlignedBB.getBoundingBoxFromPool(i, j, k, (double)i + 1.0, (double)j + 1.0, (double)k + 1.0);
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int i, int j, int k) {
        return AxisAlignedBB.getBoundingBoxFromPool(i, j, k, (double)i + 1.0, (double)j + 1.0, (double)k + 1.0);
    }

    @Override
    public void setBlockBoundsBasedOnState(IBlockAccess iblockaccess, int i, int j, int k) {
        if (this.rendering) {
            int xp = ((PCma_TileEntityXPBank)iblockaccess.getBlockTileEntity((int)i, (int)j, (int)k)).xp;
            this.setBlockBounds(0.15f, 0.29f - 0.2f * this.calculateHeightMultiplier(xp), 0.15f, 0.85f, 0.71f + 0.2f * this.calculateHeightMultiplier(xp), 0.85f);
        } else {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    private float calculateHeightMultiplier(int xp) {
        return Math.min((float)xp / 500.0f, 1.0f);
    }

    @Override
    public void setBlockBoundsForItemRender() {
        this.setBlockBounds(0.2f, 0.2f, 0.2f, 0.8f, 0.9f, 0.8f);
    }

    @Override
    public void onBlockClicked(World world, int i, int j, int k, EntityPlayer entityplayer) {
        ((PCma_TileEntityXPBank)world.getBlockTileEntity(i, j, k)).printXP(entityplayer);
    }

    @Override
    public boolean blockActivated(World world, int i, int j, int k, EntityPlayer entityplayer) {
        ItemStack ihold = entityplayer.getCurrentEquippedItem();
        if (ihold != null && ihold.getItem() instanceof ItemBlock && ihold.getItem().shiftedIndex != this.blockID && Block.blocksList[ihold.getItem().shiftedIndex] instanceof PC_IBlockType) {
            return false;
        }
        if (!entityplayer.isSneaking()) {
            ((PCma_TileEntityXPBank)world.getBlockTileEntity(i, j, k)).withdrawXP(entityplayer);
        } else {
            ((PCma_TileEntityXPBank)world.getBlockTileEntity(i, j, k)).depositXP(entityplayer);
        }
        return true;
    }

    @Override
    public int quantityDropped(Random random) {
        return 1;
    }

    @Override
    public boolean canProvidePower() {
        return true;
    }

    @Override
    public boolean isPoweringTo(IBlockAccess iblockaccess, int i, int j, int k, int l) {
        return ((PCma_TileEntityXPBank)iblockaccess.getBlockTileEntity((int)i, (int)j, (int)k)).xp > 0;
    }

    @Override
    public boolean isIndirectlyPoweringTo(World world, int i, int j, int k, int l) {
        return this.isPoweringTo(world, i, j, k, l);
    }

    @Override
    public void harvestBlock(World world, EntityPlayer entityplayer, int i, int j, int k, int l) {
        try {
            ((PCma_TileEntityXPBank)world.getBlockTileEntity(i, j, k)).withdrawXP(entityplayer);
        }
        catch (NullPointerException npe) {
            // empty catch block
        }
        super.harvestBlock(world, entityplayer, i, j, k, l);
    }

    @Override
    public Set<String> getBlockFlags(World world, PC_CoordI pos) {
        HashSet<String> set = new HashSet<String>();
        set.add("NO_HARVEST");
        set.add("HARVEST_STOP");
        set.add("XP_BANK");
        return set;
    }

    @Override
    public Set<String> getItemFlags(int damage) {
        HashSet<String> set = new HashSet<String>();
        set.add("NO_BUILD");
        return set;
    }
}

