/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.src.Block;
import net.minecraft.src.BlockContainer;
import net.minecraft.src.EntityItem;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.ItemBlock;
import net.minecraft.src.ItemStack;
import net.minecraft.src.Material;
import net.minecraft.src.PC_CoordI;
import net.minecraft.src.PC_IBlockType;
import net.minecraft.src.PC_ISwapTerrain;
import net.minecraft.src.PC_Renderer;
import net.minecraft.src.PC_Utils;
import net.minecraft.src.PCma_GuiRoaster;
import net.minecraft.src.PCma_TileEntityRoaster;
import net.minecraft.src.TileEntity;
import net.minecraft.src.World;
import net.minecraft.src.forge.ITextureProvider;
import net.minecraft.src.mod_PCmachines;

public class PCma_BlockRoaster
extends BlockContainer
implements PC_ISwapTerrain,
PC_IBlockType,
ITextureProvider {
    private static final int TXDOWN = 62;
    private static final int TXTOP = 61;
    private static final int TXSIDE = 46;
    private Random random = new Random();

    protected PCma_BlockRoaster(int i) {
        super(i, Material.ground);
        this.blockIndexInTexture = 62;
        this.setLightOpacity(0);
        PCma_BlockRoaster.opaqueCubeLookup[i] = false;
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.75f, 1.0f);
    }

    @Override
    public String getTerrainFile() {
        return mod_PCmachines.getTerrainFile();
    }

    @Override
    public String getTextureFile() {
        return this.getTerrainFile();
    }

    @Override
    public boolean renderAsNormalBlock() {
        return true;
    }

    @Override
    public void setBlockBoundsBasedOnState(IBlockAccess iblockaccess, int i, int j, int k) {
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.75f, 1.0f);
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public int getRenderType() {
        return PC_Renderer.swapTerrainRenderer;
    }

    @Override
    public int getBlockTextureFromSideAndMetadata(int s, int m) {
        if (s == 1) {
            return 61;
        }
        if (s == 0) {
            return 62;
        }
        return 46;
    }

    @Override
    public int tickRate() {
        return 4;
    }

    @Override
    public int idDropped(int i, Random random, int j) {
        return this.blockID;
    }

    @Override
    public void onBlockAdded(World world, int i, int j, int k) {
        super.onBlockAdded(world, i, j, k);
    }

    @Override
    public boolean blockActivated(World world, int i, int j, int k, EntityPlayer entityplayer) {
        ItemStack ihold = entityplayer.getCurrentEquippedItem();
        if (ihold != null && ihold.getItem() instanceof ItemBlock && ihold.getItem().shiftedIndex != this.blockID && Block.blocksList[ihold.getItem().shiftedIndex] instanceof PC_IBlockType) {
            return false;
        }
        if (world.isRemote) {
            return true;
        }
        PCma_TileEntityRoaster tileentity = (PCma_TileEntityRoaster)world.getBlockTileEntity(i, j, k);
        if (tileentity != null) {
            PC_Utils.openGres(entityplayer, new PCma_GuiRoaster(entityplayer, tileentity));
        }
        return true;
    }

    @Override
    public TileEntity getBlockEntity() {
        return new PCma_TileEntityRoaster();
    }

    @Override
    public void onBlockRemoval(World world, int i, int j, int k) {
        PCma_TileEntityRoaster tileentity = (PCma_TileEntityRoaster)world.getBlockTileEntity(i, j, k);
        if (tileentity != null) {
            for (int l = 0; l < tileentity.getSizeInventory(); ++l) {
                ItemStack itemstack = tileentity.getStackInSlot(l);
                if (itemstack == null) continue;
                float f = this.random.nextFloat() * 0.8f + 0.1f;
                float f1 = this.random.nextFloat() * 0.8f + 0.1f;
                float f2 = this.random.nextFloat() * 0.8f + 0.1f;
                while (itemstack.stackSize > 0) {
                    int i1 = this.random.nextInt(21) + 10;
                    if (i1 > itemstack.stackSize) {
                        i1 = itemstack.stackSize;
                    }
                    itemstack.stackSize -= i1;
                    EntityItem entityitem = new EntityItem(world, (float)i + f, (float)j + f1, (float)k + f2, new ItemStack(itemstack.itemID, i1, itemstack.getItemDamage()));
                    float f3 = 0.05f;
                    entityitem.motionX = (float)this.random.nextGaussian() * f3;
                    entityitem.motionY = (float)this.random.nextGaussian() * f3 + 0.2f;
                    entityitem.motionZ = (float)this.random.nextGaussian() * f3;
                    world.spawnEntityInWorld(entityitem);
                }
            }
        }
        super.onBlockRemoval(world, i, j, k);
    }

    public static boolean isIndirectlyPowered(World world, int x, int y, int z) {
        if (world.isBlockGettingPowered(x, y, z)) {
            return true;
        }
        if (world.isBlockIndirectlyGettingPowered(x, y, z)) {
            return true;
        }
        if (world.isBlockGettingPowered(x, y - 1, z)) {
            return true;
        }
        return world.isBlockIndirectlyGettingPowered(x, y - 1, z);
    }

    private static boolean hasFuel(World world, int x, int y, int z) {
        try {
            return ((PCma_TileEntityRoaster)world.getBlockTileEntity((int)x, (int)y, (int)z)).burnTime > 0;
        }
        catch (RuntimeException re) {
            return false;
        }
    }

    private boolean isNethering(World world, int x, int y, int z) {
        try {
            return ((PCma_TileEntityRoaster)world.getBlockTileEntity((int)x, (int)y, (int)z)).netherTime > 0 && PCma_BlockRoaster.isIndirectlyPowered(world, x, y, z);
        }
        catch (RuntimeException re) {
            return false;
        }
    }

    public static boolean isBurning(World world, int x, int y, int z) {
        return PCma_BlockRoaster.isIndirectlyPowered(world, x, y, z) && PCma_BlockRoaster.hasFuel(world, x, y, z);
    }

    @Override
    public void randomDisplayTick(World world, int i, int j, int k, Random random) {
        float z;
        float x;
        float y;
        int c;
        if (PCma_BlockRoaster.isBurning(world, i, j, k)) {
            if (random.nextInt(24) == 0) {
                world.playSoundEffect((float)i + 0.5f, (float)j + 0.5f, (float)k + 0.5f, "fire.fire", 1.0f + random.nextFloat(), random.nextFloat() * 0.7f + 0.3f);
            }
            for (c = 0; c < 5; ++c) {
                y = (float)j + 0.74f + random.nextFloat() * 0.3f;
                x = (float)i + 0.2f + random.nextFloat() * 0.6f;
                z = (float)k + 0.2f + random.nextFloat() * 0.6f;
                world.spawnParticle("smoke", x, y, z, 0.0, 0.0, 0.0);
                world.spawnParticle("flame", x, y, z, 0.0, 0.0, 0.0);
            }
            for (c = 0; c < 5; ++c) {
                y = (float)j + 1.3f;
                x = (float)i + 0.2f + random.nextFloat() * 0.6f;
                z = (float)k + 0.2f + random.nextFloat() * 0.6f;
                world.spawnParticle("smoke", x, y, z, 0.0, 0.0, 0.0);
            }
        }
        if (this.isNethering(world, i, j, k)) {
            for (c = 0; c < 8; ++c) {
                y = (float)j + 0.74f + random.nextFloat() * 0.3f;
                x = (float)i + 0.2f + random.nextFloat() * 0.6f;
                z = (float)k + 0.2f + random.nextFloat() * 0.6f;
                world.spawnParticle("reddust", x, y, z, 0.0, 0.0, 0.0);
            }
            for (c = 0; c < 20; ++c) {
                y = (float)j + -2.0f + random.nextFloat() * 4.0f;
                x = (float)i + -6.0f + random.nextFloat() * 12.0f;
                z = (float)k + -6.0f + random.nextFloat() * 12.0f;
                world.spawnParticle("reddust", x, y, z, 0.6, 0.001, 0.001);
            }
        }
    }

    @Override
    public Set<String> getBlockFlags(World world, PC_CoordI pos) {
        HashSet<String> set = new HashSet<String>();
        set.add("NO_HARVEST");
        set.add("HARVEST_STOP");
        set.add("ROASTER");
        set.add("FURNACE");
        if (PCma_BlockRoaster.isBurning(world, pos.x, pos.y, pos.z)) {
            set.add("SMOKE");
        }
        return set;
    }

    @Override
    public Set<String> getItemFlags(int damage) {
        HashSet<String> set = new HashSet<String>();
        set.add("NO_BUILD");
        return set;
    }
}

