/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.src.Block;
import net.minecraft.src.BlockContainer;
import net.minecraft.src.EntityItem;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.Item;
import net.minecraft.src.ItemBlock;
import net.minecraft.src.ItemStack;
import net.minecraft.src.Material;
import net.minecraft.src.MathHelper;
import net.minecraft.src.PC_BlockUtils;
import net.minecraft.src.PC_CoordI;
import net.minecraft.src.PC_IBlockType;
import net.minecraft.src.PC_ISwapTerrain;
import net.minecraft.src.PC_Renderer;
import net.minecraft.src.PC_Utils;
import net.minecraft.src.PCma_GuiReplacer;
import net.minecraft.src.PCma_TileEntityReplacer;
import net.minecraft.src.TileEntity;
import net.minecraft.src.World;
import net.minecraft.src.forge.ITextureProvider;
import net.minecraft.src.mod_PCmachines;

public class PCma_BlockReplacer
extends BlockContainer
implements PC_ISwapTerrain,
PC_IBlockType,
ITextureProvider {
    private static final int TXDOWN = 109;
    private static final int TXTOP = 153;
    private static final int TXSIDE = 137;
    private static final int TXFRONT = 105;
    private static final int TXBACK = 121;
    private int[] blockOffset = new int[]{0, 0, 0};

    protected PCma_BlockReplacer(int par1, int par2, Material par3Material) {
        super(par1, par2, par3Material);
    }

    protected PCma_BlockReplacer(int par1, Material par2Material) {
        super(par1, par2Material);
    }

    protected PCma_BlockReplacer(int par1) {
        super(par1, Material.ground);
    }

    @Override
    public String getTerrainFile() {
        return mod_PCmachines.getImgDir() + "tiles.png";
    }

    @Override
    public String getTextureFile() {
        return this.getTerrainFile();
    }

    @Override
    public boolean renderAsNormalBlock() {
        return true;
    }

    @Override
    public int getRenderType() {
        return PC_Renderer.swapTerrainRenderer;
    }

    @Override
    public int getBlockTextureFromSideAndMetadata(int s, int m) {
        if (s == 1) {
            return 153;
        }
        if (s == 0) {
            return 109;
        }
        return 137;
    }

    @Override
    public void onBlockClicked(World world, int i, int j, int k, EntityPlayer entityplayer) {
        PCma_TileEntityReplacer tileentity = (PCma_TileEntityReplacer)world.getBlockTileEntity(i, j, k);
        if (tileentity != null) {
            tileentity.aidEnabled = !tileentity.aidEnabled;
        }
    }

    @Override
    public boolean blockActivated(World world, int i, int j, int k, EntityPlayer entityplayer) {
        ItemStack ihold = entityplayer.getCurrentEquippedItem();
        if (ihold != null) {
            if (ihold.getItem() instanceof ItemBlock && ihold.getItem().shiftedIndex != this.blockID) {
                Block bhold = Block.blocksList[ihold.getItem().shiftedIndex];
                if (bhold instanceof PC_IBlockType) {
                    return false;
                }
            } else if (ihold.getItem().shiftedIndex == Item.stick.shiftedIndex) {
                PCma_TileEntityReplacer tileentity;
                int l = MathHelper.floor_double((double)(entityplayer.rotationYaw * 4.0f / 360.0f) + 0.5) & 3;
                if (PC_Utils.isPlacingReversed()) {
                    l = PC_Utils.reverseSide(l);
                }
                if (entityplayer.isSneaking()) {
                    int n = l = PC_Utils.isPlacingReversed() ? 5 : 4;
                }
                if ((tileentity = (PCma_TileEntityReplacer)world.getBlockTileEntity(i, j, k)) != null) {
                    switch (l) {
                        case 0: {
                            ++tileentity.coordOffset.z;
                            break;
                        }
                        case 2: {
                            --tileentity.coordOffset.z;
                            break;
                        }
                        case 3: {
                            ++tileentity.coordOffset.x;
                            break;
                        }
                        case 1: {
                            --tileentity.coordOffset.x;
                            break;
                        }
                        case 4: {
                            ++tileentity.coordOffset.y;
                            break;
                        }
                        case 5: {
                            --tileentity.coordOffset.y;
                        }
                    }
                    tileentity.coordOffset.x = MathHelper.clamp_int(tileentity.coordOffset.x, -16, 16);
                    tileentity.coordOffset.y = MathHelper.clamp_int(tileentity.coordOffset.y, -16, 16);
                    tileentity.coordOffset.z = MathHelper.clamp_int(tileentity.coordOffset.z, -16, 16);
                }
                return true;
            }
        }
        if (world.isRemote) {
            return true;
        }
        PCma_TileEntityReplacer tileentity = (PCma_TileEntityReplacer)world.getBlockTileEntity(i, j, k);
        if (tileentity != null) {
            PC_Utils.openGres(entityplayer, new PCma_GuiReplacer(tileentity, entityplayer));
        }
        return true;
    }

    @Override
    public int tickRate() {
        return 2;
    }

    @Override
    public void onNeighborBlockChange(World world, int i, int j, int k, int l) {
        world.scheduleBlockUpdate(i, j, k, this.blockID, this.tickRate());
    }

    private boolean replacer_canHarvestBlockAt(World world, PC_CoordI pos) {
        int id = pos.getMeta(world);
        if (id == 0 || Block.blocksList[id] == null) {
            return true;
        }
        return pos.getTileEntity(world) == null;
    }

    private boolean replacer_canPlaceBlockAt(World world, ItemStack itemstack, PC_CoordI pos) {
        if (itemstack == null) {
            return true;
        }
        Item item = itemstack.getItem();
        if (item instanceof ItemBlock) {
            Block block = Block.blocksList[item.shiftedIndex];
            if (block == null) {
                return false;
            }
            if (PC_BlockUtils.hasFlag(itemstack, "NO_BUILD")) {
                return false;
            }
            return !block.isBlockContainer;
        }
        return false;
    }

    private boolean replacer_placeBlockAt(World world, ItemStack itemstack, PC_CoordI pos) {
        if (itemstack == null) {
            pos.setBlock(world, 0, 0);
            return true;
        }
        if (!this.replacer_canPlaceBlockAt(world, itemstack, pos)) {
            return false;
        }
        ItemBlock iblock = (ItemBlock)itemstack.getItem();
        if (pos.setBlockNoNotify(world, iblock.getBlockID(), iblock.getMetadata(itemstack.getItemDamage()))) {
            if (pos.getId(world) == iblock.getBlockID()) {
                world.notifyBlockChange(pos.x, pos.y, pos.z, iblock.getBlockID());
                Block.blocksList[iblock.getBlockID()].onBlockPlaced(world, pos.x, pos.y, pos.z, 0);
            }
            --itemstack.stackSize;
        }
        return true;
    }

    private ItemStack replacer_harvestBlockAt(World world, PC_CoordI pos) {
        ItemStack loot = null;
        if (!this.replacer_canHarvestBlockAt(world, pos)) {
            return null;
        }
        Block block = Block.blocksList[pos.getId(world)];
        if (block == null) {
            return null;
        }
        if (block.canSilkHarvest()) {
            loot = block.createStackedBlock(pos.getMeta(world));
        } else {
            int dropId = block.blockID;
            int dropMeta = block.damageDropped(pos.getMeta(world));
            int dropQuant = block.quantityDropped(world.rand);
            if (dropId <= 0) {
                dropId = pos.getId(world);
            }
            if (dropQuant <= 0) {
                dropQuant = 1;
            }
            loot = new ItemStack(dropId, dropQuant, dropMeta);
        }
        return loot;
    }

    private void swapBlocks(PCma_TileEntityReplacer te) {
        PC_CoordI pos = new PC_CoordI(te.xCoord, te.yCoord, te.zCoord).offset(te.coordOffset);
        if (pos.equals(new PC_CoordI(te.xCoord, te.yCoord, te.zCoord))) {
            return;
        }
        if (!this.replacer_canHarvestBlockAt(te.worldObj, pos)) {
            return;
        }
        if (!this.replacer_canPlaceBlockAt(te.worldObj, te.buildBlock, pos)) {
            return;
        }
        ItemStack harvested = this.replacer_harvestBlockAt(te.worldObj, pos);
        this.replacer_placeBlockAt(te.worldObj, te.buildBlock, pos);
        te.buildBlock = harvested;
    }

    @Override
    public void updateTick(World world, int i, int j, int k, Random random) {
        boolean powered;
        PCma_TileEntityReplacer ter = (PCma_TileEntityReplacer)world.getBlockTileEntity(i, j, k);
        if (ter != null && !world.isRemote && (powered = this.isIndirectlyPowered(world, i, j, k)) != ter.state) {
            this.swapBlocks(ter);
            ter.state = powered;
        }
    }

    private boolean isIndirectlyPowered(World world, int i, int j, int k) {
        if (world.isBlockGettingPowered(i, j, k)) {
            return true;
        }
        if (world.isBlockIndirectlyGettingPowered(i, j, k)) {
            return true;
        }
        if (world.isBlockGettingPowered(i, j - 1, k)) {
            return true;
        }
        return world.isBlockIndirectlyGettingPowered(i, j - 1, k);
    }

    @Override
    public TileEntity getBlockEntity() {
        return new PCma_TileEntityReplacer();
    }

    @Override
    public int getMobilityFlag() {
        return 0;
    }

    @Override
    public void onBlockRemoval(World world, int i, int j, int k) {
        PCma_TileEntityReplacer tileentity = (PCma_TileEntityReplacer)world.getBlockTileEntity(i, j, k);
        Random random = new Random();
        if (tileentity != null && tileentity.buildBlock != null) {
            float f = random.nextFloat() * 0.8f + 0.1f;
            float f1 = random.nextFloat() * 0.8f + 0.1f;
            float f2 = random.nextFloat() * 0.8f + 0.1f;
            EntityItem entityitem = new EntityItem(world, (float)i + f, (float)j + f1, (float)k + f2, tileentity.buildBlock);
            float f3 = 0.05f;
            entityitem.motionX = (float)random.nextGaussian() * f3;
            entityitem.motionY = (float)random.nextGaussian() * f3 + 0.2f;
            entityitem.motionZ = (float)random.nextGaussian() * f3;
            world.spawnEntityInWorld(entityitem);
        }
        super.onBlockRemoval(world, i, j, k);
    }

    @Override
    public Set<String> getBlockFlags(World world, PC_CoordI pos) {
        HashSet<String> set = new HashSet<String>();
        set.add("NO_HARVEST");
        set.add("HARVEST_STOP");
        return set;
    }

    @Override
    public Set<String> getItemFlags(int damage) {
        HashSet<String> set = new HashSet<String>();
        set.add("NO_BUILD");
        return set;
    }
}

