/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.src.Block;
import net.minecraft.src.BlockContainer;
import net.minecraft.src.EntityItem;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.ItemBlock;
import net.minecraft.src.ItemStack;
import net.minecraft.src.Material;
import net.minecraft.src.MathHelper;
import net.minecraft.src.PC_CoordI;
import net.minecraft.src.PC_IBlockType;
import net.minecraft.src.PC_ISpecialInventoryTextures;
import net.minecraft.src.PC_ISwapTerrain;
import net.minecraft.src.PC_Renderer;
import net.minecraft.src.PC_Utils;
import net.minecraft.src.PCma_GuiBlockBuilder;
import net.minecraft.src.PCma_TileEntityBlockBuilder;
import net.minecraft.src.TileEntity;
import net.minecraft.src.World;
import net.minecraft.src.forge.ITextureProvider;
import net.minecraft.src.mod_PCmachines;

public class PCma_BlockBlockBuilder
extends BlockContainer
implements PC_ISwapTerrain,
PC_IBlockType,
PC_ISpecialInventoryTextures,
ITextureProvider {
    private static final int TXDOWN = 109;
    private static final int TXTOP = 156;
    private static final int TXSIDE = 140;
    private static final int TXFRONT = 108;
    private static final int TXBACK = 124;
    private Random random = new Random();

    @Override
    public String getTextureFile() {
        return this.getTerrainFile();
    }

    @Override
    public String getTerrainFile() {
        return mod_PCmachines.getTerrainFile();
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public int getRenderType() {
        return PC_Renderer.swapTerrainRenderer;
    }

    @Override
    public int getBlockTextureFromSideAndMetadata(int s, int m) {
        if (s == 1) {
            return 156;
        }
        if (s == 0) {
            return 109;
        }
        if (m == s) {
            return 108;
        }
        if (m == 2 && s == 3 || m == 3 && s == 2 || m == 4 && s == 5 || m == 5 && s == 4) {
            return 124;
        }
        return 140;
    }

    @Override
    public int getInvTexture(int i, int m) {
        if (i == 1) {
            return 156;
        }
        if (i == 0) {
            return 109;
        }
        if (i == 3) {
            return 108;
        }
        if (i == 4) {
            return 124;
        }
        return 140;
    }

    protected PCma_BlockBlockBuilder(int i) {
        super(i, Material.ground);
        this.blockIndexInTexture = 109;
    }

    @Override
    public int tickRate() {
        return 4;
    }

    @Override
    public int idDropped(int i, Random random, int j) {
        return this.blockID;
    }

    @Override
    public void onBlockAdded(World world, int i, int j, int k) {
        super.onBlockAdded(world, i, j, k);
        this.setDispenserDefaultDirection(world, i, j, k);
    }

    private void setDispenserDefaultDirection(World world, int i, int j, int k) {
        if (!world.isRemote) {
            int l = world.getBlockId(i, j, k - 1);
            int i1 = world.getBlockId(i, j, k + 1);
            int j1 = world.getBlockId(i - 1, j, k);
            int k1 = world.getBlockId(i + 1, j, k);
            int byte0 = 3;
            if (Block.opaqueCubeLookup[l] && !Block.opaqueCubeLookup[i1]) {
                byte0 = 3;
            }
            if (Block.opaqueCubeLookup[i1] && !Block.opaqueCubeLookup[l]) {
                byte0 = 2;
            }
            if (Block.opaqueCubeLookup[j1] && !Block.opaqueCubeLookup[k1]) {
                byte0 = 5;
            }
            if (Block.opaqueCubeLookup[k1] && !Block.opaqueCubeLookup[j1]) {
                byte0 = 4;
            }
            world.setBlockMetadataWithNotify(i, j, k, byte0);
        }
    }

    @Override
    public boolean blockActivated(World world, int i, int j, int k, EntityPlayer entityplayer) {
        Block bhold;
        ItemStack ihold = entityplayer.getCurrentEquippedItem();
        if (ihold != null && ihold.getItem() instanceof ItemBlock && ihold.getItem().shiftedIndex != this.blockID && (bhold = Block.blocksList[ihold.getItem().shiftedIndex]) instanceof PC_IBlockType) {
            return false;
        }
        if (world.isRemote) {
            return true;
        }
        PCma_TileEntityBlockBuilder tileentity = (PCma_TileEntityBlockBuilder)world.getBlockTileEntity(i, j, k);
        if (tileentity != null) {
            PC_Utils.openGres(entityplayer, new PCma_GuiBlockBuilder(entityplayer, tileentity));
        }
        return true;
    }

    @Override
    public void onNeighborBlockChange(World world, int i, int j, int k, int l) {
        boolean flag;
        if (l > 0 && Block.blocksList[l].canProvidePower() && (flag = this.isIndirectlyPowered(world, i, j, k))) {
            world.scheduleBlockUpdate(i, j, k, this.blockID, this.tickRate());
        }
    }

    @Override
    public void updateTick(World world, int i, int j, int k, Random random) {
        PCma_TileEntityBlockBuilder tileentity;
        if (!world.isRemote && this.isIndirectlyPowered(world, i, j, k) && (tileentity = (PCma_TileEntityBlockBuilder)world.getBlockTileEntity(i, j, k)) != null) {
            tileentity.useItem();
        }
    }

    @Override
    public TileEntity getBlockEntity() {
        return new PCma_TileEntityBlockBuilder();
    }

    @Override
    public void onBlockPlacedBy(World world, int i, int j, int k, EntityLiving entityliving) {
        int l = MathHelper.floor_double((double)(entityliving.rotationYaw * 4.0f / 360.0f) + 0.5) & 3;
        if (PC_Utils.isPlacingReversed()) {
            l = PC_Utils.reverseSide(l);
        }
        if (l == 0) {
            l = 2;
        } else if (l == 1) {
            l = 5;
        } else if (l == 2) {
            l = 3;
        } else if (l == 3) {
            l = 4;
        }
        world.setBlockMetadataWithNotify(i, j, k, l);
    }

    @Override
    public void onBlockRemoval(World world, int i, int j, int k) {
        PCma_TileEntityBlockBuilder tileentity = (PCma_TileEntityBlockBuilder)world.getBlockTileEntity(i, j, k);
        if (tileentity != null) {
            for (int l = 0; l < tileentity.getSizeInventory(); ++l) {
                ItemStack itemstack = tileentity.getStackInSlot(l);
                if (itemstack == null) continue;
                float f = this.random.nextFloat() * 0.8f + 0.1f;
                float f1 = this.random.nextFloat() * 0.8f + 0.1f;
                float f2 = this.random.nextFloat() * 0.8f + 0.1f;
                while (itemstack.stackSize > 0) {
                    int i1 = this.random.nextInt(21) + 10;
                    if (i1 > itemstack.stackSize) {
                        i1 = itemstack.stackSize;
                    }
                    itemstack.stackSize -= i1;
                    EntityItem entityitem = new EntityItem(world, (float)i + f, (float)j + f1, (float)k + f2, new ItemStack(itemstack.itemID, i1, itemstack.getItemDamage()));
                    float f3 = 0.05f;
                    entityitem.motionX = (float)this.random.nextGaussian() * f3;
                    entityitem.motionY = (float)this.random.nextGaussian() * f3 + 0.2f;
                    entityitem.motionZ = (float)this.random.nextGaussian() * f3;
                    world.spawnEntityInWorld(entityitem);
                }
            }
        }
        super.onBlockRemoval(world, i, j, k);
    }

    private boolean isIndirectlyPowered(World world, int i, int j, int k) {
        if (world.isBlockGettingPowered(i, j, k)) {
            return true;
        }
        if (world.isBlockIndirectlyGettingPowered(i, j, k)) {
            return true;
        }
        if (world.isBlockGettingPowered(i, j - 1, k)) {
            return true;
        }
        return world.isBlockIndirectlyGettingPowered(i, j - 1, k);
    }

    @Override
    public Set<String> getBlockFlags(World world, PC_CoordI pos) {
        HashSet<String> set = new HashSet<String>();
        set.add("NO_HARVEST");
        set.add("HARVEST_STOP");
        set.add("BLOCK_DISPENSER");
        set.add("REDSTONE");
        set.add("MACHINE");
        return set;
    }

    @Override
    public Set<String> getItemFlags(int damage) {
        HashSet<String> set = new HashSet<String>();
        set.add("NO_BUILD");
        return set;
    }
}

