/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.src.Block;
import net.minecraft.src.BlockContainer;
import net.minecraft.src.EntityItem;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.ItemBlock;
import net.minecraft.src.ItemStack;
import net.minecraft.src.Material;
import net.minecraft.src.MathHelper;
import net.minecraft.src.PC_CoordI;
import net.minecraft.src.PC_IBlockType;
import net.minecraft.src.PC_ISpecialInventoryTextures;
import net.minecraft.src.PC_ISwapTerrain;
import net.minecraft.src.PC_Renderer;
import net.minecraft.src.PC_Utils;
import net.minecraft.src.PCma_GuiAutomaticWorkbench;
import net.minecraft.src.PCma_TileEntityAutomaticWorkbench;
import net.minecraft.src.TileEntity;
import net.minecraft.src.World;
import net.minecraft.src.forge.ITextureProvider;
import net.minecraft.src.mod_PCmachines;

public class PCma_BlockAutomaticWorkbench
extends BlockContainer
implements PC_IBlockType,
PC_ISwapTerrain,
PC_ISpecialInventoryTextures,
ITextureProvider {
    private static final int TXDOWN = 109;
    private static final int TXTOP = 154;
    private static final int TXSIDE = 138;
    private static final int TXFRONT = 106;
    private static final int TXBACK = 122;

    @Override
    public String getTextureFile() {
        return this.getTerrainFile();
    }

    @Override
    public boolean blockActivated(World world, int i, int j, int k, EntityPlayer entityplayer) {
        ItemStack ihold = entityplayer.getCurrentEquippedItem();
        if (ihold != null && ihold.getItem() instanceof ItemBlock && ihold.getItem().shiftedIndex != this.blockID && Block.blocksList[ihold.getItem().shiftedIndex] instanceof PC_IBlockType) {
            return false;
        }
        PCma_TileEntityAutomaticWorkbench inventory = this.getTE(world, i, j, k);
        PC_Utils.openGres(entityplayer, new PCma_GuiAutomaticWorkbench(entityplayer, inventory));
        return true;
    }

    @Override
    public TileEntity getBlockEntity() {
        return new PCma_TileEntityAutomaticWorkbench();
    }

    public PCma_TileEntityAutomaticWorkbench getTE(World world, int x, int y, int z) {
        return (PCma_TileEntityAutomaticWorkbench)world.getBlockTileEntity(x, y, z);
    }

    protected PCma_BlockAutomaticWorkbench(int i) {
        super(i, 62, Material.ground);
        this.blockIndexInTexture = 62;
    }

    @Override
    public void onBlockRemoval(World world, int i, int j, int k) {
        PCma_TileEntityAutomaticWorkbench tileentityconveyoract = (PCma_TileEntityAutomaticWorkbench)world.getBlockTileEntity(i, j, k);
        for (int l = 0; l < tileentityconveyoract.getSizeInventory(); ++l) {
            ItemStack itemstack = tileentityconveyoract.getStackInSlot(l);
            if (itemstack == null) continue;
            float f = world.rand.nextFloat() * 0.8f + 0.1f;
            float f1 = world.rand.nextFloat() * 0.8f + 0.1f;
            float f2 = world.rand.nextFloat() * 0.8f + 0.1f;
            while (itemstack.stackSize > 0) {
                int i1 = world.rand.nextInt(21) + 10;
                if (i1 > itemstack.stackSize) {
                    i1 = itemstack.stackSize;
                }
                itemstack.stackSize -= i1;
                EntityItem entityitem = new EntityItem(world, (float)i + f, (float)j + f1, (float)k + f2, new ItemStack(itemstack.itemID, i1, itemstack.getItemDamage()));
                float f3 = 0.05f;
                entityitem.motionX = (float)world.rand.nextGaussian() * f3;
                entityitem.motionY = (float)world.rand.nextGaussian() * f3 + 0.2f;
                entityitem.motionZ = (float)world.rand.nextGaussian() * f3;
                world.spawnEntityInWorld(entityitem);
            }
        }
        super.onBlockRemoval(world, i, j, k);
    }

    @Override
    public void onBlockPlacedBy(World world, int i, int j, int k, EntityLiving entityliving) {
        int l = MathHelper.floor_double((double)(entityliving.rotationYaw * 4.0f / 360.0f) + 2.5) & 3;
        if (PC_Utils.isPlacingReversed()) {
            l = PC_Utils.reverseSide(l);
        }
        world.setBlockMetadataWithNotify(i, j, k, l);
    }

    @Override
    public int getBlockTextureFromSideAndMetadata(int s, int m) {
        if (m == 0) {
            m = 2;
        } else if (m == 1) {
            m = 5;
        } else if (m == 2) {
            m = 3;
        } else if (m == 3) {
            m = 4;
        }
        if (s == 1) {
            return 154;
        }
        if (s == 0) {
            return 109;
        }
        if (m == s) {
            return 122;
        }
        if (m == 2 && s == 3 || m == 3 && s == 2 || m == 4 && s == 5 || m == 5 && s == 4) {
            return 106;
        }
        return 138;
    }

    @Override
    public int getInvTexture(int i, int m) {
        if (i == 1) {
            return 154;
        }
        if (i == 0) {
            return 109;
        }
        if (i == 3) {
            return 106;
        }
        if (i == 4) {
            return 122;
        }
        return 138;
    }

    @Override
    public int tickRate() {
        return 4;
    }

    @Override
    public void onNeighborBlockChange(World world, int i, int j, int k, int l) {
        if (l > 0 && Block.blocksList[l].canProvidePower()) {
            boolean flag;
            boolean bl = flag = world.isBlockIndirectlyGettingPowered(i, j, k) || world.isBlockIndirectlyGettingPowered(i, j + 1, k) || world.isBlockIndirectlyGettingPowered(i, j - 1, k);
            if (flag) {
                world.scheduleBlockUpdate(i, j, k, this.blockID, this.tickRate());
            }
        }
    }

    @Override
    public void updateTick(World world, int i, int j, int k, Random random) {
        if (world.isBlockIndirectlyGettingPowered(i, j, k) || world.isBlockIndirectlyGettingPowered(i, j + 1, k) || world.isBlockIndirectlyGettingPowered(i, j - 1, k)) {
            this.getTE(world, i, j, k).doCrafting();
        }
    }

    @Override
    public String getTerrainFile() {
        return mod_PCmachines.getTerrainFile();
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public int getRenderType() {
        return PC_Renderer.swapTerrainRenderer;
    }

    @Override
    public Set<String> getBlockFlags(World world, PC_CoordI pos) {
        HashSet<String> set = new HashSet<String>();
        set.add("NO_HARVEST");
        set.add("HARVEST_STOP");
        set.add("ACT");
        set.add("REDSTONE");
        set.add("MACHINE");
        return set;
    }

    @Override
    public Set<String> getItemFlags(int damage) {
        HashSet<String> set = new HashSet<String>();
        set.add("NO_BUILD");
        return set;
    }
}

