/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.PC_Color;
import net.minecraft.src.TileEntity;

public class PClo_TileEntityLight
extends TileEntity {
    private int color = 1;

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.color = nbttagcompound.getInteger("color");
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.setInteger("color", this.color);
    }

    public void setColor(int c) {
        this.color = c;
    }

    public int getColor() {
        return this.color;
    }

    public int getHexColor(boolean on) {
        return PClo_TileEntityLight.getHexColor(this.color, on);
    }

    public static int getHexColor(int color_index, boolean on) {
        int rc;
        try {
            rc = PC_Color.light_colors[color_index];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            rc = 0xF0F0F0;
        }
        int r = (rc & 0xFF0000) >> 16;
        int g = (rc & 0xFF00) >> 8;
        int b = rc & 0xFF;
        if (!on) {
            r = (int)((double)r * 0.6);
            g = (int)((double)g * 0.6);
            b = (int)((double)b * 0.6);
        }
        return (r << 16) + (g << 8) + b;
    }

    public boolean canUpdate() {
        return false;
    }
}

