/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.List;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.PC_Lang;
import net.minecraft.src.PC_Utils;
import net.minecraft.src.PClo_RadioManager;
import net.minecraft.src.World;

public class PClo_ItemRadioRemote
extends Item {
    public PClo_ItemRadioRemote(int i) {
        super(i);
        this.setMaxDamage(0);
        this.setMaxStackSize(1);
    }

    @Override
    public ItemStack onItemRightClick(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        if (!itemstack.hasTagCompound()) {
            this.onCreated(itemstack, world, entityplayer);
        }
        PClo_RadioManager.sendRemotePulse(itemstack.getTagCompound().getString("channel"));
        world.playSoundAtEntity(entityplayer, "random.click", (world.rand.nextFloat() + 0.7f) / 2.0f, 1.0f + (world.rand.nextFloat() - world.rand.nextFloat()) * 0.4f);
        return itemstack;
    }

    @Override
    public void onCreated(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.setString("channel", "default");
        itemstack.setTagCompound(tag);
    }

    public static void setChannel(ItemStack itemstack, String channel) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.setString("channel", channel == null ? "default" : channel);
        itemstack.setTagCompound(tag);
        PC_Utils.chatMsg(PC_Lang.tr("pc.radioRemote.connected", new String[]{channel}), true);
    }

    @Override
    public void addInformation(ItemStack itemstack, List list) {
        if (itemstack.hasTagCompound()) {
            list.add(PC_Lang.tr("pc.radioRemote.desc", new String[]{itemstack.getTagCompound().getString("channel")}));
        }
    }
}

