/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.List;
import net.minecraft.src.Block;
import net.minecraft.src.BlockContainer;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.ItemBlock;
import net.minecraft.src.ItemStack;
import net.minecraft.src.MathHelper;
import net.minecraft.src.PC_Lang;
import net.minecraft.src.PClo_BlockGate;
import net.minecraft.src.PClo_GateType;
import net.minecraft.src.PClo_TileEntityGate;
import net.minecraft.src.World;
import net.minecraft.src.mod_PClogic;

public class PClo_ItemBlockGate
extends ItemBlock {
    public PClo_ItemBlockGate(int i) {
        super(i);
        this.setMaxDamage(0);
        this.setHasSubtypes(true);
    }

    @Override
    public int getBlockID() {
        return mod_PClogic.gateOff.blockID;
    }

    @Override
    public boolean onItemUse(ItemStack itemstack, EntityPlayer entityplayer, World world, int i, int j, int k, int l) {
        int id = world.getBlockId(i, j, k);
        if (id == Block.snow.blockID) {
            l = 1;
        } else if (id != Block.vine.blockID && id != Block.tallGrass.blockID && id != Block.deadBush.blockID) {
            if (l == 0) {
                --j;
            }
            if (l == 1) {
                ++j;
            }
            if (l == 2) {
                --k;
            }
            if (l == 3) {
                ++k;
            }
            if (l == 4) {
                --i;
            }
            if (l == 5) {
                ++i;
            }
        }
        if (itemstack.stackSize == 0) {
            return false;
        }
        if (!entityplayer.canPlayerEdit(i, j, k)) {
            return false;
        }
        if (j == 255 && Block.blocksList[this.getBlockID()].blockMaterial.isSolid()) {
            return false;
        }
        if (world.canBlockBePlacedAt(mod_PClogic.gateOff.blockID, i, j, k, false, l)) {
            Block block = mod_PClogic.gateOff;
            if (world.setBlock(i, j, k, block.blockID)) {
                PClo_TileEntityGate teg = (PClo_TileEntityGate)world.getBlockTileEntity(i, j, k);
                if (teg == null) {
                    teg = (PClo_TileEntityGate)((BlockContainer)block).getBlockEntity();
                }
                teg.gateType = itemstack.getItemDamage();
                world.setBlockTileEntity(i, j, k, teg);
                block.onBlockPlaced(world, i, j, k, l);
                block.onBlockPlacedBy(world, i, j, k, entityplayer);
                PClo_BlockGate.hugeUpdate(world, i, j, k, block.blockID);
                world.markBlocksDirty(i, j, k, i, j, k);
                world.markBlockNeedsUpdate(i, j, k);
                world.playSoundEffect((float)i + 0.5f, (float)j + 0.5f, (float)k + 0.5f, block.stepSound.getStepSound(), (block.stepSound.getVolume() + 1.0f) / 2.0f, block.stepSound.getPitch() * 0.8f);
                --itemstack.stackSize;
            }
        }
        return true;
    }

    @Override
    public String getItemName() {
        return mod_PClogic.gateOff.getBlockName();
    }

    @Override
    public int getIconFromDamage(int i) {
        return mod_PClogic.gateOn.getBlockTextureFromSideAndMetadata(1, 0);
    }

    @Override
    public String getItemNameIS(ItemStack itemstack) {
        try {
            return super.getItemName() + "." + PClo_GateType.names[itemstack.getItemDamage()];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return super.getItemName();
        }
    }

    @Override
    public boolean isFull3D() {
        return false;
    }

    @Override
    public boolean shouldRotateAroundWhenRendering() {
        return false;
    }

    @Override
    public void addInformation(ItemStack itemstack, List list) {
        list.add(PClo_ItemBlockGate.getDescriptionForGate(itemstack.getItemDamage()));
    }

    public static String getDescriptionForGate(int dmg) {
        return PC_Lang.tr("pc.gate." + PClo_GateType.names[MathHelper.clamp_int(dmg, 0, 25)] + ".desc");
    }
}

